/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageBundleAwareResourceResolver
extends ReturnValueAsStringResourceResolver {
    @Autowired
    private ApplicationContext context;

    public String[] resolveFrom(JoinPoint joinPoint, Exception e) {
        String[] resolved = super.resolveFrom(joinPoint, e);
        return this.resolveMessagesFromBundleOrDefault(resolved, e);
    }

    private String[] resolveMessagesFromBundleOrDefault(String[] resolved, Exception e) {
        Locale locale = LocaleContextHolder.getLocale();
        String defaultKey = Stream.of(StringUtils.splitByCharacterTypeCamelCase((String)e.getClass().getSimpleName())).collect(Collectors.joining("_")).toUpperCase();
        return (String[])Stream.of(resolved).map(key -> this.context.getMessage(key, null, defaultKey, locale)).toArray(String[]::new);
    }
}

