/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.audit.spi.DelegatingAuditTrailManager;
import org.apereo.cas.support.events.audit.CasAuditActionContextRecordedEvent;
import org.apereo.cas.util.ISOStandardDateFormat;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultDelegatingAuditTrailManager
implements DelegatingAuditTrailManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatingAuditTrailManager.class);
    private static final int INITIAL_CACHE_SIZE = 50;
    private static final long MAX_CACHE_SIZE = 1000L;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private final AuditTrailManager manager;
    private final LoadingCache<String, AuditActionContext> storage;
    private int expirationDuration = 2;
    private TimeUnit expirationTimeUnit = TimeUnit.HOURS;

    public DefaultDelegatingAuditTrailManager(AuditTrailManager manager) {
        this.manager = manager;
        this.storage = CacheBuilder.newBuilder().initialCapacity(50).maximumSize(1000L).recordStats().expireAfterWrite((long)this.expirationDuration, this.expirationTimeUnit).build((CacheLoader)new CacheLoader<String, AuditActionContext>(){

            public AuditActionContext load(String s) throws Exception {
                LOGGER.error("Load operation of the audit cache is not supported.");
                return null;
            }
        });
    }

    public void record(AuditActionContext auditActionContext) {
        this.manager.record(auditActionContext);
        String key = auditActionContext.getPrincipal() + "@" + auditActionContext.getActionPerformed() + "@" + auditActionContext.getResourceOperatedUpon() + "@" + ISOStandardDateFormat.getInstance().format(auditActionContext.getWhenActionWasPerformed());
        this.storage.put((Object)key, (Object)auditActionContext);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new CasAuditActionContextRecordedEvent((Object)this, auditActionContext));
        }
    }

    @Override
    public Set<AuditActionContext> get() {
        return new HashSet<AuditActionContext>(this.storage.asMap().values());
    }

    public void setExpirationDuration(int expirationDuration) {
        this.expirationDuration = expirationDuration;
    }

    public void setExpirationTimeUnit(TimeUnit expirationTimeUnit) {
        this.expirationTimeUnit = expirationTimeUnit;
    }
}

