/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;

public class AuditableExecutionResult {
    private RegisteredService registeredService;
    private Service service;
    private ServiceTicket serviceTicket;
    private Authentication authentication;
    private RuntimeException exception;
    private TicketGrantingTicket ticketGrantingTicket;
    private AuthenticationResult authenticationResult;
    private Map<String, Object> properties = new TreeMap<String, Object>();

    public boolean isExecutionFailure() {
        return this.getException().isPresent();
    }

    public void throwExceptionIfNeeded() {
        if (this.isExecutionFailure()) {
            throw this.getException().get();
        }
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public static AuditableExecutionResult of(RuntimeException e, Authentication authentication, Service service, RegisteredService registeredService) {
        AuditableExecutionResult result = new AuditableExecutionResult();
        result.setAuthentication(authentication);
        result.setException(e);
        result.setRegisteredService(registeredService);
        result.setService(service);
        return result;
    }

    public static AuditableExecutionResult of(Authentication authentication, Service service, RegisteredService registeredService) {
        return AuditableExecutionResult.of(null, authentication, service, registeredService);
    }

    public static AuditableExecutionResult of(ServiceTicket serviceTicket, AuthenticationResult authenticationResult, RegisteredService registeredService) {
        AuditableExecutionResult result = new AuditableExecutionResult();
        result.setServiceTicket(serviceTicket);
        result.setAuthenticationResult(authenticationResult);
        result.setRegisteredService(registeredService);
        return result;
    }

    public static AuditableExecutionResult of(Service service, RegisteredService registeredService, TicketGrantingTicket ticketGrantingTicket) {
        AuditableExecutionResult result = new AuditableExecutionResult();
        result.setTicketGrantingTicket(ticketGrantingTicket);
        result.setRegisteredService(registeredService);
        result.setService(service);
        return result;
    }

    public static AuditableExecutionResult of(Service service, RegisteredService registeredService) {
        AuditableExecutionResult result = new AuditableExecutionResult();
        result.setRegisteredService(registeredService);
        result.setService(service);
        return result;
    }

    public static AuditableExecutionResult of(RegisteredService registeredService) {
        AuditableExecutionResult result = new AuditableExecutionResult();
        result.setRegisteredService(registeredService);
        return result;
    }

    public static AuditableExecutionResult of(AuditableContext context) {
        AuditableExecutionResult result = new AuditableExecutionResult();
        context.getTicketGrantingTicket().ifPresent(result::setTicketGrantingTicket);
        context.getAuthentication().ifPresent(result::setAuthentication);
        context.getAuthenticationResult().ifPresent(result::setAuthenticationResult);
        context.getRegisteredService().ifPresent(result::setRegisteredService);
        context.getService().ifPresent(result::setService);
        context.getServiceTicket().ifPresent(result::setServiceTicket);
        result.getProperties().putAll(context.getProperties());
        return result;
    }

    public Optional<RegisteredService> getRegisteredService() {
        return Optional.ofNullable(this.registeredService);
    }

    public Optional<Service> getService() {
        return Optional.ofNullable(this.service);
    }

    public Optional<ServiceTicket> getServiceTicket() {
        return Optional.ofNullable(this.serviceTicket);
    }

    public Optional<Authentication> getAuthentication() {
        return Optional.ofNullable(this.authentication);
    }

    public Optional<TicketGrantingTicket> getTicketGrantingTicket() {
        return Optional.ofNullable(this.ticketGrantingTicket);
    }

    public Optional<AuthenticationResult> getAuthenticationResult() {
        return Optional.ofNullable(this.authenticationResult);
    }

    public Optional<RuntimeException> getException() {
        return Optional.ofNullable(this.exception);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public AuditableExecutionResult(RegisteredService registeredService, Service service, ServiceTicket serviceTicket, Authentication authentication, RuntimeException exception, TicketGrantingTicket ticketGrantingTicket, AuthenticationResult authenticationResult, Map<String, Object> properties) {
        this.registeredService = registeredService;
        this.service = service;
        this.serviceTicket = serviceTicket;
        this.authentication = authentication;
        this.exception = exception;
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.authenticationResult = authenticationResult;
        this.properties = properties;
    }

    @Generated
    public AuditableExecutionResult() {
    }

    @Generated
    public void setRegisteredService(RegisteredService registeredService) {
        this.registeredService = registeredService;
    }

    @Generated
    public void setService(Service service) {
        this.service = service;
    }

    @Generated
    public void setServiceTicket(ServiceTicket serviceTicket) {
        this.serviceTicket = serviceTicket;
    }

    @Generated
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Generated
    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    @Generated
    public void setTicketGrantingTicket(TicketGrantingTicket ticketGrantingTicket) {
        this.ticketGrantingTicket = ticketGrantingTicket;
    }

    @Generated
    public void setAuthenticationResult(AuthenticationResult authenticationResult) {
        this.authenticationResult = authenticationResult;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

