/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.persistence.Util;

public class PurgeTxnLog {
    private static final String PREFIX_SNAPSHOT = "snapshot";
    private static final String PREFIX_LOG = "log";

    static void printUsage() {
        System.out.println("PurgeTxnLog dataLogDir [snapDir] -n count");
        System.out.println("\tdataLogDir -- path to the txn log directory");
        System.out.println("\tsnapDir -- path to the snapshot directory");
        System.out.println("\tcount -- the number of old snaps/logs you want to keep");
        System.exit(1);
    }

    public static void purge(File dataDir, File snapDir, int num) throws IOException {
        if (num < 3) {
            throw new IllegalArgumentException("count should be greater than 3");
        }
        FileTxnSnapLog txnLog = new FileTxnSnapLog(dataDir, snapDir);
        List<File> snaps = txnLog.findNRecentSnapshots(num);
        PurgeTxnLog.retainNRecentSnapshots(txnLog, snaps);
    }

    static void retainNRecentSnapshots(FileTxnSnapLog txnLog, List<File> snaps) {
        if (snaps.size() == 0) {
            return;
        }
        File snapShot = snaps.get(snaps.size() - 1);
        final long leastZxidToBeRetain = Util.getZxidFromName(snapShot.getName(), PREFIX_SNAPSHOT);
        class MyFileFilter
        implements FileFilter {
            private final String prefix;

            MyFileFilter(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public boolean accept(File f) {
                if (!f.getName().startsWith(this.prefix + ".")) {
                    return false;
                }
                long fZxid = Util.getZxidFromName(f.getName(), this.prefix);
                return fZxid < leastZxidToBeRetain;
            }
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(txnLog.getDataDir().listFiles(new MyFileFilter(PREFIX_LOG))));
        files.addAll(Arrays.asList(txnLog.getSnapDir().listFiles(new MyFileFilter(PREFIX_SNAPSHOT))));
        for (File f : files) {
            System.out.println("Removing file: " + DateFormat.getDateTimeInstance().format(f.lastModified()) + "\t" + f.getPath());
            if (f.delete()) continue;
            System.err.println("Failed to remove " + f.getPath());
        }
    }

    public static void main(String[] args) throws IOException {
        File dataDir;
        if (args.length < 3 || args.length > 4) {
            PurgeTxnLog.printUsage();
        }
        int i = 0;
        File snapDir = dataDir = new File(args[0]);
        if (args.length == 4) {
            snapDir = new File(args[++i]);
        }
        ++i;
        int num = Integer.parseInt(args[++i]);
        PurgeTxnLog.purge(dataDir, snapDir, num);
    }
}

