/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.cli.CliCommand;

public class DeleteAllCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public DeleteAllCommand() {
        this("deleteall");
    }

    public DeleteAllCommand(String cmdStr) {
        super(cmdStr, "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cl = parser.parse(options, cmdArgs);
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws KeeperException, InterruptedException {
        this.printDeprecatedWarning();
        String path = this.args[1];
        ZKUtil.deleteRecursive(this.zk, path);
        return false;
    }

    private void printDeprecatedWarning() {
        if ("rmr".equals(this.args[0])) {
            this.err.println("The command 'rmr' has been deprecated. Please use 'deleteall' instead.");
        }
    }
}

