/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.jute.BinaryInputArchive;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ClientCnxnSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCnxnSocket.class);
    protected boolean initialized;
    protected final ByteBuffer lenBuffer;
    protected ByteBuffer incomingBuffer;
    protected long sentCount;
    protected long recvCount;
    protected long lastHeard;
    protected long lastSend;
    protected long now;
    protected ClientCnxn.SendThread sendThread;
    protected LinkedBlockingDeque<ClientCnxn.Packet> outgoingQueue;
    protected long sessionId;

    ClientCnxnSocket() {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocateDirect(4);
        this.sentCount = 0L;
        this.recvCount = 0L;
    }

    void introduce(ClientCnxn.SendThread sendThread, long sessionId, LinkedBlockingDeque<ClientCnxn.Packet> outgoingQueue) {
        this.sendThread = sendThread;
        this.sessionId = sessionId;
        this.outgoingQueue = outgoingQueue;
    }

    void updateNow() {
        this.now = Time.currentElapsedTime();
    }

    int getIdleRecv() {
        return (int)(this.now - this.lastHeard);
    }

    int getIdleSend() {
        return (int)(this.now - this.lastSend);
    }

    long getSentCount() {
        return this.sentCount;
    }

    long getRecvCount() {
        return this.recvCount;
    }

    void updateLastHeard() {
        this.lastHeard = this.now;
    }

    void updateLastSend() {
        this.lastSend = this.now;
    }

    void updateLastSendAndHeard() {
        this.lastSend = this.now;
        this.lastHeard = this.now;
    }

    protected void readLength() throws IOException {
        int len = this.incomingBuffer.getInt();
        if (len < 0 || len >= ClientCnxn.packetLen) {
            throw new IOException("Packet len" + len + " is out of range!");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
    }

    void readConnectResult() throws IOException {
        if (LOG.isTraceEnabled()) {
            StringBuilder buf = new StringBuilder("0x[");
            for (byte b : this.incomingBuffer.array()) {
                buf.append(Integer.toHexString(b) + ",");
            }
            buf.append("]");
            LOG.trace("readConnectResult " + this.incomingBuffer.remaining() + " " + buf.toString());
        }
        ByteBufferInputStream bbis = new ByteBufferInputStream(this.incomingBuffer);
        BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
        ConnectResponse conRsp = new ConnectResponse();
        conRsp.deserialize(bbia, "connect");
        boolean isRO = false;
        try {
            isRO = bbia.readBool("readOnly");
        }
        catch (IOException e) {
            LOG.warn("Connected to an old server; r-o mode will be unavailable");
        }
        this.sessionId = conRsp.getSessionId();
        this.sendThread.onConnected(conRsp.getTimeOut(), this.sessionId, conRsp.getPasswd(), isRO);
    }

    abstract boolean isConnected();

    abstract void connect(InetSocketAddress var1) throws IOException;

    abstract SocketAddress getRemoteSocketAddress();

    abstract SocketAddress getLocalSocketAddress();

    abstract void cleanup();

    abstract void packetAdded();

    abstract void onClosing();

    abstract void saslCompleted();

    abstract void connectionPrimed();

    abstract void doTransport(int var1, List<ClientCnxn.Packet> var2, ClientCnxn var3) throws IOException, InterruptedException;

    abstract void testableCloseSocket() throws IOException;

    abstract void close();

    abstract void sendPacket(ClientCnxn.Packet var1) throws IOException;
}

