/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;

public class FileManager {
    private static Logger LOG = LoggerFactory.getLogger(FileManager.class);
    private static Map<String, Revision> files = Collections.synchronizedMap(new HashMap());
    protected static boolean reloadingConfigs = true;
    private static final String JAR_FILE_NAME_SEPARATOR = "!/";
    private static final String JAR_FILE_EXTENSION_END = ".jar/";

    private FileManager() {
    }

    public static void setReloadingConfigs(boolean reloadingConfigs) {
        FileManager.reloadingConfigs = reloadingConfigs;
    }

    public static boolean isReloadingConfigs() {
        return reloadingConfigs;
    }

    public static boolean fileNeedsReloading(String fileName, Class clazz) {
        URL fileUrl = ClassLoaderUtil.getResource(fileName, clazz);
        return fileUrl != null && FileManager.fileNeedsReloading(fileUrl.toString());
    }

    public static boolean fileNeedsReloading(String fileName) {
        Revision revision = files.get(fileName);
        if (revision == null) {
            return reloadingConfigs;
        }
        return revision.needsReloading();
    }

    public static InputStream loadFile(String fileName, Class clazz) {
        URL fileUrl = ClassLoaderUtil.getResource(fileName, clazz);
        return FileManager.loadFile(fileUrl);
    }

    public static InputStream loadFile(URL fileUrl) {
        return FileManager.loadFile(fileUrl, true);
    }

    public static InputStream loadFile(URL fileUrl, boolean openStream) {
        if (fileUrl == null) {
            return null;
        }
        String fileName = fileUrl.toString();
        InputStream is = null;
        if (openStream) {
            try {
                is = fileUrl.openStream();
                if (is == null) {
                    throw new IllegalArgumentException("No file '" + fileName + "' found as a resource");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("No file '" + fileName + "' found as a resource");
            }
        }
        if (FileManager.isReloadingConfigs()) {
            Revision revision;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating revision for URL: " + fileName, new String[0]);
            }
            if ((revision = URLUtil.isJBossUrl(fileUrl) ? JBossFileRevision.build(fileUrl) : (URLUtil.isJarURL(fileUrl) ? JarEntryRevision.build(fileUrl) : FileRevision.build(fileUrl))) == null) {
                files.put(fileName, Revision.build(fileUrl));
            } else {
                files.put(fileName, revision);
            }
        }
        return is;
    }

    private static class JarEntryRevision
    extends Revision {
        private String jarFileName;
        private String fileNameInJar;
        private long lastModified;

        public JarEntryRevision(String jarFileName, String fileNameInJar, long lastModified) {
            if (jarFileName == null || fileNameInJar == null) {
                throw new IllegalArgumentException("JarFileName and FileNameInJar cannot be null");
            }
            this.jarFileName = jarFileName;
            this.fileNameInJar = fileNameInJar;
            this.lastModified = lastModified;
        }

        public boolean needsReloading() {
            ZipEntry entry;
            try {
                JarFile jarFile = new JarFile(this.jarFileName);
                entry = jarFile.getEntry(this.fileNameInJar);
            }
            catch (IOException e) {
                entry = null;
            }
            return entry != null && this.lastModified < entry.getTime();
        }

        public static Revision build(URL fileUrl) {
            String jarFileName = "";
            try {
                String fileName = fileUrl.toString();
                int separatorIndex = fileName.indexOf(FileManager.JAR_FILE_NAME_SEPARATOR);
                if (separatorIndex == -1) {
                    separatorIndex = fileName.lastIndexOf(FileManager.JAR_FILE_EXTENSION_END);
                }
                if (separatorIndex == -1) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Could not find end of jar file!", new String[0]);
                    }
                    return null;
                }
                jarFileName = fileName.substring(0, separatorIndex);
                int index = separatorIndex + FileManager.JAR_FILE_NAME_SEPARATOR.length();
                String fileNameInJar = fileName.substring(index).replaceAll("%20", " ");
                URL url = URLUtil.normalizeToFileProtocol(fileUrl);
                if (url != null) {
                    JarFile jarFile = new JarFile(FileUtils.toFile((URL)url));
                    ZipEntry entry = jarFile.getEntry(fileNameInJar);
                    return new JarEntryRevision(jarFileName.toString(), fileNameInJar, entry.getTime());
                }
                return null;
            }
            catch (Throwable e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not create JarEntryRevision for [" + jarFileName + "]!", e, new String[0]);
                }
                return null;
            }
        }
    }

    private static class JBossFileRevision
    extends FileRevision {
        public JBossFileRevision(File file, long lastUpdated) {
            super(file, lastUpdated);
        }

        public static Revision build(URL fileUrl) {
            File file;
            URL url = URLUtil.normalizeToFileProtocol(fileUrl);
            try {
                if (url == null) {
                    return null;
                }
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                file = new File(url.getPath());
            }
            if (file.exists() && file.canRead()) {
                long lastModified = file.lastModified();
                return new FileRevision(file, lastModified);
            }
            return null;
        }
    }

    private static class FileRevision
    extends Revision {
        private File file;
        private long lastModified;

        public FileRevision(File file, long lastUpdated) {
            if (file == null) {
                throw new IllegalArgumentException("File cannot be null");
            }
            this.file = file;
            this.lastModified = lastUpdated;
        }

        public File getFile() {
            return this.file;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean needsReloading() {
            return this.lastModified < this.file.lastModified();
        }

        public static Revision build(URL fileUrl) {
            File file;
            try {
                file = new File(fileUrl.toURI());
            }
            catch (URISyntaxException e) {
                file = new File(fileUrl.getPath());
            }
            catch (Throwable t) {
                return null;
            }
            if (file.exists() && file.canRead()) {
                long lastModified = file.lastModified();
                return new FileRevision(file, lastModified);
            }
            return null;
        }
    }

    private static class Revision {
        public boolean needsReloading() {
            return false;
        }

        public static Revision build(URL fileUrl) {
            return new Revision();
        }
    }
}

