/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import com.opensymphony.xwork2.inject.Inject;
import java.lang.reflect.Member;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWorkBasicConverter
extends DefaultTypeConverter {
    private ObjectFactory objectFactory;

    @Inject
    public void setObjectFactory(ObjectFactory fac) {
        this.objectFactory = fac;
    }

    @Override
    public Object convertValue(Map<String, Object> context, Object o, Member member, String propertyName, Object value, Class toType) {
        Object result = null;
        if (value == null || toType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (toType == String.class) {
            result = this.doConvertToString(context, value);
        } else if (toType == Boolean.TYPE) {
            result = this.doConvertToBoolean(value);
        } else if (toType == Boolean.class) {
            result = this.doConvertToBoolean(value);
        } else if (toType.isArray()) {
            result = this.doConvertToArray(context, o, member, propertyName, value, toType);
        } else if (Date.class.isAssignableFrom(toType)) {
            result = this.doConvertToDate(context, value, toType);
        } else if (Calendar.class.isAssignableFrom(toType)) {
            result = this.doConvertToCalendar(context, value);
        } else if (Collection.class.isAssignableFrom(toType)) {
            result = this.doConvertToCollection(context, o, member, propertyName, value, toType);
        } else if (toType == Character.class) {
            result = this.doConvertToCharacter(value);
        } else if (toType == Character.TYPE) {
            result = this.doConvertToCharacter(value);
        } else if (Number.class.isAssignableFrom(toType) || toType.isPrimitive()) {
            result = this.doConvertToNumber(context, value, toType);
        } else if (toType == Class.class) {
            result = this.doConvertToClass(value);
        }
        if (result == null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                value = array.length >= 1 ? array[0] : null;
                result = this.convertValue(context, o, member, propertyName, value, toType);
            } else if (!"".equals(value)) {
                result = super.convertValue(context, value, toType);
            }
            if (result == null && value != null && !"".equals(value)) {
                throw new XWorkException("Cannot create type " + toType + " from value " + value);
            }
        }
        return result;
    }

    private Object doConvertToCalendar(Map<String, Object> context, Object value) {
        Calendar result = null;
        Date dateResult = (Date)this.doConvertToDate(context, value, Date.class);
        if (dateResult != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateResult);
            result = calendar;
        }
        return result;
    }

    private Object doConvertToArray(Map<String, Object> context, Object o, Member member, String prop, Object value, Class toType) {
        TypeConverter converter = this.objectFactory.buildConverter("array");
        if (converter == null) {
            throw new XWorkException("TypeConverter with name [array] must be registered first!");
        }
        return converter.convertValue(context, o, member, prop, value, toType);
    }

    private Object doConvertToCharacter(Object value) {
        if (value instanceof String) {
            String cStr = (String)value;
            return cStr.length() > 0 ? new Character(cStr.charAt(0)) : null;
        }
        return null;
    }

    private Object doConvertToBoolean(Object value) {
        if (value instanceof String) {
            String bStr = (String)value;
            return Boolean.valueOf(bStr);
        }
        return null;
    }

    private Class doConvertToClass(Object value) {
        Class<?> clazz = null;
        if (value instanceof String && value != null && ((String)value).length() > 0) {
            try {
                clazz = Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new XWorkException(e.getLocalizedMessage(), e);
            }
        }
        return clazz;
    }

    private Object doConvertToCollection(Map<String, Object> context, Object o, Member member, String prop, Object value, Class toType) {
        TypeConverter converter = this.objectFactory.buildConverter("collection");
        if (converter == null) {
            throw new XWorkException("TypeConverter with name [collection] must be registered first!");
        }
        return converter.convertValue(context, o, member, prop, value, toType);
    }

    private Object doConvertToDate(Map<String, Object> context, Object value, Class toType) {
        TypeConverter converter = this.objectFactory.buildConverter("date");
        if (converter == null) {
            throw new XWorkException("TypeConverter with name [date] must be registered first!");
        }
        return converter.convertValue(context, null, null, null, value, toType);
    }

    private Object doConvertToNumber(Map<String, Object> context, Object value, Class toType) {
        TypeConverter converter = this.objectFactory.buildConverter("number");
        if (converter == null) {
            throw new XWorkException("TypeConverter with name [number] must be registered first!");
        }
        return converter.convertValue(context, null, null, null, value, toType);
    }

    private Object doConvertToString(Map<String, Object> context, Object value) {
        TypeConverter converter = this.objectFactory.buildConverter("string");
        if (converter == null) {
            throw new XWorkException("TypeConverter with name [string] must be registered first!");
        }
        return converter.convertValue(context, null, null, null, value, null);
    }
}

