/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u00193\u0005IR\u0004\"\u0002&\u0001\t\u0003a\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007I\u0002\u0001\u000b\u0011B)\t\u000f1\u0004!\u0019!C\u0005[\"1a\u000f\u0001Q\u0001\n9Dqa\u001e\u0001A\u0002\u0013%\u0001\u0010C\u0005\u0002(\u0001\u0001\r\u0011\"\u0003\u0002*!9\u0011Q\u0007\u0001!B\u0013I\b\"CA \u0001\u0001\u0007I\u0011AA!\u0011%\tI\u0005\u0001a\u0001\n\u0003\tY\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0015BA\"\u0011%\t\t\u0006\u0001a\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\u0001\r\u0011\"\u0001\u0002^!A\u0011\u0011\r\u0001!B\u0013\t)\u0006C\u0005\u0002d\u0001\u0001\r\u0011\"\u0001\u0002f!I\u0011Q\u000e\u0001A\u0002\u0013\u0005\u0011q\u000e\u0005\t\u0003g\u0002\u0001\u0015)\u0003\u0002h!I\u0011Q\u000f\u0001A\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003o\u0002\u0001\u0019!C\u0001\u0003sB\u0001\"! \u0001A\u0003&\u0011q\r\u0005\n\u0003\u007f\u0002\u0001\u0019!C\u0001\u0003\u0003B\u0011\"!!\u0001\u0001\u0004%\t!a!\t\u0011\u0005\u001d\u0005\u0001)Q\u0005\u0003\u0007B\u0011\"!#\u0001\u0001\u0004%I!a#\t\u0013\u00055\u0005\u00011A\u0005\n\u0005=\u0005\u0002CAJ\u0001\u0001\u0006K!!\t\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003\u0017CaAa\t\u0001\t\u0003A\bb\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005\u0003BqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003L\u0001!\t!a*\t\u000f\t5\u0003\u0001\"\u0001\u0002(\"9!q\n\u0001\u0005\u0002\tE\u0003b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005w\u0002A\u0011\u0002B?\u00051!5\u000b\u001e:fC6<%/\u00199i\u0015\t\u0019D'A\u0005tiJ,\u0017-\\5oO*\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014xm\u0005\u0003\u0001w\u0005#\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$AB!osJ+g\r\u0005\u0002=\u0005&\u00111)\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fR\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0013\u001a\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0005C\u0001(\u0001\u001b\u0005\u0011\u0014\u0001D5oaV$8\u000b\u001e:fC6\u001cX#A)\u0011\u0007I;\u0016,D\u0001T\u0015\t!V+A\u0004nkR\f'\r\\3\u000b\u0005Yk\u0014AC2pY2,7\r^5p]&\u0011\u0001l\u0015\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\r\u0002[EB\u00191L\u00181\u000e\u0003qS!!\u0018\u001a\u0002\u000f\u0011\u001cHO]3b[&\u0011q\f\u0018\u0002\r\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003C\nd\u0001\u0001B\u0005d\u0007\u0005\u0005\t\u0011!B\u0001K\n\u0019q\fJ\u0019\u0002\u001b%t\u0007/\u001e;TiJ,\u0017-\\:!#\t1\u0017\u000e\u0005\u0002=O&\u0011\u0001.\u0010\u0002\b\u001d>$\b.\u001b8h!\ta$.\u0003\u0002l{\t\u0019\u0011I\\=\u0002\u001b=,H\u000f];u'R\u0014X-Y7t+\u0005q\u0007c\u0001*X_B\u0012\u0001\u000f\u001e\t\u00047F\u001c\u0018B\u0001:]\u0005\u001d!5\u000b\u001e:fC6\u0004\"!\u0019;\u0005\u0013U,\u0011\u0011!A\u0001\u0006\u0003)'aA0%e\u0005qq.\u001e;qkR\u001cFO]3b[N\u0004\u0013\u0001F5oaV$8\u000b\u001e:fC6t\u0015-\\3B]\u0012LE)F\u0001z!\u0015Q\u0018QAA\u0006\u001d\rY\u0018\u0011\u0001\b\u0003y~l\u0011! \u0006\u0003}.\u000ba\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0007\u0005\rQ(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0004'\u0016\f(bAA\u0002{A9A(!\u0004\u0002\u0012\u0005\u0005\u0012bAA\b{\t1A+\u001e9mKJ\u0002B!a\u0005\u0002\u001c9!\u0011QCA\f!\taX(C\u0002\u0002\u001au\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000f\u0003?\u0011aa\u0015;sS:<'bAA\r{A\u0019A(a\t\n\u0007\u0005\u0015RHA\u0002J]R\f\u0001$\u001b8qkR\u001cFO]3b[:\u000bW.Z!oI&#u\fJ3r)\u0011\tY#!\r\u0011\u0007q\ni#C\u0002\u00020u\u0012A!\u00168ji\"A\u00111G\u0004\u0002\u0002\u0003\u0007\u00110A\u0002yIE\nQ#\u001b8qkR\u001cFO]3b[:\u000bW.Z!oI&#\u0005\u0005K\u0002\t\u0003s\u00012\u0001PA\u001e\u0013\r\ti$\u0010\u0002\tm>d\u0017\r^5mK\u0006\u0001\"/Z7f[\n,'\u000fR;sCRLwN\\\u000b\u0003\u0003\u0007\u00022ATA#\u0013\r\t9E\r\u0002\t\tV\u0014\u0018\r^5p]\u0006!\"/Z7f[\n,'\u000fR;sCRLwN\\0%KF$B!a\u000b\u0002N!I\u00111\u0007\u0006\u0002\u0002\u0003\u0007\u00111I\u0001\u0012e\u0016lW-\u001c2fe\u0012+(/\u0019;j_:\u0004\u0013\u0001F2iK\u000e\\\u0007o\\5oi&s\u0007K]8he\u0016\u001c8/\u0006\u0002\u0002VA\u0019A(a\u0016\n\u0007\u0005eSHA\u0004C_>dW-\u00198\u00021\rDWmY6q_&tG/\u00138Qe><'/Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005}\u0003\"CA\u001a\u001b\u0005\u0005\t\u0019AA+\u0003U\u0019\u0007.Z2la>Lg\u000e^%o!J|wM]3tg\u0002\n\u0001B_3s_RKW.Z\u000b\u0003\u0003O\u00022ATA5\u0013\r\tYG\r\u0002\u0005)&lW-\u0001\u0007{KJ|G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0004\"CA\u001a!\u0005\u0005\t\u0019AA4\u0003%QXM]8US6,\u0007%A\u0005ti\u0006\u0014H\u000fV5nK\u0006i1\u000f^1siRKW.Z0%KF$B!a\u000b\u0002|!I\u00111G\n\u0002\u0002\u0003\u0007\u0011qM\u0001\u000bgR\f'\u000f\u001e+j[\u0016\u0004\u0013!\u00042bi\u000eDG)\u001e:bi&|g.A\tcCR\u001c\u0007\u000eR;sCRLwN\\0%KF$B!a\u000b\u0002\u0006\"I\u00111\u0007\f\u0002\u0002\u0003\u0007\u00111I\u0001\u000fE\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8!\u00031qW/\u001c*fG\u0016Lg/\u001a:t+\t\t\t#\u0001\tok6\u0014VmY3jm\u0016\u00148o\u0018\u0013fcR!\u00111FAI\u0011%\t\u0019$GA\u0001\u0002\u0004\t\t#A\u0007ok6\u0014VmY3jm\u0016\u00148\u000f\t\u0015\u00045\u0005e\u0012!B:uCJ$H\u0003BA\u0016\u00037Cq!!(\u001c\u0001\u0004\t9'\u0001\u0003uS6,\u0017a\u0002:fgR\f'\u000f\u001e\u000b\u0005\u0003W\t\u0019\u000bC\u0004\u0002\u001er\u0001\r!a\u001a\u0002\tM$x\u000e\u001d\u000b\u0003\u0003W\t!b]3u\u0007>tG/\u001a=u)\u0011\tY#!,\t\u000f\u0005=f\u00041\u0001\u00022\u0006\u00191o]2\u0011\u00079\u000b\u0019,C\u0002\u00026J\u0012\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0002!M,GOQ1uG\"$UO]1uS>tG\u0003BA\u0016\u0003wCq!!0 \u0001\u0004\t\u0019%\u0001\u0005ekJ\fG/[8o\u0003!\u0011X-\\3nE\u0016\u0014H\u0003BA\u0016\u0003\u0007Dq!!0!\u0001\u0004\t\u0019%\u0001\bbI\u0012Le\u000e];u'R\u0014X-Y7\u0015\t\u0005-\u0012\u0011\u001a\u0005\b\u0003\u0017\f\u0003\u0019AAg\u0003-Ig\u000e];u'R\u0014X-Y71\t\u0005=\u00171\u001b\t\u00057z\u000b\t\u000eE\u0002b\u0003'$1\"!6\u0002J\u0006\u0005\t\u0011!B\u0001K\n\u0019q\f\n\u001b\u0002\u001f\u0005$GmT;uaV$8\u000b\u001e:fC6$B!a\u000b\u0002\\\"9\u0011Q\u001c\u0012A\u0002\u0005}\u0017\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0007BAq\u0003K\u0004BaW9\u0002dB\u0019\u0011-!:\u0005\u0017\u0005\u001d\u00181\\A\u0001\u0002\u0003\u0015\t!\u001a\u0002\u0004?\u0012*\u0014aD4fi&s\u0007/\u001e;TiJ,\u0017-\\:\u0015\u0005\u00055\b#\u0002\u001f\u0002p\u0006M\u0018bAAy{\t)\u0011I\u001d:bsB\"\u0011Q_A}!\u0011Yf,a>\u0011\u0007\u0005\fI\u0010\u0002\u0006\u0002|\u000e\n\t\u0011!A\u0003\u0002\u0015\u00141a\u0018\u00137\u0003A9W\r^(viB,Ho\u0015;sK\u0006l7\u000f\u0006\u0002\u0003\u0002A)A(a<\u0003\u0004A\"!Q\u0001B\u0005!\u0011Y\u0016Oa\u0002\u0011\u0007\u0005\u0014I\u0001\u0002\u0006\u0003\f\u0011\n\t\u0011!A\u0003\u0002\u0015\u00141a\u0018\u00138\u0003]9W\r\u001e*fG\u0016Lg/\u001a:J]B,Ho\u0015;sK\u0006l7\u000f\u0006\u0002\u0003\u0012A)A(a<\u0003\u0014A\"!Q\u0003B\u000f!\u0015Y&q\u0003B\u000e\u0013\r\u0011I\u0002\u0018\u0002\u0015%\u0016\u001cW-\u001b<fe&s\u0007/\u001e;E'R\u0014X-Y7\u0011\u0007\u0005\u0014i\u0002\u0002\u0006\u0003 \u0015\n\t\u0011!A\u0003\u0002\u0015\u00141a\u0018\u00139\u0003=9W\r\u001e(v[J+7-Z5wKJ\u001c\u0018aF4fi&s\u0007/\u001e;TiJ,\u0017-\u001c(b[\u0016\fe\u000eZ%E\u000319WM\\3sCR,'j\u001c2t)\u0011\u0011ICa\u000e\u0011\u000bi\f)Aa\u000b\u0011\t\t5\"1G\u0007\u0003\u0005_Q1A!\r3\u0003%\u00198\r[3ek2,'/\u0003\u0003\u00036\t=\"a\u0001&pE\"9\u0011Q\u0014\u0015A\u0002\u0005\u001d\u0014!D2mK\u0006\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002,\tu\u0002bBAOS\u0001\u0007\u0011qM\u0001\u0015kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0015\t\u0005-\"1\t\u0005\b\u0003;S\u0003\u0019AA4\u0003M\u0019G.Z1s\u0007\",7m\u001b9pS:$H)\u0019;b)\u0011\tYC!\u0013\t\u000f\u0005u5\u00061\u0001\u0002h\u0005)\"/Z:u_J,7\t[3dWB|\u0017N\u001c;ECR\f\u0017\u0001\u0003<bY&$\u0017\r^3\u0002C\u001d,G/T1y\u0013:\u0004X\u000f^*ue\u0016\fWNU3nK6\u0014WM\u001d#ve\u0006$\u0018n\u001c8\u0015\u0005\u0005\r\u0013aC<sSR,wJ\u00196fGR$B!a\u000b\u0003X!9!\u0011L\u0018A\u0002\tm\u0013aA8pgB!!Q\fB4\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014AA5p\u0015\t\u0011)'\u0001\u0003kCZ\f\u0017\u0002\u0002B5\u0005?\u0012!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\"*qF!\u001c\u0003zA)AHa\u001c\u0003t%\u0019!\u0011O\u001f\u0003\rQD'o\\<t!\u0011\u0011iF!\u001e\n\t\t]$q\f\u0002\f\u0013>+\u0005pY3qi&|gn\t\u0002\u0003t\u0005Q!/Z1e\u001f\nTWm\u0019;\u0015\t\u0005-\"q\u0010\u0005\b\u0005\u0003\u0003\u0004\u0019\u0001BB\u0003\ry\u0017n\u001d\t\u0005\u0005;\u0012))\u0003\u0003\u0003\b\n}#!E(cU\u0016\u001cG/\u00138qkR\u001cFO]3b[\"*\u0001G!\u001c\u0003z\u0001")
public final class DStreamGraph
implements scala.Serializable,
Logging {
    private final ArrayBuffer<InputDStream<?>> inputStreams;
    private final ArrayBuffer<DStream<?>> outputStreams;
    private volatile Seq<Tuple2<String, Object>> inputStreamNameAndID;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private volatile int numReceivers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private ArrayBuffer<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    private Seq<Tuple2<String, Object>> inputStreamNameAndID() {
        return this.inputStreamNameAndID;
    }

    private void inputStreamNameAndID_$eq(Seq<Tuple2<String, Object>> x$1) {
        this.inputStreamNameAndID = x$1;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    private int numReceivers() {
        return this.numReceivers;
    }

    private void numReceivers_$eq(int x$1) {
        this.numReceivers = x$1;
    }

    public synchronized void start(Time time) {
        Predef$.MODULE$.require(this.zeroTime() == null, (Function0 & Serializable & scala.Serializable)() -> "DStream graph computation already started");
        this.zeroTime_$eq(time);
        this.startTime_$eq(time);
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.initialize(this.zeroTime());
            return BoxedUnit.UNIT;
        });
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.remember(this.rememberDuration());
            return BoxedUnit.UNIT;
        });
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.validateAtStart();
            return BoxedUnit.UNIT;
        });
        this.numReceivers_$eq(this.inputStreams().count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$start$5(x$4))));
        this.inputStreamNameAndID_$eq((Seq<Tuple2<String, Object>>)((Seq)this.inputStreams().map((Function1 & Serializable & scala.Serializable)is -> new Tuple2((Object)is.name(), (Object)BoxesRunTime.boxToInteger((int)is.id())), ArrayBuffer$.MODULE$.canBuildFrom())));
        this.inputStreams().par().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.start();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        this.inputStreams().par().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.setContext(ssc);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void setBatchDuration(Duration duration) {
        Predef$.MODULE$.require(this.batchDuration() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Batch duration already set as ").append(this.batchDuration()).append(". Cannot set it again.").toString());
        this.batchDuration_$eq(duration);
    }

    public synchronized void remember(Duration duration) {
        Predef$.MODULE$.require(this.rememberDuration() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Remember duration already set as ").append(this.rememberDuration()).append(". Cannot set it again.").toString());
        this.rememberDuration_$eq(duration);
    }

    public void addInputStream(InputDStream<?> inputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            inputStream.setGraph(this);
            this.inputStreams().$plus$eq(inputStream);
        }
    }

    public void addOutputStream(DStream<?> outputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            outputStream.setGraph(this);
            this.outputStreams().$plus$eq(outputStream);
        }
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized ReceiverInputDStream<?>[] getReceiverInputStreams() {
        return (ReceiverInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$getReceiverInputStreams$1(x$8)))).map((Function1 & Serializable & scala.Serializable)x$9 -> (ReceiverInputDStream)x$9, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ReceiverInputDStream.class));
    }

    public int getNumReceivers() {
        return this.numReceivers();
    }

    public Seq<Tuple2<String, Object>> getInputStreamNameAndID() {
        return this.inputStreamNameAndID();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Job> generateJobs(Time time) {
        void var2_4;
        ArrayBuffer arrayBuffer;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Generating jobs for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            arrayBuffer = (ArrayBuffer)this.outputStreams().flatMap((Function1 & Serializable & scala.Serializable)outputStream -> {
                Option<Job> jobOption = outputStream.generateJob(time);
                jobOption.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                    x$10.setCallSite(outputStream.creationSite());
                    return BoxedUnit.UNIT;
                });
                return Option$.MODULE$.option2Iterable(jobOption);
            }, ArrayBuffer$.MODULE$.canBuildFrom());
        }
        ArrayBuffer jobs = arrayBuffer;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Generated ").append(jobs.length()).append(" jobs for time ").append(time).toString());
        return var2_4;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Clearing metadata for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.clearMetadata(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Cleared old metadata for time ").append(time).toString());
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Updating checkpoint data for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                x$12.updateCheckpointData(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updated checkpoint data for time ").append(time).toString());
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Clearing checkpoint data for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.clearCheckpointData(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleared checkpoint data for time ").append(time).toString());
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restoring checkpoint data");
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.restoreCheckpointData();
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restored checkpoint data");
    }

    public synchronized void validate() {
        Predef$.MODULE$.require(this.batchDuration() != null, (Function0 & Serializable & scala.Serializable)() -> "Batch duration has not been set");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No output operations registered, so nothing to execute");
    }

    public Duration getMaxInputStreamRememberDuration() {
        return (Duration)((TraversableOnce)((TraversableLike)this.inputStreams().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.rememberDuration(), ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$getMaxInputStreamRememberDuration$2(x$16)))).maxBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.milliseconds()), (Ordering)Ordering.Long$.MODULE$);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DStreamGraph.writeObject used");
            DStreamGraph dStreamGraph = this;
            synchronized (dStreamGraph) {
                this.checkpointInProgress_$eq(true);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Enabled checkpoint mode");
                oos.defaultWriteObject();
                this.checkpointInProgress_$eq(false);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disabled checkpoint mode");
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DStreamGraph.readObject used");
            DStreamGraph dStreamGraph = this;
            synchronized (dStreamGraph) {
                this.checkpointInProgress_$eq(true);
                ois.defaultReadObject();
                this.checkpointInProgress_$eq(false);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$start$5(InputDStream x$4) {
        return x$4 instanceof ReceiverInputDStream;
    }

    public static final /* synthetic */ boolean $anonfun$getReceiverInputStreams$1(InputDStream x$8) {
        return x$8 instanceof ReceiverInputDStream;
    }

    public static final /* synthetic */ boolean $anonfun$getMaxInputStreamRememberDuration$2(Duration x$16) {
        return x$16 != null;
    }

    public DStreamGraph() {
        Logging.$init$((Logging)this);
        this.inputStreams = new ArrayBuffer();
        this.outputStreams = new ArrayBuffer();
        this.inputStreamNameAndID = Nil$.MODULE$;
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
        this.numReceivers = 0;
    }
}

