/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class TeradataDialect$
extends JdbcDialect
implements Product {
    public static final TeradataDialect$ MODULE$ = new TeradataDialect$();

    static {
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:teradata");
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(9).append("VAR_POP(").append(distinct).append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(10).append("VAR_SAMP(").append(distinct).append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(12).append("STDDEV_POP(").append(distinct).append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string5 = "STDDEV_SAMP";
                if (!(string != null ? !string.equals(string5) : string5 != null)) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    String distinct = generalAggregateFunc.isDistinct() ? "DISTINCT " : "";
                    return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(distinct).append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string6 = "COVAR_POP";
                if (!(string != null ? !string.equals(string6) : string6 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(13).append("COVAR_POP(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(", ").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string7 = "COVAR_SAMP";
                if (!(string != null ? !string.equals(string7) : string7 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(14).append("COVAR_SAMP(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(", ").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (!bl) return None$.MODULE$;
            String string = generalAggregateFunc.name();
            String string8 = "CORR";
            if (string == null) {
                if (string8 != null) {
                    return None$.MODULE$;
                }
            } else if (!string.equals(string8)) return None$.MODULE$;
            if (generalAggregateFunc.isDistinct()) return None$.MODULE$;
            Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
            return new Some((Object)new StringBuilder(8).append("CORR(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(", ").append(ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
        });
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Object object = StringType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("VARCHAR(255)", 12)) : (BooleanType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1)) : None$.MODULE$);
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(16).append("DELETE FROM ").append(table).append(" ALL").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    public String productPrefix() {
        return "TeradataDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TeradataDialect$;
    }

    public int hashCode() {
        return -1014754660;
    }

    public String toString() {
        return "TeradataDialect";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TeradataDialect$.class);
    }

    private TeradataDialect$() {
    }
}

