/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair$;
import org.apache.spark.sql.execution.streaming.state.RocksDB$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBLoader$;
import org.apache.spark.sql.execution.streaming.state.RocksDBMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram$;
import org.apache.spark.util.NextIterator;
import org.apache.spark.util.Utils$;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.Checkpoint;
import org.rocksdb.Filter;
import org.rocksdb.FlushOptions;
import org.rocksdb.HistogramType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.TickerType;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapView;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMd\u0001\u0002-Z\u0001!D\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\u000b\u0003\u0007\u0001!Q1A\u0005\u0002\u0005\u0015\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\b!Q\u0011\u0011\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0005\t\u0015\u0005\r\u0002A!A!\u0002\u0013\t)\u0003C\u0005\u00024\u0001\u0011\t\u0011)A\u0005m\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002\"CA#\u0001\t\u0007I\u0011BA$\u0011!\t)\u0006\u0001Q\u0001\n\u0005%\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011!\t\t\u0007\u0001Q\u0001\n\u0005m\u0003\"CA2\u0001\t\u0007I\u0011BA3\u0011!\ti\u0007\u0001Q\u0001\n\u0005\u001d\u0004\"CA8\u0001\u0001\u0007I\u0011BA9\u0011%\tI\b\u0001a\u0001\n\u0013\tY\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0015BA:\u0011%\tI\t\u0001b\u0001\n\u0013\tY\t\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BAG\u0011%\t)\n\u0001b\u0001\n\u0013\t9\n\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAM\u0011%\t\t\u000b\u0001b\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAS\u0011%\ti\u000b\u0001b\u0001\n\u0013\ty\u000b\u0003\u0005\u00028\u0002\u0001\u000b\u0011BAY\u0011%\tI\f\u0001b\u0001\n\u0013\tY\f\u0003\u0005\u0002D\u0002\u0001\u000b\u0011BA_\u0011%\t)\r\u0001b\u0001\n\u0013\t9\r\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BA\n\u0011%\tY\r\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002V\u0002\u0001\u000b\u0011BAh\u0011%\t9\u000e\u0001b\u0001\n\u0013\tI\u000e\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAn\u0011%\t\u0019\u000f\u0001b\u0001\n\u0013\t)\u000f\u0003\u0005\u0002~\u0002\u0001\u000b\u0011BAt\u0011%\ty\u0010\u0001b\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\u0010\u0001\u0001\u000b\u0011\u0002B\u0002\u0011-\u0011\t\u0002\u0001a\u0001\u0002\u0004%IAa\u0005\t\u0017\te\u0001\u00011AA\u0002\u0013%!1\u0004\u0005\f\u0005?\u0001\u0001\u0019!A!B\u0013\u0011)\u0002C\u0005\u0003*\u0001\u0001\r\u0011\"\u0003\u0003,!I!Q\u0006\u0001A\u0002\u0013%!q\u0006\u0005\t\u0005g\u0001\u0001\u0015)\u0003\u0002x\"I!q\u0007\u0001A\u0002\u0013%!1\u0006\u0005\n\u0005s\u0001\u0001\u0019!C\u0005\u0005wA\u0001Ba\u0010\u0001A\u0003&\u0011q\u001f\u0005\n\u0005\u0007\u0002\u0001\u0019!C\u0005\u0005WA\u0011B!\u0012\u0001\u0001\u0004%IAa\u0012\t\u0011\t-\u0003\u0001)Q\u0005\u0003oD\u0011Ba\u0014\u0001\u0001\u0004%IA!\u0015\t\u0013\te\u0003\u00011A\u0005\n\tm\u0003\u0002\u0003B0\u0001\u0001\u0006KAa\u0015\t\u0017\t\r\u0004\u00011AA\u0002\u0013%!Q\r\u0005\f\u0005[\u0002\u0001\u0019!a\u0001\n\u0013\u0011y\u0007C\u0006\u0003t\u0001\u0001\r\u0011!Q!\n\t\u001d\u0004\"\u0003BI\u0001\t\u0007I\u0011\u0002BJ\u0011!\u0011I\u000b\u0001Q\u0001\n\tU\u0005b\u0002BV\u0001\u0011\u0005!Q\u0016\u0005\b\u0005g\u0003A\u0011\u0001B[\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013DqAa4\u0001\t\u0003\u0011\t\u000eC\u0004\u0003V\u0002!\tAa6\t\u000f\t-\b\u0001\"\u0003\u0003n\"9!q\u001e\u0001\u0005\u0002\tE\bb\u0002B|\u0001\u0011\u0005!Q\u001e\u0005\b\u0005s\u0004A\u0011\u0001B~\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005wDqAa@\u0001\t\u0003\u0011Y\u0010C\u0004\u0004\u0002\u0001!\tA!<\t\u000f\r\r\u0001\u0001\"\u0001\u0004\u0006!91Q\u0002\u0001\u0005\n\tm\bbBB\b\u0001\u0011%!1 \u0005\b\u0007#\u0001A\u0011\u0002B~\u0011\u001d\u0019\u0019\u0002\u0001C\u0005\u0005wDqa!\u0006\u0001\t\u0013\u00199\u0002C\u0004\u0004\u001e\u0001!IAa?\t\u000f\r}\u0001\u0001\"\u0003\u0003|\"91\u0011\u0005\u0001\u0005\n\r\r\u0002bBB\u0013\u0001\u0011%1q\u0005\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u00199\u0004\u0001C\t\u0007sAqa!\u0012\u0001\t#\u001a9eB\u0005\u0004Je\u000b\t\u0011#\u0001\u0004L\u0019A\u0001,WA\u0001\u0012\u0003\u0019i\u0005C\u0004\u00026M#\taa\u0014\t\u0013\rE3+%A\u0005\u0002\rM\u0003\"CB4'F\u0005I\u0011AB5\u0011%\u0019igUI\u0001\n\u0003\u0019yGA\u0004S_\u000e\\7\u000f\u0012\"\u000b\u0005i[\u0016!B:uCR,'B\u0001/^\u0003%\u0019HO]3b[&twM\u0003\u0002_?\u0006IQ\r_3dkRLwN\u001c\u0006\u0003A\u0006\f1a]9m\u0015\t\u00117-A\u0003ta\u0006\u00148N\u0003\u0002eK\u00061\u0011\r]1dQ\u0016T\u0011AZ\u0001\u0004_J<7\u0001A\n\u0004\u0001%|\u0007C\u00016n\u001b\u0005Y'\"\u00017\u0002\u000bM\u001c\u0017\r\\1\n\u00059\\'AB!osJ+g\r\u0005\u0002qg6\t\u0011O\u0003\u0002sC\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002uc\n9Aj\\4hS:<\u0017A\u00033ggJ{w\u000e\u001e#jeB\u0011qO \b\u0003qr\u0004\"!_6\u000e\u0003iT!a_4\u0002\rq\u0012xn\u001c;?\u0013\ti8.\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~W\u0006!1m\u001c8g+\t\t9\u0001\u0005\u0003\u0002\n\u0005-Q\"A-\n\u0007\u00055\u0011LA\u0006S_\u000e\\7\u000f\u0012\"D_:4\u0017!B2p]\u001a\u0004\u0013\u0001\u00047pG\u0006d'k\\8u\t&\u0014\b\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0003S>T!!!\b\u0002\t)\fg/Y\u0005\u0005\u0003C\t9B\u0001\u0003GS2,\u0017A\u00035bI>|\u0007oQ8oMB!\u0011qEA\u0018\u001b\t\tIC\u0003\u0003\u0002\u0004\u0005-\"bAA\u0017G\u00061\u0001.\u00193p_BLA!!\r\u0002*\ti1i\u001c8gS\u001e,(/\u0019;j_:\f\u0011\u0002\\8hO&tw-\u00133\u0002\rqJg.\u001b;?)1\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"!\r\tI\u0001\u0001\u0005\u0006k\u001e\u0001\rA\u001e\u0005\b\u0003\u00079\u0001\u0019AA\u0004\u0011%\t\tb\u0002I\u0001\u0002\u0004\t\u0019\u0002C\u0005\u0002$\u001d\u0001\n\u00111\u0001\u0002&!A\u00111G\u0004\u0011\u0002\u0003\u0007a/A\u0006sK\u0006$w\n\u001d;j_:\u001cXCAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(K\u00069!o\\2lg\u0012\u0014\u0017\u0002BA*\u0003\u001b\u00121BU3bI>\u0003H/[8og\u0006a!/Z1e\u001fB$\u0018n\u001c8tA\u0005aqO]5uK>\u0003H/[8ogV\u0011\u00111\f\t\u0005\u0003\u0017\ni&\u0003\u0003\u0002`\u00055#\u0001D,sSR,w\n\u001d;j_:\u001c\u0018!D<sSR,w\n\u001d;j_:\u001c\b%\u0001\u0007gYV\u001c\bn\u00149uS>t7/\u0006\u0002\u0002hA!\u00111JA5\u0013\u0011\tY'!\u0014\u0003\u0019\u0019cWo\u001d5PaRLwN\\:\u0002\u001b\u0019dWo\u001d5PaRLwN\\:!\u0003)9(/\u001b;f\u0005\u0006$8\r[\u000b\u0003\u0003g\u0002B!a\u0013\u0002v%!\u0011qOA'\u0005M9&/\u001b;f\u0005\u0006$8\r[,ji\"Le\u000eZ3y\u000399(/\u001b;f\u0005\u0006$8\r[0%KF$B!! \u0002\u0004B\u0019!.a \n\u0007\u0005\u00055N\u0001\u0003V]&$\b\"CAC\u001f\u0005\u0005\t\u0019AA:\u0003\rAH%M\u0001\foJLG/\u001a\"bi\u000eD\u0007%A\u0006cY>|WNR5mi\u0016\u0014XCAAG!\u0011\tY%a$\n\t\u0005E\u0015Q\n\u0002\f\u00052|w.\u001c$jYR,'/\u0001\u0007cY>|WNR5mi\u0016\u0014\b%A\tuC\ndWMR8s[\u0006$8i\u001c8gS\u001e,\"!!'\u0011\t\u0005-\u00131T\u0005\u0005\u0003;\u000biEA\u000bCY>\u001c7NQ1tK\u0012$\u0016M\u00197f\u0007>tg-[4\u0002%Q\f'\r\\3G_Jl\u0017\r^\"p]\u001aLw\rI\u0001\nI\n|\u0005\u000f^5p]N,\"!!*\u0011\t\u0005-\u0013qU\u0005\u0005\u0003S\u000biEA\u0004PaRLwN\\:\u0002\u0015\u0011\u0014w\n\u001d;j_:\u001c\b%\u0001\u0005eE2{wmZ3s+\t\t\t\f\u0005\u0003\u0002L\u0005M\u0016\u0002BA[\u0003\u001b\u0012a\u0001T8hO\u0016\u0014\u0018!\u00033c\u0019><w-\u001a:!\u0003-q\u0017\r^5wKN#\u0018\r^:\u0016\u0005\u0005u\u0006\u0003BA&\u0003\u007fKA!!1\u0002N\tQ1\u000b^1uSN$\u0018nY:\u0002\u00199\fG/\u001b<f'R\fGo\u001d\u0011\u0002\u0015]|'o[5oO\u0012K'/\u0006\u0002\u0002\u0014\u0005Yqo\u001c:lS:<G)\u001b:!\u0003-1\u0017\u000e\\3NC:\fw-\u001a:\u0016\u0005\u0005=\u0007\u0003BA\u0005\u0003#L1!a5Z\u0005I\u0011vnY6t\t\n3\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0019\u0019LG.Z'b]\u0006<WM\u001d\u0011\u0002\u001b\tLH/Z!se\u0006L\b+Y5s+\t\tY\u000e\u0005\u0003\u0002\n\u0005u\u0017bAAp3\ni!)\u001f;f\u0003J\u0014\u0018-\u001f)bSJ\faBY=uK\u0006\u0013(/Y=QC&\u0014\b%A\bd_6l\u0017\u000e\u001e'bi\u0016t7-_'t+\t\t9\u000fE\u0004\u0002j\u0006Mh/a>\u000e\u0005\u0005-(\u0002BAw\u0003_\fq!\\;uC\ndWMC\u0002\u0002r.\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)0a;\u0003\u000f!\u000b7\u000f['baB\u0019!.!?\n\u0007\u0005m8N\u0001\u0003M_:<\u0017\u0001E2p[6LG\u000fT1uK:\u001c\u00170T:!\u0003-\t7-];je\u0016dunY6\u0016\u0005\t\r\u0001\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\t\t%\u00111D\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u000e\t\u001d!AB(cU\u0016\u001cG/\u0001\u0007bGF,\u0018N]3M_\u000e\\\u0007%\u0001\u0002eEV\u0011!Q\u0003\t\u0005\u0003\u0017\u00129\"C\u0002Y\u0003\u001b\na\u0001\u001a2`I\u0015\fH\u0003BA?\u0005;A\u0011\"!\"'\u0003\u0003\u0005\rA!\u0006\u0002\u0007\u0011\u0014\u0007\u0005K\u0002(\u0005G\u00012A\u001bB\u0013\u0013\r\u00119c\u001b\u0002\tm>d\u0017\r^5mK\u0006iAn\\1eK\u00124VM]:j_:,\"!a>\u0002#1|\u0017\rZ3e-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002~\tE\u0002\"CACS\u0005\u0005\t\u0019AA|\u00039aw.\u00193fIZ+'o]5p]\u0002B3A\u000bB\u0012\u0003YqW/\\&fsN|e\u000eT8bI\u0016$g+\u001a:tS>t\u0017A\u00078v[.+\u0017p](o\u0019>\fG-\u001a3WKJ\u001c\u0018n\u001c8`I\u0015\fH\u0003BA?\u0005{A\u0011\"!\"-\u0003\u0003\u0005\r!a>\u0002/9,XnS3zg>sGj\\1eK\u00124VM]:j_:\u0004\u0003fA\u0017\u0003$\u00059b.^7LKf\u001cxJ\\,sSRLgn\u001a,feNLwN\\\u0001\u001c]Vl7*Z=t\u001f:<&/\u001b;j]\u001e4VM]:j_:|F%Z9\u0015\t\u0005u$\u0011\n\u0005\n\u0003\u000b{\u0013\u0011!a\u0001\u0003o\f\u0001D\\;n\u0017\u0016L8o\u00148Xe&$\u0018N\\4WKJ\u001c\u0018n\u001c8!Q\r\u0001$1E\u0001\u0013M&dW-T1oC\u001e,'/T3ue&\u001c7/\u0006\u0002\u0003TA!\u0011\u0011\u0002B+\u0013\r\u00119&\u0017\u0002\u001a%>\u001c7n\u001d#C\r&dW-T1oC\u001e,'/T3ue&\u001c7/\u0001\fgS2,W*\u00198bO\u0016\u0014X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\tiH!\u0018\t\u0013\u0005\u0015%'!AA\u0002\tM\u0013a\u00054jY\u0016l\u0015M\\1hKJlU\r\u001e:jGN\u0004\u0003fA\u001a\u0003$\u0005\u0011\u0012mY9vSJ,G\r\u00165sK\u0006$\u0017J\u001c4p+\t\u00119\u0007\u0005\u0003\u0002\n\t%\u0014b\u0001B63\n\u0011\u0012iY9vSJ,G\r\u00165sK\u0006$\u0017J\u001c4p\u0003Y\t7-];je\u0016$G\u000b\u001b:fC\u0012LeNZ8`I\u0015\fH\u0003BA?\u0005cB\u0011\"!\"6\u0003\u0003\u0005\rAa\u001a\u0002'\u0005\u001c\u0017/^5sK\u0012$\u0006N]3bI&sgm\u001c\u0011)\u0007Y\u0012\u0019\u0003K\u00047\u0005s\u0012iIa$\u0011\t\tm$\u0011R\u0007\u0003\u0005{RAAa \u0003\u0002\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t\r%QQ\u0001\u000bC:tw\u000e^1uS>t'B\u0001BD\u0003\u0015Q\u0017M^1y\u0013\u0011\u0011YI! \u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017EAA\u0000\u0003M\u0001(/\u001a4jqN\u001b\u0017M\u001c*fkN,\u0017\n^3s+\t\u0011)\n\u0005\u0005\u0003\u0018\n}\u0015q\u001fBR\u001b\t\u0011IJ\u0003\u0003\u0003\u0000\tm%\u0002\u0002BO\u00037\tA!\u001e;jY&!!\u0011\u0015BM\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003\u0017\u0012)+\u0003\u0003\u0003(\u00065#!\u0004*pG.\u001c\u0018\n^3sCR|'/\u0001\u000bqe\u00164\u0017\u000e_*dC:\u0014V-^:f\u0013R,'\u000fI\u0001\u0005Y>\fG\r\u0006\u0003\u0002:\t=\u0006b\u0002BYs\u0001\u0007\u0011q_\u0001\bm\u0016\u00148/[8o\u0003\r9W\r\u001e\u000b\u0005\u0005o\u0013\u0019\rE\u0003k\u0005s\u0013i,C\u0002\u0003<.\u0014Q!\u0011:sCf\u00042A\u001bB`\u0013\r\u0011\tm\u001b\u0002\u0005\u0005f$X\rC\u0004\u0003Fj\u0002\rAa.\u0002\u0007-,\u00170A\u0002qkR$b!! \u0003L\n5\u0007b\u0002Bcw\u0001\u0007!q\u0017\u0005\b\u0005\u001b[\u0004\u0019\u0001B\\\u0003\u0019\u0011X-\\8wKR!\u0011Q\u0010Bj\u0011\u001d\u0011)\r\u0010a\u0001\u0005o\u000b\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u0003\u00053\u0004bAa7\u0003f\u0006mg\u0002\u0002Bo\u0005Ct1!\u001fBp\u0013\u0005a\u0017b\u0001BrW\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bt\u0005S\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0005G\\\u0017!C2pk:$8*Z=t)\t\t90\u0001\u0006qe\u00164\u0017\u000e_*dC:$BA!7\u0003t\"9!Q_ A\u0002\t]\u0016A\u00029sK\u001aL\u00070\u0001\u0004d_6l\u0017\u000e^\u0001\te>dGNY1dWR\u0011\u0011QP\u0001\bG2,\u0017M\\;q\u0003\u0015\u0019Gn\\:f\u0003A9W\r\u001e'bi\u0016\u001cHOV3sg&|g.A\u0004nKR\u0014\u0018nY:\u0016\u0005\r\u001d\u0001\u0003BA\u0005\u0007\u0013I1aa\u0003Z\u00059\u0011vnY6t\t\nkU\r\u001e:jGN\fq!Y2rk&\u0014X-A\u0004sK2,\u0017m]3\u00021\rdwn]3Qe\u00164\u0017\u000e_*dC:LE/\u001a:bi>\u00148/A\bsKN,Go\u0016:ji\u0016\u0014\u0015\r^2i\u000359W\r\u001e#C!J|\u0007/\u001a:usR!\u0011q_B\r\u0011\u0019\u0019YB\u0013a\u0001m\u0006A\u0001O]8qKJ$\u00180\u0001\u0004pa\u0016tGIQ\u0001\bG2|7/\u001a#C\u00031\u0019'/Z1uK2{wmZ3s)\t\t\t,A\u0007de\u0016\fG/\u001a+f[B$\u0015N\u001d\u000b\u0005\u0003'\u0019I\u0003\u0003\u0004\u0003v:\u0003\rA^\u0001\u0018g&dWM\u001c;EK2,G/\u001a*fGV\u00148/\u001b<fYf$b!! \u00040\rM\u0002bBB\u0019\u001f\u0002\u0007\u00111C\u0001\u0005M&dW\r\u0003\u0004\u00046=\u0003\rA^\u0001\u0004[N<\u0017a\u0003;j[\u0016$\u0016m[3o\u001bN$B!a>\u0004<!A1Q\b)\u0005\u0002\u0004\u0019y$\u0001\u0003c_\u0012L\b#\u00026\u0004B\u0005u\u0014bAB\"W\nAAHY=oC6,g(A\u0004m_\u001et\u0015-\\3\u0016\u0003Y\fqAU8dWN$%\tE\u0002\u0002\nM\u001b\"aU5\u0015\u0005\r-\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0004V)\"\u00111CB,W\t\u0019I\u0006\u0005\u0003\u0004\\\r\rTBAB/\u0015\u0011\u0019yf!\u0019\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BBW&!1QMB/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r-$\u0006BA\u0013\u0007/\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAB9U\r18q\u000b")
public class RocksDB
implements Logging {
    private final RocksDBConf conf;
    private final File localRootDir;
    private final String loggingId;
    private final ReadOptions readOptions;
    private final WriteOptions writeOptions;
    private final FlushOptions flushOptions;
    private WriteBatchWithIndex writeBatch;
    private final BloomFilter bloomFilter;
    private final BlockBasedTableConfig tableFormatConfig;
    private final Options org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions;
    private final org.rocksdb.Logger dbLogger;
    private final Statistics nativeStats;
    private final File workingDir;
    private final RocksDBFileManager fileManager;
    private final ByteArrayPair org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair;
    private final HashMap<String, Object> commitLatencyMs;
    private final Object acquireLock;
    private volatile org.rocksdb.RocksDB db;
    private volatile long loadedVersion;
    private volatile long numKeysOnLoadedVersion;
    private volatile long numKeysOnWritingVersion;
    private volatile RocksDBFileManagerMetrics fileManagerMetrics;
    @GuardedBy(value="acquireLock")
    private volatile AcquiredThreadInfo acquiredThreadInfo;
    private final ConcurrentHashMap<Object, RocksIterator> prefixScanReuseIter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String $lessinit$greater$default$5() {
        return RocksDB$.MODULE$.$lessinit$greater$default$5();
    }

    public static Configuration $lessinit$greater$default$4() {
        return RocksDB$.MODULE$.$lessinit$greater$default$4();
    }

    public static File $lessinit$greater$default$3() {
        return RocksDB$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RocksDBConf conf() {
        return this.conf;
    }

    private ReadOptions readOptions() {
        return this.readOptions;
    }

    private WriteOptions writeOptions() {
        return this.writeOptions;
    }

    private FlushOptions flushOptions() {
        return this.flushOptions;
    }

    private WriteBatchWithIndex writeBatch() {
        return this.writeBatch;
    }

    private void writeBatch_$eq(WriteBatchWithIndex x$1) {
        this.writeBatch = x$1;
    }

    private BloomFilter bloomFilter() {
        return this.bloomFilter;
    }

    private BlockBasedTableConfig tableFormatConfig() {
        return this.tableFormatConfig;
    }

    public Options org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions() {
        return this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions;
    }

    private org.rocksdb.Logger dbLogger() {
        return this.dbLogger;
    }

    private Statistics nativeStats() {
        return this.nativeStats;
    }

    private File workingDir() {
        return this.workingDir;
    }

    private RocksDBFileManager fileManager() {
        return this.fileManager;
    }

    public ByteArrayPair org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair() {
        return this.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair;
    }

    private HashMap<String, Object> commitLatencyMs() {
        return this.commitLatencyMs;
    }

    private Object acquireLock() {
        return this.acquireLock;
    }

    private org.rocksdb.RocksDB db() {
        return this.db;
    }

    private void db_$eq(org.rocksdb.RocksDB x$1) {
        this.db = x$1;
    }

    private long loadedVersion() {
        return this.loadedVersion;
    }

    private void loadedVersion_$eq(long x$1) {
        this.loadedVersion = x$1;
    }

    private long numKeysOnLoadedVersion() {
        return this.numKeysOnLoadedVersion;
    }

    private void numKeysOnLoadedVersion_$eq(long x$1) {
        this.numKeysOnLoadedVersion = x$1;
    }

    private long numKeysOnWritingVersion() {
        return this.numKeysOnWritingVersion;
    }

    private void numKeysOnWritingVersion_$eq(long x$1) {
        this.numKeysOnWritingVersion = x$1;
    }

    private RocksDBFileManagerMetrics fileManagerMetrics() {
        return this.fileManagerMetrics;
    }

    private void fileManagerMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.fileManagerMetrics = x$1;
    }

    private AcquiredThreadInfo acquiredThreadInfo() {
        return this.acquiredThreadInfo;
    }

    private void acquiredThreadInfo_$eq(AcquiredThreadInfo x$1) {
        this.acquiredThreadInfo = x$1;
    }

    private ConcurrentHashMap<Object, RocksIterator> prefixScanReuseIter() {
        return this.prefixScanReuseIter;
    }

    public RocksDB load(long version) {
        Predef$.MODULE$.assert(version >= 0L);
        this.acquire();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(8).append("Loading ").append(version).toString());
        try {
            if (this.loadedVersion() != version) {
                this.closeDB();
                RocksDBCheckpointMetadata metadata = this.fileManager().loadCheckpointFromDfs(version, this.workingDir());
                this.openDB();
                long numKeys = !this.conf().trackTotalNumberOfRows() ? -1L : (metadata.numKeys() < 0L ? this.countKeys() : metadata.numKeys());
                this.numKeysOnWritingVersion_$eq(numKeys);
                this.numKeysOnLoadedVersion_$eq(numKeys);
                this.loadedVersion_$eq(version);
                this.fileManagerMetrics_$eq(this.fileManager().latestLoadCheckpointMetrics());
            }
            if (this.conf().resetStatsOnLoad()) {
                this.nativeStats().reset();
            }
            this.closePrefixScanIterators();
            this.resetWriteBatch();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(7).append("Loaded ").append(version).toString());
        }
        catch (Throwable t) {
            this.loadedVersion_$eq(-1L);
            throw t;
        }
        return this;
    }

    public byte[] get(byte[] key) {
        return this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key);
    }

    public void put(byte[] key, byte[] value) {
        byte[] oldValue;
        if (this.conf().trackTotalNumberOfRows() && (oldValue = this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key)) == null) {
            this.numKeysOnWritingVersion_$eq(this.numKeysOnWritingVersion() + 1L);
        }
        this.writeBatch().put(key, value);
    }

    public void remove(byte[] key) {
        byte[] value;
        if (this.conf().trackTotalNumberOfRows() && (value = this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key)) != null) {
            this.numKeysOnWritingVersion_$eq(this.numKeysOnWritingVersion() - 1L);
        }
        this.writeBatch().remove(key);
    }

    public Iterator<ByteArrayPair> iterator() {
        RocksIterator iter = this.writeBatch().newIteratorWithBase(this.db().newIterator());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Getting iterator from version ").append(this.loadedVersion()).toString());
        iter.seekToFirst();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)tc -> tc.addTaskCompletionListener((Function1 & Serializable)x$3 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        return new NextIterator<ByteArrayPair>(this, iter){
            private final /* synthetic */ RocksDB $outer;
            private final RocksIterator iter$1;

            public ByteArrayPair getNext() {
                ByteArrayPair byteArrayPair;
                if (this.iter$1.isValid()) {
                    this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair().set(this.iter$1.key(), this.iter$1.value());
                    this.iter$1.next();
                    byteArrayPair = this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair();
                } else {
                    this.finished_$eq(true);
                    this.iter$1.close();
                    byteArrayPair = null;
                }
                return byteArrayPair;
            }

            public void close() {
                this.iter$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$1 = iter$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private long countKeys() {
        void v0;
        try (RocksIterator iter = this.db().newIterator();){
            void var2_2;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Counting keys - getting iterator from version ").append(this.loadedVersion()).toString());
            iter.seekToFirst();
            long keys = 0L;
            while (iter.isValid()) {
                ++keys;
                iter.next();
            }
            v0 = var2_2;
        }
        return (long)v0;
    }

    public Iterator<ByteArrayPair> prefixScan(byte[] prefix) {
        long threadId = Thread.currentThread().getId();
        RocksIterator iter = this.prefixScanReuseIter().computeIfAbsent(BoxesRunTime.boxToLong((long)threadId), tid -> RocksDB.$anonfun$prefixScan$1(this, BoxesRunTime.unboxToLong((Object)tid)));
        iter.seek(prefix);
        return new NextIterator<ByteArrayPair>(this, iter, prefix){
            private final /* synthetic */ RocksDB $outer;
            private final RocksIterator iter$2;
            private final byte[] prefix$1;

            public ByteArrayPair getNext() {
                ByteArrayPair byteArrayPair;
                if (this.iter$2.isValid() && Predef$.MODULE$.wrapByteArray((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(this.iter$2.key()), this.prefix$1.length)).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(this.prefix$1))) {
                    this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair().set(this.iter$2.key(), this.iter$2.value());
                    this.iter$2.next();
                    byteArrayPair = this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair();
                } else {
                    this.finished_$eq(true);
                    byteArrayPair = null;
                }
                return byteArrayPair;
            }

            public void close() {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$2 = iter$2;
                this.prefix$1 = prefix$1;
            }
        };
    }

    public long commit() {
        long l;
        long newVersion = this.loadedVersion() + 1L;
        File checkpointDir = this.createTempDir("checkpoint");
        try {
            try {
                long l2;
                Utils$.MODULE$.deleteRecursively(checkpointDir);
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Writing updates for ").append(newVersion).toString());
                long writeTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.db().write(this.writeOptions(), this.writeBatch()));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Flushing updates for ").append(newVersion).toString());
                long flushTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.db().flush(this.flushOptions()));
                if (this.conf().compactOnCommit()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Compacting");
                    l2 = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.db().compactRange());
                } else {
                    l2 = 0L;
                }
                long compactTimeMs = l2;
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Pausing background work");
                long pauseTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.db().pauseBackgroundWork());
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Creating checkpoint for ").append(newVersion).append(" in ").append(checkpointDir).toString());
                long checkpointTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    Checkpoint cp = Checkpoint.create((org.rocksdb.RocksDB)this.db());
                    cp.createCheckpoint(checkpointDir.toString());
                });
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Syncing checkpoint for ").append(newVersion).append(" to DFS").toString());
                long fileSyncTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.fileManager().saveCheckpointToDfs(checkpointDir, newVersion, this.numKeysOnWritingVersion()));
                this.numKeysOnLoadedVersion_$eq(this.numKeysOnWritingVersion());
                this.loadedVersion_$eq(newVersion);
                this.fileManagerMetrics_$eq(this.fileManager().latestSaveCheckpointMetrics());
                this.commitLatencyMs().$plus$plus$eq((IterableOnce)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeBatch"), (Object)BoxesRunTime.boxToLong((long)writeTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush"), (Object)BoxesRunTime.boxToLong((long)flushTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compact"), (Object)BoxesRunTime.boxToLong((long)compactTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pause"), (Object)BoxesRunTime.boxToLong((long)pauseTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkpoint"), (Object)BoxesRunTime.boxToLong((long)checkpointTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileSync"), (Object)BoxesRunTime.boxToLong((long)fileSyncTimeMs))})));
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Committed ").append(newVersion).append(", stats = ").append(this.metrics().json()).toString());
                l = this.loadedVersion();
            }
            catch (Throwable t) {
                this.loadedVersion_$eq(-1L);
                throw t;
            }
        }
        finally {
            this.db().continueBackgroundWork();
            this.silentDeleteRecursively(checkpointDir, new StringBuilder(11).append("committing ").append(newVersion).toString());
            this.closePrefixScanIterators();
            this.resetWriteBatch();
            this.release();
        }
        return l;
    }

    public void rollback() {
        this.closePrefixScanIterators();
        this.resetWriteBatch();
        this.numKeysOnWritingVersion_$eq(this.numKeysOnLoadedVersion());
        this.release();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append("Rolled back to ").append(this.loadedVersion()).toString());
    }

    public void cleanup() {
        long cleanupTime = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.fileManager().deleteOldVersions(this.conf().minVersionsToRetain()));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Cleaned old data, time taken: ").append(cleanupTime).append(" ms").toString());
    }

    public void close() {
        this.closePrefixScanIterators();
        try {
            this.closeDB();
            this.writeBatch().clear();
            this.writeBatch().close();
            this.readOptions().close();
            this.writeOptions().close();
            this.flushOptions().close();
            this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().close();
            this.dbLogger().close();
            this.silentDeleteRecursively(this.localRootDir, "closing RocksDB");
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error closing RocksDB", e);
        }
    }

    public long getLatestVersion() {
        return this.fileManager().getLatestVersion();
    }

    public RocksDBMetrics metrics() {
        long totalSSTFilesBytes = this.getDBProperty("rocksdb.total-sst-files-size");
        long readerMemUsage = this.getDBProperty("rocksdb.estimate-table-readers-mem");
        long memTableMemUsage = this.getDBProperty("rocksdb.size-all-mem-tables");
        long blockCacheUsage = this.getDBProperty("rocksdb.block-cache-usage");
        long writeBatchMemUsage = this.writeBatch().getWriteBatch().getDataSize();
        scala.collection.immutable.Map nativeOpsHistograms = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get"), (Object)HistogramType.DB_GET), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"put"), (Object)HistogramType.DB_WRITE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compaction"), (Object)HistogramType.COMPACTION_TIME)})).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        MapView nativeOpsLatencyMicros = nativeOpsHistograms.mapValues((Function1 & Serializable)typ -> RocksDBNativeHistogram$.MODULE$.apply(this.nativeStats().getHistogramData(typ)));
        scala.collection.immutable.Map nativeOpsMetricTickers = package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readBlockCacheMissCount"), (Object)TickerType.BLOCK_CACHE_MISS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readBlockCacheHitCount"), (Object)TickerType.BLOCK_CACHE_HIT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesRead"), (Object)TickerType.BYTES_READ), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWritten"), (Object)TickerType.BYTES_WRITTEN), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesReadThroughIterator"), (Object)TickerType.ITER_BYTES_READ), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writerStallDuration"), (Object)TickerType.STALL_MICROS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesReadByCompaction"), (Object)TickerType.COMPACT_READ_BYTES), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWrittenByCompaction"), (Object)TickerType.COMPACT_WRITE_BYTES)})).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        MapView nativeOpsMetrics = nativeOpsMetricTickers.mapValues((Function1 & Serializable)typ -> BoxesRunTime.boxToLong((long)RocksDB.$anonfun$metrics$2(this, typ)));
        long x$1 = this.numKeysOnLoadedVersion();
        long x$2 = this.numKeysOnWritingVersion();
        long x$3 = readerMemUsage + memTableMemUsage + blockCacheUsage + writeBatchMemUsage;
        long x$4 = writeBatchMemUsage;
        long x$5 = totalSSTFilesBytes;
        scala.collection.immutable.Map x$6 = nativeOpsLatencyMicros.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashMap<String, Object> x$7 = this.commitLatencyMs();
        long x$8 = this.fileManagerMetrics().bytesCopied();
        long x$9 = this.fileManagerMetrics().filesCopied();
        long x$10 = this.fileManagerMetrics().filesReused();
        Option<Object> x$11 = this.fileManagerMetrics().zipFileBytesUncompressed();
        scala.collection.immutable.Map x$12 = nativeOpsMetrics.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new RocksDBMetrics(x$1, x$2, x$3, x$4, x$5, (Map<String, RocksDBNativeHistogram>)x$6, (Map<String, Object>)x$7, x$9, x$8, x$10, x$11, (Map<String, Object>)x$12);
    }

    private void acquire() {
        Object object = this.acquireLock();
        synchronized (object) {
            AcquiredThreadInfo newAcquiredThreadInfo = new AcquiredThreadInfo();
            long waitStartTime = System.currentTimeMillis();
            while (this.isAcquiredByDifferentThread$1(newAcquiredThreadInfo) && RocksDB.timeWaitedMs$1(waitStartTime) < this.conf().lockAcquireTimeoutMs()) {
                this.acquireLock().wait(10L);
            }
            if (this.isAcquiredByDifferentThread$1(newAcquiredThreadInfo)) {
                String stackTraceOutput = Predef$.MODULE$.wrapRefArray((Object[])((Thread)this.acquiredThreadInfo().threadRef().get().get()).getStackTrace()).mkString("\n");
                String msg = new StringBuilder(0).append(new StringBuilder(49).append("RocksDB instance could not be acquired by ").append(newAcquiredThreadInfo).append(" as it ").toString()).append(new StringBuilder(32).append("was not released by ").append(this.acquiredThreadInfo()).append(" after ").append(RocksDB.timeWaitedMs$1(waitStartTime)).append(" ms.\n").toString()).append(new StringBuilder(35).append("Thread holding the lock has trace: ").append(stackTraceOutput).toString()).toString();
                this.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                throw new IllegalStateException(new StringBuilder(2).append(this.loggingId).append(": ").append(msg).toString());
            }
            this.acquiredThreadInfo_$eq(newAcquiredThreadInfo);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable)x$5 -> {
                this.release();
                return BoxedUnit.UNIT;
            }));
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("RocksDB instance was acquired by ").append(this.acquiredThreadInfo()).toString());
        }
    }

    private void release() {
        Object object = this.acquireLock();
        synchronized (object) {
            this.acquiredThreadInfo_$eq(null);
            this.acquireLock().notifyAll();
        }
    }

    private void closePrefixScanIterators() {
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.prefixScanReuseIter().entrySet()).asScala()).foreach((Function1 & Serializable)x$6 -> {
            RocksDB.$anonfun$closePrefixScanIterators$1(x$6);
            return BoxedUnit.UNIT;
        });
        this.prefixScanReuseIter().clear();
    }

    private void resetWriteBatch() {
        this.writeBatch().clear();
        this.writeBatch().close();
        this.writeBatch_$eq(new WriteBatchWithIndex(true));
    }

    private long getDBProperty(String property) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(this.db().getProperty(property)));
    }

    private void openDB() {
        Predef$.MODULE$.assert(this.db() == null);
        this.db_$eq(org.rocksdb.RocksDB.open((Options)this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions(), (String)this.workingDir().toString()));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Opened DB with conf ").append(this.conf()).toString());
    }

    private void closeDB() {
        block0: {
            if (this.db() == null) break block0;
            this.db().close();
            this.db_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private org.rocksdb.Logger createLogger() {
        void var1_1;
        org.rocksdb.Logger dbLogger = new org.rocksdb.Logger(this){
            private final /* synthetic */ RocksDB $outer;

            public void log(InfoLogLevel infoLogLevel, String logMsg) {
                Function1 & Serializable intersect;
                InfoLogLevel infoLogLevel2 = infoLogLevel;
                boolean bl = InfoLogLevel.FATAL_LEVEL.equals(infoLogLevel2) ? true : InfoLogLevel.ERROR_LEVEL.equals(infoLogLevel2);
                if (bl) {
                    intersect = (Function1 & Serializable)x$7 -> {
                        $anon$3.$anonfun$log$1(this, x$7);
                        return BoxedUnit.UNIT;
                    };
                } else {
                    boolean bl2 = InfoLogLevel.WARN_LEVEL.equals(infoLogLevel2) ? true : InfoLogLevel.INFO_LEVEL.equals(infoLogLevel2);
                    intersect = bl2 ? (Function1 & Serializable)x$8 -> {
                        $anon$3.$anonfun$log$2(this, x$8);
                        return BoxedUnit.UNIT;
                    } : (InfoLogLevel.DEBUG_LEVEL.equals(infoLogLevel2) ? (Function1 & Serializable)x$9 -> {
                        $anon$3.$anonfun$log$3(this, x$9);
                        return BoxedUnit.UNIT;
                    } : (Function1 & Serializable)x$10 -> {
                        $anon$3.$anonfun$log$4(this, x$10);
                        return BoxedUnit.UNIT;
                    });
                }
                Function1 & Serializable loggingFunc = intersect;
                loggingFunc.apply((Function0 & Serializable)() -> new StringBuilder(17).append("[NativeRocksDB-").append(infoLogLevel.getValue()).append("] ").append(logMsg).toString());
            }

            public static final /* synthetic */ void $anonfun$log$1($anon$3 $this, Function0 x$7) {
                $this.$outer.logError((Function0<String>)x$7);
            }

            public static final /* synthetic */ void $anonfun$log$2($anon$3 $this, Function0 x$8) {
                $this.$outer.logInfo((Function0<String>)x$8);
            }

            public static final /* synthetic */ void $anonfun$log$3($anon$3 $this, Function0 x$9) {
                $this.$outer.logDebug((Function0<String>)x$9);
            }

            public static final /* synthetic */ void $anonfun$log$4($anon$3 $this, Function0 x$10) {
                $this.$outer.logTrace((Function0<String>)x$10);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$log$1$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$2$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$3$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$4$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$5(org.rocksdb.InfoLogLevel java.lang.String )}, serializedLambda);
            }
        };
        ObjectRef dbLogLevel = ObjectRef.create((Object)InfoLogLevel.ERROR_LEVEL);
        if (this.log().isWarnEnabled()) {
            dbLogLevel.elem = InfoLogLevel.WARN_LEVEL;
        }
        if (this.log().isInfoEnabled()) {
            dbLogLevel.elem = InfoLogLevel.INFO_LEVEL;
        }
        if (this.log().isDebugEnabled()) {
            dbLogLevel.elem = InfoLogLevel.DEBUG_LEVEL;
        }
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setLogger(dbLogger);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setInfoLogLevel((InfoLogLevel)dbLogLevel.elem);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Set RocksDB native logging level to ").append((InfoLogLevel)dbLogLevel$1.elem).toString());
        return var1_1;
    }

    private File createTempDir(String prefix) {
        return Utils$.MODULE$.createDirectory(this.localRootDir.getAbsolutePath(), prefix);
    }

    private void silentDeleteRecursively(File file, String msg) {
        try {
            Utils$.MODULE$.deleteRecursively(file);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error recursively deleting local dir ").append(file).append(" while ").append(msg).toString(), e);
        }
    }

    public long timeTakenMs(Function0<BoxedUnit> body) {
        return Utils$.MODULE$.timeTakenMs(body)._2$mcJ$sp();
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RocksIterator $anonfun$prefixScan$1(RocksDB $this, long tid) {
        void var3_2;
        RocksIterator it = $this.writeBatch().newIteratorWithBase($this.db().newIterator());
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("Getting iterator from version ").append($this.loadedVersion()).append(" for prefix scan on ").toString()).append(new StringBuilder(10).append("thread ID ").append(tid).toString()).toString());
        return var3_2;
    }

    public static final /* synthetic */ long $anonfun$metrics$2(RocksDB $this, TickerType typ) {
        return $this.nativeStats().getTickerCount(typ);
    }

    private static final long timeWaitedMs$1(long waitStartTime$1) {
        return System.currentTimeMillis() - waitStartTime$1;
    }

    private final boolean isAcquiredByDifferentThread$1(AcquiredThreadInfo newAcquiredThreadInfo$1) {
        return this.acquiredThreadInfo() != null && this.acquiredThreadInfo().threadRef().get().isDefined() && ((Thread)newAcquiredThreadInfo$1.threadRef().get().get()).getId() != ((Thread)this.acquiredThreadInfo().threadRef().get().get()).getId();
    }

    public static final /* synthetic */ void $anonfun$closePrefixScanIterators$1(Map.Entry x$6) {
        ((AbstractImmutableNativeReference)x$6.getValue()).close();
    }

    public RocksDB(String dfsRootDir, RocksDBConf conf, File localRootDir, Configuration hadoopConf, String loggingId) {
        this.conf = conf;
        this.localRootDir = localRootDir;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        RocksDBLoader$.MODULE$.loadLibrary();
        this.readOptions = new ReadOptions();
        this.writeOptions = new WriteOptions().setSync(true);
        this.flushOptions = new FlushOptions().setWaitForFlush(true);
        this.writeBatch = new WriteBatchWithIndex(true);
        this.bloomFilter = new BloomFilter();
        this.tableFormatConfig = new BlockBasedTableConfig();
        this.tableFormatConfig().setBlockSize(conf.blockSizeKB() * 1024L);
        this.tableFormatConfig().setBlockCache((Cache)new LRUCache(conf.blockCacheSizeMB() * 1024L * 1024L));
        this.tableFormatConfig().setFilterPolicy((Filter)this.bloomFilter());
        this.tableFormatConfig().setFormatVersion(conf.formatVersion());
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions = new Options();
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setCreateIfMissing(true);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setTableFormatConfig((TableFormatConfig)this.tableFormatConfig());
        this.dbLogger = this.createLogger();
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setStatistics(new Statistics());
        this.nativeStats = this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().statistics();
        this.workingDir = this.createTempDir("workingDir");
        this.fileManager = new RocksDBFileManager(dfsRootDir, this.createTempDir("fileManager"), hadoopConf, loggingId);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair = new ByteArrayPair(ByteArrayPair$.MODULE$.$lessinit$greater$default$1(), ByteArrayPair$.MODULE$.$lessinit$greater$default$2());
        this.commitLatencyMs = new HashMap();
        this.acquireLock = new Object();
        this.loadedVersion = -1L;
        this.numKeysOnLoadedVersion = 0L;
        this.numKeysOnWritingVersion = 0L;
        this.fileManagerMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.prefixScanReuseIter = new ConcurrentHashMap();
    }
}

