/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class JDBCRDD$
implements Logging,
Serializable {
    public static final JDBCRDD$ MODULE$ = new JDBCRDD$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StructType resolveTable(JDBCOptions options) {
        String url = options.url();
        String table = options.tableOrQuery();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        return this.getQueryOutputSchema(dialect.getSchemaQuery(table), options, dialect);
    }

    public StructType getQueryOutputSchema(String query, JDBCOptions options, JdbcDialect dialect) {
        StructType structType;
        try (Connection conn = (Connection)dialect.createConnectionFactory(options).apply((Object)BoxesRunTime.boxToInteger((int)-1));
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setQueryTimeout(options.queryTimeout());
            try (ResultSet rs = statement.executeQuery();){
                structType = JdbcUtils$.MODULE$.getSchema(rs, dialect, true);
            }
        }
        return structType;
    }

    private StructType pruneSchema(StructType schema, String[] columns) {
        Map fieldMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.name()), x), ClassTag$.MODULE$.apply(Tuple2.class))));
        return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)name -> (StructField)fieldMap.apply(name), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public RDD<InternalRow> scanTable(SparkContext sc, StructType schema, String[] requiredColumns, Predicate[] predicates, Partition[] parts, JDBCOptions options, Option<StructType> outputSchema, Option<String[]> groupByColumns, Option<TableSampleInfo> sample, int limit, SortOrder[] sortOrders) {
        String url = options.url();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String[] quotedColumns = groupByColumns.isEmpty() ? (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])requiredColumns), (Function1 & Serializable)colName -> dialect.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class)) : requiredColumns;
        return new JDBCRDD(sc, dialect.createConnectionFactory(options), (StructType)outputSchema.getOrElse((Function0 & Serializable)() -> MODULE$.pruneSchema(schema, requiredColumns)), quotedColumns, predicates, parts, url, options, groupByColumns, sample, limit, sortOrders);
    }

    public Option<StructType> scanTable$default$7() {
        return None$.MODULE$;
    }

    public Option<String[]> scanTable$default$8() {
        return None$.MODULE$;
    }

    public Option<TableSampleInfo> scanTable$default$9() {
        return None$.MODULE$;
    }

    public int scanTable$default$10() {
        return 0;
    }

    public SortOrder[] scanTable$default$11() {
        return (SortOrder[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SortOrder.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCRDD$.class);
    }

    private JDBCRDD$() {
    }
}

