/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u0013&\u0001IB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011M\u0004!Q1A\u0005BQD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\n\u0003\u0013\u0001!\u0019!C!\u0003\u0017A\u0001\"a\u0007\u0001A\u0003%\u0011Q\u0002\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0002C\u0006\u00024\u0001\u0001\r\u00111A\u0005\n\u0005U\u0002bCA!\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CA1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011BA-\u0011-\ti\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0014\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003K\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0007\u0003\u0006\u0002l\u0001\u0001\r\u0011!Q!\nADq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002t\u0001!\t&a\b\t\u000f\u0005U\u0004\u0001\"\u0015\u0002N!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBA>\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003{\u0002A\u0011IA@\u0011\u001d\t\t\n\u0001C!\u0003'Cq!a'\u0001\t\u0003\tijB\u0004\u0002*\u0016B\t!a+\u0007\r\u0011*\u0003\u0012AAW\u0011\u0019Qh\u0004\"\u0001\u0002B\"A\u00111\u0019\u0010\u0005\u0002%\n)\rC\u0005\u0002pz\t\n\u0011\"\u0001\u0002r\"I!q\u0001\u0010\u0012\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005\u001bq\u0012\u0013!C\u0001\u0005\u001f\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u0015\t1s%A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0015*\u0003%)\u00070Z2vi&|gN\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001gA\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u001b!\u0006\u0014H/\u001b;j_:LgnZ!xCJ,g)\u001b7f\u0013:$W\r_\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003sij\u0011!K\u0005\u0003w%\u0012Ab\u00159be.\u001cVm]:j_:\f!C]8piB\u000bG\u000f[:Ta\u0016\u001c\u0017NZ5fIB\u0019a\bS&\u000f\u0005}*eB\u0001!D\u001b\u0005\t%B\u0001\"2\u0003\u0019a$o\\8u}%\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u000f\u00069\u0001/Y2lC\u001e,'\"\u0001#\n\u0005%S%aA*fc*\u0011ai\u0012\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b!AZ:\u000b\u0005Ak\u0013A\u00025bI>|\u0007/\u0003\u0002S\u001b\n!\u0001+\u0019;i\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005+fcFL\u0004\u0002W/B\u0011\u0001iR\u0005\u00031\u001e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\ri\u0015\r\u001d\u0006\u00031\u001e\u0003\"!V/\n\u0005y[&AB*ue&tw-A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rE\u0002bE\u0012l\u0011aR\u0005\u0003G\u001e\u0013aa\u00149uS>t\u0007CA3i\u001b\u00051'BA4*\u0003\u0015!\u0018\u0010]3t\u0013\tIgM\u0001\u0006TiJ,8\r\u001e+za\u0016\fqBZ5mKN#\u0018\r^;t\u0007\u0006\u001c\u0007.\u001a\t\u0003i1L!!\\\u0013\u0003\u001f\u0019KG.Z*uCR,8oQ1dQ\u0016\f!$^:feN\u0003XmY5gS\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e\u00042!\u00192q!\t!\u0014/\u0003\u0002sK\ti\u0001+\u0019:uSRLwN\\*qK\u000e\f\u0011#\\3uC\u0012\fG/Y(qgRKW.\u001a(t+\u0005)\bcA1cmB\u0011\u0011m^\u0005\u0003q\u001e\u0013A\u0001T8oO\u0006\u0011R.\u001a;bI\u0006$\u0018m\u00149t)&lWMT:!\u0003\u0019a\u0014N\\5u}QaA0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\bA\u0011A\u0007\u0001\u0005\u0006o%\u0001\r\u0001\u000f\u0005\u0006y%\u0001\r!\u0010\u0005\u0006'&\u0001\r\u0001\u0016\u0005\u0006?&\u0001\r\u0001\u0019\u0005\bU&\u0001\n\u00111\u0001l\u0011\u001dq\u0017\u0002%AA\u0002=Dqa]\u0005\u0011\u0002\u0003\u0007Q/A\u0005s_>$\b+\u0019;igV\u0011\u0011Q\u0002\t\u0006\u0003\u001f\tIbS\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003/9\u0015AC2pY2,7\r^5p]&\u0019\u0011*!\u0005\u0002\u0015I|w\u000e\u001e)bi\"\u001c\b%A\bdC\u000eDW\r\u001a'fC\u001a4\u0015\u000e\\3t+\t\t\t\u0003E\u0004\u0002$\u0005%2*!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003+\tq!\\;uC\ndW-\u0003\u0003\u0002,\u0005\u0015\"!\u0004'j].,G\rS1tQ6\u000b\u0007\u000fE\u0002M\u0003_I1!!\rN\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u0014G\u0006\u001c\u0007.\u001a3MK\u00064g)\u001b7fg~#S-\u001d\u000b\u0005\u0003o\ti\u0004E\u0002b\u0003sI1!a\u000fH\u0005\u0011)f.\u001b;\t\u0013\u0005}R\"!AA\u0002\u0005\u0005\u0012a\u0001=%c\u0005\u00012-Y2iK\u0012dU-\u00194GS2,7\u000f\t\u0015\u0004\u001d\u0005\u0015\u0003cA1\u0002H%\u0019\u0011\u0011J$\u0003\u0011Y|G.\u0019;jY\u0016\fAdY1dQ\u0016$G*Z1g\t&\u0014Hk\\\"iS2$'/\u001a8GS2,7/\u0006\u0002\u0002PA)Q+W&\u0002RA)\u0011-a\u0015\u0002.%\u0019\u0011QK$\u0003\u000b\u0005\u0013(/Y=\u0002A\r\f7\r[3e\u0019\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fg~#S-\u001d\u000b\u0005\u0003o\tY\u0006C\u0005\u0002@A\t\t\u00111\u0001\u0002P\u0005i2-Y2iK\u0012dU-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001c\b\u0005K\u0002\u0012\u0003\u000b\n1cY1dQ\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e,\u0012\u0001]\u0001\u0018G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003XmY0%KF$B!a\u000e\u0002j!A\u0011qH\n\u0002\u0002\u0003\u0007\u0001/\u0001\u000bdC\u000eDW\r\u001a)beRLG/[8o'B,7\r\t\u0015\u0004)\u0005\u0015\u0013!\u00049beRLG/[8o'B,7\rF\u0001q\u0003%aW-\u00194GS2,7/\u0001\fmK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3t\u0003\u001d\u0011XM\u001a:fg\"$\"!a\u000e\u0002\u0011I,gM]3tQB\na!Z9vC2\u001cH\u0003BAA\u0003\u000f\u00032!YAB\u0013\r\t)i\u0012\u0002\b\u0005>|G.Z1o\u0011\u001d\tII\u0007a\u0001\u0003\u0017\u000bQa\u001c;iKJ\u00042!YAG\u0013\r\tyi\u0012\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0005cA1\u0002\u0018&\u0019\u0011\u0011T$\u0003\u0007%sG/A\u0007mSN$H*Z1g\r&dWm\u001d\u000b\u0005\u0003?\u000b)\u000b\u0005\u0004\u0002$\u0005\u0005\u0016QF\u0005\u0005\u0003G\u000b)CA\u0007MS:\\W\r\u001a%bg\"\u001cV\r\u001e\u0005\u0007\u0003Oc\u0002\u0019A\u001f\u0002\u000bA\fG\u000f[:\u0002#%sW*Z7pef4\u0015\u000e\\3J]\u0012,\u0007\u0010\u0005\u00025=M)a$a,\u00026B\u0019\u0011-!-\n\u0007\u0005MvI\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111X\u0016\u0002\u0011%tG/\u001a:oC2LA!a0\u0002:\n9Aj\\4hS:<GCAAV\u0003E\u0011W\u000f\\6MSN$H*Z1g\r&dWm\u001d\u000b\u000b\u0003\u000f\f\t.a5\u0002d\u00065\b\u0003\u0002 I\u0003\u0013\u0004b!YAf\u0017\u0006=\u0017bAAg\u000f\n1A+\u001e9mKJ\u0002BA\u0010%\u0002.!1\u0011q\u0015\u0011A\u0002uBq!!6!\u0001\u0004\t9.\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0004\u0003;|\u0015\u0001B2p]\u001aLA!!9\u0002\\\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!!:!\u0001\u0004\t9/\u0001\u0004gS2$XM\u001d\t\u0004\u0019\u0006%\u0018bAAv\u001b\nQ\u0001+\u0019;i\r&dG/\u001a:\t\u000b]\u0002\u0003\u0019\u0001\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\u0019PK\u0002l\u0003k\\#!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u00039\u0015AC1o]>$\u0018\r^5p]&!!QAA~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t-!fA8\u0002v\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"A!\u0005+\u0007U\f)\u0010")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private final Option<PartitionSpec> userSpecifiedPartitionSpec;
    private final Option<Object> metadataOpsTimeNs;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static Option<Object> $lessinit$greater$default$7() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<PartitionSpec> $lessinit$greater$default$6() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return this.metadataOpsTimeNs;
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            if (this.userSpecifiedPartitionSpec.isDefined()) {
                this.cachedPartitionSpec_$eq((PartitionSpec)this.userSpecifiedPartitionSpec.get());
            } else {
                this.cachedPartitionSpec_$eq(this.inferPartitioning());
            }
        }
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((IterableOnce)files.map((Function1 & Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f)))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class))), (Function1 & Serializable)x$5 -> x$5.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable)path -> {
            InMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch.toSeq(), this.hadoopConf(), filter, this.sparkSession);
        discovered.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((IterableOnce)leafFiles);
            return linkedHashSet;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(30).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").toString()).append(new StringBuilder(12).append(" for ").append(paths.length()).append(" paths.").toString()).toString());
        return output;
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(InMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        AbstractIterable abstractIterable;
        Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            abstractIterable = (AbstractIterable)output$1.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])files));
        } else if (None$.MODULE$.equals(option)) {
            abstractIterable = (AbstractIterable)pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError(option);
        }
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache, Option<PartitionSpec> userSpecifiedPartitionSpec, Option<Object> metadataOpsTimeNs) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        this.userSpecifiedPartitionSpec = userSpecifiedPartitionSpec;
        this.metadataOpsTimeNs = metadataOpsTimeNs;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }
}

