/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\u00180\u0001aB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0007\u0015\u0002!\taL&\t\u000b9\u0003A\u0011A(\t\u000bu\u0003A\u0011\u00010\t\u000bu\u0003A\u0011\u00014\t\u000b%\u0004A\u0011\u00016\t\u000b%\u0004A\u0011A8\t\u000b%\u0004A\u0011A;\t\u000b%\u0004A\u0011A>\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u00111\u0001\u0001\u0005\u0002\u0005U\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003O\u0001A\u0011AA\u001d\u0011\u001d\t9\u0003\u0001C\u0001\u0003\u007fAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005}\u0003\u0001\"\u0001\u0002v!9\u0011q\f\u0001\u0005\u0002\u0005U\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003O\u0003A\u0011AAW\u0011\u001d\t9\u000b\u0001C\u0001\u0003gCq!a*\u0001\t\u0003\tY\u000eC\u0004\u0002(\u0002!\t!!<\t\u000f\u0005e\b\u0001\"\u0001\u0002|\"9\u0011\u0011 \u0001\u0005\u0002\u0005}\bbBA}\u0001\u0011\u0005!Q\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005#AqAa\u0006\u0001\t\u0003\u0011I\u0002C\u0004\u0003\u0018\u0001!\tA!\b\t\u000f\u0005%\u0004\u0001\"\u0001\u0003$!9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B\u0015\u0001\u0011\u0005!q\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011)\u0004\u0001C\u0001\u0005wAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005\u0003\u0005R\u0001\u0001\u0007I\u0011\u0002B(\u0011%\u0011\t\u0006\u0001a\u0001\n\u0013\u0011\u0019\u0006C\u0004\u0003Z\u0001\u0001\u000b\u0015\u0002*\t\u0013\tm\u0003\u00011A\u0005\n\tu\u0003\"\u0003B3\u0001\u0001\u0007I\u0011\u0002B4\u0011!\u0011Y\u0007\u0001Q!\n\t}\u0003\"\u0003B7\u0001\u0001\u0007I\u0011\u0002B8\u0011%\u0011y\b\u0001a\u0001\n\u0013\u0011\t\t\u0003\u0005\u0003\u0006\u0002\u0001\u000b\u0015\u0002B9\u0005=!\u0015\r^1Ge\u0006lWMU3bI\u0016\u0014(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011c\u0001\u0001:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0019\u0002\u0011%tG/\u001a:oC2L!\u0001R!\u0003\u000f1{wmZ5oO\u0006a1\u000f]1sWN+7o]5p]B\u0011q\tS\u0007\u0002_%\u0011\u0011j\f\u0002\r'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051k\u0005CA$\u0001\u0011\u0015)%\u00011\u0001G\u0003\u00191wN]7biR\u0011A\n\u0015\u0005\u0006#\u000e\u0001\rAU\u0001\u0007g>,(oY3\u0011\u0005MSfB\u0001+Y!\t)6(D\u0001W\u0015\t9v'\u0001\u0004=e>|GOP\u0005\u00033n\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011lO\u0001\u0007g\u000eDW-\\1\u0015\u00051{\u0006\"B/\u0005\u0001\u0004\u0001\u0007CA1e\u001b\u0005\u0011'BA20\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\u0006TiJ,8\r\u001e+za\u0016$\"\u0001T4\t\u000b!,\u0001\u0019\u0001*\u0002\u0019M\u001c\u0007.Z7b'R\u0014\u0018N\\4\u0002\r=\u0004H/[8o)\ra5.\u001c\u0005\u0006Y\u001a\u0001\rAU\u0001\u0004W\u0016L\b\"\u00028\u0007\u0001\u0004\u0011\u0016!\u0002<bYV,Gc\u0001'qc\")An\u0002a\u0001%\")an\u0002a\u0001eB\u0011!h]\u0005\u0003in\u0012qAQ8pY\u0016\fg\u000eF\u0002Mm^DQ\u0001\u001c\u0005A\u0002ICQA\u001c\u0005A\u0002a\u0004\"AO=\n\u0005i\\$\u0001\u0002'p]\u001e$2\u0001\u0014?~\u0011\u0015a\u0017\u00021\u0001S\u0011\u0015q\u0017\u00021\u0001\u007f!\tQt0C\u0002\u0002\u0002m\u0012a\u0001R8vE2,\u0017aB8qi&|gn\u001d\u000b\u0004\u0019\u0006\u001d\u0001bBA\u0002\u0015\u0001\u0007\u0011\u0011\u0002\t\u0007\u0003\u0017\t\tB\u0015*\u000e\u0005\u00055!bAA\bw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\u0004\u001b\u0006\u0004Hc\u0001'\u0002\u0018!9\u00111A\u0006A\u0002\u0005e\u0001CBA\u000e\u0003K\u0011&+\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0012\u0001\u00026bm\u0006LA!a\u0005\u0002\u001e\u0005!An\\1e)\t\tY\u0003\u0005\u0003\u0002.\u0005MbbA$\u00020%\u0019\u0011\u0011G\u0018\u0002\u000fA\f7m[1hK&!\u0011QGA\u001c\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u00022=\"B!a\u000b\u0002<!1\u0011QH\u0007A\u0002I\u000bA\u0001]1uQR!\u00111FA!\u0011\u001d\t\u0019E\u0004a\u0001\u0003\u000b\nQ\u0001]1uQN\u0004BAOA$%&\u0019\u0011\u0011J\u001e\u0003\u0015q\u0012X\r]3bi\u0016$g\bK\u0002\u000f\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'Z\u0014AC1o]>$\u0018\r^5p]&!\u0011qKA)\u0005\u001d1\u0018M]1sON\fA\u0002\\8bIZ\u000b4k\\;sG\u0016$B!a\u000b\u0002^!9\u00111I\bA\u0002\u0005\u0015\u0013\u0001\u00026eE\u000e$\u0002\"a\u000b\u0002d\u0005\u001d\u00141\u000e\u0005\u0007\u0003K\u0002\u0002\u0019\u0001*\u0002\u0007U\u0014H\u000e\u0003\u0004\u0002jA\u0001\rAU\u0001\u0006i\u0006\u0014G.\u001a\u0005\b\u0003[\u0002\u0002\u0019AA8\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u00037\t\t(\u0003\u0003\u0002t\u0005u!A\u0003)s_B,'\u000f^5fgR\u0001\u00121FA<\u0003s\nY(a \u0002\u0004\u0006\u001d\u0015\u0011\u0013\u0005\u0007\u0003K\n\u0002\u0019\u0001*\t\r\u0005%\u0014\u00031\u0001S\u0011\u0019\ti(\u0005a\u0001%\u0006Q1m\u001c7v[:t\u0015-\\3\t\r\u0005\u0005\u0015\u00031\u0001y\u0003)awn^3s\u0005>,h\u000e\u001a\u0005\u0007\u0003\u000b\u000b\u0002\u0019\u0001=\u0002\u0015U\u0004\b/\u001a:C_VtG\rC\u0004\u0002\nF\u0001\r!a#\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\rQ\u0014QR\u0005\u0004\u0003\u001f[$aA%oi\"9\u00111S\tA\u0002\u0005=\u0014\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0006\u0006\u0002,\u0005]\u0015\u0011TAN\u0003KCa!!\u001a\u0013\u0001\u0004\u0011\u0006BBA5%\u0001\u0007!\u000bC\u0004\u0002\u001eJ\u0001\r!a(\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0003;\u0003C\u0013\u0016bAARw\t)\u0011I\u001d:bs\"9\u00111\u0013\nA\u0002\u0005=\u0014\u0001\u00026t_:$B!a\u000b\u0002,\"1\u0011QH\nA\u0002I#B!a\u000b\u00020\"9\u00111\t\u000bA\u0002\u0005\u0015\u0003f\u0001\u000b\u0002NQ!\u00111FA[\u0011\u001d\t9,\u0006a\u0001\u0003s\u000bqA[:p]J#E\tE\u0003\u0002<\u0006\r'+\u0004\u0002\u0002>*!\u00111EA`\u0015\r\t\t-M\u0001\u0004CBL\u0017\u0002BAc\u0003{\u0013qAS1wCJ#E\tK\u0006\u0016\u0003\u0013\fy-!5\u0002V\u0006]\u0007c\u0001\u001e\u0002L&\u0019\u0011QZ\u001e\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0005\u0005M\u0017AI+tK\u0002R7o\u001c8)\t\u0006$\u0018m]3u7N#(/\u001b8h;&\u0002\u0013N\\:uK\u0006$g&A\u0003tS:\u001cW-\t\u0002\u0002Z\u0006)!G\f\u001a/aQ!\u00111FAo\u0011\u001d\t9L\u0006a\u0001\u0003?\u0004R!!9\u0002hJk!!a9\u000b\u0007\u0005\u0015\u0018'A\u0002sI\u0012LA!!;\u0002d\n\u0019!\u000b\u0012#)\u0017Y\tI-a4\u0002R\u0006U\u0017q\u001b\u000b\u0005\u0003W\ty\u000fC\u0004\u0002r^\u0001\r!a=\u0002\u0017)\u001cxN\u001c#bi\u0006\u001cX\r\u001e\t\u0005\u000f\u0006U(+C\u0002\u0002x>\u0012q\u0001R1uCN,G/A\u0002dgZ$B!a\u000b\u0002~\"1\u0011Q\b\rA\u0002I#B!a\u000b\u0003\u0002!9!1A\rA\u0002\u0005M\u0018AC2tm\u0012\u000bG/Y:fiR!\u00111\u0006B\u0004\u0011\u001d\t\u0019E\u0007a\u0001\u0003\u000bB3AGA'\u0003\u001d\u0001\u0018M]9vKR$B!a\u000b\u0003\u0010!1\u0011QH\u000eA\u0002I#B!a\u000b\u0003\u0014!9\u00111\t\u000fA\u0002\u0005\u0015\u0003f\u0001\u000f\u0002N\u0005\u0019qN]2\u0015\t\u0005-\"1\u0004\u0005\u0007\u0003{i\u0002\u0019\u0001*\u0015\t\u0005-\"q\u0004\u0005\b\u0003\u0007r\u0002\u0019AA#Q\rq\u0012Q\n\u000b\u0005\u0003W\u0011)\u0003\u0003\u0004\u0003(}\u0001\rAU\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fA\u0001^3yiR!\u00111\u0006B\u0017\u0011\u0019\ti\u0004\ta\u0001%R!\u00111\u0006B\u0019\u0011\u001d\t\u0019%\ta\u0001\u0003\u000bB3!IA'\u0003!!X\r\u001f;GS2,G\u0003BAz\u0005sAa!!\u0010#\u0001\u0004\u0011F\u0003BAz\u0005{Aq!a\u0011$\u0001\u0004\t)\u0005K\u0002$\u0003\u001b\nq#Y:tKJ$hj\\*qK\u000eLg-[3e'\u000eDW-\\1\u0015\t\t\u0015#1\n\t\u0004u\t\u001d\u0013b\u0001B%w\t!QK\\5u\u0011\u0019\u0011i\u0005\na\u0001%\u0006Iq\u000e]3sCRLwN\\\u000b\u0002%\u0006Q1o\\;sG\u0016|F%Z9\u0015\t\t\u0015#Q\u000b\u0005\t\u0005/2\u0013\u0011!a\u0001%\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM|WO]2fA\u0005\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nCV\u0011!q\f\t\u0005u\t\u0005\u0004-C\u0002\u0003dm\u0012aa\u00149uS>t\u0017aF;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fw\fJ3r)\u0011\u0011)E!\u001b\t\u0013\t]\u0013&!AA\u0002\t}\u0013\u0001F;tKJ\u001c\u0006/Z2jM&,GmU2iK6\f\u0007%\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0003rA)!1\u000fB>%6\u0011!Q\u000f\u0006\u0005\u0003?\u00119HC\u0002\u0003z=\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0005{\u0012)H\u0001\nDCN,\u0017J\\:f]NLG/\u001b<f\u001b\u0006\u0004\u0018\u0001E3yiJ\fw\n\u001d;j_:\u001cx\fJ3r)\u0011\u0011)Ea!\t\u0013\t]C&!AA\u0002\tE\u0014!D3yiJ\fw\n\u001d;j_:\u001c\b\u0005K\u0002\u0001\u0005\u0013\u0003BAa#\u0003\u00106\u0011!Q\u0012\u0006\u0004\u0003'\n\u0014\u0002\u0002BI\u0005\u001b\u0013aa\u0015;bE2,\u0007")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        return this.schema(StructType$.MODULE$.fromDDL(schemaString));
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public Dataset<Row> load(String path) {
        return this.sparkSession.sessionState().conf().legacyPathOptionBehavior() ? this.option("path", path).load((Seq<String>)((Seq)package$.MODULE$.Seq().empty())) : this.load((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("read");
        }
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        if (!legacyPathOptionBehavior && (this.extraOptions().contains("path") || this.extraOptions().contains("paths")) && paths.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.pathOptionNotSetCorrectlyWhenReadingError();
        }
        return (Dataset)DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.sparkSession.sessionState().conf()).flatMap((Function1 & Serializable)provider -> DataSourceV2Utils$.MODULE$.loadV2Source($this.sparkSession, (TableProvider)provider, this.userSpecifiedSchema(), this.extraOptions(), this.source(), paths)).getOrElse((Function0 & Serializable)() -> this.loadV1Source(paths));
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        Tuple2 tuple2;
        boolean legacyPathOptionBehavior = this.sparkSession.sessionState().conf().legacyPathOptionBehavior();
        Tuple2 tuple22 = tuple2 = !legacyPathOptionBehavior && paths.length() == 1 ? new Tuple2((Object)package$.MODULE$.Nil(), (Object)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), paths.head()))) : new Tuple2(paths, this.extraOptions());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq finalPaths = (Seq)tuple2._1();
        CaseInsensitiveMap finalOptions = (CaseInsensitiveMap)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)finalPaths, (Object)finalOptions);
        Tuple2 tuple24 = tuple23;
        Seq finalPaths2 = (Seq)tuple24._1();
        CaseInsensitiveMap finalOptions2 = (CaseInsensitiveMap)tuple24._2();
        SparkSession x$1 = this.sparkSession;
        Seq x$2 = finalPaths2;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = finalOptions2.originalMap();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, (Seq<String>)x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table)}))));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)Long.toString(lowerBound)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)Long.toString(upperBound)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)Integer.toString(numPartitions))}))));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((IterableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])predicates))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, ClassTag$.MODULE$.apply(Partition.class));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)x$2 -> {
            DataFrameReader.$anonfun$json$1(x$2);
            return BoxedUnit.UNIT;
        });
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        this.userSpecifiedSchema().foreach((Function1 & Serializable)x$4 -> {
            DataFrameReader.$anonfun$json$3(x$4);
            return BoxedUnit.UNIT;
        });
        StructType schema = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            StructType structType2 = !BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION())) ? structType.asNullable() : structType;
            return structType2;
        }).getOrElse((Function0 & Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$7(parsedOptions, x$6))));
        Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true, JacksonParser$.MODULE$.$lessinit$greater$default$4());
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))) : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().map((Function1 & Serializable)x0$1 -> {
            StructType structType = x0$1;
            StructType structType2 = !BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_RESPECT_NULLABILITY_IN_TEXT_DATASET_CONVERSION())) ? structType.asNullable() : structType;
            return structType2;
        }).getOrElse(() -> DataFrameReader.$anonfun$csv$2(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$3(parsedOptions, x$7))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, new StringBuilder(12).append("CSV source: ").append(csvDataset).toString(), CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable)x$8 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$8, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable((Option)rawParser.parse().apply(input)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        Seq multipartIdentifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(multipartIdentifier, new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.extraOptions().toMap()).asJava()), UnresolvedRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Nil$.MODULE$).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ void $anonfun$json$1(StructType x$2) {
        ExprUtils$.MODULE$.checkJsonSchema((DataType)x$2).foreach((Function1 & Serializable)x$3 -> {
            throw x$3;
        });
    }

    public static final /* synthetic */ void $anonfun$json$3(StructType x$4) {
        ExprUtils$.MODULE$.checkJsonSchema((DataType)x$4).foreach((Function1 & Serializable)x$5 -> {
            throw x$5;
        });
    }

    public static final /* synthetic */ boolean $anonfun$json$7(JSONOptions parsedOptions$1, StructField x$6) {
        String string = x$6.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$2(DataFrameReader $this, Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$3(CSVOptions parsedOptions$2, StructField x$7) {
        String string = x$7.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

