/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousDataSourceRDDPartition;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousQueuedDataReader;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTaskRetryException;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.util.NextIterator;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001E\u0011qcQ8oi&tWo\\;t\t\u0006$\u0018mU8ve\u000e,'\u000b\u0012#\u000b\u0005\r!\u0011AC2p]RLg.^8vg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\r\u0019b\u0003G\u0007\u0002))\u0011QCC\u0001\u0004e\u0012$\u0017BA\f\u0015\u0005\r\u0011F\t\u0012\t\u00033qi\u0011A\u0007\u0006\u00037!\t\u0001bY1uC2L8\u000f^\u0005\u0003;i\u00111\"\u00138uKJt\u0017\r\u001c*po\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0002tGB\u0011\u0011EI\u0007\u0002\u0015%\u00111E\u0003\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005iA-\u0019;b#V,W/Z*ju\u0016\u0004\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u00121!\u00138u\u0011!i\u0003A!A!\u0002\u0013q\u0013aE3q_\u000eD\u0007k\u001c7m\u0013:$XM\u001d<bY6\u001b\bCA\u00140\u0013\t\u0001\u0004F\u0001\u0003M_:<\u0007\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011B\u001a\u0002+I,\u0017\rZ3s\u0013:\u0004X\u000f\u001e)beRLG/[8ogV\tA\u0007E\u00026{\u0001s!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005e\u0002\u0012A\u0002\u001fs_>$h(C\u0001*\u0013\ta\u0004&A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$aA*fc*\u0011A\b\u000b\t\u0004\u0003\"CR\"\u0001\"\u000b\u0005\r#\u0015A\u0002:fC\u0012,'O\u0003\u0002F\r\u0006\u0011aO\r\u0006\u0003\u000f\"\tqa]8ve\u000e,7/\u0003\u0002J\u0005\nq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0007\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002-I,\u0017\rZ3s\u0013:\u0004X\u000f\u001e)beRLG/[8og\u0002BQ!\u0014\u0001\u0005\u00029\u000ba\u0001P5oSRtD#B(R%N#\u0006C\u0001)\u0001\u001b\u0005\u0011\u0001\"B\u0010M\u0001\u0004\u0001\u0003\"B\u0013M\u0001\u00041\u0003\"B\u0017M\u0001\u0004q\u0003\"\u0002\u001aM\u0001\u0004!\u0004\"\u0002,\u0001\t#:\u0016!D4fiB\u000b'\u000f^5uS>t7/F\u0001Y!\r9\u0013lW\u0005\u00035\"\u0012Q!\u0011:sCf\u0004\"!\t/\n\u0005uS!!\u0003)beRLG/[8o\u0011\u0015y\u0006\u0001\"\u0011a\u0003\u001d\u0019w.\u001c9vi\u0016$2!\u00193g!\r)$\rG\u0005\u0003G~\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u0006Kz\u0003\raW\u0001\u0006gBd\u0017\u000e\u001e\u0005\u0006Oz\u0003\r\u0001[\u0001\bG>tG/\u001a=u!\t\t\u0013.\u0003\u0002k\u0015\tYA+Y:l\u0007>tG/\u001a=u\u0011\u0015a\u0007\u0001\"\u0011n\u0003U9W\r\u001e)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N$\"A\\<\u0011\u0007Ujt\u000e\u0005\u0002qi:\u0011\u0011O\u001d\t\u0003o!J!a\u001d\u0015\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003g\"BQ!Z6A\u0002m;Q!\u001f\u0002\t\u0002i\fqcQ8oi&tWo\\;t\t\u0006$\u0018mU8ve\u000e,'\u000b\u0012#\u0011\u0005A[h!B\u0001\u0003\u0011\u0003a8\u0003B>~\u0003\u0003\u0001\"a\n@\n\u0005}D#AB!osJ+g\rE\u0002(\u0003\u0007I1!!\u0002)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0019i5\u0010\"\u0001\u0002\nQ\t!\u0010\u0003\u0005\u0002\u000em$\tAAA\b\u0003M9W\r^\"p]RLg.^8vgJ+\u0017\rZ3s)\u0011\t\t\"a\r1\t\u0005M\u0011\u0011\u0005\t\u0007\u0003+\tI\"!\b\u000e\u0005\u0005]!BA\u0003C\u0013\u0011\tY\"a\u0006\u0003=\r{g\u000e^5ok>,8/\u00138qkR\u0004\u0016M\u001d;ji&|gNU3bI\u0016\u0014\b\u0003BA\u0010\u0003Ca\u0001\u0001\u0002\u0007\u0002$\u0005-\u0011\u0011!A\u0001\u0006\u0003\t)CA\u0002`IE\nB!a\n\u0002.A\u0019q%!\u000b\n\u0007\u0005-\u0002FA\u0004O_RD\u0017N\\4\u0011\u0007\u001d\ny#C\u0002\u00022!\u00121!\u00118z\u0011\u001d\u0019\u00151\u0002a\u0001\u0003k\u0001B!QA\u001c1%\u0019\u0011\u0011\b\"\u0003)%s\u0007/\u001e;QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\u0011%\tid_A\u0001\n\u0013\ty$A\u0006sK\u0006$'+Z:pYZ,GCAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\nA\u0001\\1oO*\u0011\u00111J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002P\u0005\u0015#AB(cU\u0016\u001cG\u000f")
public class ContinuousDataSourceRDD
extends RDD<InternalRow> {
    private final int dataQueueSize;
    private final long epochPollIntervalMs;
    private final Seq<InputPartition<InternalRow>> readerInputPartitions;

    private Seq<InputPartition<InternalRow>> readerInputPartitions() {
        return this.readerInputPartitions;
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.readerInputPartitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputPartition inputPartition = (InputPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            ContinuousDataSourceRDDPartition continuousDataSourceRDDPartition = new ContinuousDataSourceRDDPartition(index, inputPartition);
            return continuousDataSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        if (context.attemptNumber() != 0) {
            throw new ContinuousTaskRetryException();
        }
        ContinuousDataSourceRDDPartition partition = (ContinuousDataSourceRDDPartition)split;
        if (partition.queueReader() == null) {
            partition.queueReader_$eq(new ContinuousQueuedDataReader(partition, context, this.dataQueueSize, this.epochPollIntervalMs));
        }
        ContinuousQueuedDataReader readerForPartition = partition.queueReader();
        return new NextIterator<InternalRow>(null, readerForPartition){
            private final ContinuousQueuedDataReader readerForPartition$1;

            public InternalRow getNext() {
                InternalRow internalRow;
                InternalRow internalRow2 = this.readerForPartition$1.next();
                if (internalRow2 == null) {
                    this.finished_$eq(true);
                    internalRow = null;
                } else {
                    internalRow = internalRow2;
                }
                return internalRow;
            }

            public void close() {
            }
            {
                this.readerForPartition$1 = readerForPartition$1;
            }
        };
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])((ContinuousDataSourceRDDPartition)split).inputPartition().preferredLocations());
    }

    public ContinuousDataSourceRDD(SparkContext sc, int dataQueueSize, long epochPollIntervalMs, Seq<InputPartition<InternalRow>> readerInputPartitions) {
        this.dataQueueSize = dataQueueSize;
        this.epochPollIntervalMs = epochPollIntervalMs;
        this.readerInputPartitions = readerInputPartitions;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

