/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\tub!B\u0001\u0003\u0001\t\u0001\"a\u0005)beF,X\r^,sSR,7+\u001e9q_J$(BA\u0002\u0005\u0003\u001d\u0001\u0018M]9vKRT!!\u0002\u0004\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xmE\u0002\u0001#\u0001\u00022A\u0005\r\u001b\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\r\t\u0007/\u001b\u0006\u0003-]\ta\u0001[1e_>\u0004(BA\u0002\r\u0013\tI2C\u0001\u0007Xe&$XmU;qa>\u0014H\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0002 9\tY\u0011J\u001c;fe:\fGNU8x!\t\tC%D\u0001#\u0015\t\u0019#\"\u0001\u0005j]R,'O\\1m\u0013\t)#EA\u0004M_\u001e<\u0017N\\4\t\u000b\u001d\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u000b\t\u0003W\u0001i\u0011AA\u0003\u0005[\u0001!aFA\u0006WC2,Xm\u0016:ji\u0016\u0014\b#B\u00183iijT\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA\u001b9\u001b\u00051$BA\u001c\u001d\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005e2$AE*qK\u000eL\u0017\r\\5{K\u0012<U\r\u001e;feN\u0004\"aL\u001e\n\u0005q\u0002$aA%oiB\u0011qFP\u0005\u0003\u007fA\u0012A!\u00168ji\"I\u0011\t\u0001a\u0001\u0002\u0004%IAQ\u0001\u0007g\u000eDW-\\1\u0016\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0005\u0002\u000bQL\b/Z:\n\u0005!+%AC*ueV\u001cG\u000fV=qK\"I!\n\u0001a\u0001\u0002\u0004%IaS\u0001\u000bg\u000eDW-\\1`I\u0015\fHCA\u001fM\u0011\u001di\u0015*!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011%y\u0005\u00011A\u0001B\u0003&1)A\u0004tG\",W.\u0019\u0011\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0016\u0001\u0005:p_R4\u0015.\u001a7e/JLG/\u001a:t+\u0005\u0019\u0006cA\u0018U-&\u0011Q\u000b\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003/2j\u0011\u0001\u0001\u0005\n3\u0002\u0001\r\u00111A\u0005\ni\u000bAC]8pi\u001aKW\r\u001c3Xe&$XM]:`I\u0015\fHCA\u001f\\\u0011\u001di\u0005,!AA\u0002MC\u0011\"\u0018\u0001A\u0002\u0003\u0005\u000b\u0015B*\u0002#I|w\u000e\u001e$jK2$wK]5uKJ\u001c\b\u0005C\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\u0006q!/Z2pe\u0012\u001cuN\\:v[\u0016\u0014X#A1\u0011\u0005\t4W\"A2\u000b\u0005Q!'BA3\u0018\u0003\tIw.\u0003\u0002hG\nq!+Z2pe\u0012\u001cuN\\:v[\u0016\u0014\b\"C5\u0001\u0001\u0004\u0005\r\u0011\"\u0003k\u0003I\u0011XmY8sI\u000e{gn];nKJ|F%Z9\u0015\u0005uZ\u0007bB'i\u0003\u0003\u0005\r!\u0019\u0005\n[\u0002\u0001\r\u0011!Q!\n\u0005\fqB]3d_J$7i\u001c8tk6,'\u000f\t\u0005\n_\u0002\u0001\r\u00111A\u0005\nA\f\u0001d\u001e:ji\u0016dUmZ1dsB\u000b'/];fi\u001a{'/\\1u+\u0005\t\bCA\u0018s\u0013\t\u0019\bGA\u0004C_>dW-\u00198\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00131\u0018\u0001H<sSR,G*Z4bGf\u0004\u0016M]9vKR4uN]7bi~#S-\u001d\u000b\u0003{]Dq!\u0014;\u0002\u0002\u0003\u0007\u0011\u000fC\u0005z\u0001\u0001\u0007\t\u0011)Q\u0005c\u0006IrO]5uK2+w-Y2z!\u0006\u0014\u0018/^3u\r>\u0014X.\u0019;!\u0011%Y\b\u00011AA\u0002\u0013%A0A\npkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X-F\u0001~!\rq\u0018q\u0002\b\u0004\u007f\u0006%a\u0002BA\u0001\u0003\u000bi!!a\u0001\u000b\u0005\rB\u0011\u0002BA\u0004\u0003\u0007\tqaU)M\u0007>tg-\u0003\u0003\u0002\f\u00055\u0011A\u0007)beF,X\r^(viB,H\u000fV5nKN$\u0018-\u001c9UsB,'\u0002BA\u0004\u0003\u0007IA!!\u0005\u0002\u0014\t)a+\u00197vK&\u0019\u0011Q\u0003\u0019\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\"A\fpkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004Xm\u0018\u0013fcR\u0019Q(!\b\t\u00115\u000b9\"!AA\u0002uD!\"!\t\u0001\u0001\u0004\u0005\t\u0015)\u0003~\u0003QyW\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9fA!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011qE\u0001\u0010i&lWm\u001d;b[B\u0014UO\u001a4feV\u0011\u0011\u0011\u0006\t\u0005_Q\u000bY\u0003E\u00020\u0003[I1!a\f1\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005M\u0002\u0001)A\u0005\u0003S\t\u0001\u0003^5nKN$\u0018-\u001c9Ck\u001a4WM\u001d\u0011\t\u0013\u0005]\u0002A1A\u0005\n\u0005\u001d\u0012!\u00043fG&l\u0017\r\u001c\"vM\u001a,'\u000f\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0015\u00039!WmY5nC2\u0014UO\u001a4fe\u0002Bq!a\u0010\u0001\t\u0003\n\t%\u0001\u0003j]&$H\u0003BA\"\u0003W\u0002B!!\u0012\u0002f9!\u0011qIA1\u001d\u0011\tI%a\u0018\u000f\t\u0005-\u0013Q\f\b\u0005\u0003\u001b\nYF\u0004\u0003\u0002P\u0005ec\u0002BA)\u0003/j!!a\u0015\u000b\u0007\u0005U\u0003&\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00071I!AF\f\n\u0005Q)\u0012bAA2'\u0005aqK]5uKN+\b\u000f]8si&!\u0011qMA5\u000519&/\u001b;f\u0007>tG/\u001a=u\u0015\r\t\u0019g\u0005\u0005\t\u0003[\ni\u00041\u0001\u0002p\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004B!!\u001d\u0002z5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003d_:4'B\u0001\f\r\u0013\u0011\tY(a\u001d\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\ty\b\u0001C!\u0003\u0003\u000bq\u0002\u001d:fa\u0006\u0014XMR8s/JLG/\u001a\u000b\u0004{\u0005\r\u0005BB0\u0002~\u0001\u0007\u0011\rC\u0004\u0002\b\u0002!\t%!#\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007u\nY\tC\u0004\u0002\u000e\u0006\u0015\u0005\u0019\u0001\u000e\u0002\u0007I|w\u000fC\u0004\u0002\u0012\u0002!I!a%\u0002\u0017]\u0014\u0018\u000e^3GS\u0016dGm\u001d\u000b\b{\u0005U\u0015qSAM\u0011\u001d\ti)a$A\u0002iAa!QAH\u0001\u0004\u0019\u0005bBAN\u0003\u001f\u0003\raU\u0001\rM&,G\u000eZ,sSR,'o\u001d\u0005\b\u0003?\u0003A\u0011BAQ\u0003)i\u0017m[3Xe&$XM\u001d\u000b\u0004-\u0006\r\u0006\u0002CAS\u0003;\u0003\r!a*\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042\u0001RAU\u0013\r\tY+\u0012\u0002\t\t\u0006$\u0018\rV=qK\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0016!E7bW\u0016$UmY5nC2<&/\u001b;feR)a+a-\u00028\"9\u0011QWAW\u0001\u0004Q\u0014!\u00039sK\u000eL7/[8o\u0011\u001d\tI,!,A\u0002i\nQa]2bY\u0016Dq!!0\u0001\t\u0003\ty,A\bnC.,\u0017I\u001d:bs^\u0013\u0018\u000e^3s)\r1\u0016\u0011\u0019\u0005\t\u0003\u0007\fY\f1\u0001\u0002F\u0006I\u0011M\u001d:bsRK\b/\u001a\t\u0004\t\u0006\u001d\u0017bAAe\u000b\nI\u0011I\u001d:bsRK\b/\u001a\u0005\b\u0003\u001b\u0004A\u0011BAh\u00035i\u0017m[3NCB<&/\u001b;feR\u0019a+!5\t\u0011\u0005M\u00171\u001aa\u0001\u0003+\fq!\\1q)f\u0004X\rE\u0002E\u0003/L1!!7F\u0005\u001di\u0015\r\u001d+za\u0016Dq!!8\u0001\t\u0013\ty.\u0001\bd_:\u001cX/\\3NKN\u001c\u0018mZ3\u0015\u0007u\n\t\u000fC\u0005\u0002d\u0006mG\u00111\u0001\u0002f\u0006\ta\r\u0005\u00030\u0003Ol\u0014bAAua\tAAHY=oC6,g\bC\u0004\u0002n\u0002!I!a<\u0002\u0019\r|gn];nK\u001e\u0013x.\u001e9\u0015\u0007u\n\t\u0010C\u0005\u0002d\u0006-H\u00111\u0001\u0002f\"9\u0011Q\u001f\u0001\u0005\n\u0005]\u0018\u0001D2p]N,X.\u001a$jK2$GCBA}\u0003{\u0014\t\u0002F\u0002>\u0003wD\u0011\"a9\u0002t\u0012\u0005\r!!:\t\u0011\u0005}\u00181\u001fa\u0001\u0005\u0003\tQAZ5fY\u0012\u0004BAa\u0001\u0003\f9!!Q\u0001B\u0004!\r\t\t\u0006M\u0005\u0004\u0005\u0013\u0001\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003\u000e\t=!AB*ue&twMC\u0002\u0003\nABqAa\u0005\u0002t\u0002\u0007!(A\u0003j]\u0012,\u0007p\u0002\u0005\u0003\u0018\tA\tA\u0001B\r\u0003M\u0001\u0016M]9vKR<&/\u001b;f'V\u0004\bo\u001c:u!\rY#1\u0004\u0004\b\u0003\tA\tA\u0001B\u000f'\u0011\u0011YBa\b\u0011\u0007=\u0012\t#C\u0002\u0003$A\u0012a!\u00118z%\u00164\u0007bB\u0014\u0003\u001c\u0011\u0005!q\u0005\u000b\u0003\u00053A!Ba\u000b\u0003\u001c\t\u0007I\u0011\u0001B\u0017\u0003A\u0019\u0006+\u0011*L?J{ukX*D\u0011\u0016k\u0015)\u0006\u0002\u0003\u0002!I!\u0011\u0007B\u000eA\u0003%!\u0011A\u0001\u0012'B\u000b%kS0S\u001f^{6k\u0011%F\u001b\u0006\u0003\u0003\u0002\u0003B\u001b\u00057!\tAa\u000e\u0002\u0013M,GoU2iK6\fG#B\u001f\u0003:\tm\u0002BB!\u00034\u0001\u00071\t\u0003\u0005\u0002n\tM\u0002\u0019AA8\u0001")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setSchema(StructType structType, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(structType, configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(new StringOps(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean());
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((TraversableOnce)((TraversableLike)this.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).asJava();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())).stripMargin());
        return new WriteSupport.WriteContext(messageType, metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        Function2 & Serializable & scala.Serializable intersect;
        block21: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType3;
                if (BooleanType$.MODULE$.equals(dataType3 = dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ByteType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ShortType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                boolean bl = IntegerType$.MODULE$.equals(dataType3) ? true : DateType$.MODULE$.equals(dataType3);
                if (bl) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (LongType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (FloatType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (DoubleType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    Function2 & Serializable & scala.Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                            ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                    ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block21;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block21;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType = (StructType)dataType3;
                    Function2[] fieldWriters = (Function2[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeWriter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    intersect = this.makeArrayWriter(arrayType);
                    break block21;
                }
                if (dataType3 instanceof MapType) {
                    MapType mapType = (MapType)dataType3;
                    intersect = this.makeMapWriter(mapType);
                    break block21;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            throw package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType2).append(".").toString());
        }
        return intersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable & scala.Serializable int32Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable int64Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, keyWriter, valueWriter, repeatedGroupName, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(row.getLong(ordinal));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long millis = DateTimeUtils$.MODULE$.toMillis(row.getLong(ordinal));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, Function2 elementWriter$1, String repeatedGroupName$1, String elementFieldName$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, elementWriter$1, repeatedGroupName, elementFieldName, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, Function2 elementWriter$1, String repeatedFieldName$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, elementWriter$1, repeatedFieldName, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, Function2 keyWriter$1, Function2 valueWriter$1, String repeatedGroupName$2, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
    }
}

