/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.CompletionIterator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005%v!B\u0001\u0003\u0011\u0003\t\u0012a\u0002&E\u0005\u000e\u0013F\t\u0012\u0006\u0003\u0007\u0011\tAA\u001b3cG*\u0011QAB\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\b\u0011\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001\u0001\t\u0003%Mi\u0011A\u0001\u0004\u0006)\tA\t!\u0006\u0002\b\u0015\u0012\u00135I\u0015#E'\u0011\u0019b\u0003\b\u0012\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\ti\u0002%D\u0001\u001f\u0015\ty\"\"\u0001\u0005j]R,'O\\1m\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\u0011\u0005]\u0019\u0013B\u0001\u0013\u0019\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001513\u0003\"\u0001(\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003C\u0003*'\u0011\u0005!&\u0001\u0007sKN|GN^3UC\ndW\r\u0006\u0002,cA\u0011AfL\u0007\u0002[)\u0011a\u0006C\u0001\u0006if\u0004Xm]\u0005\u0003a5\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015\u0011\u0004\u00061\u00014\u0003\u001dy\u0007\u000f^5p]N\u0004\"A\u0005\u001b\n\u0005U\u0012!a\u0003&E\u0005\u000e{\u0005\u000f^5p]NDQaN\n\u0005\na\n1\u0002\u001d:v]\u0016\u001c6\r[3nCR\u00191&O\u001e\t\u000bi2\u0004\u0019A\u0016\u0002\rM\u001c\u0007.Z7b\u0011\u0015ad\u00071\u0001>\u0003\u001d\u0019w\u000e\\;n]N\u00042a\u0006 A\u0013\ty\u0004DA\u0003BeJ\f\u0017\u0010\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007bi\u0011\u0001\u0012\u0006\u0003\u000bB\ta\u0001\u0010:p_Rt\u0014BA$\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dC\u0002\"\u0002'\u0014\t\u0003i\u0015!D2p[BLG.\u001a$jYR,'\u000fF\u0002O#f\u00032aF(A\u0013\t\u0001\u0006D\u0001\u0004PaRLwN\u001c\u0005\u0006%.\u0003\raU\u0001\u0002MB\u0011AkV\u0007\u0002+*\u0011a\u000bC\u0001\bg>,(oY3t\u0013\tAVK\u0001\u0004GS2$XM\u001d\u0005\u00065.\u0003\raW\u0001\bI&\fG.Z2u!\taf,D\u0001^\u0015\t\u0019\u0001\"\u0003\u0002`;\nY!\n\u001a2d\t&\fG.Z2u\u0011\u0015\t7\u0003\"\u0001c\u0003%\u00198-\u00198UC\ndW\r\u0006\u0005d_V4\bp_A\u0002!\r!w-[\u0007\u0002K*\u0011aMC\u0001\u0004e\u0012$\u0017B\u00015f\u0005\r\u0011F\t\u0012\t\u0003U6l\u0011a\u001b\u0006\u0003Y\"\t\u0001bY1uC2L8\u000f^\u0005\u0003].\u00141\"\u00138uKJt\u0017\r\u001c*po\")\u0001\u000f\u0019a\u0001c\u0006\u00111o\u0019\t\u0003eNl\u0011AC\u0005\u0003i*\u0011Ab\u00159be.\u001cuN\u001c;fqRDQA\u000f1A\u0002-BQa\u001e1A\u0002u\nqB]3rk&\u0014X\rZ\"pYVlgn\u001d\u0005\u0006s\u0002\u0004\rA_\u0001\bM&dG/\u001a:t!\r9bh\u0015\u0005\u0006y\u0002\u0004\r!`\u0001\u0006a\u0006\u0014Ho\u001d\t\u0004/yr\bC\u0001:\u0000\u0013\r\t\tA\u0003\u0002\n!\u0006\u0014H/\u001b;j_:DQA\r1A\u0002MB\u0011\"a\u0002\u0014\u0003\u0003%I!!\u0003\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0003mC:<'BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0002\u0002\u0007\u001f\nTWm\u0019;\u0007\rQ\u0011\u0001AAA\u000f'\r\tYb\u0019\u0005\na\u0006m!\u0011!Q\u0001\nED1\"a\t\u0002\u001c\t\u0005\t\u0015!\u0003\u0002&\u0005iq-\u001a;D_:tWm\u0019;j_:\u0004RaFA\u0014\u0003WI1!!\u000b\u0019\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0003\u0002.\u0005ERBAA\u0018\u0015\rI\u00111C\u0005\u0005\u0003g\tyC\u0001\u0006D_:tWm\u0019;j_:D\u0011BOA\u000e\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0013q\nYB!A!\u0002\u0013i\u0004\"C=\u0002\u001c\t\u0005\t\u0015!\u0003{\u0011)\ti$a\u0007\u0003\u0002\u0003\u0006I!`\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bBCA!\u00037\u0011\t\u0011)A\u0005\u0001\u0006\u0019QO\u001d7\t\u0013I\nYB!A!\u0002\u0013\u0019\u0004b\u0002\u0014\u0002\u001c\u0011\u0005\u0011q\t\u000b\u0013\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131KA+\u0003/\nI\u0006E\u0002\u0013\u00037Aa\u0001]A#\u0001\u0004\t\b\u0002CA\u0012\u0003\u000b\u0002\r!!\n\t\ri\n)\u00051\u0001,\u0011\u0019a\u0014Q\ta\u0001{!1\u00110!\u0012A\u0002iDq!!\u0010\u0002F\u0001\u0007Q\u0010C\u0004\u0002B\u0005\u0015\u0003\u0019\u0001!\t\rI\n)\u00051\u00014\u0011!\ti&a\u0007\u0005B\u0005}\u0013!D4fiB\u000b'\u000f^5uS>t7/F\u0001~\u0011)\t\u0019'a\u0007C\u0002\u0013%\u0011QM\u0001\u000bG>dW/\u001c8MSN$X#\u0001!\t\u0011\u0005%\u00141\u0004Q\u0001\n\u0001\u000b1bY8mk6tG*[:uA!Q\u0011QNA\u000e\u0005\u0004%I!!\u001a\u0002#\u0019LG\u000e^3s/\",'/Z\"mCV\u001cX\r\u0003\u0005\u0002r\u0005m\u0001\u0015!\u0003A\u0003I1\u0017\u000e\u001c;fe^CWM]3DY\u0006,8/\u001a\u0011\t\u0011\u0005U\u00141\u0004C\u0005\u0003o\nabZ3u/\",'/Z\"mCV\u001cX\rF\u0002A\u0003sB\u0001\"a\u001f\u0002t\u0001\u0007\u0011QP\u0001\u0005a\u0006\u0014H\u000fE\u0002\u0013\u0003\u007fJ1!!!\u0003\u00055QEIQ\"QCJ$\u0018\u000e^5p]\"A\u0011QQA\u000e\t\u0003\n9)A\u0004d_6\u0004X\u000f^3\u0015\r\u0005%\u00151TAP!\u0015\tY)!&j\u001d\u0011\ti)!%\u000f\u0007\r\u000by)C\u0001\u001a\u0013\r\t\u0019\nG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9*!'\u0003\u0011%#XM]1u_JT1!a%\u0019\u0011\u001d\ti*a!A\u0002y\fq\u0001\u001e5f!\u0006\u0014H\u000f\u0003\u0005\u0002\"\u0006\r\u0005\u0019AAR\u0003\u001d\u0019wN\u001c;fqR\u00042A]AS\u0013\r\t9K\u0003\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000f")
public class JDBCRDD
extends RDD<InternalRow> {
    private final Function0<Connection> getConnection;
    private final StructType schema;
    private final Partition[] partitions;
    private final String url;
    private final JDBCOptions options;
    private final String columnList;
    private final String filterWhereClause;

    public static RDD<InternalRow> scanTable(SparkContext sparkContext, StructType structType, String[] stringArray, Filter[] filterArray, Partition[] partitionArray, JDBCOptions jDBCOptions) {
        return JDBCRDD$.MODULE$.scanTable(sparkContext, structType, stringArray, filterArray, partitionArray, jDBCOptions);
    }

    public static Option<String> compileFilter(Filter filter, JdbcDialect jdbcDialect) {
        return JDBCRDD$.MODULE$.compileFilter(filter, jdbcDialect);
    }

    public static StructType resolveTable(JDBCOptions jDBCOptions) {
        return JDBCRDD$.MODULE$.resolveTable(jDBCOptions);
    }

    public Partition[] getPartitions() {
        return this.partitions;
    }

    private String columnList() {
        return this.columnList;
    }

    private String filterWhereClause() {
        return this.filterWhereClause;
    }

    private String getWhereClause(JDBCPartition part) {
        return part.whereClause() != null && this.filterWhereClause().length() > 0 ? new java.lang.StringBuilder(11).append("WHERE ").append(new java.lang.StringBuilder(2).append("(").append(this.filterWhereClause()).append(")").toString()).append(" AND ").append(new java.lang.StringBuilder(2).append("(").append(part.whereClause()).append(")").toString()).toString() : (part.whereClause() != null ? new java.lang.StringBuilder(6).append("WHERE ").append(part.whereClause()).toString() : (this.filterWhereClause().length() > 0 ? new java.lang.StringBuilder(6).append("WHERE ").append(this.filterWhereClause()).toString() : ""));
    }

    public Iterator<InternalRow> compute(Partition thePart, TaskContext context2) {
        Object object;
        BooleanRef closed = BooleanRef.create((boolean)false);
        ObjectRef rs = ObjectRef.create(null);
        ObjectRef stmt = ObjectRef.create(null);
        ObjectRef conn = ObjectRef.create(null);
        context2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)context -> {
            this.close$1(closed, rs, stmt, conn);
            return BoxedUnit.UNIT;
        });
        InputMetrics inputMetrics = context2.taskMetrics().inputMetrics();
        JDBCPartition part = (JDBCPartition)thePart;
        conn.elem = (Connection)this.getConnection.apply();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(this.url);
        dialect.beforeFetch((Connection)conn.elem, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.options.asProperties()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        Option<String> option = this.options.sessionInitStatement();
        if (option instanceof Some) {
            Boolean bl;
            Some some = (Some)option;
            String sql = (String)some.value();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Executing sessionInitStatement: ").append(sql).toString());
            try (PreparedStatement statement = ((Connection)conn.elem).prepareStatement(sql);){
                statement.setQueryTimeout(this.options.queryTimeout());
                bl = BoxesRunTime.boxToBoolean((boolean)statement.execute());
            }
            object = bl;
        } else if (None$.MODULE$.equals(option)) {
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        String myWhereClause = this.getWhereClause(part);
        String sqlText = new java.lang.StringBuilder(14).append("SELECT ").append(this.columnList()).append(" FROM ").append(this.options.tableOrQuery()).append(" ").append(myWhereClause).toString();
        stmt.elem = ((Connection)conn.elem).prepareStatement(sqlText, 1003, 1007);
        ((PreparedStatement)stmt.elem).setFetchSize(this.options.fetchSize());
        ((PreparedStatement)stmt.elem).setQueryTimeout(this.options.queryTimeout());
        rs.elem = ((PreparedStatement)stmt.elem).executeQuery();
        Iterator<InternalRow> rowsIterator = JdbcUtils$.MODULE$.resultSetToSparkInternalRows((ResultSet)rs.elem, this.schema, inputMetrics);
        return CompletionIterator$.MODULE$.apply((Iterator)new InterruptibleIterator(context2, rowsIterator), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close$1(closed, rs, stmt, conn));
    }

    private final void close$1(BooleanRef closed$1, ObjectRef rs$1, ObjectRef stmt$1, ObjectRef conn$1) {
        if (closed$1.elem) {
            return;
        }
        try {
            if ((ResultSet)rs$1.elem != null) {
                ((ResultSet)rs$1.elem).close();
            }
        }
        catch (Exception e) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Exception closing resultset", e);
        }
        try {
            if ((PreparedStatement)stmt$1.elem != null) {
                ((PreparedStatement)stmt$1.elem).close();
            }
        }
        catch (Exception e) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Exception closing statement", e);
        }
        try {
            if ((Connection)conn$1.elem != null) {
                if (!((Connection)conn$1.elem).isClosed() && !((Connection)conn$1.elem).getAutoCommit()) {
                    try {
                        ((Connection)conn$1.elem).commit();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Exception committing transaction", e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                }
                ((Connection)conn$1.elem).close();
            }
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "closed connection");
        }
        catch (Exception e) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Exception closing connection", e);
        }
        closed$1.elem = true;
    }

    public JDBCRDD(SparkContext sc, Function0<Connection> getConnection, StructType schema, String[] columns, Filter[] filters, Partition[] partitions, String url, JDBCOptions options) {
        this.getConnection = getConnection;
        this.schema = schema;
        this.partitions = partitions;
        this.url = url;
        this.options = options;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
        StringBuilder sb = new StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).foreach((Function1 & Serializable & scala.Serializable)x -> sb.append(",").append(x));
        this.columnList = sb.isEmpty() ? "1" : sb.substring(1);
        this.filterWhereClause = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(JDBCRDD$.MODULE$.compileFilter((Filter)x$3, JdbcDialects$.MODULE$.get($this.url))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)p -> new java.lang.StringBuilder(2).append("(").append((String)p).append(")").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" AND ");
    }
}

