/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CsvOutputWriter;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001E\u0011QbQ*W\r&dWMR8s[\u0006$(BA\u0002\u0005\u0003\r\u00197O\u001e\u0006\u0003\u000b\u0019\t1\u0002Z1uCN|WO]2fg*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0005\u0013\t)BAA\nUKb$()Y:fI\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u000591o\\;sG\u0016\u001c\u0018BA\u000e\u0019\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u001a\u0013!C:i_J$h*Y7f)\u0005!\u0003CA\u0013/\u001d\t1C\u0006\u0005\u0002(U5\t\u0001F\u0003\u0002*!\u00051AH]8pizR\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\na\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011QF\u000b\u0005\u0006e\u0001!\teM\u0001\fSN\u001c\u0006\u000f\\5uC\ndW\r\u0006\u00035qy\u001a\u0005CA\u001b7\u001b\u0005Q\u0013BA\u001c+\u0005\u001d\u0011un\u001c7fC:DQ!O\u0019A\u0002i\nAb\u001d9be.\u001cVm]:j_:\u0004\"a\u000f\u001f\u000e\u0003!I!!\u0010\u0005\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b}\n\u0004\u0019\u0001!\u0002\u000f=\u0004H/[8ogB!Q%\u0011\u0013%\u0013\t\u0011\u0005GA\u0002NCBDQ\u0001R\u0019A\u0002\u0015\u000bA\u0001]1uQB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0003MNT!A\u0013\u0007\u0002\r!\fGm\\8q\u0013\tauI\u0001\u0003QCRD\u0007\"\u0002(\u0001\t\u0003z\u0015aC5oM\u0016\u00148k\u00195f[\u0006$B\u0001U-[7B\u0019Q'U*\n\u0005IS#AB(qi&|g\u000e\u0005\u0002U/6\tQK\u0003\u0002W\u0011\u0005)A/\u001f9fg&\u0011\u0001,\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B\u001dN\u0001\u0004Q\u0004\"B N\u0001\u0004\u0001\u0005\"\u0002/N\u0001\u0004i\u0016!\u00024jY\u0016\u001c\bc\u00010dM:\u0011q,\u0019\b\u0003O\u0001L\u0011aK\u0005\u0003E*\nq\u0001]1dW\u0006<W-\u0003\u0002eK\n\u00191+Z9\u000b\u0005\tT\u0003C\u0001$h\u0013\tAwI\u0001\u0006GS2,7\u000b^1ukNDQA\u001b\u0001\u0005B-\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$R\u0001\\8qqf\u0004\"aE7\n\u00059$!aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"B\u001dj\u0001\u0004Q\u0004\"B9j\u0001\u0004\u0011\u0018a\u00016pEB\u00111O^\u0007\u0002i*\u0011Q/S\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!a\u001e;\u0003\u0007){'\rC\u0003@S\u0002\u0007\u0001\tC\u0003{S\u0002\u00071+\u0001\u0006eCR\f7k\u00195f[\u0006DQ\u0001 \u0001\u0005Bu\f1BY;jY\u0012\u0014V-\u00193feRya0a\u0007\u0002\u001e\u0005}\u00111EA\u0014\u0003g\t)\u0004\u0005\u00046\u007f\u0006\r\u0011\u0011B\u0005\u0004\u0003\u0003Q#!\u0003$v]\u000e$\u0018n\u001c82!\r\u0019\u0012QA\u0005\u0004\u0003\u000f!!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000by\u000bY!a\u0004\n\u0007\u00055QM\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002\u001a\u0005M!aC%oi\u0016\u0014h.\u00197S_^DQ!O>A\u0002iBQA_>A\u0002MCa!!\t|\u0001\u0004\u0019\u0016a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005\u00152\u00101\u0001T\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!!\u000b|\u0001\u0004\tY#A\u0004gS2$XM]:\u0011\ty\u001b\u0017Q\u0006\t\u0004/\u0005=\u0012bAA\u00191\t1a)\u001b7uKJDQaP>A\u0002\u0001Cq!a\u000e|\u0001\u0004\tI$\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fI\u0015\u0001B2p]\u001aLA!a\u0011\u0002>\ti1i\u001c8gS\u001e,(/\u0019;j_:Da!a\u0012\u0001\t\u0003\u001a\u0013\u0001\u0003;p'R\u0014\u0018N\\4\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002PA\u0019Q'!\u0015\n\u0007\u0005M#FA\u0002J]RDq!a\u0016\u0001\t\u0003\nI&\u0001\u0004fcV\fGn\u001d\u000b\u0004i\u0005m\u0003\u0002CA/\u0003+\u0002\r!a\u0018\u0002\u000b=$\b.\u001a:\u0011\u0007U\n\t'C\u0002\u0002d)\u00121!\u00118z\u0011\u001d\t9\u0007\u0001C!\u0003S\nqb];qa>\u0014H\u000fR1uCRK\b/\u001a\u000b\u0006i\u0005-\u0014Q\u000f\u0005\t\u0003[\n)\u00071\u0001\u0002p\u0005AA-\u0019;b)f\u0004X\rE\u0002U\u0003cJ1!a\u001dV\u0005!!\u0015\r^1UsB,\u0007bBA<\u0003K\u0002\r\u0001N\u0001\u000bSN\u0014V-\u00193QCRD\u0007")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "csv";
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$4());
        CSVDataSource csvDataSource = CSVDataSource$.MODULE$.apply(parsedOptions);
        return csvDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$4());
        return CSVDataSource$.MODULE$.apply(parsedOptions).inferSchema(sparkSession, files, parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$4());
        csvOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, csvOptions){
            private final CSVOptions csvOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new CsvOutputWriter(path, dataSchema, context, this.csvOptions$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(4).append(".csv").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.csvOptions$1 = csvOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        dataSchema.getFieldIndex(parsedOptions.columnNameOfCorruptRecord()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = dataSchema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new AnalysisException(new StringBuilder(551).append("Since Spark 2.3, the queries from raw JSON/CSV files are disallowed when the\nreferenced columns only include the internal corrupt record column\n").append("(named _corrupt_record by default). For example:\n").append("spark.read.schema(schema).csv(file).filter($\"_corrupt_record\".isNotNull).count()\n").append("and spark.read.schema(schema).csv(file).select(\"_corrupt_record\").show().\n").append("Instead, you can cache or save the parsed results and then send the same query.\n").append("For example, val df = spark.read.schema(schema).csv(file).cache() and then\n").append("df.filter($\"_corrupt_record\".isNotNull).count().").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        boolean columnPruning = sparkSession.sessionState().conf().csvColumnPruning();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)dataSchema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$3(parsedOptions, x$1)))), StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVFileFormat.$anonfun$buildReader$4(parsedOptions, x$2)))), parsedOptions);
            return CSVDataSource$.MODULE$.apply(parsedOptions).readFile(conf, (PartitionedFile)file, parser, requiredSchema, dataSchema, caseSensitive, columnPruning);
        };
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$3(CSVOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$4(CSVOptions parsedOptions$1, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

