/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowTablesCommand$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001>\u0011\u0011c\u00155poR\u000b'\r\\3t\u0007>lW.\u00198e\u0015\t\u0019A!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001C\u0007\u0010%!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#A\u0004m_\u001eL7-\u00197\u000b\u0005U1\u0012!\u00029mC:\u001c(BA\f\u0007\u0003!\u0019\u0017\r^1msN$\u0018BA\r\u0013\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\rI\u0006$\u0018MY1tK:\u000bW.Z\u000b\u0002UA\u0019qdK\u0017\n\u00051\u0002#AB(qi&|g\u000e\u0005\u0002/k9\u0011qf\r\t\u0003a\u0001j\u0011!\r\u0006\u0003e9\ta\u0001\u0010:p_Rt\u0014B\u0001\u001b!\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u0002\u0003\u0002C\u001d\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u001b\u0011\fG/\u00192bg\u0016t\u0015-\\3!\u0011!Y\u0004A!f\u0001\n\u0003I\u0013A\u0006;bE2,\u0017\nZ3oi&4\u0017.\u001a:QCR$XM\u001d8\t\u0011u\u0002!\u0011#Q\u0001\n)\nq\u0003^1cY\u0016LE-\u001a8uS\u001aLWM\u001d)biR,'O\u001c\u0011\t\u0011}\u0002!Q3A\u0005\u0002\u0001\u000b!\"[:FqR,g\u000eZ3e+\u0005\t\u0005CA\u0010C\u0013\t\u0019\u0005EA\u0004C_>dW-\u00198\t\u0011\u0015\u0003!\u0011#Q\u0001\n\u0005\u000b1\"[:FqR,g\u000eZ3eA!Aq\t\u0001BK\u0002\u0013\u0005\u0001*A\u0007qCJ$\u0018\u000e^5p]N\u0003XmY\u000b\u0002\u0013B\u0019qd\u000b&\u0011\u0005-cfB\u0001'Z\u001d\tiuK\u0004\u0002O-:\u0011q*\u0016\b\u0003!Rs!!U*\u000f\u0005A\u0012\u0016\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0018\r%\u0011\u0001LF\u0001\bG\u0006$\u0018\r\\8h\u0013\tQ6,\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002Y-%\u0011QL\u0018\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002[7\"A\u0001\r\u0001B\tB\u0003%\u0011*\u0001\bqCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0011\t\u000b\t\u0004A\u0011A2\u0002\rqJg.\u001b;?)\u0015!WMZ4i!\tY\u0002\u0001C\u0003)C\u0002\u0007!\u0006C\u0003<C\u0002\u0007!\u0006C\u0004@CB\u0005\t\u0019A!\t\u000f\u001d\u000b\u0007\u0013!a\u0001\u0013\"9!\u000e\u0001b\u0001\n\u0003Z\u0017AB8viB,H/F\u0001m!\ri'/\u001e\b\u0003]Bt!\u0001M8\n\u0003\u0005J!!\u001d\u0011\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0004'\u0016\f(BA9!!\t1\u00180D\u0001x\u0015\tAh#A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001>x\u0005%\tE\u000f\u001e:jEV$X\r\u0003\u0004}\u0001\u0001\u0006I\u0001\\\u0001\b_V$\b/\u001e;!\u0011\u0015q\b\u0001\"\u0011\u0000\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u0003\tY\u0001\u0005\u0003ne\u0006\r\u0001\u0003BA\u0003\u0003\u000fi\u0011AB\u0005\u0004\u0003\u00131!a\u0001*po\"9\u0011QB?A\u0002\u0005=\u0011\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\u0003\u0003#I1!a\u0005\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011%\t9\u0002AA\u0001\n\u0003\tI\"\u0001\u0003d_BLH#\u00033\u0002\u001c\u0005u\u0011qDA\u0011\u0011!A\u0013Q\u0003I\u0001\u0002\u0004Q\u0003\u0002C\u001e\u0002\u0016A\u0005\t\u0019\u0001\u0016\t\u0011}\n)\u0002%AA\u0002\u0005C\u0001bRA\u000b!\u0003\u0005\r!\u0013\u0005\n\u0003K\u0001\u0011\u0013!C\u0001\u0003O\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002*)\u001a!&a\u000b,\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000e!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\t\tDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0010\u0001#\u0003%\t!a\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\t\u0001\u0012\u0002\u0013\u0005\u0011QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t9EK\u0002B\u0003WA\u0011\"a\u0013\u0001#\u0003%\t!!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\n\u0016\u0004\u0013\u0006-\u0002\"CA*\u0001\u0005\u0005I\u0011IA+\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006L1ANA.\u0011%\t9\u0007AA\u0001\n\u0003\tI'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002lA\u0019q$!\u001c\n\u0007\u0005=\u0004EA\u0002J]RD\u0011\"a\u001d\u0001\u0003\u0003%\t!!\u001e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qOA?!\ry\u0012\u0011P\u0005\u0004\u0003w\u0002#aA!os\"Q\u0011qPA9\u0003\u0003\u0005\r!a\u001b\u0002\u0007a$\u0013\u0007C\u0005\u0002\u0004\u0002\t\t\u0011\"\u0011\u0002\u0006\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\bB1\u0011\u0011RAH\u0003oj!!a#\u000b\u0007\u00055\u0005%\u0001\u0006d_2dWm\u0019;j_:LA!!%\u0002\f\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0001\u0002\u0018\u0006A1-\u00198FcV\fG\u000eF\u0002B\u00033C!\"a \u0002\u0014\u0006\u0005\t\u0019AA<\u0011%\ti\nAA\u0001\n\u0003\ny*\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0003\u0006\u0005\u0006BCA@\u00037\u000b\t\u00111\u0001\u0002x\u001dI\u0011Q\u0015\u0002\u0002\u0002#\u0005\u0011qU\u0001\u0012'\"|w\u000fV1cY\u0016\u001c8i\\7nC:$\u0007cA\u000e\u0002*\u001aA\u0011AAA\u0001\u0012\u0003\tYkE\u0003\u0002*\u00065F\u0005E\u0005\u00020\u0006U&FK!JI6\u0011\u0011\u0011\u0017\u0006\u0004\u0003g\u0003\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003o\u000b\tLA\tBEN$(/Y2u\rVt7\r^5p]RBqAYAU\t\u0003\tY\f\u0006\u0002\u0002(\"Q\u0011qXAU\u0003\u0003%)%!1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0016\t\u0015\u0005\u0015\u0017\u0011VA\u0001\n\u0003\u000b9-A\u0003baBd\u0017\u0010F\u0005e\u0003\u0013\fY-!4\u0002P\"1\u0001&a1A\u0002)BaaOAb\u0001\u0004Q\u0003\u0002C \u0002DB\u0005\t\u0019A!\t\u0011\u001d\u000b\u0019\r%AA\u0002%C!\"a5\u0002*\u0006\u0005I\u0011QAk\u0003\u001d)h.\u00199qYf$B!a6\u0002`B!qdKAm!\u001dy\u00121\u001c\u0016+\u0003&K1!!8!\u0005\u0019!V\u000f\u001d7fi!I\u0011\u0011]Ai\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\u0002\u0004BCAs\u0003S\u000b\n\u0011\"\u0001\u0002F\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002j\u0006%\u0016\u0013!C\u0001\u0003\u001b\nq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0003[\fI+%A\u0005\u0002\u0005\u0015\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002r\u0006%\u0016\u0013!C\u0001\u0003\u001b\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004BCA{\u0003S\u000b\t\u0011\"\u0003\u0002x\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u0010\u0005\u0003\u0002Z\u0005m\u0018\u0002BA\u007f\u00037\u0012aa\u00142kK\u000e$\b")
public class ShowTablesCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final Option<String> databaseName;
    private final Option<String> tableIdentifierPattern;
    private final boolean isExtended;
    private final Option<Map<String, String>> partitionSpec;
    private final Seq<Attribute> output;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Map<String, String>> $lessinit$greater$default$4() {
        return ShowTablesCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return ShowTablesCommand$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Map<String, String>> apply$default$4() {
        return ShowTablesCommand$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return ShowTablesCommand$.MODULE$.apply$default$3();
    }

    public static Option<Tuple4<Option<String>, Option<String>, Object, Option<Map<String, String>>>> unapply(ShowTablesCommand showTablesCommand) {
        return ShowTablesCommand$.MODULE$.unapply(showTablesCommand);
    }

    public static Function1<Tuple4<Option<String>, Option<String>, Object, Option<Map<String, String>>>, ShowTablesCommand> tupled() {
        return ShowTablesCommand$.MODULE$.tupled();
    }

    public static Function1<Option<String>, Function1<Option<String>, Function1<Object, Function1<Option<Map<String, String>>, ShowTablesCommand>>>> curried() {
        return ShowTablesCommand$.MODULE$.curried();
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        ShowTablesCommand showTablesCommand = this;
        synchronized (showTablesCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public Option<String> databaseName() {
        return this.databaseName;
    }

    public Option<String> tableIdentifierPattern() {
        return this.tableIdentifierPattern;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        String db = (String)this.databaseName().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        if (this.partitionSpec().isEmpty()) {
            Seq tables = (Seq)this.tableIdentifierPattern().map((Function1 & Serializable & scala.Serializable)x$24 -> catalog.listTables(db, x$24)).getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.listTables(db));
            seq = (Seq)tables.map((Function1 & Serializable & scala.Serializable)tableIdent -> {
                Row row;
                String database = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                String tableName = tableIdent.table();
                boolean isTemp = catalog.isTemporaryTable(tableIdent);
                if (this.isExtended()) {
                    String information = catalog.getTempViewOrPermanentTableMetadata(tableIdent).simpleString();
                    row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp), new StringBuilder(1).append(information).append("\n").toString()}));
                } else {
                    row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp)}));
                }
                return row;
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            TableIdentifier tableIdent2 = new TableIdentifier((String)this.tableIdentifierPattern().get(), (Option)new Some((Object)db));
            TableIdentifier table = catalog.getTableMetadata(tableIdent2).identifier();
            CatalogTablePartition partition = catalog.getPartition(tableIdent2, (Map)this.partitionSpec().get());
            String database = (String)table.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String tableName = table.table();
            boolean isTemp = catalog.isTemporaryTable(table);
            String information = partition.simpleString();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, tableName, BoxesRunTime.boxToBoolean((boolean)isTemp), new StringBuilder(1).append(information).append("\n").toString()}))}));
        }
        return seq;
    }

    public ShowTablesCommand copy(Option<String> databaseName, Option<String> tableIdentifierPattern, boolean isExtended, Option<Map<String, String>> partitionSpec) {
        return new ShowTablesCommand(databaseName, tableIdentifierPattern, isExtended, partitionSpec);
    }

    public Option<String> copy$default$1() {
        return this.databaseName();
    }

    public Option<String> copy$default$2() {
        return this.tableIdentifierPattern();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public Option<Map<String, String>> copy$default$4() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "ShowTablesCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.databaseName();
                break;
            }
            case 1: {
                object = this.tableIdentifierPattern();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isExtended());
                break;
            }
            case 3: {
                object = this.partitionSpec();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowTablesCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowTablesCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowTablesCommand showTablesCommand = (ShowTablesCommand)x$1;
        Option<String> option = this.databaseName();
        Option<String> option2 = showTablesCommand.databaseName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.tableIdentifierPattern();
        Option<String> option4 = showTablesCommand.tableIdentifierPattern();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.isExtended() != showTablesCommand.isExtended()) return false;
        Option<Map<String, String>> option5 = this.partitionSpec();
        Option<Map<String, String>> option6 = showTablesCommand.partitionSpec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!showTablesCommand.canEqual(this)) return false;
        return true;
    }

    public ShowTablesCommand(Option<String> databaseName, Option<String> tableIdentifierPattern, boolean isExtended, Option<Map<String, String>> partitionSpec) {
        Nil$ nil$;
        this.databaseName = databaseName;
        this.tableIdentifierPattern = tableIdentifierPattern;
        this.isExtended = isExtended;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        if (isExtended) {
            String x$68 = "information";
            StringType$ x$69 = StringType$.MODULE$;
            boolean x$70 = false;
            Metadata x$71 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$72 = AttributeReference$.MODULE$.apply$default$5(x$68, (DataType)x$69, x$70, x$71);
            Seq x$73 = AttributeReference$.MODULE$.apply$default$6(x$68, (DataType)x$69, x$70, x$71);
            AttributeReference attributeReference = new AttributeReference(x$68, (DataType)x$69, x$70, x$71, x$72, x$73);
            nil$ = Nil$.MODULE$.$colon$colon((Object)attributeReference);
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ tableExtendedInfo = nil$;
        String x$74 = "database";
        StringType$ x$75 = StringType$.MODULE$;
        boolean x$76 = false;
        Metadata x$77 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$78 = AttributeReference$.MODULE$.apply$default$5(x$74, (DataType)x$75, x$76, x$77);
        Seq x$79 = AttributeReference$.MODULE$.apply$default$6(x$74, (DataType)x$75, x$76, x$77);
        AttributeReference attributeReference = new AttributeReference(x$74, (DataType)x$75, x$76, x$77, x$78, x$79);
        String x$80 = "tableName";
        StringType$ x$81 = StringType$.MODULE$;
        boolean x$82 = false;
        Metadata x$83 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$84 = AttributeReference$.MODULE$.apply$default$5(x$80, (DataType)x$81, x$82, x$83);
        Seq x$85 = AttributeReference$.MODULE$.apply$default$6(x$80, (DataType)x$81, x$82, x$83);
        AttributeReference attributeReference2 = new AttributeReference(x$80, (DataType)x$81, x$82, x$83, x$84, x$85);
        String x$86 = "isTemporary";
        BooleanType$ x$87 = BooleanType$.MODULE$;
        boolean x$88 = false;
        Metadata x$89 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$90 = AttributeReference$.MODULE$.apply$default$5(x$86, (DataType)x$87, x$88, x$89);
        Seq x$91 = AttributeReference$.MODULE$.apply$default$6(x$86, (DataType)x$87, x$88, x$89);
        AttributeReference attributeReference3 = new AttributeReference(x$86, (DataType)x$87, x$88, x$89, x$90, x$91);
        this.output = tableExtendedInfo.$colon$colon((Object)attributeReference3).$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
    }
}

