/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenMap$;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u0001\u0003\u0001>\u0011!%\u00117uKJ$\u0016M\u00197f%\u0016\u001cwN^3s!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u0005IA/\u00192mK:\u000bW.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0006uC\ndWMT1nK\u0002B\u0001\"\r\u0001\u0003\u0016\u0004%\tAM\u0001\u0004G6$W#A\u001a\u0011\u0005QZdBA\u001b:!\t1\u0004%D\u00018\u0015\tAd\"\u0001\u0004=e>|GOP\u0005\u0003u\u0001\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!\b\t\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005g\u0005!1-\u001c3!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q\u00191\tR#\u0011\u0005m\u0001\u0001\"\u0002\u0015A\u0001\u0004Q\u0003bB\u0019A!\u0003\u0005\ra\r\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%qU+T0G\u00132+5+F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003y-Ca!\u0015\u0001!\u0002\u0013I\u0015A\u0003(V\u001b~3\u0015\nT#TA!91\u000b\u0001b\u0001\n\u0003A\u0015A\u0003+P)\u0006culU%[\u000b\"1Q\u000b\u0001Q\u0001\n%\u000b1\u0002V(U\u00032{6+\u0013.FA!9q\u000b\u0001b\u0001\n\u0003A\u0015\u0001\u0003#E\u0019~#\u0016*T#\t\re\u0003\u0001\u0015!\u0003J\u0003%!E\tT0U\u00136+\u0005\u0005C\u0003\\\u0001\u0011%A,A\u0007hKR\u0004\u0016\r\u001e5GS2$XM\u001d\u000b\u0003;\u0016\u0004\"AX2\u000e\u0003}S!\u0001Y1\u0002\u0005\u0019\u001c(B\u00012\u000b\u0003\u0019A\u0017\rZ8pa&\u0011Am\u0018\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\b\"\u00024[\u0001\u00049\u0017A\u00035bI>|\u0007oQ8oMB\u0011\u0001n[\u0007\u0002S*\u0011!.Y\u0001\u0005G>tg-\u0003\u0002mS\ni1i\u001c8gS\u001e,(/\u0019;j_:DQA\u001c\u0001\u0005B=\f1A];o)\t\u0001X\u0010E\u0002rmft!A\u001d;\u000f\u0005Y\u001a\u0018\"A\u0011\n\u0005U\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003ob\u00141aU3r\u0015\t)\b\u0005\u0005\u0002{w6\ta!\u0003\u0002}\r\t\u0019!k\\<\t\u000b%i\u0007\u0019\u0001@\u0011\u0005i|\u0018bAA\u0001\r\ta1\u000b]1sWN+7o]5p]\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0011AD:dC:\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0015\u0003\u0013\tY%!\u0014\u0002V\u0005e\u0013QLA1\u0003O\n\t(!#\u0011\r\u0005-\u0011\u0011CA\u000b\u001b\t\tiAC\u0002\u0002\u0010\u0001\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0004\u0003\r\u001d+gnU3r!\u001dy\u0012qCA\u000e\u0003\u000bJ1!!\u0007!\u0005\u0019!V\u000f\u001d7feA!\u0011QDA \u001d\u0011\ty\"!\u000f\u000f\t\u0005\u0005\u0012Q\u0007\b\u0005\u0003G\t\u0019D\u0004\u0003\u0002&\u0005Eb\u0002BA\u0014\u0003_qA!!\u000b\u0002.9\u0019a'a\u000b\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t9b!C\u0002\u00028Y\tqaY1uC2|w-\u0003\u0003\u0002<\u0005u\u0012\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c(bAA\u001c-%!\u0011\u0011IA\"\u0005I!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u000b\t\u0005m\u0012Q\b\t\u0004=\u0006\u001d\u0013bAA%?\n!\u0001+\u0019;i\u0011\u0019I\u00111\u0001a\u0001}\"9\u0001-a\u0001A\u0002\u0005=\u0003c\u00010\u0002R%\u0019\u00111K0\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0004\u0002X\u0005\r\u0001\u0019A/\u0002\r\u0019LG\u000e^3s\u0011!\tY&a\u0001A\u0002\u0005\u0015\u0013\u0001\u00029bi\"D\u0001\"a\u0018\u0002\u0004\u0001\u0007\u00111D\u0001\u0005gB,7\r\u0003\u0005\u0002d\u0005\r\u0001\u0019AA3\u00039\u0001\u0018M\u001d;ji&|gNT1nKN\u00042!\u001d<4\u0011!\tI'a\u0001A\u0002\u0005-\u0014!\u0003;ie\u0016\u001c\bn\u001c7e!\ry\u0012QN\u0005\u0004\u0003_\u0002#aA%oi\"A\u00111OA\u0002\u0001\u0004\t)(\u0001\u0005sKN|GN^3s!\u0011\t9(a!\u000f\t\u0005e\u0014q\u0010\b\u0005\u0003C\tY(C\u0002\u0002~Y\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0004k\u0006\u0005%bAA?-%!\u0011QQAD\u0005!\u0011Vm]8mm\u0016\u0014(bA;\u0002\u0002\"A\u00111RA\u0002\u0001\u0004\ti)A\bfm\u0006dG+Y:l'V\u0004\bo\u001c:u!\u0011\ty)!&\u000e\u0005\u0005E%\u0002BAJ\u0003\u001b\t\u0001\u0002]1sC2dW\r\\\u0005\u0005\u0003/\u000b\tJA\nG_J\\'j\\5o)\u0006\u001c8nU;qa>\u0014H\u000fC\u0004\u0002\u001c\u0002!I!!(\u0002)\u001d\fG\u000f[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t)1\ty*a+\u0002.\u0006E\u00161WA\\!\u001d\tY!!)4\u0003KKA!a)\u0002\u000e\t1q)\u001a8NCB\u00042aGAT\u0013\r\tIK\u0001\u0002\u0014!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;jgRL7m\u001d\u0005\u0007\u0013\u0005e\u0005\u0019\u0001@\t\u0011\u0005=\u0016\u0011\u0014a\u0001\u0003\u0013\tQ\u0003]1si&$\u0018n\u001c8Ta\u0016\u001c7/\u00118e\u0019>\u001c7\u000fC\u0004a\u00033\u0003\r!a\u0014\t\u000f\u0005U\u0016\u0011\u0014a\u0001;\u0006Q\u0001/\u0019;i\r&dG/\u001a:\t\u0011\u0005%\u0014\u0011\u0014a\u0001\u0003WBq!a/\u0001\t\u0013\ti,A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000b\u0003\u007f\u000b)-a2\u0002T\u0006U\u0007cA\u0010\u0002B&\u0019\u00111\u0019\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0013\u0005e\u0006\u0019\u0001@\t\u0011\u0005%\u0017\u0011\u0018a\u0001\u0003\u0017\fQ\u0001^1cY\u0016\u0004B!!4\u0002P6\u0011\u0011QH\u0005\u0005\u0003#\fiD\u0001\u0007DCR\fGn\\4UC\ndW\r\u0003\u0005\u00020\u0006e\u0006\u0019AA\u0005\u0011!\t9.!/A\u0002\u0005}\u0015A\u00049beRLG/[8o'R\fGo\u001d\u0005\n\u00037\u0004\u0011\u0011!C\u0001\u0003;\fAaY8qsR)1)a8\u0002b\"A\u0001&!7\u0011\u0002\u0003\u0007!\u0006\u0003\u00052\u00033\u0004\n\u00111\u00014\u0011%\t)\u000fAI\u0001\n\u0003\t9/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%(f\u0001\u0016\u0002l.\u0012\u0011Q\u001e\t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003%)hn\u00195fG.,GMC\u0002\u0002x\u0002\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY0!=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0000\u0002\t\n\u0011\"\u0001\u0003\u0002\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0002U\r\u0019\u00141\u001e\u0005\t\u0005\u000f\u0001\u0011\u0011!C!\u0011\u0006i\u0001O]8ek\u000e$\bK]3gSbD\u0011Ba\u0003\u0001\u0003\u0003%\tA!\u0004\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0004\"\u0003B\t\u0001\u0005\u0005I\u0011\u0001B\n\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0006\u0003\u001cA\u0019qDa\u0006\n\u0007\te\u0001EA\u0002B]fD!B!\b\u0003\u0010\u0005\u0005\t\u0019AA6\u0003\rAH%\r\u0005\n\u0005C\u0001\u0011\u0011!C!\u0005G\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005K\u0001b!a\u0003\u0003(\tU\u0011\u0002\u0002B\u0015\u0003\u001b\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005[\u0001\u0011\u0011!C\u0001\u0005_\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005c\u00119\u0004E\u0002 \u0005gI1A!\u000e!\u0005\u001d\u0011un\u001c7fC:D!B!\b\u0003,\u0005\u0005\t\u0019\u0001B\u000b\u0011%\u0011Y\u0004AA\u0001\n\u0003\u0012i$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005c\u0011y\u0004\u0003\u0006\u0003\u001e\te\u0012\u0011!a\u0001\u0005+9\u0011Ba\u0011\u0003\u0003\u0003E\tA!\u0012\u0002E\u0005cG/\u001a:UC\ndWMU3d_Z,'\u000fU1si&$\u0018n\u001c8t\u0007>lW.\u00198e!\rY\"q\t\u0004\t\u0003\t\t\t\u0011#\u0001\u0003JM)!q\tB&IA9!Q\nB*UM\u001aUB\u0001B(\u0015\r\u0011\t\u0006I\u0001\beVtG/[7f\u0013\u0011\u0011)Fa\u0014\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004B\u0005\u000f\"\tA!\u0017\u0015\u0005\t\u0015\u0003B\u0003B/\u0005\u000f\n\t\u0011\"\u0012\u0003`\u0005AAo\\*ue&tw\rF\u0001J\u0011)\u0011\u0019Ga\u0012\u0002\u0002\u0013\u0005%QM\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0007\n\u001d$\u0011\u000e\u0005\u0007Q\t\u0005\u0004\u0019\u0001\u0016\t\u0011E\u0012\t\u0007%AA\u0002MB!B!\u001c\u0003H\u0005\u0005I\u0011\u0011B8\u0003\u001d)h.\u00199qYf$BA!\u001d\u0003zA)qDa\u001d\u0003x%\u0019!Q\u000f\u0011\u0003\r=\u0003H/[8o!\u0015y\u0012q\u0003\u00164\u0011%\u0011YHa\u001b\u0002\u0002\u0003\u00071)A\u0002yIAB!Ba \u0003HE\u0005I\u0011\u0001B\u0001\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003BB\u0005\u000f\n\n\u0011\"\u0001\u0003\u0002\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB!Ba\"\u0003H\u0005\u0005I\u0011\u0002BE\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t-\u0005c\u0001&\u0003\u000e&\u0019!qR&\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableRecoverPartitionsCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.$lessinit$greater$default$2();
    }

    public static String apply$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2();
    }

    public static Option<Tuple2<TableIdentifier, String>> unapply(AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand) {
        return AlterTableRecoverPartitionsCommand$.MODULE$.unapply(alterTableRecoverPartitionsCommand);
    }

    public static Function1<Tuple2<TableIdentifier, String>, AlterTableRecoverPartitionsCommand> tupled() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, AlterTableRecoverPartitionsCommand>> curried() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = this;
        synchronized (alterTableRecoverPartitionsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    private PathFilter getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return new PathFilter(null, pathFilter){
            private final PathFilter pathFilter$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(Path path) {
                String name;
                String string = name = path.getName();
                String string2 = "_SUCCESS";
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = name;
                String string4 = "_temporary";
                if (string3 == null) {
                    if (string4 == null) return false;
                } else if (string3.equals(string4)) return false;
                if (name.startsWith(".")) return false;
                if (this.pathFilter$1 == null) return true;
                if (!this.pathFilter$1.accept(path)) return false;
                return true;
            }
            {
                this.pathFilter$1 = pathFilter$1;
            }
        };
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        Seq seq;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        if (table.partitionColumnNames().isEmpty()) {
            throw new AnalysisException(new StringBuilder(58).append("Operation not allowed: ").append(this.cmd()).append(" only works on partitioned tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.storage().locationUri().isEmpty()) {
            throw new AnalysisException(new StringBuilder(49).append("Operation not allowed: ").append(this.cmd()).append(" only works on table with ").append(new StringBuilder(19).append("location provided: ").append(tableIdentWithDB).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Path root = new Path(table.location());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Recover all the partitions in ").append(root).toString());
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = root.getFileSystem(hadoopConf);
        int threshold = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("spark.rdd.parallelListingThreshold", "10"))).toInt();
        PathFilter pathFilter = this.getPathFilter(hadoopConf);
        ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("AlterTableRecoverPartitionsCommand", 8);
        try {
            seq = this.scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool)).seq();
        }
        finally {
            evalPool.shutdown();
        }
        Seq partitionSpecsAndLocs = seq;
        int total = partitionSpecsAndLocs.length();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Found ").append(total).append(" partitions in ").append(root).toString());
        GenMap<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, fs, pathFilter, threshold) : GenMap$.MODULE$.empty();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Finished to gather the fast stats for all ").append(total).append(" partitions.").toString());
        this.addPartitions(spark, table, (GenSeq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, partitionStats);
        boolean x$85 = true;
        TableIdentifier x$86 = table.copy$default$1();
        CatalogTableType x$87 = table.copy$default$2();
        CatalogStorageFormat x$88 = table.copy$default$3();
        StructType x$89 = table.copy$default$4();
        Option x$90 = table.copy$default$5();
        Seq x$91 = table.copy$default$6();
        Option x$92 = table.copy$default$7();
        String x$93 = table.copy$default$8();
        long x$94 = table.copy$default$9();
        long x$95 = table.copy$default$10();
        String x$96 = table.copy$default$11();
        Map x$97 = table.copy$default$12();
        Option x$98 = table.copy$default$13();
        Option x$99 = table.copy$default$14();
        Option x$100 = table.copy$default$15();
        Seq x$101 = table.copy$default$16();
        boolean x$102 = table.copy$default$18();
        Map x$103 = table.copy$default$19();
        spark.sessionState().catalog().alterTable(table.copy(x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$85, x$102, x$103));
        catalog.refreshTable(this.tableName());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Recovered all partitions (").append(total).append(").").toString());
        return (Seq)Seq$.MODULE$.empty();
    }

    private GenSeq<Tuple2<Map<String, String>, Path>> scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        WrappedArray wrappedArray;
        if (partitionNames.isEmpty()) {
            return (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spec), (Object)path)}));
        }
        FileStatus[] statuses = fs.listStatus(path, filter);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParArray parArray = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).par();
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            wrappedArray = parArray;
        } else {
            wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])statuses);
        }
        WrappedArray statusPar = wrappedArray;
        return (GenSeq)statusPar.flatMap((Function1 & Serializable & scala.Serializable)st -> {
            GenSeq<Tuple2<Map<String, String>, Path>> genSeq;
            String name = st.getPath().getName();
            if (st.isDirectory() && name.contains("=")) {
                String[] ps = name.split("=", 2);
                String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                if (BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)columnName, partitionNames.head()))) {
                    genSeq = this.scanPartitions(spark, fs, filter, st.getPath(), (Map<String, String>)spec.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionNames.head()), (Object)value)}))), (Seq<String>)((Seq)partitionNames.drop(1)), threshold, resolver, evalTaskSupport);
                } else {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("expected partition column ").append(partitionNames.head()).append(", but got ").append(ps[0]).append(", ignoring it").toString());
                    genSeq = (GenSeq)Seq$.MODULE$.empty();
                }
            } else {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("ignore ").append(new Path(path, name)).toString());
                genSeq = (GenSeq<Tuple2<Map<String, String>, Path>>)Seq$.MODULE$.empty();
            }
            return genSeq;
        }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom());
    }

    private GenMap<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        GenMap genMap;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((GenTraversableOnce)partitionSpecsAndLocs.map((Function1 & Serializable & scala.Serializable)x$8 -> ((Path)x$8._2()).toString(), (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Gather the fast stats in parallel using ").append(numParallelism).append(" tasks.").toString());
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable & scala.Serializable x$104 = (Function1 & Serializable & scala.Serializable)paths -> {
                PathFilter pathFilter = this.getPathFilter(serializableConfiguration.value());
                return paths.map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9)).map((Function1 & Serializable & scala.Serializable)path -> {
                    FileSystem fs = path.getFileSystem(serializableConfiguration.value());
                    FileStatus[] statuses = fs.listStatus(path, pathFilter);
                    return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.getLen()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                });
            };
            boolean x$105 = qual$1.mapPartitions$default$2();
            genMap = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$104, x$105, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        } else {
            genMap = ((GenTraversableOnce)partitionSpecsAndLocs.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path location = (Path)tuple2._2();
                FileStatus[] statuses = fs.listStatus(location, pathFilter);
                Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.getLen()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                return tuple22;
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        return genMap;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, GenMap<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = 100;
        partitionSpecsAndLocs.toIterator().grouped(batchSize).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            AlterTableRecoverPartitionsCommand.$anonfun$addPartitions$1(this, spark, table, partitionStats, total, done, batch);
            return BoxedUnit.UNIT;
        });
    }

    public AlterTableRecoverPartitionsCommand copy(TableIdentifier tableName, String cmd) {
        return new AlterTableRecoverPartitionsCommand(tableName, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.cmd();
    }

    public String productPrefix() {
        return "AlterTableRecoverPartitionsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.cmd();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRecoverPartitionsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRecoverPartitionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = (AlterTableRecoverPartitionsCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRecoverPartitionsCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = alterTableRecoverPartitionsCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableRecoverPartitionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AlterTableRecoverPartitionsCommand $this, SparkSession spark$2, CatalogTable table$6, GenMap partitionStats$1, int total$2, LongRef done$1, Seq batch) {
        long now = System.currentTimeMillis() / 1000L;
        Seq parts = (Seq)batch.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map spec = (Map)tuple2._1();
            Path location = (Path)tuple2._2();
            Map params = (Map)partitionStats$1.get((Object)location.toString()).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                PartitionStatistics partitionStatistics = x0$5;
                if (partitionStatistics == null) {
                    throw new MatchError((Object)partitionStatistics);
                }
                int numFiles = partitionStatistics.numFiles();
                long totalSize = partitionStatistics.totalSize();
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)((Object)BoxesRunTime.boxToLong((long)totalSize)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)((Object)BoxesRunTime.boxToLong((long)now)).toString())}));
                return map;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, table$6.storage().copy((Option)new Some((Object)location.toUri()), table$6.storage().copy$default$2(), table$6.storage().copy$default$3(), table$6.storage().copy$default$4(), table$6.storage().copy$default$5(), table$6.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        }, Seq$.MODULE$.canBuildFrom());
        spark$2.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Recovered ").append(parts.length()).append(" partitions (").append(done$1.elem).append("/").append(total$2).append(" so far)").toString());
    }

    public AlterTableRecoverPartitionsCommand(TableIdentifier tableName, String cmd) {
        this.tableName = tableName;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
    }
}

