/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableAddPartitionCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001>\u0011Q$\u00117uKJ$\u0016M\u00197f\u0003\u0012$\u0007+\u0019:uSRLwN\\\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\tqaY8n[\u0006tGM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001AQb\u0004\n\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0016-\u0005)\u0001\u000f\\1og*\u0011qCB\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011D\u0005\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0003;bE2,g*Y7f+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003U\u0001\u0018M\u001d;ji&|gn\u00159fGN\fe\u000e\u001a'pGN,\u0012a\r\t\u0004iqzdBA\u001b;\u001d\t1\u0014(D\u00018\u0015\tAd\"\u0001\u0004=e>|GOP\u0005\u0002C%\u00111\bI\u0001\ba\u0006\u001c7.Y4f\u0013\tidHA\u0002TKFT!a\u000f\u0011\u0011\t}\u0001%iV\u0005\u0003\u0003\u0002\u0012a\u0001V;qY\u0016\u0014\u0004CA\"U\u001d\t!\u0015K\u0004\u0002F\u001f:\u0011aI\u0014\b\u0003\u000f6s!\u0001\u0013'\u000f\u0005%[eB\u0001\u001cK\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003!Z\tqaY1uC2|w-\u0003\u0002S'\u0006a1)\u0019;bY><G+\u001f9fg*\u0011\u0001KF\u0005\u0003+Z\u0013!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011!k\u0015\t\u0004?aS\u0016BA-!\u0005\u0019y\u0005\u000f^5p]B\u00111l\u0018\b\u00039v\u0003\"A\u000e\u0011\n\u0005y\u0003\u0013A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!A\u0018\u0011\t\u0011\r\u0004!\u0011#Q\u0001\nM\na\u0003]1si&$\u0018n\u001c8Ta\u0016\u001c7/\u00118e\u0019>\u001c7\u000f\t\u0005\tK\u0002\u0011)\u001a!C\u0001M\u0006Y\u0011N\u001a(pi\u0016C\u0018n\u001d;t+\u00059\u0007CA\u0010i\u0013\tI\u0007EA\u0004C_>dW-\u00198\t\u0011-\u0004!\u0011#Q\u0001\n\u001d\fA\"\u001b4O_R,\u00050[:ug\u0002BQ!\u001c\u0001\u0005\u00029\fa\u0001P5oSRtD\u0003B8qcJ\u0004\"a\u0007\u0001\t\u000b!b\u0007\u0019\u0001\u0016\t\u000bEb\u0007\u0019A\u001a\t\u000b\u0015d\u0007\u0019A4\t\u000bQ\u0004A\u0011I;\u0002\u0007I,h\u000e\u0006\u0002wwB\u0019A\u0007P<\u0011\u0005aLX\"\u0001\u0004\n\u0005i4!a\u0001*po\")Ap\u001da\u0001{\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0001P`\u0005\u0003\u007f\u001a\u0011Ab\u00159be.\u001cVm]:j_:D\u0011\"a\u0001\u0001\u0003\u0003%\t!!\u0002\u0002\t\r|\u0007/\u001f\u000b\b_\u0006\u001d\u0011\u0011BA\u0006\u0011!A\u0013\u0011\u0001I\u0001\u0002\u0004Q\u0003\u0002C\u0019\u0002\u0002A\u0005\t\u0019A\u001a\t\u0011\u0015\f\t\u0001%AA\u0002\u001dD\u0011\"a\u0004\u0001#\u0003%\t!!\u0005\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0003\u0016\u0004U\u0005U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0002%\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003[Q3aMA\u000b\u0011%\t\t\u0004AI\u0001\n\u0003\t\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U\"fA4\u0002\u0016!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00131H\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\r\u0001\u0017\u0011\t\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001f\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0015\u0011\u0007}\t\u0019&C\u0002\u0002V\u0001\u00121!\u00138u\u0011%\tI\u0006AA\u0001\n\u0003\tY&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00131\r\t\u0004?\u0005}\u0013bAA1A\t\u0019\u0011I\\=\t\u0015\u0005\u0015\u0014qKA\u0001\u0002\u0004\t\t&A\u0002yIEB\u0011\"!\u001b\u0001\u0003\u0003%\t%a\u001b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001c\u0011\r\u0005=\u0014QOA/\u001b\t\t\tHC\u0002\u0002t\u0001\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9(!\u001d\u0003\u0011%#XM]1u_JD\u0011\"a\u001f\u0001\u0003\u0003%\t!! \u0002\u0011\r\fg.R9vC2$2aZA@\u0011)\t)'!\u001f\u0002\u0002\u0003\u0007\u0011Q\f\u0005\n\u0003\u0007\u0003\u0011\u0011!C!\u0003\u000b\u000ba!Z9vC2\u001cHcA4\u0002\b\"Q\u0011QMAA\u0003\u0003\u0005\r!!\u0018\b\u0013\u0005-%!!A\t\u0002\u00055\u0015!H!mi\u0016\u0014H+\u00192mK\u0006#G\rU1si&$\u0018n\u001c8D_6l\u0017M\u001c3\u0011\u0007m\tyI\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAI'\u0015\ty)a%%!!\t)*a'+g\u001d|WBAAL\u0015\r\tI\nI\u0001\beVtG/[7f\u0013\u0011\ti*a&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004n\u0003\u001f#\t!!)\u0015\u0005\u00055\u0005BCAS\u0003\u001f\u000b\t\u0011\"\u0012\u0002(\u0006AAo\\*ue&tw\r\u0006\u0002\u0002>!Q\u00111VAH\u0003\u0003%\t)!,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f=\fy+!-\u00024\"1\u0001&!+A\u0002)Ba!MAU\u0001\u0004\u0019\u0004BB3\u0002*\u0002\u0007q\r\u0003\u0006\u00028\u0006=\u0015\u0011!CA\u0003s\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002<\u0006\r\u0007\u0003B\u0010Y\u0003{\u0003baHA`UM:\u0017bAAaA\t1A+\u001e9mKNB\u0011\"!2\u00026\u0006\u0005\t\u0019A8\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002J\u0006=\u0015\u0011!C\u0005\u0003\u0017\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u001a\t\u0005\u0003\u007f\ty-\u0003\u0003\u0002R\u0006\u0005#AB(cU\u0016\u001cG\u000f")
public class AlterTableAddPartitionCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs;
    private final boolean ifNotExists;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>>, Object>> unapply(AlterTableAddPartitionCommand alterTableAddPartitionCommand) {
        return AlterTableAddPartitionCommand$.MODULE$.unapply(alterTableAddPartitionCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Seq<Tuple2<Map<String, String>, Option<String>>>, Object>, AlterTableAddPartitionCommand> tupled() {
        return AlterTableAddPartitionCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<Tuple2<Map<String, String>, Option<String>>>, Function1<Object, AlterTableAddPartitionCommand>>> curried() {
        return AlterTableAddPartitionCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddPartitionCommand alterTableAddPartitionCommand = this;
        synchronized (alterTableAddPartitionCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs() {
        return this.partitionSpecsAndLocs;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        block0: {
            CatalogTable table;
            SessionCatalog catalog;
            block1: {
                catalog = sparkSession.sessionState().catalog();
                table = catalog.getTableMetadata(this.tableName());
                DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
                DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE ADD PARTITION");
                Seq parts = (Seq)this.partitionSpecsAndLocs().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Map spec = (Map)tuple2._1();
                    Option location = (Option)tuple2._2();
                    Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
                    CatalogTablePartition catalogTablePartition = new CatalogTablePartition(normalizedSpec, table.storage().copy(location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str)), table.storage().copy$default$2(), table.storage().copy$default$3(), table.storage().copy$default$4(), table.storage().copy$default$5(), table.storage().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                    return catalogTablePartition;
                }, Seq$.MODULE$.canBuildFrom());
                catalog.createPartitions(table.identifier(), parts, this.ifNotExists());
                if (!table.stats().nonEmpty()) break block0;
                if (!sparkSession.sessionState().conf().autoSizeUpdateEnabled()) break block1;
                long addedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToLong((long)CommandUtils$.MODULE$.calculateLocationSize(sparkSession.sessionState(), table.identifier(), (Option<URI>)part.storage().locationUri())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                if (addedSize <= 0L) break block0;
                CatalogStatistics newStats = new CatalogStatistics(((CatalogStatistics)table.stats().get()).sizeInBytes().$plus(BigInt$.MODULE$.long2bigInt(addedSize)), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog.alterTableStats(table.identifier(), (Option)new Some((Object)newStats));
                break block0;
            }
            catalog.alterTableStats(table.identifier(), (Option)None$.MODULE$);
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableAddPartitionCommand copy(TableIdentifier tableName, Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs, boolean ifNotExists) {
        return new AlterTableAddPartitionCommand(tableName, partitionSpecsAndLocs, ifNotExists);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Seq<Tuple2<Map<String, String>, Option<String>>> copy$default$2() {
        return this.partitionSpecsAndLocs();
    }

    public boolean copy$default$3() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "AlterTableAddPartitionCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.partitionSpecsAndLocs();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddPartitionCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddPartitionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddPartitionCommand alterTableAddPartitionCommand = (AlterTableAddPartitionCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableAddPartitionCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<Tuple2<Map<String, String>, Option<String>>> seq = this.partitionSpecsAndLocs();
        Seq<Tuple2<Map<String, String>, Option<String>>> seq2 = alterTableAddPartitionCommand.partitionSpecsAndLocs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.ifNotExists() != alterTableAddPartitionCommand.ifNotExists()) return false;
        if (!alterTableAddPartitionCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddPartitionCommand(TableIdentifier tableName, Seq<Tuple2<Map<String, String>, Option<String>>> partitionSpecsAndLocs, boolean ifNotExists) {
        this.tableName = tableName;
        this.partitionSpecsAndLocs = partitionSpecsAndLocs;
        this.ifNotExists = ifNotExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

