/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.local.LocalFs;
import org.apache.hadoop.fs.local.RawLocalFs;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$$anonfun$add$1$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.util.UninterruptibleThread;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]\u0019\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011\u0012!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\t\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Y5j\u0011AB\u0005\u0003]\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0005a\u0006$\b\u000e\u0005\u00023k9\u0011!cM\u0005\u0003iM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011Ag\u0005\u0005\ts\u0001\u0011\u0019\u0011)A\u0006u\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007mr4$D\u0001=\u0015\ti4#A\u0004sK\u001adWm\u0019;\n\u0005}b$\u0001C\"mCN\u001cH+Y4\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\r\u0019ei\u0012\u000b\u0003\t\u0016\u00032\u0001\u0007\u0001\u001c\u0011\u0015I\u0004\tq\u0001;\u0011\u0015Q\u0003\t1\u0001,\u0011\u0015\u0001\u0004\t1\u00012\u0011\u001dI\u0005A1A\u0005\f)\u000bqAZ8s[\u0006$8/F\u0001L%\ra5k\u0017\u0004\u0005\u001b\u0002\u00011J\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0002J\u001f&\u0011\u0001+\u0015\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005Ic\u0011A\u00026t_:$4\u000f\u0005\u0002U36\tQK\u0003\u0002W/\u0006!A.\u00198h\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\r=\u0013'.Z2u!\taV,D\u0001R\u0013\tq\u0016KA\u0004G_Jl\u0017\r^:\t\u000f\u0001d%\u0019!C\u0001C\u0006QA-\u0019;f\r>\u0014X.\u0019;\u0016\u0003\t\u0004\"\u0001X2\n\u0005\u0011\f&A\u0003#bi\u00164uN]7bi\"9a\r\u0014b\u0001\n\u0003:\u0017!\u0003;za\u0016D\u0015N\u001c;t+\u0005A\u0007C\u0001/j\u0013\tQ\u0017KA\u0005UsB,\u0007*\u001b8ug\"1A\u000e\u0001Q\u0001\n-\u000b\u0001BZ8s[\u0006$8\u000f\t\u0005\b]\u0002\u0011\r\u0011b\u0003p\u0003!i\u0017M\\5gKN$X#\u00019\u0011\u0007m\n8$\u0003\u0002sy\tAQ*\u00198jM\u0016\u001cH\u000f\u0003\u0004u\u0001\u0001\u0006I\u0001]\u0001\n[\u0006t\u0017NZ3ti\u0002BqA\u001e\u0001C\u0002\u0013\u0005q/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b.F\u0001y!\tIh0D\u0001{\u0015\tYH0\u0001\u0002gg*\u0011QPC\u0001\u0007Q\u0006$wn\u001c9\n\u0005}T(\u0001\u0002)bi\"Dq!a\u0001\u0001A\u0003%\u00010A\u0007nKR\fG-\u0019;b!\u0006$\b\u000e\t\u0005\n\u0003\u000f\u0001!\u0019!C\t\u0003\u0013\t1BZ5mK6\u000bg.Y4feV\u0011\u00111\u0002\t\u0005\u0003\u001b\tiBD\u0002\u0019\u0003\u001f9q!!\u0005\u0003\u0011\u0003\t\u0019\"A\bI\t\u001a\u001bV*\u001a;bI\u0006$\u0018\rT8h!\rA\u0012Q\u0003\u0004\u0007\u0003\tA\t!a\u0006\u0014\u0007\u0005U\u0011\u0003C\u0004B\u0003+!\t!a\u0007\u0015\u0005\u0005MaACA\u0010\u0003+\u0001\n1%\u0001\u0002\"\tYa)\u001b7f\u001b\u0006t\u0017mZ3s'\r\ti\"\u0005\u0005\t\u0003K\tiB\"\u0001\u0002(\u0005!A.[:u)\u0019\tI#!\u000e\u00028A)!#a\u000b\u00020%\u0019\u0011QF\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0007e\f\t$C\u0002\u00024i\u0014!BR5mKN#\u0018\r^;t\u0011\u0019\u0001\u00141\u0005a\u0001q\"A\u0011\u0011HA\u0012\u0001\u0004\tY$\u0001\u0004gS2$XM\u001d\t\u0004s\u0006u\u0012bAA u\nQ\u0001+\u0019;i\r&dG/\u001a:\t\u0011\u0005\r\u0013Q\u0004D\u0001\u0003\u000b\na!\\6eSJ\u001cH\u0003BA$\u0003\u001b\u00022AEA%\u0013\r\tYe\u0005\u0002\u0005+:LG\u000f\u0003\u00041\u0003\u0003\u0002\r\u0001\u001f\u0005\t\u0003#\niB\"\u0001\u0002T\u00051Q\r_5tiN$B!!\u0016\u0002\\A\u0019!#a\u0016\n\u0007\u0005e3CA\u0004C_>dW-\u00198\t\rA\ny\u00051\u0001y\u0011!\ty&!\b\u0007\u0002\u0005\u0005\u0014\u0001B8qK:$B!a\u0019\u0002jA\u0019\u00110!\u001a\n\u0007\u0005\u001d$PA\tG'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6Da\u0001MA/\u0001\u0004A\b\u0002CA7\u0003;1\t!a\u001c\u0002\r\r\u0014X-\u0019;f)\u0011\t\t(a\u001e\u0011\u0007e\f\u0019(C\u0002\u0002vi\u0014!CR*ECR\fw*\u001e;qkR\u001cFO]3b[\"1\u0001'a\u001bA\u0002aD\u0001\"a\u001f\u0002\u001e\u0019\u0005\u0011QP\u0001\u0007e\u0016t\u0017-\\3\u0015\r\u0005\u001d\u0013qPAB\u0011\u001d\t\t)!\u001fA\u0002a\fqa\u001d:d!\u0006$\b\u000eC\u0004\u0002\u0006\u0006e\u0004\u0019\u0001=\u0002\u0011\u0011,7\u000f\u001e)bi\"D\u0001\"!#\u0002\u001e\u0019\u0005\u00111R\u0001\u0007I\u0016dW\r^3\u0015\t\u0005\u001d\u0013Q\u0012\u0005\u0007a\u0005\u001d\u0005\u0019\u0001=\t\u0011\u0005E\u0015Q\u0004D\u0001\u0003'\u000b\u0011#[:M_\u000e\fGNR5mKNK8\u000f^3n+\t\t)FB\u0004\u0002\u0018\u0006U\u0001!!'\u0003%\u0019KG.Z\"p]R,\u0007\u0010^'b]\u0006<WM]\n\u0006\u0003+\u000b\u00121\u0014\t\u0005\u0003;\u000bi\"\u0004\u0002\u0002\u0016!I\u0001'!&\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\f\u0003G\u000b)J!A!\u0002\u0013\t)+\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003Wc\u0018\u0001B2p]\u001aLA!a,\u0002*\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!QAK\t\u0003\t\u0019\f\u0006\u0004\u00026\u0006]\u0016\u0011\u0018\t\u0005\u0003;\u000b)\n\u0003\u00041\u0003c\u0003\r\u0001\u001f\u0005\t\u0003G\u000b\t\f1\u0001\u0002&\"Q\u0011QXAK\u0005\u0004%I!a0\u0002\u0005\u0019\u001cWCAAa!\rI\u00181Y\u0005\u0004\u0003\u000bT(a\u0003$jY\u0016\u001cuN\u001c;fqRD\u0011\"!3\u0002\u0016\u0002\u0006I!!1\u0002\u0007\u0019\u001c\u0007\u0005\u0003\u0005\u0002&\u0005UE\u0011IAg)\u0019\tI#a4\u0002R\"1\u0001'a3A\u0002aD\u0001\"!\u000f\u0002L\u0002\u0007\u00111\b\u0005\t\u0003w\n)\n\"\u0011\u0002VR1\u0011qIAl\u00033Dq!!!\u0002T\u0002\u0007\u0001\u0010C\u0004\u0002\u0006\u0006M\u0007\u0019\u0001=\t\u0011\u0005\r\u0013Q\u0013C!\u0003;$B!a\u0012\u0002`\"1\u0001'a7A\u0002aD\u0001\"a\u0018\u0002\u0016\u0012\u0005\u00131\u001d\u000b\u0005\u0003G\n)\u000f\u0003\u00041\u0003C\u0004\r\u0001\u001f\u0005\t\u0003[\n)\n\"\u0011\u0002jR!\u0011\u0011OAv\u0011\u0019\u0001\u0014q\u001da\u0001q\"A\u0011\u0011KAK\t\u0003\ny\u000f\u0006\u0003\u0002V\u0005E\bB\u0002\u0019\u0002n\u0002\u0007\u0001\u0010\u0003\u0005\u0002\n\u0006UE\u0011IA{)\u0011\t9%a>\t\rA\n\u0019\u00101\u0001y\u0011!\t\t*!&\u0005B\u0005MeaBA\u007f\u0003+\u0001\u0011q \u0002\u0012\r&dWmU=ti\u0016lW*\u00198bO\u0016\u00148#BA~#\u0005m\u0005\"\u0003\u0019\u0002|\n\u0005\t\u0015!\u0003y\u0011-\t\u0019+a?\u0003\u0002\u0003\u0006I!!*\t\u000f\u0005\u000bY\u0010\"\u0001\u0003\bQ1!\u0011\u0002B\u0006\u0005\u001b\u0001B!!(\u0002|\"1\u0001G!\u0002A\u0002aD\u0001\"a)\u0003\u0006\u0001\u0007\u0011Q\u0015\u0005\nw\u0006m(\u0019!C\u0005\u0005#)\"Aa\u0005\u0011\u0007e\u0014)\"C\u0002\u0003\u0018i\u0014!BR5mKNK8\u000f^3n\u0011%\u0011Y\"a?!\u0002\u0013\u0011\u0019\"A\u0002gg\u0002B\u0001\"!\n\u0002|\u0012\u0005#q\u0004\u000b\u0007\u0003S\u0011\tCa\t\t\rA\u0012i\u00021\u0001y\u0011!\tID!\bA\u0002\u0005m\u0002\u0002CA>\u0003w$\tEa\n\u0015\r\u0005\u001d#\u0011\u0006B\u0016\u0011\u001d\t\tI!\nA\u0002aDq!!\"\u0003&\u0001\u0007\u0001\u0010\u0003\u0005\u0002D\u0005mH\u0011\tB\u0018)\u0011\t9E!\r\t\rA\u0012i\u00031\u0001y\u0011!\ty&a?\u0005B\tUB\u0003BA2\u0005oAa\u0001\rB\u001a\u0001\u0004A\b\u0002CA7\u0003w$\tEa\u000f\u0015\t\u0005E$Q\b\u0005\u0007a\te\u0002\u0019\u0001=\t\u0011\u0005E\u00131 C!\u0005\u0003\"B!!\u0016\u0003D!1\u0001Ga\u0010A\u0002aD\u0001\"!#\u0002|\u0012\u0005#q\t\u000b\u0005\u0003\u000f\u0012I\u0005\u0003\u00041\u0005\u000b\u0002\r\u0001\u001f\u0005\t\u0003#\u000bY\u0010\"\u0011\u0002\u0014\"A!q\n\u0001!\u0002\u0013\tY!\u0001\u0007gS2,W*\u00198bO\u0016\u0014\b\u0005C\u0005\u0003T\u0001\u0011\r\u0011\"\u0005\u0003V\u0005\u0001\"-\u0019;dQ\u001aKG.Z:GS2$XM]\u000b\u0003\u0005/\u0012RA!\u0017T\u0003w1a!\u0014B.\u0001\t]\u0003\u0002\u0003B/\u0001\u0001\u0006IAa\u0016\u0002#\t\fGo\u00195GS2,7OR5mi\u0016\u0014\b\u0005C\u0004\u0003b\u0001!\tBa\u0019\u0002\u001b\t\fGo\u00195JIR{\u0007+\u0019;i)\rA(Q\r\u0005\t\u0005O\u0012y\u00061\u0001\u0003j\u00059!-\u0019;dQ&#\u0007c\u0001\n\u0003l%\u0019!QN\n\u0003\t1{gn\u001a\u0005\b\u0005c\u0002A\u0011\u0003B:\u00035\u0001\u0018\r\u001e5U_\n\u000bGo\u00195JIR!!\u0011\u000eB;\u0011\u0019\u0001$q\u000ea\u0001q\"9!\u0011\u0010\u0001\u0005\u0012\tm\u0014aC5t\u0005\u0006$8\r\u001b$jY\u0016$B!!\u0016\u0003~!1\u0001Ga\u001eA\u0002aDqA!!\u0001\t#\u0011\u0019)A\u0005tKJL\u0017\r\\5{KR1\u0011q\tBC\u0005\u0013CqAa\"\u0003\u0000\u0001\u00071$\u0001\u0005nKR\fG-\u0019;b\u0011!\u0011YIa A\u0002\t5\u0015aA8viB!!q\u0012BK\u001b\t\u0011\tJC\u0002\u0003\u0014^\u000b!![8\n\t\t]%\u0011\u0013\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u00057\u0003A\u0011\u0003BO\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007m\u0011y\n\u0003\u0005\u0003\"\ne\u0005\u0019\u0001BR\u0003\tIg\u000e\u0005\u0003\u0003\u0010\n\u0015\u0016\u0002\u0002BT\u0005#\u00131\"\u00138qkR\u001cFO]3b[\"9!1\u0016\u0001\u0005B\t5\u0016aA1eIR1\u0011Q\u000bBX\u0005cC\u0001Ba\u001a\u0003*\u0002\u0007!\u0011\u000e\u0005\b\u0005\u000f\u0013I\u000b1\u0001\u001c\u0011\u001d\u0011)\f\u0001C\u0001\u0005o\u000bab\u001e:ji\u0016$V-\u001c9CCR\u001c\u0007\u000e\u0006\u0004\u0003:\n}&\u0011\u0019\t\u0005%\tm\u00060C\u0002\u0003>N\u0011aa\u00149uS>t\u0007b\u0002BD\u0005g\u0003\ra\u0007\u0005\u000b\u0005\u0007\u0014\u0019\f%AA\u0002\t\u0015\u0017AB<sSR,'\u000f\u0005\u0005\u0013\u0005\u000f\\\"QRA$\u0013\r\u0011Im\u0005\u0002\n\rVt7\r^5p]JBqA!4\u0001\t\u0013\u0011y-\u0001\u0006xe&$XMQ1uG\"$\u0002\"a\u0012\u0003R\nM'Q\u001b\u0005\t\u0005O\u0012Y\r1\u0001\u0003j!9!q\u0011Bf\u0001\u0004Y\u0002\u0002\u0003Bb\u0005\u0017\u0004\rA!2\t\u000f\te\u0007\u0001\"\u0003\u0003\\\u0006a\u0012n\u001d$jY\u0016\fEN]3bIf,\u00050[:ug\u0016C8-\u001a9uS>tG\u0003BA+\u0005;D\u0001Ba8\u0003X\u0002\u0007!\u0011]\u0001\u0002KB!!q\u0012Br\u0013\u0011\u0011)O!%\u0003\u0017%{U\t_2faRLwN\u001c\u0005\b\u0005S\u0004A\u0011\u0001Bv\u0003\r9W\r\u001e\u000b\u0005\u0005[\u0014y\u000f\u0005\u0003\u0013\u0005w[\u0002b\u0002By\u0005O\u0004\r\u0001_\u0001\nE\u0006$8\r\u001b$jY\u0016DqA!;\u0001\t\u0003\u0012)\u0010\u0006\u0003\u0003n\n]\b\u0002\u0003B4\u0005g\u0004\rA!\u001b\t\u000f\t%\b\u0001\"\u0011\u0003|R1!Q`B\u0003\u0007\u0017\u0001RAEA\u0016\u0005\u007f\u0004bAEB\u0001\u0005SZ\u0012bAB\u0002'\t1A+\u001e9mKJB\u0001ba\u0002\u0003z\u0002\u00071\u0011B\u0001\bgR\f'\u000f^%e!\u0015\u0011\"1\u0018B5\u0011!\u0019iA!?A\u0002\r%\u0011!B3oI&#\u0007bBB\t\u0001\u0011\u000531C\u0001\nO\u0016$H*\u0019;fgR$\"a!\u0006\u0011\u000bI\u0011YLa@\t\u000f\re\u0001\u0001\"\u0001\u0004\u001c\u0005!r-\u001a;Pe\u0012,'/\u001a3CCR\u001c\u0007NR5mKN$\"!!\u000b\t\u000f\r}\u0001\u0001\"\u0011\u0004\"\u0005)\u0001/\u001e:hKR!\u0011qIB\u0012\u0011!\u0019)c!\bA\u0002\t%\u0014\u0001\u0005;ie\u0016\u001c\bn\u001c7e\u0005\u0006$8\r[%e\u0011\u001d\u0019I\u0003\u0001C\u0005\u0007W\t\u0011c\u0019:fCR,g)\u001b7f\u001b\u0006t\u0017mZ3s)\t\tY\u0001C\u0005\u00040\u0001\t\n\u0011\"\u0001\u00042\u0005ArO]5uKR+W\u000e\u001d\"bi\u000eDG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rM\"\u0006\u0002Bc\u0007kY#aa\u000e\u0011\t\re21I\u0007\u0003\u0007wQAa!\u0010\u0004@\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u0003\u001a\u0012AC1o]>$\u0018\r^5p]&!1QIB\u001e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final FileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$1) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(this, batchId, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            public final long batchId$1;
            public final Object metadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                if (this.$outer.fileManager().isLocalFileSystem()) {
                    Thread thread = Thread.currentThread();
                    if (!(thread instanceof UninterruptibleThread)) throw new IllegalStateException("HDFSMetadataLog.add() on a local file system must be executed on a o.a.spark.util.UninterruptibleThread");
                    UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
                    BoxedUnit boxedUnit = (BoxedUnit)uninterruptibleThread.runUninterruptibly((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$add$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(this.$outer.batchId$1, this.$outer.metadata$1, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$add$1$$anonfun$apply$mcZ$sp$1 $outer;

                                public final void apply(T metadata, OutputStream out) {
                                    this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().serialize(metadata, out);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$add$1 org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return true;
                } else {
                    this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(this.batchId$1, this.metadata$1, new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$add$1 $outer;

                        public final void apply(T metadata, OutputStream out) {
                            this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().serialize(metadata, out);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return true;
            }

            public /* synthetic */ HDFSMetadataLog org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.batchId$1 = batchId$1;
                this.metadata$1 = var4_3;
            }
        }));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Path> writeTempBatch(T metadata, Function2<T, OutputStream, BoxedUnit> writer) {
        int nextId = 0;
        Path tempPath = new Path(this.metadataPath(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString()})));
        {
            Some some;
            FSDataOutputStream output2 = this.fileManager().create(tempPath);
            {
                writer.apply(metadata, (Object)output2);
                some = new Some((Object)tempPath);
            }
            IOUtils.closeQuietly((OutputStream)output2);
            return some;
        }
    }

    public Function2<T, OutputStream, BoxedUnit> writeTempBatch$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(T metadata, OutputStream out) {
                this.$outer.serialize(metadata, out);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public void org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(long batchId, T metadata, Function2<T, OutputStream, BoxedUnit> writer) {
        Path tempPath = (Path)this.writeTempBatch(metadata, writer).getOrElse((Function0)new Serializable(this, batchId){
            public static final long serialVersionUID = 0L;
            private final long batchId$2;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create temp batch file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.batchId$2)})));
            }
            {
                this.batchId$2 = batchId$2;
            }
        });
        try {
            this.logDebug((Function0<String>)new Serializable(this, batchId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;
                private final long batchId$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to write log #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.batchIdToPath(this.batchId$2)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.batchId$2 = batchId$2;
                }
            });
            this.fileManager().rename(tempPath, this.batchIdToPath(batchId));
            Path crcPath = new Path(tempPath.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".crc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempPath.getName()})));
            if (this.fileManager().exists(crcPath)) {
                this.fileManager().delete(crcPath);
            }
            this.fileManager().delete(tempPath);
            return;
        }
        catch (Throwable throwable) {
            try {
                IOException iOException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException && this.isFileAlreadyExistsException(iOException = (IOException)throwable2)) {
                    throw new ConcurrentModificationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple HDFSMetadataLog are using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path})), iOException);
                }
                if (throwable2 instanceof FileNotFoundException) {
                    FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                    throw new ConcurrentModificationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple HDFSMetadataLog are using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path})), fileNotFoundException);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                this.fileManager().delete(tempPath);
                throw throwable3;
            }
        }
    }

    private boolean isFileAlreadyExistsException(IOException e) {
        return e instanceof FileAlreadyExistsException || e.getMessage() != null && e.getMessage().startsWith("File already exists: ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<T> get(Path batchFile) {
        Option<T> option;
        if (this.fileManager().exists(batchFile)) {
            if (!this.isBatchFile(batchFile)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " is not a batch file!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchFile})));
            option = this.get(this.pathToBatchId(batchFile));
            return option;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    @Override
    public Option<T> get(long batchId) {
        Some some;
        FSDataInputStream input;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.fileManager().exists(batchMetadataFile)) {
            input = this.fileManager().open(batchMetadataFile);
            some = new Some(this.deserialize((InputStream)input));
        } else {
            this.logDebug((Function0<String>)new Serializable(this, batchMetadataFile){
                public static final long serialVersionUID = 0L;
                private final Path batchMetadataFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchMetadataFile$1}));
                }
                {
                    this.batchMetadataFile$1 = batchMetadataFile$1;
                }
            });
            some = None$.MODULE$;
        }
        return some;
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).filter((Function1)new Serializable(this, startId, endId){
            public static final long serialVersionUID = 0L;
            private final Option startId$1;
            private final Option endId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return !(!this.endId$1.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)this.endId$1.get()) || !this.startId$1.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)this.startId$1.get()));
            }
            {
                void var3_3;
                this.startId$1 = startId$1;
                this.endId$1 = var3_3;
            }
        });
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(batchIds).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, Option<T>> apply(long batchId) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), this.$outer.get(batchId));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<T>> x$2) {
                return ((Option)x$2._2()).isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, T> apply(Tuple2<Object, Option<T>> x0$1) {
                Tuple2<Object, Option<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    Option metadataOption = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;

                    public final long apply(FileStatus f) {
                        return this.$outer.pathToBatchId(f.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sorted((Ordering)Ordering.Long$.MODULE$)).reverse();
                Predef$.MODULE$.longArrayOps(batchIds).foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long batchId) {
                        this.apply$mcVJ$sp(batchId);
                    }

                    public void apply$mcVJ$sp(long batchId) {
                        Option<T> batch = this.$outer.get(batchId);
                        if (batch.isDefined()) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$)).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId < this.thresholdBatchId$1;
            }
            {
                this.thresholdBatchId$1 = thresholdBatchId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private FileManager createFileManager() {
        FileManager fileManager;
        Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConf();
        try {
            fileManager = new FileContextManager(this.metadataPath(), hadoopConf);
        }
        catch (UnsupportedFileSystemException unsupportedFileSystemException) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Could not use FileContext API for managing metadata log files at path ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Using FileSystem API instead for managing log files. The log may be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.metadataPath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inconsistent under failures."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            fileManager = new FileSystemManager(this.metadataPath(), hadoopConf);
        }
        return fileManager;
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.sparkSession = sparkSession;
        this.path = path;
        Logging.class.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Should not create a log with type Seq, use Arrays instead - see SPARK-17372";
            }
        });
        this.metadataPath = new Path(path);
        this.fileManager = this.createFileManager();
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new $anon$1(this);
    }

    public static interface FileManager {
        public FileStatus[] list(Path var1, PathFilter var2);

        public void mkdirs(Path var1);

        public boolean exists(Path var1);

        public FSDataInputStream open(Path var1);

        public FSDataOutputStream create(Path var1);

        public void rename(Path var1, Path var2);

        public void delete(Path var1);

        public boolean isLocalFileSystem();
    }

    public static class FileSystemManager
    implements FileManager {
        private final FileSystem fs;

        private FileSystem fs() {
            return this.fs;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fs().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            if (this.fs().exists(srcPath)) {
                if (this.fs().exists(destPath)) {
                    throw new FileAlreadyExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination path already exists: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destPath})));
                }
                if (this.fs().rename(srcPath, destPath)) {
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, destPath})));
            }
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath})));
        }

        @Override
        public void mkdirs(Path path) {
            this.fs().mkdirs(path, FsPermission.getDirDefault());
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fs().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fs().create(path, false);
        }

        @Override
        public boolean exists(Path path) {
            return this.fs().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fs().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isLocalFileSystem() {
            FileSystem fileSystem = this.fs();
            boolean bl = fileSystem instanceof LocalFileSystem ? true : fileSystem instanceof RawLocalFileSystem;
            boolean bl2 = bl;
            return bl2;
        }

        public FileSystemManager(Path path, Configuration hadoopConf) {
            this.fs = path.getFileSystem(hadoopConf);
        }
    }

    public static class FileContextManager
    implements FileManager {
        private final FileContext fc;

        private FileContext fc() {
            return this.fc;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fc().util().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            this.fc().rename(srcPath, destPath, new Options.Rename[0]);
        }

        @Override
        public void mkdirs(Path path) {
            this.fc().mkdir(path, FsPermission.getDirDefault(), true);
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fc().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fc().create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        }

        @Override
        public boolean exists(Path path) {
            return this.fc().util().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fc().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isLocalFileSystem() {
            AbstractFileSystem abstractFileSystem = this.fc().getDefaultFileSystem();
            boolean bl = abstractFileSystem instanceof LocalFs ? true : abstractFileSystem instanceof RawLocalFs;
            boolean bl2 = bl;
            return bl2;
        }

        public FileContextManager(Path path, Configuration hadoopConf) {
            this.fc = path.toUri().getScheme() == null ? FileContext.getFileContext((Configuration)hadoopConf) : FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
        }
    }
}

