/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001>\u0011QC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7M\u0003\u0002\u0004\t\u0005AQ\r_2iC:<WM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tAQ\t_2iC:<W\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0004Qe>$Wo\u0019;\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!q\u0002A!f\u0001\n\u0003y\u0012\u0001B7pI\u0016,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003K\u0019\nQ\u0001\u001d7b]NT!a\n\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u000b\u0012\u0003\u001b\t\u0013x.\u00193dCN$Xj\u001c3f\u0011!Y\u0003A!E!\u0002\u0013\u0001\u0013!B7pI\u0016\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003=\u0002\"\u0001M\u0019\u000e\u0003\u0011I!A\r\u0003\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011B\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u0005E\u0001\u0001\"\u0002\u00106\u0001\u0004\u0001\u0003\"B\u00176\u0001\u0004y\u0003\u0002\u0003\u001f\u0001\u0011\u000b\u0007I\u0011I\u001f\u0002\u000f5,GO]5dgV\ta\b\u0005\u0003@\t\u001asU\"\u0001!\u000b\u0005\u0005\u0013\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0019e#\u0001\u0006d_2dWm\u0019;j_:L!!\u0012!\u0003\u00075\u000b\u0007\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\rM#(/\u001b8h!\ty%+D\u0001Q\u0015\t\tF!\u0001\u0004nKR\u0014\u0018nY\u0005\u0003'B\u0013\u0011bU)M\u001b\u0016$(/[2\t\u0011U\u0003\u0001\u0012!Q!\ny\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\u0006/\u0002!\t\u0005W\u0001\u0013_V$\b/\u001e;QCJ$\u0018\u000e^5p]&tw-F\u0001Z!\t\t#,\u0003\u0002\\E\ta\u0001+\u0019:uSRLwN\\5oO\")Q\f\u0001C!=\u0006Q1/Y7f%\u0016\u001cX\u000f\u001c;\u0015\u0005}\u0013\u0007CA\u000ba\u0013\t\tgCA\u0004C_>dW-\u00198\t\u000b\rd\u0006\u0019A\u0018\u0002\tAd\u0017M\u001c\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0003\u001d!\u0018.\\3pkR,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003YZ\t!bY8oGV\u0014(/\u001a8u\u0013\tq\u0017N\u0001\u0005EkJ\fG/[8o\u0011\u0019\u0001\b\u0001)A\u0005O\u0006AA/[7f_V$\b\u0005\u000b\u0002peB\u0011Qc]\u0005\u0003iZ\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011Y\u0004\u0001R1A\u0005\n]\faB]3mCRLwN\u001c$viV\u0014X-F\u0001y!\rI(\u0010`\u0007\u0002W&\u00111p\u001b\u0002\u0007\rV$XO]3\u0011\u000bu\f\t!!\u0002\u000e\u0003yT!a \u0005\u0002\u0013\t\u0014x.\u00193dCN$\u0018bAA\u0002}\nI!I]8bI\u000e\f7\u000f\u001e\t\u0004+\u0005\u001d\u0011bAA\u0005-\t\u0019\u0011I\\=\t\u0013\u00055\u0001\u0001#A!B\u0013A\u0018a\u0004:fY\u0006$\u0018n\u001c8GkR,(/\u001a\u0011)\u0007\u0005-!\u000fC\u0004\u0002\u0014\u0001!\t&!\u0006\u0002\u0013\u0011|\u0007K]3qCJ,GCAA\f!\r)\u0012\u0011D\u0005\u0004\u000371\"\u0001B+oSRDq!a\b\u0001\t#\n\t#A\u0005e_\u0016CXmY;uKR\u0011\u00111\u0005\t\u0007\u0003K\tY#a\f\u000e\u0005\u0005\u001d\"bAA\u0015\u0011\u0005\u0019!\u000f\u001a3\n\t\u00055\u0012q\u0005\u0002\u0004%\u0012#\u0005\u0003BA\u0019\u0003gi\u0011AJ\u0005\u0004\u0003k1#aC%oi\u0016\u0014h.\u00197S_^D\u0001\"!\u000f\u0001\t#2\u00111H\u0001\u0013I>,\u00050Z2vi\u0016\u0014%o\\1eG\u0006\u001cH/\u0006\u0003\u0002>\u0005\u0015CCAA !\u0015i\u0018\u0011AA!!\u0011\t\u0019%!\u0012\r\u0001\u0011A\u0011qIA\u001c\u0005\u0004\tIEA\u0001U#\u0011\tY%!\u0002\u0011\u0007U\ti%C\u0002\u0002PY\u0011qAT8uQ&tw\rC\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V\u0005!1m\u001c9z)\u0015A\u0014qKA-\u0011!q\u0012\u0011\u000bI\u0001\u0002\u0004\u0001\u0003\u0002C\u0017\u0002RA\u0005\t\u0019A\u0018\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CR3\u0001IA2W\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA8-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA<\u0001E\u0005I\u0011AA=\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u001f+\u0007=\n\u0019\u0007C\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u0012\u0005\n\u0003\u000b\u0003\u0011\u0011!C\u0001\u0003\u000f\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!#\u0011\u0007U\tY)C\u0002\u0002\u000eZ\u00111!\u00138u\u0011%\t\t\nAA\u0001\n\u0003\t\u0019*\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u0011Q\u0013\u0005\u000b\u0003/\u000by)!AA\u0002\u0005%\u0015a\u0001=%c!I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013QT\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0014\t\u0007\u0003C\u000b\u0019+!\u0002\u000e\u0003\tK1!!*C\u0005!IE/\u001a:bi>\u0014\b\"CAU\u0001\u0005\u0005I\u0011AAV\u0003!\u0019\u0017M\\#rk\u0006dGcA0\u0002.\"Q\u0011qSAT\u0003\u0003\u0005\r!!\u0002\t\u0013\u0005E\u0006!!A\u0005B\u0005M\u0016AB3rk\u0006d7\u000fF\u0002`\u0003kC!\"a&\u00020\u0006\u0005\t\u0019AA\u0003\u000f\u001d\tIL\u0001E\u0001\u0003w\u000bQC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7\rE\u0002\u0012\u0003{3a!\u0001\u0002\t\u0002\u0005}6#BA_\u0003\u0003T\u0002cA\u000b\u0002D&\u0019\u0011Q\u0019\f\u0003\r\u0005s\u0017PU3g\u0011\u001d1\u0014Q\u0018C\u0001\u0003\u0013$\"!a/\t\u0017\u00055\u0017Q\u0018b\u0001\n\u0003!\u0011qZ\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\"!!5\u0011\u0007e\f\u0019.C\u0002\u0002V.\u0014q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011%\tI.!0!\u0002\u0013\t\t.A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002B!\"!8\u0002>\u0006\u0005I\u0011QAp\u0003\u0015\t\u0007\u000f\u001d7z)\u0015A\u0014\u0011]Ar\u0011\u0019q\u00121\u001ca\u0001A!1Q&a7A\u0002=B!\"a:\u0002>\u0006\u0005I\u0011QAu\u0003\u001d)h.\u00199qYf$B!a;\u0002xB)Q#!<\u0002r&\u0019\u0011q\u001e\f\u0003\r=\u0003H/[8o!\u0015)\u00121\u001f\u00110\u0013\r\t)P\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005e\u0018Q]A\u0001\u0002\u0004A\u0014a\u0001=%a!Q\u0011Q`A_\u0003\u0003%I!a@\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0003\u00012a\u0012B\u0002\u0013\r\u0011)\u0001\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class BroadcastExchangeExec
extends Exchange {
    private final BroadcastMode mode;
    private final SparkPlan child;
    private Map<String, SQLMetric> metrics;
    private final transient Duration timeout;
    private transient Future<Broadcast<Object>> relationFuture;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private Map metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "data size (bytes)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to collect (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to build (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to broadcast (ms)"))}));
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    private Future relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$trans$0) {
                String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                this.relationFuture = Future$.MODULE$.apply((Function0)new Serializable(this, executionId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BroadcastExchangeExec $outer;
                    public final String executionId$1;

                    public final Broadcast<Object> apply() {
                        return (Broadcast)SQLExecution$.MODULE$.withExecutionId(this.$outer.sparkContext(), this.executionId$1, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$relationFuture$1 $outer;

                            public final Broadcast<Object> apply() {
                                try {
                                    long beforeCollect = System.nanoTime();
                                    InternalRow[] input = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().child().executeCollect();
                                    if (input.length >= 512000000) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table with more than 512 millions rows: ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.length)})));
                                    }
                                    long beforeBuild = System.nanoTime();
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("collectTime").$plus$eq((beforeBuild - beforeCollect) / 1000000L);
                                    long dataSize = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])input).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(InternalRow x$1) {
                                            return ((UnsafeRow)x$1).getSizeInBytes();
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("dataSize").$plus$eq(dataSize);
                                    if (dataSize >= 0x200000000L) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table that is larger than 8GB: ", " GB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(dataSize >> 30))})));
                                    }
                                    Object relation = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().mode().transform(input);
                                    long beforeBroadcast = System.nanoTime();
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("buildTime").$plus$eq((beforeBroadcast - beforeBuild) / 1000000L);
                                    Broadcast broadcasted = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("broadcastTime").$plus$eq((System.nanoTime() - beforeBroadcast) / 1000000L);
                                    if (this.$outer.executionId$1 != null) {
                                        this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(new StringOps(Predef$.MODULE$.augmentString(this.$outer.executionId$1)).toLong(), (Seq<Tuple2<Object, Object>>)((TraversableOnce)this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().metrics().values().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Tuple2<Object, Object> apply(SQLMetric m) {
                                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value()));
                                            }
                                        }, Iterable$.MODULE$.canBuildFrom())).toSeq()));
                                    }
                                    return broadcasted;
                                }
                                catch (OutOfMemoryError outOfMemoryError) {
                                    throw new OutOfMemoryError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough memory to build and broadcast the table to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"all worker nodes. As a workaround, you can either disable broadcast by setting "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to -1 or increase the spark driver "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory by setting ", " to a higher value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark.driver.memory"}))).toString()).initCause(outOfMemoryError.getCause());
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ BroadcastExchangeExec org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionId$1 = executionId$1;
                    }
                }, (ExecutionContext)BroadcastExchangeExec$.MODULE$.executionContext());
                this.bitmap$trans$0 = true;
            }
            return this.relationFuture;
        }
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public boolean sameResult(SparkPlan plan) {
        boolean bl;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof BroadcastExchangeExec) {
            BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)sparkPlan;
            bl = this.mode().compatibleWith(broadcastExchangeExec.mode()) && this.child().sameResult(broadcastExchangeExec.child());
        } else {
            bl = false;
        }
        return bl;
    }

    private Duration timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture() {
        return this.bitmap$trans$0 ? this.relationFuture : this.relationFuture$lzycompute();
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        return (Broadcast)ThreadUtils$.MODULE$.awaitResultInForkJoinSafely(this.relationFuture(), this.timeout());
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        SparkPlan sparkPlan;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                sparkPlan = this.child();
                break;
            }
            case 0: {
                sparkPlan = this.mode();
            }
        }
        return sparkPlan;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        int timeoutValue = this.sqlContext().conf().broadcastTimeout();
        this.timeout = timeoutValue < 0 ? Duration$.MODULE$.Inf() : new package.DurationInt(package$.MODULE$.DurationInt(timeoutValue)).seconds();
    }
}

