/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat$$anonfun$buildReader$2$;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001E\u0011a\u0002V3yi\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!A/\u001a=u\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\n\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\u0006_\u0001!\teI\u0001\ti>\u001cFO]5oO\")\u0011\u0007\u0001C\u0005e\u0005aa/\u001a:jMf\u001c6\r[3nCR\u00111G\u000e\t\u0003MQJ!!N\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006oA\u0002\r\u0001O\u0001\u0007g\u000eDW-\\1\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mB\u0011!\u0002;za\u0016\u001c\u0018BA\u001f;\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u007f\u0001!\t\u0005Q\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003B\t*{\u0005c\u0001\u0014Cq%\u00111i\n\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\u0015s\u0004\u0019\u0001$\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dCU\"\u0001\u0005\n\u0005%C!\u0001D*qCJ\\7+Z:tS>t\u0007\"B&?\u0001\u0004a\u0015aB8qi&|gn\u001d\t\u0005K5#C%\u0003\u0002O[\t\u0019Q*\u00199\t\u000bAs\u0004\u0019A)\u0002\u000b\u0019LG.Z:\u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bE\u0001\u0007yI|w\u000e\u001e \n\u0003!J!!W\u0014\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\u0004'\u0016\f(BA-(!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0002gg*\u0011!\rD\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0011|&A\u0003$jY\u0016\u001cF/\u0019;vg\")a\r\u0001C!O\u0006a\u0001O]3qCJ,wK]5uKR)\u0001n\u001b7ukB\u00111#[\u0005\u0003U\u0012\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQ!R3A\u0002\u0019CQ!\\3A\u00029\f1A[8c!\ty'/D\u0001q\u0015\t\t\u0018-A\u0005nCB\u0014X\rZ;dK&\u00111\u000f\u001d\u0002\u0004\u0015>\u0014\u0007\"B&f\u0001\u0004a\u0005\"\u0002<f\u0001\u0004A\u0014A\u00033bi\u0006\u001c6\r[3nC\")\u0001\u0010\u0001C!s\u0006Y!-^5mIJ+\u0017\rZ3s)=Q\u00181CA\u000b\u0003/\tY\"a\b\u0002,\u00055\u0002#\u0002\u0014|{\u0006\u0005\u0011B\u0001?(\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u0014}&\u0011q\u0010\u0002\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)!+a\u0001\u0002\b%\u0019\u0011Q\u0001/\u0003\u0011%#XM]1u_J\u0004B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bA\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005E\u00111\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003Fo\u0002\u0007a\tC\u0003wo\u0002\u0007\u0001\b\u0003\u0004\u0002\u001a]\u0004\r\u0001O\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u0011QD<A\u0002a\naB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002\"]\u0004\r!a\t\u0002\u000f\u0019LG\u000e^3sgB!!KWA\u0013!\r9\u0012qE\u0005\u0004\u0003SA\"A\u0002$jYR,'\u000fC\u0003Lo\u0002\u0007A\nC\u0004\u00020]\u0004\r!!\r\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9$Y\u0001\u0005G>tg-\u0003\u0003\u0002<\u0005U\"!D\"p]\u001aLw-\u001e:bi&|g\u000e")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "text";
    }

    public String toString() {
        return "Text";
    }

    private void verifySchema(StructType schema) {
        DataType tpe;
        if (schema.size() != 1) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a single column, and you have ", " columns."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schema.size())})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        DataType dataType = tpe = schema.apply(0).dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a string column, but you have ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe.simpleString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        Configuration conf = job.getConfiguration();
        Option compressionCodec = options.get((Object)"compression").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return CompressionCodecs$.MODULE$.getCodecClassName(name);
            }
        });
        compressionCodec.foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".txt").append((Object)TextOutputWriter$.MODULE$.getCompressionExtension(context)).toString();
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Text data source only produces a single data column named \"value\".";
            }
        });
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, requiredSchema, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<UnsafeRow> apply(PartitionedFile file) {
                Iterator<B> iterator2;
                HadoopFileLinesReader reader = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    public final HadoopFileLinesReader reader$1;

                    public final TaskContext apply(TaskContext x$1) {
                        return x$1.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$2$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$2) {
                                this.$outer.reader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                });
                if (this.requiredSchema$1.isEmpty()) {
                    UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                    iterator2 = reader.map(new Serializable(this, emptyUnsafeRow){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeRow emptyUnsafeRow$1;

                        public final UnsafeRow apply(Text x$3) {
                            return this.emptyUnsafeRow$1;
                        }
                        {
                            this.emptyUnsafeRow$1 = emptyUnsafeRow$1;
                        }
                    });
                } else {
                    UnsafeRow unsafeRow = new UnsafeRow(1);
                    BufferHolder bufferHolder = new BufferHolder(unsafeRow);
                    UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(bufferHolder, 1);
                    iterator2 = reader.map(new Serializable(this, unsafeRow, bufferHolder, unsafeRowWriter){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeRow unsafeRow$1;
                        private final BufferHolder bufferHolder$1;
                        private final UnsafeRowWriter unsafeRowWriter$1;

                        public final UnsafeRow apply(Text line) {
                            this.bufferHolder$1.reset();
                            this.unsafeRowWriter$1.write(0, line.getBytes(), 0, line.getLength());
                            this.unsafeRow$1.setTotalSize(this.bufferHolder$1.totalSize());
                            return this.unsafeRow$1;
                        }
                        {
                            this.unsafeRow$1 = unsafeRow$1;
                            this.bufferHolder$1 = bufferHolder$1;
                            this.unsafeRowWriter$1 = unsafeRowWriter$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }
}

