/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetLogRedirector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rua\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0002\u0001\u00131q\u0011\u0003\u0006\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011\u0001B\u0005\u00037\u0011\u0011!BR5mK\u001a{'/\\1u!\ti\u0002%D\u0001\u001f\u0015\ty\u0002\"A\u0004t_V\u00148-Z:\n\u0005\u0005r\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0006\u0002\u0011%tG/\u001a:oC2L!a\n\u0013\u0003\u000f1{wmZ5oOB\u00111#K\u0005\u0003UQ\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000fE\u0002!\u0019!C\u0005e\u0005!\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J,\u0012a\r\t\u0003_QJ!!\u000e\u0002\u0003)A\u000b'/];fi2{wMU3eSJ,7\r^8s\u0011\u00199\u0004\u0001)A\u0005g\u0005)\u0002/\u0019:rk\u0016$Hj\\4SK\u0012L'/Z2u_J\u0004\u0003\"B\u001d\u0001\t\u0003R\u0014!C:i_J$h*Y7f)\u0005Y\u0004C\u0001\u001f@\u001d\t\u0019R(\u0003\u0002?)\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqD\u0003C\u0003D\u0001\u0011\u0005#(\u0001\u0005u_N#(/\u001b8h\u0011\u0015)\u0005\u0001\"\u0011G\u0003!A\u0017m\u001d5D_\u0012,G#A$\u0011\u0005MA\u0015BA%\u0015\u0005\rIe\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0005T\u0001\u0007KF,\u0018\r\\:\u0015\u00055\u0003\u0006CA\nO\u0013\tyECA\u0004C_>dW-\u00198\t\u000bES\u0005\u0019\u0001*\u0002\u000b=$\b.\u001a:\u0011\u0005M\u0019\u0016B\u0001+\u0015\u0005\r\te.\u001f\u0005\u0006-\u0002!\teV\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u00061n\u000b7\u000e\u001d\t\u00033eK!A\u0017\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bq+\u0006\u0019A/\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005y{V\"\u0001\u0005\n\u0005\u0001D!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u00022V\u0001\u0004\u0019\u0017a\u00016pEB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!\u0001\u001b\u0007\u0002\r!\fGm\\8q\u0013\tQWMA\u0002K_\nDQ\u0001\\+A\u00025\fqa\u001c9uS>t7\u000f\u0005\u0003=]nZ\u0014BA8B\u0005\ri\u0015\r\u001d\u0005\u0006cV\u0003\rA]\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA:w\u001b\u0005!(BA;\t\u0003\u0015!\u0018\u0010]3t\u0013\t9HO\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u001f\u0001\u0005\u0002i\f1\"\u001b8gKJ\u001c6\r[3nCR)1P`@\u0002\u0004A\u00191\u0003 :\n\u0005u$\"AB(qi&|g\u000eC\u0003]q\u0002\u0007Q\f\u0003\u0004\u0002\u0002a\u0004\r!\\\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bbBA\u0003q\u0002\u0007\u0011qA\u0001\u0006M&dWm\u001d\t\u0007\u0003\u0013\tI\"a\b\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\t\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012bAA\f)\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9\u0002\u0006\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011QE4\u0002\u0005\u0019\u001c\u0018\u0002BA\u0015\u0003G\u0011!BR5mKN#\u0018\r^;t\r\u0019\ti\u0003\u0001!\u00020\tIa)\u001b7f)f\u0004Xm]\n\u0007\u0003W\u0011\u0012\u0011\u0007\u0015\u0011\u0007M\t\u0019$C\u0002\u00026Q\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0006\u0002:\u0005-\"Q3A\u0005\u0002\u0005m\u0012\u0001\u00023bi\u0006,\"!a\u0002\t\u0017\u0005}\u00121\u0006B\tB\u0003%\u0011qA\u0001\u0006I\u0006$\u0018\r\t\u0005\f\u0003\u0007\nYC!f\u0001\n\u0003\tY$\u0001\u0005nKR\fG-\u0019;b\u0011-\t9%a\u000b\u0003\u0012\u0003\u0006I!a\u0002\u0002\u00135,G/\u00193bi\u0006\u0004\u0003bCA&\u0003W\u0011)\u001a!C\u0001\u0003w\tabY8n[>tW*\u001a;bI\u0006$\u0018\rC\u0006\u0002P\u0005-\"\u0011#Q\u0001\n\u0005\u001d\u0011aD2p[6|g.T3uC\u0012\fG/\u0019\u0011\t\u000f1\nY\u0003\"\u0001\u0002TQA\u0011QKA-\u00037\ni\u0006\u0005\u0003\u0002X\u0005-R\"\u0001\u0001\t\u0011\u0005e\u0012\u0011\u000ba\u0001\u0003\u000fA\u0001\"a\u0011\u0002R\u0001\u0007\u0011q\u0001\u0005\t\u0003\u0017\n\t\u00061\u0001\u0002\b!Q\u0011\u0011MA\u0016\u0003\u0003%\t!a\u0019\u0002\t\r|\u0007/\u001f\u000b\t\u0003+\n)'a\u001a\u0002j!Q\u0011\u0011HA0!\u0003\u0005\r!a\u0002\t\u0015\u0005\r\u0013q\fI\u0001\u0002\u0004\t9\u0001\u0003\u0006\u0002L\u0005}\u0003\u0013!a\u0001\u0003\u000fA!\"!\u001c\u0002,E\u0005I\u0011AA8\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001d+\t\u0005\u001d\u00111O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0010\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011qQA\u0016#\u0003%\t!a\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u00111RA\u0016#\u0003%\t!a\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q\u0011qRA\u0016\u0003\u0003%\t%!%\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\t1\fgn\u001a\u0006\u0003\u0003;\u000bAA[1wC&\u0019\u0001)a&\t\u0015\u0005\r\u00161FA\u0001\n\u0003\t)+\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001H\u0011)\tI+a\u000b\u0002\u0002\u0013\u0005\u00111V\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0011\u0016Q\u0016\u0005\n\u0003_\u000b9+!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0011)\t\u0019,a\u000b\u0002\u0002\u0013\u0005\u0013QW\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0017\t\u0006\u0003s\u000byLU\u0007\u0003\u0003wS1!!0\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\fYL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\t)-a\u000b\u0002\u0002\u0013\u0005\u0011qY\u0001\tG\u0006tW)];bYR\u0019Q*!3\t\u0013\u0005=\u00161YA\u0001\u0002\u0004\u0011\u0006\u0002C#\u0002,\u0005\u0005I\u0011\t$\t\u0013\r\u000bY#!A\u0005B\u0005=GCAAJ\u0011%Y\u00151FA\u0001\n\u0003\n\u0019\u000eF\u0002N\u0003+D\u0011\"a,\u0002R\u0006\u0005\t\u0019\u0001*\b\u0013\u0005e\u0007!!A\t\u0002\u0005m\u0017!\u0003$jY\u0016$\u0016\u0010]3t!\u0011\t9&!8\u0007\u0013\u00055\u0002!!A\t\u0002\u0005}7#BAo\u0003CD\u0003\u0003DAr\u0003S\f9!a\u0002\u0002\b\u0005USBAAs\u0015\r\t9\u000fF\u0001\beVtG/[7f\u0013\u0011\tY/!:\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004-\u0003;$\t!a<\u0015\u0005\u0005m\u0007\"C\"\u0002^\u0006\u0005IQIAh\u0011)\t)0!8\u0002\u0002\u0013\u0005\u0015q_\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003+\nI0a?\u0002~\"A\u0011\u0011HAz\u0001\u0004\t9\u0001\u0003\u0005\u0002D\u0005M\b\u0019AA\u0004\u0011!\tY%a=A\u0002\u0005\u001d\u0001B\u0003B\u0001\u0003;\f\t\u0011\"!\u0003\u0004\u00059QO\\1qa2LH\u0003\u0002B\u0003\u0005\u001b\u0001Ba\u0005?\u0003\bAI1C!\u0003\u0002\b\u0005\u001d\u0011qA\u0005\u0004\u0005\u0017!\"A\u0002+va2,7\u0007\u0003\u0006\u0003\u0010\u0005}\u0018\u0011!a\u0001\u0003+\n1\u0001\u001f\u00131\u0011)\u0011\u0019\"!8\u0002\u0002\u0013%!QC\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0018A!\u0011Q\u0013B\r\u0013\u0011\u0011Y\"a&\u0003\r=\u0013'.Z2u\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005C\t!b\u001d9mSR4\u0015\u000e\\3t)\u0011\t)Fa\t\t\u0011\t\u0015\"Q\u0004a\u0001\u0003\u000f\t\u0001\"\u00197m\r&dWm\u001d\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u00035I7oU;n[\u0006\u0014\u0018PR5mKR\u0019QJ!\f\t\u0011\t=\"q\u0005a\u0001\u0005c\tAAZ5mKB!\u0011\u0011\u0005B\u001a\u0013\u0011\u0011)$a\t\u0003\tA\u000bG\u000f\u001b\u0005\b\u0005s\u0001A\u0011\tB\u001e\u00031\u0019X\u000f\u001d9peR\u0014\u0015\r^2i)\u0015i%Q\bB \u0011\u0019a&q\u0007a\u0001;\"9!\u0011\tB\u001c\u0001\u0004\u0011\u0018AB:dQ\u0016l\u0017\rC\u0004\u0003F\u0001!\tEa\u0012\u0002\u0017%\u001c8\u000b\u001d7ji\u0006\u0014G.\u001a\u000b\b\u001b\n%#1\nB'\u0011\u0019a&1\ta\u0001;\"1ANa\u0011A\u00025D\u0001Ba\u0014\u0003D\u0001\u0007!\u0011G\u0001\u0005a\u0006$\b\u000eC\u0004\u0003T\u0001!\tE!\u0016\u0002=\t,\u0018\u000e\u001c3SK\u0006$WM],ji\"\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001cH\u0003\u0005B,\u0005g\u0012)Ha\u001e\u0003|\t}$1\u0012BG!\u001d\u0019\"\u0011\fB/\u0005GJ1Aa\u0017\u0015\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u001a\u0005?J1A!\u0019\u0005\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007CBA\u0005\u0005K\u00129'\u0003\u0003\u0002B\u0006u\u0001\u0003\u0002B5\u0005_j!Aa\u001b\u000b\u0007\t5\u0004\"\u0001\u0005dCR\fG._:u\u0013\u0011\u0011\tHa\u001b\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u00079\nE\u0003\u0019A/\t\rE\u0014\t\u00061\u0001s\u0011\u001d\u0011IH!\u0015A\u0002I\fq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\b\u0005{\u0012\t\u00061\u0001s\u00039\u0011X-];je\u0016$7k\u00195f[\u0006D\u0001B!!\u0003R\u0001\u0007!1Q\u0001\bM&dG/\u001a:t!\u0019\tI!!\u0007\u0003\u0006B\u0019QDa\"\n\u0007\t%eD\u0001\u0004GS2$XM\u001d\u0005\u0007Y\nE\u0003\u0019A7\t\u0011\t=%\u0011\u000ba\u0001\u0005#\u000b!\u0002[1e_>\u00048i\u001c8g!\u0011\u0011\u0019J!'\u000e\u0005\tU%b\u0001BLO\u0006!1m\u001c8g\u0013\u0011\u0011YJ!&\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\u0011y\n\u0001C!\u0005C\u000b1BY;jY\u0012\u0014V-\u00193feR\u0001\"q\u000bBR\u0005K\u00139K!+\u0003,\n5&q\u0016\u0005\u00079\nu\u0005\u0019A/\t\rE\u0014i\n1\u0001s\u0011\u001d\u0011IH!(A\u0002IDqA! \u0003\u001e\u0002\u0007!\u000f\u0003\u0005\u0003\u0002\nu\u0005\u0019\u0001BB\u0011\u0019a'Q\u0014a\u0001[\"A!q\u0012BO\u0001\u0004\u0011\tjB\u0004\u00034\nA\tA!.\u0002#A\u000b'/];fi\u001aKG.\u001a$pe6\fG\u000fE\u00020\u0005o3a!\u0001\u0002\t\u0002\te6#\u0002B\\%\tB\u0003b\u0002\u0017\u00038\u0012\u0005!Q\u0018\u000b\u0003\u0005kC\u0011B!1\u00038\u0012\u0005!Aa1\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\rF\u0003|\u0005\u000b\u00149\u000e\u0003\u0005\u0003H\n}\u0006\u0019\u0001Be\u0003\u001d1wn\u001c;feN\u0004b!!\u0003\u0002\u001a\t-\u0007\u0003\u0002Bg\u0005'l!Aa4\u000b\u0007!\u0014\tN\u0003\u0002\u0004\u0019%!!Q\u001bBh\u0005\u00191un\u001c;fe\"1ALa0A\u0002uC\u0001Ba7\u00038\u0012\u0005!Q\\\u0001\u001c[\u0016\u0014x-Z'fi\u0006\u001cHo\u001c:f!\u0006\u0014\u0018/^3u'\u000eDW-\\1\u0015\u000bI\u0014yNa9\t\u000f\t\u0005(\u0011\u001ca\u0001e\u0006yQ.\u001a;bgR|'/Z*dQ\u0016l\u0017\rC\u0004\u0003f\ne\u0007\u0019\u0001:\u0002\u001bA\f'/];fiN\u001b\u0007.Z7b\u0011%\u0011IOa.\u0005\u0002\t\u0011Y/\u0001\u000enKJ<W-T5tg&twMT;mY\u0006\u0014G.\u001a$jK2$7\u000fF\u0003s\u0005[\u0014y\u000fC\u0004\u0003b\n\u001d\b\u0019\u0001:\t\u000f\t\u0015(q\u001da\u0001e\"A!1\u001fB\\\t\u0003\u0011)0\u0001\fnKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)\u0015Y(q\u001fB~\u0011!\u0011IP!=A\u0002\u0005\u001d\u0011\u0001\u00044jY\u0016\u001cHk\u001c+pk\u000eD\u0007B\u0002/\u0003r\u0002\u0007Q\f\u0003\u0005\u0003\u0000\n]F\u0011AB\u0001\u0003Q\u0011X-\u00193TG\",W.\u0019$s_64un\u001c;feR)!oa\u0001\u0004\b!A1Q\u0001B\u007f\u0001\u0004\u0011Y-\u0001\u0004g_>$XM\u001d\u0005\t\u0007\u0013\u0011i\u00101\u0001\u0004\f\u0005I1m\u001c8wKJ$XM\u001d\t\u0004_\r5\u0011bAB\b\u0005\t1\u0002+\u0019:rk\u0016$8k\u00195f[\u0006\u001cuN\u001c<feR,'\u000f\u0003\u0005\u0004\u0014\t]F\u0011BB\u000b\u0003]!Wm]3sS\u0006d\u0017N_3TG\",W.Y*ue&tw\rF\u0002|\u0007/Aqa!\u0007\u0004\u0012\u0001\u00071(\u0001\u0007tG\",W.Y*ue&tw\r\u0003\u0006\u0003\u0014\t]\u0016\u0011!C\u0005\u0005+\u0001")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private final ParquetLogRedirector parquetLogRedirector;
    private volatile ParquetFileFormat$FileTypes$ FileTypes$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetSchemaConverter parquetSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(seq, sparkSession);
    }

    public static StructType mergeMetastoreParquetSchema(StructType structType, StructType structType2) {
        return ParquetFileFormat$.MODULE$.mergeMetastoreParquetSchema(structType, structType2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParquetFileFormat$FileTypes$ FileTypes$lzycompute() {
        ParquetFileFormat parquetFileFormat = this;
        synchronized (parquetFileFormat) {
            if (this.FileTypes$module != null) return this.FileTypes$module;
            this.FileTypes$module = new ParquetFileFormat$FileTypes$(this);
            return this.FileTypes$module;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private ParquetLogRedirector parquetLogRedirector() {
        return this.parquetLogRedirector;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, ParquetOutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using default output committer for Parquet: ").append((Object)ParquetOutputCommitter.class.getCanonicalName()).toString();
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using user defined output committer for Parquet: ").append((Object)this.committerClass$1.getCanonicalName()).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, ParquetOutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)dataSchema);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetBinaryAsString())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetINT96AsTimestamp())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.enable.summary-metadata") == null) {
            conf.setBoolean("parquet.enable.summary-metadata", false);
        }
        return new OutputWriterFactory(this){
            private final ParquetLogRedirector parquetLogRedirector;

            private ParquetLogRedirector parquetLogRedirector() {
                return this.parquetLogRedirector;
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append((Object)".parquet").toString();
            }
            {
                this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = sparkSession.sessionState().conf().isParquetSchemaRespectSummaries();
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.metadata().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            }).orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.data().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            })).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    public ParquetFileFormat$FileTypes$ FileTypes() {
        return this.FileTypes$module == null ? this.FileTypes$lzycompute() : this.FileTypes$module;
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles2) {
        FileStatus[] leaves = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)allFiles2.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath()) || (!f.getPath().getName().startsWith("_") || f.getPath().getName().contains("=")) && !f.getPath().getName().startsWith(".");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).toArray(ClassTag$.MODULE$.apply(FileStatus.class))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$2) {
                String string = x$2.getPath().getName();
                String string2 = "_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_common_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                return x$4.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return this.buildReader(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)requiredSchema);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        None$ pushed = sparkSession.sessionState().conf().parquetFilterPushDown() ? ((TraversableOnce)filters.flatMap((Function1)new Serializable(this, requiredSchema){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;

            public final Iterable<FilterPredicate> apply(Filter x$5) {
                return Option$.MODULE$.option2Iterable(ParquetFilters$.MODULE$.createFilter(this.requiredSchema$1, x$5));
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
            }
        }) : None$.MODULE$;
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        boolean enableVectorizedReader = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && resultSchema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$6) {
                return x$6.dataType() instanceof AtomicType;
            }
        });
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        return new Serializable(this, partitionSchema, requiredSchema, (Option)pushed, broadcastedHadoopConf, enableVectorizedReader, returningBatch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;
            public final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final Option pushed$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final boolean enableVectorizedReader$1;
            private final boolean returningBatch$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedParquetRecordReader;
                Predef$.MODULE$.assert(file.partitionValues().numFields() == this.partitionSchema$1.size());
                FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                ParquetInputSplit split = new ParquetInputSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value(), attemptId);
                if (this.pushed$1.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)this.pushed$1.get()));
                }
                if (this.enableVectorizedReader$1) {
                    VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader();
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildReader$1 $outer;
                        private final PartitionedFile file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionSchema$1, this.file$1.partitionValues()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                    vectorizedReader.initBatch(this.partitionSchema$1, file.partitionValues());
                    if (this.returningBatch$1) {
                        vectorizedReader.enableReturningBatches();
                    }
                    vectorizedParquetRecordReader = vectorizedReader;
                } else {
                    ParquetRecordReader parquetRecordReader;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to parquet-mr"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    Option option = this.pushed$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FilterPredicate filter2 = (FilterPredicate)some.x();
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport(), FilterCompat.get((FilterPredicate)filter2, null));
                    } else {
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport());
                    }
                    ParquetRecordReader reader = parquetRecordReader;
                    reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    vectorizedParquetRecordReader = reader;
                }
                VectorizedParquetRecordReader parquetReader = vectorizedParquetRecordReader;
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(parquetReader);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, iter){
                    public static final long serialVersionUID = 0L;
                    public final RecordReaderIterator iter$1;

                    public final TaskContext apply(TaskContext x$7) {
                        return x$7.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$apply$4 $outer;

                            public final void apply(TaskContext x$8) {
                                this.$outer.iter$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.iter$1 = iter$1;
                    }
                });
                if (parquetReader instanceof VectorizedParquetRecordReader && this.enableVectorizedReader$1) {
                    recordReaderIterator = iter;
                } else {
                    Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    JoinedRow joinedRow = new JoinedRow();
                    UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    recordReaderIterator = this.partitionSchema$1.length() == 0 ? iter : iter.map(new Serializable(this, file, joinedRow, appendPartitionColumns){
                        public static final long serialVersionUID = 0L;
                        private final PartitionedFile file$1;
                        private final JoinedRow joinedRow$1;
                        private final UnsafeProjection appendPartitionColumns$1;

                        public final UnsafeRow apply(InternalRow d) {
                            return this.appendPartitionColumns$1.apply((InternalRow)this.joinedRow$1.apply(d, this.file$1.partitionValues()));
                        }
                        {
                            this.file$1 = file$1;
                            this.joinedRow$1 = joinedRow$1;
                            this.appendPartitionColumns$1 = appendPartitionColumns$1;
                        }
                    });
                }
                return recordReaderIterator;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.pushed$1 = pushed$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.returningBatch$1 = returningBatch$1;
            }
        };
    }

    public ParquetFileFormat() {
        FileFormat$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.parquetLogRedirector = ParquetLogRedirector.INSTANCE;
    }

    public class FileTypes
    implements Product,
    Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ ParquetFileFormat $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 0: {
                    seq = this.data();
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ParquetFileFormat org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(ParquetFileFormat $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

