/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$$anonfun$13$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$$anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class JdbcUtils$
implements Logging {
    public static final JdbcUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JdbcUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Function0<Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return new Serializable(options, driverClass){
            public static final long serialVersionUID = 0L;
            private final JDBCOptions options$1;
            public final String driverClass$1;

            public final Connection apply() {
                DriverRegistry$.MODULE$.register(this.driverClass$1);
                Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionFactory.1 $outer;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var6_9;
                        A1 A1 = x1;
                        if (A1 instanceof DriverWrapper) {
                            DriverWrapper driverWrapper = (DriverWrapper)A1;
                            String string = driverWrapper.wrapped().getClass().getCanonicalName();
                            String string2 = this.$outer.driverClass$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                DriverWrapper driverWrapper2 = driverWrapper;
                                return var6_9;
                            }
                        }
                        String string = A1.getClass().getCanonicalName();
                        String string3 = this.$outer.driverClass$1;
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            A1 A12 = A1;
                            return var6_9;
                        }
                        Object object = function1.apply(x1);
                        return var6_9;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Driver x1) {
                        Driver driver = x1;
                        if (driver instanceof DriverWrapper) {
                            DriverWrapper driverWrapper = (DriverWrapper)driver;
                            String string = driverWrapper.wrapped().getClass().getCanonicalName();
                            String string2 = this.$outer.driverClass$1;
                            if (string == null) {
                                if (string2 == null) return true;
                            } else if (string.equals(string2)) {
                                return true;
                            }
                        }
                        String string = driver.getClass().getCanonicalName();
                        String string3 = this.$outer.driverClass$1;
                        if (string != null) {
                            if (!string.equals(string3)) return false;
                            return true;
                        }
                        if (string3 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionFactory.1 $outer;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not find registered driver with class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.driverClass$1})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return driver.connect(this.options$1.url(), this.options$1.asConnectionProperties());
            }
            {
                this.options$1 = options$1;
                this.driverClass$1 = driverClass$1;
            }
        };
    }

    public boolean tableExists(Connection conn, String url, String table) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        return Try$.MODULE$.apply((Function0)new Serializable(conn, table, dialect){
            public static final long serialVersionUID = 0L;
            private final Connection conn$1;
            private final String table$1;
            private final JdbcDialect dialect$1;

            public final ResultSet apply() {
                PreparedStatement statement = this.conn$1.prepareStatement(this.dialect$1.getTableExistsQuery(this.table$1));
                try {
                    return statement.executeQuery();
                }
                finally {
                    statement.close();
                }
            }
            {
                this.conn$1 = conn$1;
                this.table$1 = table$1;
                this.dialect$1 = dialect$1;
            }
        }).isSuccess();
    }

    public void dropTable(Connection conn, String table) {
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
            return;
        }
        finally {
            statement.close();
        }
    }

    public void truncateTable(Connection conn, String table) {
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
            return;
        }
        finally {
            statement.close();
        }
    }

    public Option<Object> isCascadingTruncateTable(String url) {
        return JdbcDialects$.MODULE$.get(url).isCascadingTruncateTable();
    }

    public PreparedStatement insertStatement(Connection conn, String table, StructType rddSchema, JdbcDialect dialect) {
        String columns2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$2;

            public final String apply(StructField x) {
                return this.dialect$2.quoteIdentifier(x.name());
            }
            {
                this.dialect$2 = dialect$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        String placeholders = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return "?";
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (", ") VALUES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, columns2, placeholders}));
        return conn.prepareStatement(sql);
    }

    public Option<JdbcType> getCommonJDBCType(DataType dt) {
        Option option;
        DataType dataType = dt;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        DataType dataType2 = dataType;
        if (!(integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null)) {
            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 4));
        } else {
            LongType$ longType$ = LongType$.MODULE$;
            DataType dataType3 = dataType;
            if (!(longType$ != null ? !longType$.equals(dataType3) : dataType3 != null)) {
                option = Option$.MODULE$.apply((Object)new JdbcType("BIGINT", -5));
            } else {
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                DataType dataType4 = dataType;
                if (!(doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null)) {
                    option = Option$.MODULE$.apply((Object)new JdbcType("DOUBLE PRECISION", 8));
                } else {
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    DataType dataType5 = dataType;
                    if (!(floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null)) {
                        option = Option$.MODULE$.apply((Object)new JdbcType("REAL", 6));
                    } else {
                        ShortType$ shortType$ = ShortType$.MODULE$;
                        DataType dataType6 = dataType;
                        if (!(shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null)) {
                            option = Option$.MODULE$.apply((Object)new JdbcType("INTEGER", 5));
                        } else {
                            ByteType$ byteType$ = ByteType$.MODULE$;
                            DataType dataType7 = dataType;
                            if (!(byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null)) {
                                option = Option$.MODULE$.apply((Object)new JdbcType("BYTE", -6));
                            } else {
                                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                DataType dataType8 = dataType;
                                if (!(booleanType$ != null ? !booleanType$.equals(dataType8) : dataType8 != null)) {
                                    option = Option$.MODULE$.apply((Object)new JdbcType("BIT(1)", -7));
                                } else {
                                    StringType$ stringType$ = StringType$.MODULE$;
                                    DataType dataType9 = dataType;
                                    if (!(stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null)) {
                                        option = Option$.MODULE$.apply((Object)new JdbcType("TEXT", 2005));
                                    } else {
                                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                        DataType dataType10 = dataType;
                                        if (!(binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null)) {
                                            option = Option$.MODULE$.apply((Object)new JdbcType("BLOB", 2004));
                                        } else {
                                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                            DataType dataType11 = dataType;
                                            if (!(timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null)) {
                                                option = Option$.MODULE$.apply((Object)new JdbcType("TIMESTAMP", 93));
                                            } else {
                                                DateType$ dateType$ = DateType$.MODULE$;
                                                DataType dataType12 = dataType;
                                                if (!(dateType$ != null ? !dateType$.equals(dataType12) : dataType12 != null)) {
                                                    option = Option$.MODULE$.apply((Object)new JdbcType("DATE", 91));
                                                } else if (dataType instanceof DecimalType) {
                                                    DecimalType decimalType = (DecimalType)dataType;
                                                    option = Option$.MODULE$.apply((Object)new JdbcType(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())})), 3));
                                                } else {
                                                    option = None$.MODULE$;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return option;
    }

    public JdbcType org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(DataType dt, JdbcDialect dialect) {
        return (JdbcType)dialect.getJDBCType(dt).orElse((Function0)new Serializable(dt){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;

            public final Option<JdbcType> apply() {
                return JdbcUtils$.MODULE$.getCommonJDBCType(this.dt$1);
            }
            {
                this.dt$1 = dt$1;
            }
        }).getOrElse((Function0)new Serializable(dt){
            public static final long serialVersionUID = 0L;
            private final DataType dt$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't get JDBC type for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dt$1.simpleString()})));
            }
            {
                this.dt$1 = dt$1;
            }
        });
    }

    public DataType org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        StringType$ answer;
        int n = sqlType;
        switch (n) {
            default: {
                StringType$ stringType$ = null;
                break;
            }
            case 12: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -3: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -6: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case 93: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 92: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 2002: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2009: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 5: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case -8: {
                StringType$ stringType$ = LongType$.MODULE$;
                break;
            }
            case 2006: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 7: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 1111: {
                StringType$ stringType$ = null;
                break;
            }
            case -9: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                stringType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 0: {
                StringType$ stringType$ = null;
                break;
            }
            case 2011: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -16: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2000: {
                StringType$ stringType$ = null;
                break;
            }
            case 4: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 6: {
                StringType$ stringType$ = FloatType$.MODULE$;
                break;
            }
            case 8: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 2001: {
                StringType$ stringType$ = null;
                break;
            }
            case 3: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                stringType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 91: {
                StringType$ stringType$ = DateType$.MODULE$;
                break;
            }
            case 70: {
                StringType$ stringType$ = null;
                break;
            }
            case 2005: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 16: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -2: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -5: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 2003: {
                StringType$ stringType$ = answer = null;
            }
        }
        if (answer == null) {
            throw new SQLException(new StringBuilder().append((Object)"Unsupported type ").append((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString());
        }
        return answer;
    }

    /*
     * Exception decompiling
     */
    public StructType getSchema(ResultSet resultSet, JdbcDialect dialect) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 298->311)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterator<Row> resultSetToRows(ResultSet resultSet, StructType schema) {
        InputMetrics inputMetrics = (InputMetrics)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputMetrics apply(TaskContext x$2) {
                return x$2.taskMetrics().inputMetrics();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputMetrics apply() {
                return new InputMetrics();
            }
        });
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
        Seq x$7 = qual$1.resolveAndBind$default$1();
        Analyzer x$8 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$7, x$8);
        Iterator<InternalRow> internalRows = this.resultSetToSparkInternalRows(resultSet, schema, inputMetrics);
        return internalRows.map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$1;

            public final Row apply(InternalRow row) {
                return (Row)this.encoder$1.fromRow(row);
            }
            {
                this.encoder$1 = encoder$1;
            }
        });
    }

    public Iterator<InternalRow> resultSetToSparkInternalRows(ResultSet resultSet, StructType schema, InputMetrics inputMetrics) {
        return new NextIterator<InternalRow>(resultSet, schema, inputMetrics){
            private final ResultSet rs;
            private final Function3<ResultSet, InternalRow, Object, BoxedUnit>[] getters;
            private final SpecificInternalRow mutableRow;
            private final InputMetrics inputMetrics$1;

            public void close() {
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    JdbcUtils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Exception closing resultset";
                        }
                    }, exception);
                }
            }

            public InternalRow getNext() {
                SpecificInternalRow specificInternalRow;
                if (this.rs.next()) {
                    this.inputMetrics$1.incRecordsRead(1L);
                    for (int i = 0; i < this.getters.length; ++i) {
                        this.getters[i].apply((Object)this.rs, (Object)this.mutableRow, (Object)BoxesRunTime.boxToInteger((int)i));
                        if (!this.rs.wasNull()) continue;
                        this.mutableRow.setNullAt(i);
                    }
                    specificInternalRow = this.mutableRow;
                } else {
                    this.finished_$eq(true);
                    specificInternalRow = null;
                }
                return specificInternalRow;
            }
            {
                this.inputMetrics$1 = inputMetrics$1;
                this.rs = resultSet$1;
                this.getters = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(schema$1);
                this.mutableRow = new SpecificInternalRow((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])schema$1.fields()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(StructField x) {
                        return x.dataType();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))));
            }
        };
    }

    public Function3<ResultSet, InternalRow, Object, BoxedUnit>[] org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetters(StructType schema) {
        return (Function3[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function3<ResultSet, InternalRow, Object, BoxedUnit> apply(StructField sf) {
                return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter(sf.dataType(), sf.metadata());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
    }

    public Function3<ResultSet, InternalRow, Object, BoxedUnit> org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter(DataType dt, Metadata metadata) {
        block26: {
            Object object;
            block14: {
                Object object2;
                DataType et;
                DataType dataType;
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    boolean bl;
                                    block20: {
                                        DataType dataType2;
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        DecimalType decimalType;
                                                        Option option;
                                                        block15: {
                                                            block13: {
                                                                bl = false;
                                                                dataType2 = null;
                                                                dataType = dt;
                                                                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                                DataType dataType3 = dataType;
                                                                if (booleanType$ != null ? !booleanType$.equals(dataType3) : dataType3 != null) break block13;
                                                                object = new Serializable(){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                                        row.setBoolean(pos, rs.getBoolean(pos + 1));
                                                                    }
                                                                };
                                                                break block14;
                                                            }
                                                            DateType$ dateType$ = DateType$.MODULE$;
                                                            DataType dataType4 = dataType;
                                                            if (dateType$ != null ? !dateType$.equals(dataType4) : dataType4 != null) break block15;
                                                            object = new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                                    Date dateVal = rs.getDate(pos + 1);
                                                                    if (dateVal == null) {
                                                                        row.update(pos, null);
                                                                    } else {
                                                                        row.setInt(pos, DateTimeUtils$.MODULE$.fromJavaDate(dateVal));
                                                                    }
                                                                }
                                                            };
                                                            break block14;
                                                        }
                                                        if (!(dataType instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) break block16;
                                                        int p = ((Tuple2)option.get())._1$mcI$sp();
                                                        int s = ((Tuple2)option.get())._2$mcI$sp();
                                                        object = new Serializable(p, s){
                                                            public static final long serialVersionUID = 0L;
                                                            public final int p$1;
                                                            public final int s$1;

                                                            public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                                Object decimal = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(rs.getBigDecimal(pos + 1), new Serializable(this){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter$3 $outer;

                                                                    public final Decimal apply(BigDecimal d) {
                                                                        return Decimal$.MODULE$.apply(d, this.$outer.p$1, this.$outer.s$1);
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw new NullPointerException();
                                                                        }
                                                                        this.$outer = $outer;
                                                                    }
                                                                });
                                                                row.update(pos, decimal);
                                                            }
                                                            {
                                                                this.p$1 = p$1;
                                                                this.s$1 = s$1;
                                                            }
                                                        };
                                                        break block14;
                                                    }
                                                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                    DataType dataType5 = dataType;
                                                    if (doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null) break block17;
                                                    object = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                            row.setDouble(pos, rs.getDouble(pos + 1));
                                                        }
                                                    };
                                                    break block14;
                                                }
                                                FloatType$ floatType$ = FloatType$.MODULE$;
                                                DataType dataType6 = dataType;
                                                if (floatType$ != null ? !floatType$.equals(dataType6) : dataType6 != null) break block18;
                                                object = new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                        row.setFloat(pos, rs.getFloat(pos + 1));
                                                    }
                                                };
                                                break block14;
                                            }
                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                            DataType dataType7 = dataType;
                                            if (integerType$ != null ? !integerType$.equals(dataType7) : dataType7 != null) break block19;
                                            object = new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                    row.setInt(pos, rs.getInt(pos + 1));
                                                }
                                            };
                                            break block14;
                                        }
                                        LongType$ longType$ = LongType$.MODULE$;
                                        DataType dataType8 = dataType;
                                        if (longType$ != null ? !longType$.equals(dataType8) : dataType8 != null) break block20;
                                        bl = true;
                                        dataType2 = dataType;
                                        if (!metadata.contains("binarylong")) break block20;
                                        object = new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final void apply(ResultSet rs, InternalRow row, int pos) {
                                                byte[] bytes = rs.getBytes(pos + 1);
                                                long ans = 0L;
                                                for (int j = 0; j < bytes.length; ++j) {
                                                    ans = 256L * ans + (long)(0xFF & bytes[j]);
                                                }
                                                row.setLong(pos, ans);
                                            }
                                        };
                                        break block14;
                                    }
                                    if (!bl) break block21;
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(ResultSet rs, InternalRow row, int pos) {
                                            row.setLong(pos, rs.getLong(pos + 1));
                                        }
                                    };
                                    break block14;
                                }
                                ShortType$ shortType$ = ShortType$.MODULE$;
                                DataType dataType9 = dataType;
                                if (shortType$ != null ? !shortType$.equals(dataType9) : dataType9 != null) break block22;
                                object = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                                        row.setShort(pos, rs.getShort(pos + 1));
                                    }
                                };
                                break block14;
                            }
                            StringType$ stringType$ = StringType$.MODULE$;
                            DataType dataType10 = dataType;
                            if (stringType$ != null ? !stringType$.equals(dataType10) : dataType10 != null) break block23;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(ResultSet rs, InternalRow row, int pos) {
                                    row.update(pos, (Object)UTF8String.fromString((String)rs.getString(pos + 1)));
                                }
                            };
                            break block14;
                        }
                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                        DataType dataType11 = dataType;
                        if (timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null) break block24;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ResultSet rs, InternalRow row, int pos) {
                                Timestamp t = rs.getTimestamp(pos + 1);
                                if (t == null) {
                                    row.update(pos, null);
                                } else {
                                    row.setLong(pos, DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
                                }
                            }
                        };
                        break block14;
                    }
                    BinaryType$ binaryType$ = BinaryType$.MODULE$;
                    DataType dataType12 = dataType;
                    if (binaryType$ != null ? !binaryType$.equals(dataType12) : dataType12 != null) break block25;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ResultSet rs, InternalRow row, int pos) {
                            row.update(pos, (Object)rs.getBytes(pos + 1));
                        }
                    };
                    break block14;
                }
                if (!(dataType instanceof ArrayType)) break block26;
                ArrayType arrayType = (ArrayType)dataType;
                DataType dataType13 = et = arrayType.elementType();
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                DataType dataType14 = dataType13;
                if (!(timestampType$ != null ? !timestampType$.equals(dataType14) : dataType14 != null)) {
                    object2 = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Object[] apply(Object array2) {
                            return (Object[])Predef$.MODULE$.refArrayOps((Object[])((Timestamp[])array2)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Object apply(Timestamp timestamp) {
                                    return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(timestamp, new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(Timestamp t) {
                                            return DateTimeUtils$.MODULE$.fromJavaTimestamp(t);
                                        }
                                    });
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                        }
                    };
                } else {
                    StringType$ stringType$ = StringType$.MODULE$;
                    DataType dataType15 = dataType13;
                    if (!(stringType$ != null ? !stringType$.equals(dataType15) : dataType15 != null)) {
                        object2 = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final UTF8String[] apply(Object array2) {
                                return (UTF8String[])Predef$.MODULE$.refArrayOps((Object[])((String[])array2)).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final UTF8String apply(String x$1) {
                                        return UTF8String.fromString((String)x$1);
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UTF8String.class)));
                            }
                        };
                    } else {
                        DateType$ dateType$ = DateType$.MODULE$;
                        DataType dataType16 = dataType13;
                        if (!(dateType$ != null ? !dateType$.equals(dataType16) : dataType16 != null)) {
                            object2 = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final Object[] apply(Object array2) {
                                    return (Object[])Predef$.MODULE$.refArrayOps((Object[])((Date[])array2)).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(Date date) {
                                            return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(date, new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final int apply(Date date) {
                                                    return DateTimeUtils$.MODULE$.fromJavaDate(date);
                                                }
                                            });
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                                }
                            };
                        } else if (dataType13 instanceof DecimalType) {
                            DecimalType decimalType = (DecimalType)dataType13;
                            object2 = new Serializable(decimalType){
                                public static final long serialVersionUID = 0L;
                                public final DecimalType x8$1;

                                public final Object[] apply(Object array2) {
                                    return (Object[])Predef$.MODULE$.refArrayOps((Object[])((BigDecimal[])array2)).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.13 $outer;

                                        public final Object apply(BigDecimal decimal) {
                                            return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(decimal, new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun$13$$anonfun$apply$6 $outer;

                                                public final Decimal apply(BigDecimal d) {
                                                    return Decimal$.MODULE$.apply(d, this.$outer.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$anonfun$$anonfun$$$outer().x8$1.precision(), this.$outer.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$anonfun$$anonfun$$$outer().x8$1.scale());
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                        }

                                        public /* synthetic */ anonfun.13 org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$anonfun$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                                }
                                {
                                    this.x8$1 = x8$1;
                                }
                            };
                        } else {
                            LongType$ longType$ = LongType$.MODULE$;
                            DataType dataType17 = dataType13;
                            if (!(longType$ != null ? !longType$.equals(dataType17) : dataType17 != null) && metadata.contains("binarylong")) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported array element "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type ", " based on binary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt.simpleString()}))).toString());
                            }
                            if (dataType13 instanceof ArrayType) {
                                throw new IllegalArgumentException("Nested arrays unsupported");
                            }
                            object2 = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final Object[] apply(Object array2) {
                                    return (Object[])array2;
                                }
                            };
                        }
                    }
                }
                Serializable elementConversion = object2;
                object = new Serializable((Function1)elementConversion){
                    public static final long serialVersionUID = 0L;
                    public final Function1 elementConversion$1;

                    public final void apply(ResultSet rs, InternalRow row, int pos) {
                        Object array2 = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(rs.getArray(pos + 1).getArray(), new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeGetter$13 $outer;

                            public final GenericArrayData apply(Object array2) {
                                return new GenericArrayData(this.$outer.elementConversion$1.apply(array2));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        row.update(pos, array2);
                    }
                    {
                        this.elementConversion$1 = elementConversion$1;
                    }
                };
            }
            return object;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt.simpleString()})));
    }

    public <T> Object org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$nullSafeConvert(T input, Function1<T, Object> f) {
        return input == null ? null : f.apply(input);
    }

    public Function3<PreparedStatement, Row, Object, BoxedUnit> org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeSetter(Connection conn, JdbcDialect dialect, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        DataType dataType3 = dataType2;
        if (!(integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(PreparedStatement stmt, Row row, int pos) {
                    stmt.setInt(pos + 1, row.getInt(pos));
                }
            };
        } else {
            LongType$ longType$ = LongType$.MODULE$;
            DataType dataType4 = dataType2;
            if (!(longType$ != null ? !longType$.equals(dataType4) : dataType4 != null)) {
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PreparedStatement stmt, Row row, int pos) {
                        stmt.setLong(pos + 1, row.getLong(pos));
                    }
                };
            } else {
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                DataType dataType5 = dataType2;
                if (!(doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null)) {
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(PreparedStatement stmt, Row row, int pos) {
                            stmt.setDouble(pos + 1, row.getDouble(pos));
                        }
                    };
                } else {
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    DataType dataType6 = dataType2;
                    if (!(floatType$ != null ? !floatType$.equals(dataType6) : dataType6 != null)) {
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(PreparedStatement stmt, Row row, int pos) {
                                stmt.setFloat(pos + 1, row.getFloat(pos));
                            }
                        };
                    } else {
                        ShortType$ shortType$ = ShortType$.MODULE$;
                        DataType dataType7 = dataType2;
                        if (!(shortType$ != null ? !shortType$.equals(dataType7) : dataType7 != null)) {
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(PreparedStatement stmt, Row row, int pos) {
                                    stmt.setInt(pos + 1, row.getShort(pos));
                                }
                            };
                        } else {
                            ByteType$ byteType$ = ByteType$.MODULE$;
                            DataType dataType8 = dataType2;
                            if (!(byteType$ != null ? !byteType$.equals(dataType8) : dataType8 != null)) {
                                object = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(PreparedStatement stmt, Row row, int pos) {
                                        stmt.setInt(pos + 1, row.getByte(pos));
                                    }
                                };
                            } else {
                                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                DataType dataType9 = dataType2;
                                if (!(booleanType$ != null ? !booleanType$.equals(dataType9) : dataType9 != null)) {
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(PreparedStatement stmt, Row row, int pos) {
                                            stmt.setBoolean(pos + 1, row.getBoolean(pos));
                                        }
                                    };
                                } else {
                                    StringType$ stringType$ = StringType$.MODULE$;
                                    DataType dataType10 = dataType2;
                                    if (!(stringType$ != null ? !stringType$.equals(dataType10) : dataType10 != null)) {
                                        object = new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final void apply(PreparedStatement stmt, Row row, int pos) {
                                                stmt.setString(pos + 1, row.getString(pos));
                                            }
                                        };
                                    } else {
                                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                        DataType dataType11 = dataType2;
                                        if (!(binaryType$ != null ? !binaryType$.equals(dataType11) : dataType11 != null)) {
                                            object = new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(PreparedStatement stmt, Row row, int pos) {
                                                    stmt.setBytes(pos + 1, (byte[])row.getAs(pos));
                                                }
                                            };
                                        } else {
                                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                            DataType dataType12 = dataType2;
                                            if (!(timestampType$ != null ? !timestampType$.equals(dataType12) : dataType12 != null)) {
                                                object = new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final void apply(PreparedStatement stmt, Row row, int pos) {
                                                        stmt.setTimestamp(pos + 1, (Timestamp)row.getAs(pos));
                                                    }
                                                };
                                            } else {
                                                DateType$ dateType$ = DateType$.MODULE$;
                                                DataType dataType13 = dataType2;
                                                if (!(dateType$ != null ? !dateType$.equals(dataType13) : dataType13 != null)) {
                                                    object = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final void apply(PreparedStatement stmt, Row row, int pos) {
                                                            stmt.setDate(pos + 1, (Date)row.getAs(pos));
                                                        }
                                                    };
                                                } else if (dataType2 instanceof DecimalType) {
                                                    object = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final void apply(PreparedStatement stmt, Row row, int pos) {
                                                            stmt.setBigDecimal(pos + 1, row.getDecimal(pos));
                                                        }
                                                    };
                                                } else if (dataType2 instanceof ArrayType) {
                                                    ArrayType arrayType = (ArrayType)dataType2;
                                                    DataType et = arrayType.elementType();
                                                    String typeName = this.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(et, dialect).databaseTypeDefinition().toLowerCase().split("\\(")[0];
                                                    object = new Serializable(conn, typeName){
                                                        public static final long serialVersionUID = 0L;
                                                        private final Connection conn$2;
                                                        private final String typeName$1;

                                                        public final void apply(PreparedStatement stmt, Row row, int pos) {
                                                            Array array2 = this.conn$2.createArrayOf(this.typeName$1, (Object[])row.getSeq(pos).toArray(ClassTag$.MODULE$.AnyRef()));
                                                            stmt.setArray(pos + 1, array2);
                                                        }
                                                        {
                                                            this.conn$2 = conn$2;
                                                            this.typeName$1 = typeName$1;
                                                        }
                                                    };
                                                } else {
                                                    object = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Nothing$ apply(PreparedStatement x$3, Row x$4, int pos) {
                                                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate non-null value for field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)pos)})));
                                                        }
                                                    };
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Iterator<Object> savePartition(Function0<Connection> getConnection, String table, Iterator<Row> iterator, StructType rddSchema, int[] nullTypes, int batchSize, JdbcDialect dialect, int isolationLevel) {
        block33: {
            block32: {
                conn = (Connection)getConnection.apply();
                committed = false;
                finalIsolationLevel = 0;
                if (isolationLevel != 0) {
                    try {
                        metadata = conn.getMetaData();
                        if (metadata.supportsTransactions()) {
                            finalIsolationLevel = defaultIsolation = metadata.getDefaultTransactionIsolation();
                            if (metadata.supportsTransactionIsolationLevel(isolationLevel)) {
                                finalIsolationLevel = isolationLevel;
                            } else {
                                this.logWarning((Function0<String>)new Serializable(isolationLevel, defaultIsolation){
                                    public static final long serialVersionUID = 0L;
                                    private final int isolationLevel$1;
                                    private final int defaultIsolation$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested isolation level ", " is not supported; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.isolationLevel$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"falling back to default isolation level ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.defaultIsolation$1)}))).toString();
                                    }
                                    {
                                        this.isolationLevel$1 = isolationLevel$1;
                                        this.defaultIsolation$1 = defaultIsolation$1;
                                    }
                                });
                            }
                        } else {
                            this.logWarning((Function0<String>)new Serializable(isolationLevel){
                                public static final long serialVersionUID = 0L;
                                private final int isolationLevel$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested isolation level ", ", but transactions are unsupported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.isolationLevel$1)}));
                                }
                                {
                                    this.isolationLevel$1 = isolationLevel$1;
                                }
                            });
                        }
                    }
                    catch (Throwable var14_14) {
                        var15_15 = var14_14;
                        var16_16 = NonFatal$.MODULE$.unapply(var15_15);
                        if (var16_16.isEmpty()) {
                            throw var14_14;
                        }
                        e = (Throwable)var16_16.get();
                        this.logWarning((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Exception while detecting transaction support";
                            }
                        }, e);
                        var18_18 = BoxedUnit.UNIT;
                    }
                }
                supportsTransactions = finalIsolationLevel != 0;
                if (supportsTransactions) {
                    conn.setAutoCommit(false);
                    conn.setTransactionIsolation(finalIsolationLevel);
                }
                stmt = this.insertStatement(conn, table, rddSchema, dialect);
                setters = (Function3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(StructField x$5) {
                        return x$5.dataType();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))).map((Function1)new Serializable(dialect, conn){
                    public static final long serialVersionUID = 0L;
                    private final JdbcDialect dialect$3;
                    private final Connection conn$3;

                    public final Function3<PreparedStatement, Row, Object, BoxedUnit> apply(DataType x$6) {
                        return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$makeSetter(this.conn$3, this.dialect$3, x$6);
                    }
                    {
                        this.dialect$3 = dialect$3;
                        this.conn$3 = conn$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)))).toArray(ClassTag$.MODULE$.apply(Function3.class));
                numFields = rddSchema.fields().length;
                rowCount = 0;
                while (iterator.hasNext()) {
                    row = (Row)iterator.next();
                    for (i = 0; i < numFields; ++i) {
                        if (row.isNullAt(i)) {
                            stmt.setNull(i + 1, nullTypes[i]);
                            v0 = BoxedUnit.UNIT;
                            continue;
                        }
                        v0 = setters[i].apply((Object)stmt, (Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    stmt.addBatch();
                    if (++rowCount % batchSize != 0) continue;
                    stmt.executeBatch();
                    rowCount = 0;
                }
                v1 = rowCount > 0 ? (Object)stmt.executeBatch() : BoxedUnit.UNIT;
                stmt.close();
                if (supportsTransactions) {
                    conn.commit();
                }
                committed = true;
                var26_26 = package$.MODULE$.Iterator().empty();
                if (!committed) break block32;
                try {
                    conn.close();
                }
                catch (Exception var32_33) {
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Transaction succeeded, but closing failed";
                        }
                    }, var32_33);
                }
            }
            if (supportsTransactions) {
                conn.rollback();
            }
            conn.close();
            break block33;
            {
                catch (Throwable var27_27) {
                    try {
                        try {
                            var20_20.close();
                            throw var27_27;
                        }
                        catch (SQLException var28_28) {
                            cause = var28_28.getNextException();
                            if (cause == null) ** GOTO lbl-1000
                            v2 = var28_28.getCause();
                            var30_30 = cause;
                            if (!(v2 != null ? v2.equals(var30_30) == false : var30_30 != null)) lbl-1000:
                            // 2 sources

                            {
                                v3 /* !! */  = BoxedUnit.UNIT;
                            } else if (var28_28.getCause() == null) {
                                v3 /* !! */  = var28_28.initCause(cause);
                            } else {
                                var28_28.addSuppressed(cause);
                                v3 /* !! */  = BoxedUnit.UNIT;
                            }
                            throw var28_28;
                        }
                    }
                    catch (Throwable var31_31) {
                        if (committed) {
                            try {
                                conn.close();
                            }
                            catch (Exception var32_32) {
                                this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, var32_32);
                            }
                        } else {
                            if (supportsTransactions) {
                                conn.rollback();
                            }
                            conn.close();
                        }
                        throw var31_31;
                    }
                }
            }
        }
        return var26_26;
    }

    public String schemaString(StructType schema, String url) {
        StringBuilder sb = new StringBuilder();
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        Predef$.MODULE$.refArrayOps((Object[])schema.fields()).foreach((Function1)new Serializable(sb, dialect){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;
            private final JdbcDialect dialect$4;

            public final StringBuilder apply(StructField field) {
                String name = this.dialect$4.quoteIdentifier(field.name());
                String typ = JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(field.dataType(), this.dialect$4).databaseTypeDefinition();
                String nullable = field.nullable() ? "" : "NOT NULL";
                return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typ, nullable})));
            }
            {
                this.sb$1 = sb$1;
                this.dialect$4 = dialect$4;
            }
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public void saveTable(Dataset<Row> df, String url, String table, JDBCOptions options) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        int[] nullTypes = (int[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$5;

            public final int apply(StructField field) {
                return JdbcUtils$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JdbcUtils$$getJdbcType(field.dataType(), this.dialect$5).jdbcNullType();
            }
            {
                this.dialect$5 = dialect$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        StructType rddSchema = df.schema();
        Function0<Connection> getConnection = this.createConnectionFactory(options);
        int batchSize = options.batchSize();
        int isolationLevel = options.isolationLevel();
        df.foreachPartition((Function1<Iterator<Row>, BoxedUnit>)new Serializable(table, dialect, nullTypes, rddSchema, getConnection, batchSize, isolationLevel){
            public static final long serialVersionUID = 0L;
            private final String table$2;
            private final JdbcDialect dialect$5;
            private final int[] nullTypes$1;
            private final StructType rddSchema$1;
            private final Function0 getConnection$1;
            private final int batchSize$1;
            private final int isolationLevel$2;

            public final void apply(Iterator<Row> iterator2) {
                JdbcUtils$.MODULE$.savePartition((Function0<Connection>)this.getConnection$1, this.table$2, iterator2, this.rddSchema$1, this.nullTypes$1, this.batchSize$1, this.dialect$5, this.isolationLevel$2);
            }
            {
                this.table$2 = table$2;
                this.dialect$5 = dialect$5;
                this.nullTypes$1 = nullTypes$1;
                this.rddSchema$1 = rddSchema$1;
                this.getConnection$1 = getConnection$1;
                this.batchSize$1 = batchSize$1;
                this.isolationLevel$2 = isolationLevel$2;
            }
        });
    }

    public void createTable(StructType schema, String url, String table, String createTableOptions, Connection conn) {
        String strSchema = this.schemaString(schema, url);
        String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, strSchema, createTableOptions}));
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(sql);
            return;
        }
        finally {
            statement.close();
        }
    }

    private JdbcUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

