/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat$$anonfun$buildReader$1$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOutputWriterFactory;
import org.apache.spark.sql.execution.datasources.csv.CSVRelation$;
import org.apache.spark.sql.execution.datasources.csv.CsvReader;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001E\u0011QbQ*W\r&dWMR8s[\u0006$(BA\u0002\u0005\u0003\r\u00197O\u001e\u0006\u0003\u000b\u0019\t1\u0002Z1uCN|WO]2fg*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0005\u0013\t)BAA\nUKb$()Y:fI\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u000591o\\;sG\u0016\u001c\u0018BA\u000e\u0019\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u001a\u0013!C:i_J$h*Y7f)\u0005!\u0003CA\u0013,\u001d\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005):\u0003\"B\u0018\u0001\t\u0003\u001a\u0013\u0001\u0003;p'R\u0014\u0018N\\4\t\u000bE\u0002A\u0011\t\u001a\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\r\t\u0003MQJ!!N\u0014\u0003\u0007%sG\u000fC\u00038\u0001\u0011\u0005\u0003(\u0001\u0004fcV\fGn\u001d\u000b\u0003sq\u0002\"A\n\u001e\n\u0005m:#a\u0002\"p_2,\u0017M\u001c\u0005\u0006{Y\u0002\rAP\u0001\u0006_RDWM\u001d\t\u0003M}J!\u0001Q\u0014\u0003\u0007\u0005s\u0017\u0010C\u0003C\u0001\u0011\u00053)A\u0006j]\u001a,'oU2iK6\fG\u0003\u0002#N'b\u00032AJ#H\u0013\t1uE\u0001\u0004PaRLwN\u001c\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\"\tQ\u0001^=qKNL!\u0001T%\u0003\u0015M#(/^2u)f\u0004X\rC\u0003O\u0003\u0002\u0007q*\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002Q#6\t\u0001\"\u0003\u0002S\u0011\ta1\u000b]1sWN+7o]5p]\")A+\u0011a\u0001+\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0013WI\u0011J!aV\u0017\u0003\u00075\u000b\u0007\u000fC\u0003Z\u0003\u0002\u0007!,A\u0003gS2,7\u000fE\u0002\\G\u001at!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}\u0003\u0012A\u0002\u001fs_>$h(C\u0001)\u0013\t\u0011w%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'aA*fc*\u0011!m\n\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f!AZ:\u000b\u0005-d\u0011A\u00025bI>|\u0007/\u0003\u0002nQ\nQa)\u001b7f'R\fG/^:\t\u000b=\u0004A\u0011\u00029\u0002\u001d5\f7.Z*bM\u0016DU-\u00193feR!\u0011\u000f\u001e<{!\r1#\u000fJ\u0005\u0003g\u001e\u0012Q!\u0011:sCfDQ!\u001e8A\u0002E\f1A]8x\u0011\u0015!f\u000e1\u0001x!\t\u0001\u00030\u0003\u0002z\u0005\tQ1i\u0015,PaRLwN\\:\t\u000bmt\u0007\u0019A\u001d\u0002\u001b\r\f7/Z*f]NLG/\u001b<f\u0011\u0015i\b\u0001\"\u0011\u007f\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)%y\u0018QAA\u0004\u0003/\tI\u0002E\u0002\u0014\u0003\u0003I1!a\u0001\u0005\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015qE\u00101\u0001P\u0011\u001d\tI\u0001 a\u0001\u0003\u0017\t1A[8c!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tU\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0005\u0003+\tyAA\u0002K_\nDQ\u0001\u0016?A\u0002UCa!a\u0007}\u0001\u00049\u0015A\u00033bi\u0006\u001c6\r[3nC\"9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0012a\u00032vS2$'+Z1eKJ$\u0002#a\t\u0002B\u0005\r\u0013QIA%\u0003\u001b\nI&a\u0017\u0011\u000f\u0019\n)#!\u000b\u00020%\u0019\u0011qE\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\n\u0002,%\u0019\u0011Q\u0006\u0003\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004RaWA\u0019\u0003kI1!a\rf\u0005!IE/\u001a:bi>\u0014\b\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\u0002\"\u0001\u0005dCR\fG._:u\u0013\u0011\ty$!\u000f\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0007\u001d\u0006u\u0001\u0019A(\t\u000f\u0005m\u0011Q\u0004a\u0001\u000f\"9\u0011qIA\u000f\u0001\u00049\u0015a\u00049beRLG/[8o'\u000eDW-\\1\t\u000f\u0005-\u0013Q\u0004a\u0001\u000f\u0006q!/Z9vSJ,GmU2iK6\f\u0007\u0002CA(\u0003;\u0001\r!!\u0015\u0002\u000f\u0019LG\u000e^3sgB!1lYA*!\r9\u0012QK\u0005\u0004\u0003/B\"A\u0002$jYR,'\u000f\u0003\u0004U\u0003;\u0001\r!\u0016\u0005\t\u0003;\ni\u00021\u0001\u0002`\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001ak\u0003\u0011\u0019wN\u001c4\n\t\u0005%\u00141\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u00059!-Y:f%\u0012$G\u0003CA9\u0003{\ny(!!\u0011\u000b\u0005M\u0014\u0011\u0010\u0013\u000e\u0005\u0005U$bAA<\u0015\u0005\u0019!\u000f\u001a3\n\t\u0005m\u0014Q\u000f\u0002\u0004%\u0012#\u0005B\u0002(\u0002l\u0001\u0007q\n\u0003\u0004U\u0003W\u0002\ra\u001e\u0005\t\u0003\u0007\u000bY\u00071\u0001\u0002\u0006\u0006Q\u0011N\u001c9viB\u000bG\u000f[:\u0011\u0007m\u001bG\u0005C\u0004\u0002\n\u0002!I!a#\u0002\u0011Q|7.\u001a8SI\u0012$\"\"!$\u0002\u0010\u0006E\u00151SAL!\u0015\t\u0019(!\u001fr\u0011\u0019q\u0015q\u0011a\u0001\u001f\"1A+a\"A\u0002]Dq!!&\u0002\b\u0002\u0007\u0011/\u0001\u0004iK\u0006$WM\u001d\u0005\t\u0003\u0007\u000b9\t1\u0001\u0002\u0006\"9\u00111\u0014\u0001\u0005\n\u0005u\u0015!\u00044j]\u00124\u0015N]:u\u0019&tW\rF\u0003%\u0003?\u000b\t\u000b\u0003\u0004U\u00033\u0003\ra\u001e\u0005\t\u0003o\nI\n1\u0001\u0002r!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0016\u0001\u0003:fC\u0012$V\r\u001f;\u0015\u0011\u0005E\u0014\u0011VAV\u0003[CaATAR\u0001\u0004y\u0005B\u0002+\u0002$\u0002\u0007q\u000fC\u0004\u00020\u0006\r\u0006\u0019\u0001\u0013\u0002\u00111|7-\u0019;j_:Dq!a-\u0001\t\u0013\t),\u0001\u0007wKJLg-_*dQ\u0016l\u0017\r\u0006\u0003\u00028\u0006u\u0006c\u0001\u0014\u0002:&\u0019\u00111X\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u007f\u000b\t\f1\u0001H\u0003\u0019\u00198\r[3nC\u0002")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "csv";
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        StructType structType;
        CSVOptions csvOptions = new CSVOptions(options);
        Seq paths = (Seq)((TraversableLike)files.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.getPath().getName().startsWith("_");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$2) {
                return x$2.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        RDD<String> rdd = this.baseRdd(sparkSession, csvOptions, (Seq<String>)paths);
        String firstLine = this.findFirstLine(csvOptions, rdd);
        String[] firstRow = new CsvReader(csvOptions).parseLine(firstLine);
        boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        String[] header = this.makeSafeHeader(firstRow, csvOptions, caseSensitive);
        RDD<String[]> parsedRdd = this.tokenRdd(sparkSession, csvOptions, header, (Seq<String>)paths);
        if (csvOptions.inferSchemaFlag()) {
            structType = CSVInferSchema$.MODULE$.infer(parsedRdd, header, csvOptions);
        } else {
            StructField[] schemaFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fieldName) {
                    return new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            structType = new StructType(schemaFields);
        }
        StructType schema = structType;
        return new Some((Object)schema);
    }

    private String[] makeSafeHeader(String[] row, CSVOptions options, boolean caseSensitive) {
        String[] stringArray;
        if (options.headerFlag()) {
            String[] headerNames = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])row).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$3) {
                    return x$3 != null;
                }
            })).map((Function1)new Serializable(this, caseSensitive){
                public static final long serialVersionUID = 0L;
                private final boolean caseSensitive$1;

                public final String apply(String name) {
                    return this.caseSensitive$1 ? name : name.toLowerCase();
                }
                {
                    this.caseSensitive$1 = caseSensitive$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] duplicates = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])headerNames).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])headerNames).distinct()))).distinct();
            stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])row).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, options, caseSensitive, duplicates){
                public static final long serialVersionUID = 0L;
                private final CSVOptions options$1;
                private final boolean caseSensitive$1;
                private final String[] duplicates$1;

                /*
                 * Unable to fully structure code
                 */
                public final String apply(Tuple2<String, Object> x0$1) {
                    block2: {
                        var2_2 = x0$1;
                        if (var2_2 == null) break block2;
                        value = (String)var2_2._1();
                        index = var2_2._2$mcI$sp();
                        if (value == null || value.isEmpty()) ** GOTO lbl-1000
                        v0 = value;
                        var5_5 = this.options$1.nullValue();
                        if (!(v0 != null ? v0.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                        // 2 sources

                        {
                            v1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                        } else {
                            v1 = this.caseSensitive$1 == false && Predef$.MODULE$.refArrayOps((Object[])this.duplicates$1).contains((Object)value.toLowerCase()) != false ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, BoxesRunTime.boxToInteger((int)index)})) : (Predef$.MODULE$.refArrayOps((Object[])this.duplicates$1).contains((Object)value) != false ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, BoxesRunTime.boxToInteger((int)index)})) : value);
                        }
                        var6_6 = v1;
                        return var6_6;
                    }
                    throw new MatchError(var2_2);
                }
                {
                    this.options$1 = options$1;
                    this.caseSensitive$1 = caseSensitive$1;
                    this.duplicates$1 = duplicates$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])row).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int index = tuple2._2$mcI$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        return stringArray;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options);
        csvOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new CSVOutputWriterFactory(csvOptions);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        CSVOptions csvOptions = new CSVOptions(options);
        String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)csvOptions.comment())).toString();
        String[] headers = (String[])Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$4) {
                return x$4.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, dataSchema, requiredSchema, csvOptions, commentPrefix, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final StructType requiredSchema$1;
            public final CSVOptions csvOptions$1;
            public final String commentPrefix$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Configuration conf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, conf);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, linesReader){
                    public static final long serialVersionUID = 0L;
                    public final HadoopFileLinesReader linesReader$1;

                    public final TaskContext apply(TaskContext x$5) {
                        return x$5.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$1$$anonfun$7 $outer;

                            public final void apply(TaskContext x$6) {
                                this.$outer.linesReader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.linesReader$1 = linesReader$1;
                    }
                });
                Iterator<B> lineIterator = linesReader.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final String apply(Text line) {
                        return new String(line.getBytes(), 0, line.getLength(), this.$outer.csvOptions$1.charset());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                CSVRelation$.MODULE$.dropHeaderLine(file, lineIterator, this.csvOptions$1);
                CsvReader csvParser2 = new CsvReader(this.csvOptions$1);
                Iterator tokenizedIterator = lineIterator.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final boolean apply(String line) {
                        return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(this.$outer.commentPrefix$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).map((Function1)new Serializable(this, csvParser2){
                    public static final long serialVersionUID = 0L;
                    private final CsvReader csvParser$1;

                    public final String[] apply(String line) {
                        return this.csvParser$1.parseLine(line);
                    }
                    {
                        this.csvParser$1 = csvParser$1;
                    }
                });
                Function2<String[], Object, Option<InternalRow>> parser = CSVRelation$.MODULE$.csvParser(this.dataSchema$1, this.requiredSchema$1.fieldNames(), this.csvOptions$1);
                IntRef numMalformedRecords = new IntRef(0);
                return tokenizedIterator.flatMap((Function1)new Serializable(this, parser, numMalformedRecords){
                    public static final long serialVersionUID = 0L;
                    private final Function2 parser$1;
                    private final IntRef numMalformedRecords$1;

                    public final Iterable<InternalRow> apply(String[] recordTokens) {
                        Option row = (Option)this.parser$1.apply((Object)recordTokens, (Object)BoxesRunTime.boxToInteger((int)this.numMalformedRecords$1.elem));
                        if (row.isEmpty()) {
                            ++this.numMalformedRecords$1.elem;
                        }
                        return Option$.MODULE$.option2Iterable(row);
                    }
                    {
                        this.parser$1 = parser$1;
                        this.numMalformedRecords$1 = numMalformedRecords$1;
                    }
                });
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.csvOptions$1 = csvOptions$1;
                this.commentPrefix$1 = commentPrefix$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    private RDD<String> baseRdd(SparkSession sparkSession, CSVOptions options, Seq<String> inputPaths) {
        return this.readText(sparkSession, options, inputPaths.mkString(","));
    }

    private RDD<String[]> tokenRdd(SparkSession sparkSession, CSVOptions options, String[] header, Seq<String> inputPaths) {
        RDD<String> rdd = this.baseRdd(sparkSession, options, inputPaths);
        String firstLine = options.headerFlag() ? this.findFirstLine(options, rdd) : null;
        return CSVRelation$.MODULE$.univocityTokenizer(rdd, firstLine, options);
    }

    private String findFirstLine(CSVOptions options, RDD<String> rdd) {
        String string;
        if (options.isCommentSet()) {
            String comment = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            string = (String)rdd.filter((Function1)new Serializable(this, comment){
                public static final long serialVersionUID = 0L;
                private final String comment$1;

                public final boolean apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(this.comment$1);
                }
                {
                    this.comment$1 = comment$1;
                }
            }).first();
        } else {
            string = (String)rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty();
                }
            }).first();
        }
        return string;
    }

    private RDD<String> readText(SparkSession sparkSession, CSVOptions options, String location) {
        RDD rDD;
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            rDD = sparkSession.sparkContext().textFile(location, sparkSession.sparkContext().textFile$default$2());
        } else {
            String charset3 = options.charset();
            RDD qual$1 = sparkSession.sparkContext().hadoopFile(location, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class));
            Serializable x$8 = new Serializable(this, charset3){
                public static final long serialVersionUID = 0L;
                public final String charset$1;

                public final Iterator<String> apply(Iterator<Tuple2<LongWritable, Text>> x$7) {
                    return x$7.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$11 $outer;

                        public final String apply(Tuple2<LongWritable, Text> pair) {
                            return new String(((Text)pair._2()).getBytes(), 0, ((Text)pair._2()).getLength(), this.$outer.charset$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.charset$1 = charset$1;
                }
            };
            boolean x$9 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$8, x$9, ClassTag$.MODULE$.apply(String.class));
        }
        return rDD;
    }

    private void verifySchema(StructType schema) {
        schema.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVFileFormat $outer;

            public final void apply(StructField field) {
                this.$outer.org$apache$spark$sql$execution$datasources$csv$CSVFileFormat$$verifyType$1(field.dataType());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final void org$apache$spark$sql$execution$datasources$csv$CSVFileFormat$$verifyType$1(DataType dataType) {
        while (true) {
            boolean bl;
            DataType dataType2 = dataType;
            ByteType$ byteType$ = ByteType$.MODULE$;
            DataType dataType3 = dataType2;
            if (!(byteType$ != null ? !byteType$.equals(dataType3) : dataType3 != null)) {
                bl = true;
            } else {
                ShortType$ shortType$ = ShortType$.MODULE$;
                DataType dataType4 = dataType2;
                if (!(shortType$ != null ? !shortType$.equals(dataType4) : dataType4 != null)) {
                    bl = true;
                } else {
                    IntegerType$ integerType$ = IntegerType$.MODULE$;
                    DataType dataType5 = dataType2;
                    if (!(integerType$ != null ? !integerType$.equals(dataType5) : dataType5 != null)) {
                        bl = true;
                    } else {
                        LongType$ longType$ = LongType$.MODULE$;
                        DataType dataType6 = dataType2;
                        if (!(longType$ != null ? !longType$.equals(dataType6) : dataType6 != null)) {
                            bl = true;
                        } else {
                            FloatType$ floatType$ = FloatType$.MODULE$;
                            DataType dataType7 = dataType2;
                            if (!(floatType$ != null ? !floatType$.equals(dataType7) : dataType7 != null)) {
                                bl = true;
                            } else {
                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                DataType dataType8 = dataType2;
                                if (!(doubleType$ != null ? !doubleType$.equals(dataType8) : dataType8 != null)) {
                                    bl = true;
                                } else {
                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                    DataType dataType9 = dataType2;
                                    if (!(booleanType$ != null ? !booleanType$.equals(dataType9) : dataType9 != null)) {
                                        bl = true;
                                    } else if (dataType2 instanceof DecimalType) {
                                        bl = true;
                                    } else {
                                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                        DataType dataType10 = dataType2;
                                        if (!(timestampType$ != null ? !timestampType$.equals(dataType10) : dataType10 != null)) {
                                            bl = true;
                                        } else {
                                            DateType$ dateType$ = DateType$.MODULE$;
                                            DataType dataType11 = dataType2;
                                            if (!(dateType$ != null ? !dateType$.equals(dataType11) : dataType11 != null)) {
                                                bl = true;
                                            } else {
                                                StringType$ stringType$ = StringType$.MODULE$;
                                                DataType dataType12 = dataType2;
                                                bl = !(stringType$ != null ? !stringType$.equals(dataType12) : dataType12 != null);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV data source does not support ", " data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.simpleString()})));
    }
}

