/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.DropTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001>\u0011\u0001\u0003\u0012:paR\u000b'\r\\3D_6l\u0017M\u001c3\u000b\u0005\r!\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"D\b\u0013\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00111+\u0017M\u001a(pI\u0016\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u0005IA/\u00192mK:\u000bW.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0006uC\ndWMT1nK\u0002B\u0001\"\r\u0001\u0003\u0016\u0004%\tAM\u0001\tS\u001a,\u00050[:ugV\t1\u0007\u0005\u0002 i%\u0011Q\u0007\t\u0002\b\u0005>|G.Z1o\u0011!9\u0004A!E!\u0002\u0013\u0019\u0014!C5g\u000bbL7\u000f^:!\u0011!I\u0004A!f\u0001\n\u0003\u0011\u0014AB5t-&,w\u000f\u0003\u0005<\u0001\tE\t\u0015!\u00034\u0003\u001dI7OV5fo\u0002B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tAM\u0001\u0006aV\u0014x-\u001a\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005g\u00051\u0001/\u001e:hK\u0002BQ!\u0011\u0001\u0005\u0002\t\u000ba\u0001P5oSRtD#B\"E\u000b\u001a;\u0005CA\u000e\u0001\u0011\u0015A\u0003\t1\u0001+\u0011\u0015\t\u0004\t1\u00014\u0011\u0015I\u0004\t1\u00014\u0011\u0015i\u0004\t1\u00014\u0011\u0015I\u0005\u0001\"\u0011K\u0003\r\u0011XO\u001c\u000b\u0003\u0017n\u00032\u0001\u0014+X\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002Q\u001d\u00051AH]8pizJ\u0011!I\u0005\u0003'\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002V-\n\u00191+Z9\u000b\u0005M\u0003\u0003C\u0001-Z\u001b\u00051\u0011B\u0001.\u0007\u0005\r\u0011vn\u001e\u0005\u00069\"\u0003\r!X\u0001\rgB\f'o[*fgNLwN\u001c\t\u00031zK!a\u0018\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u0005\u0004\u0011\u0011!C\u0001E\u0006!1m\u001c9z)\u0015\u00195\rZ3g\u0011\u001dA\u0003\r%AA\u0002)Bq!\r1\u0011\u0002\u0003\u00071\u0007C\u0004:AB\u0005\t\u0019A\u001a\t\u000fu\u0002\u0007\u0013!a\u0001g!9\u0001\u000eAI\u0001\n\u0003I\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002U*\u0012!f[\u0016\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001d\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002t]\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fU\u0004\u0011\u0013!C\u0001m\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#A<+\u0005MZ\u0007bB=\u0001#\u0003%\tA^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011\u001dY\b!%A\u0005\u0002Y\fabY8qs\u0012\"WMZ1vYR$C\u0007C\u0004~\u0001\u0005\u0005I\u0011\t@\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005Y\u0006twM\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\rM#(/\u001b8h\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016A\u0019q$a\u0006\n\u0007\u0005e\u0001EA\u0002J]RD\u0011\"!\b\u0001\u0003\u0003%\t!a\b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011EA\u0014!\ry\u00121E\u0005\u0004\u0003K\u0001#aA!os\"Q\u0011\u0011FA\u000e\u0003\u0003\u0005\r!!\u0006\u0002\u0007a$\u0013\u0007C\u0005\u0002.\u0001\t\t\u0011\"\u0011\u00020\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00022A1\u00111GA\u001d\u0003Ci!!!\u000e\u000b\u0007\u0005]\u0002%\u0001\u0006d_2dWm\u0019;j_:LA!a\u000f\u00026\tA\u0011\n^3sCR|'\u000fC\u0005\u0002@\u0001\t\t\u0011\"\u0001\u0002B\u0005A1-\u00198FcV\fG\u000eF\u00024\u0003\u0007B!\"!\u000b\u0002>\u0005\u0005\t\u0019AA\u0011\u0011%\t9\u0005AA\u0001\n\u0003\nI%\u0001\u0004fcV\fGn\u001d\u000b\u0004g\u0005-\u0003BCA\u0015\u0003\u000b\n\t\u00111\u0001\u0002\"\u001dI\u0011q\n\u0002\u0002\u0002#\u0005\u0011\u0011K\u0001\u0011\tJ|\u0007\u000fV1cY\u0016\u001cu.\\7b]\u0012\u00042aGA*\r!\t!!!A\t\u0002\u0005U3#BA*\u0003/\"\u0003#CA-\u0003?R3gM\u001aD\u001b\t\tYFC\u0002\u0002^\u0001\nqA];oi&lW-\u0003\u0003\u0002b\u0005m#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oi!9\u0011)a\u0015\u0005\u0002\u0005\u0015DCAA)\u0011)\tI'a\u0015\u0002\u0002\u0013\u0015\u00131N\u0001\ti>\u001cFO]5oOR\tq\u0010\u0003\u0006\u0002p\u0005M\u0013\u0011!CA\u0003c\nQ!\u00199qYf$\u0012bQA:\u0003k\n9(!\u001f\t\r!\ni\u00071\u0001+\u0011\u0019\t\u0014Q\u000ea\u0001g!1\u0011(!\u001cA\u0002MBa!PA7\u0001\u0004\u0019\u0004BCA?\u0003'\n\t\u0011\"!\u0002\u0000\u00059QO\\1qa2LH\u0003BAA\u0003\u001b\u0003RaHAB\u0003\u000fK1!!\"!\u0005\u0019y\u0005\u000f^5p]B9q$!#+gM\u001a\u0014bAAFA\t1A+\u001e9mKRB\u0011\"a$\u0002|\u0005\u0005\t\u0019A\"\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002\u0014\u0006M\u0013\u0011!C\u0005\u0003+\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0013\t\u0005\u0003\u0003\tI*\u0003\u0003\u0002\u001c\u0006\r!AB(cU\u0016\u001cG\u000f")
public class DropTableCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropTableCommand> tupled() {
        return DropTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropTableCommand>>>> curried() {
        return DropTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Boolean bl;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (!catalog.isTemporaryTable(this.tableName()) && catalog.tableExists(this.tableName())) {
            CatalogTableType catalogTableType = catalog.getTableMetadata(this.tableName()).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !this.isView()) {
                throw new AnalysisException("Cannot drop a view with DROP TABLE. Please use DROP VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && this.isView()) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot drop a table with DROP VIEW. Please use DROP TABLE instead"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)sparkSession.sharedState().cacheManager().uncacheQuery(sparkSession.table(this.tableName().quotedString()), sparkSession.sharedState().cacheManager().uncacheQuery$default$2()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NoSuchTableException && this.ifExists()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().warn(e.toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = boxedUnit;
        }
        catalog.refreshTable(this.tableName());
        catalog.dropTable(this.tableName(), this.ifExists(), this.purge());
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropTableCommand copy(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge2) {
        return new DropTableCommand(tableName, ifExists, isView, purge2);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 0: {
                object = this.tableName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropTableCommand dropTableCommand = (DropTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = dropTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropTableCommand.ifExists()) return false;
        if (this.isView() != dropTableCommand.isView()) return false;
        if (this.purge() != dropTableCommand.purge()) return false;
        if (!dropTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropTableCommand(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge2) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge2;
        Command.class.$init$((Command)this);
    }
}

