/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001>\u0011q#\u00117uKJ$\u0016M\u00197f%\u0016t\u0017-\\3D_6l\u0017M\u001c3\u000b\u0005\r!\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"D\b\u0013\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00111+\u0017M\u001a(pI\u0016\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u00059q\u000e\u001c3OC6,W#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\n\u0001b\u001c7e\u001d\u0006lW\r\t\u0005\tc\u0001\u0011)\u001a!C\u0001S\u00059a.Z<OC6,\u0007\u0002C\u001a\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u00119,wOT1nK\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\u0007SN4\u0016.Z<\u0016\u0003]\u0002\"a\b\u001d\n\u0005e\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\tw\u0001\u0011\t\u0012)A\u0005o\u00059\u0011n\u001d,jK^\u0004\u0003\"B\u001f\u0001\t\u0003q\u0014A\u0002\u001fj]&$h\b\u0006\u0003@\u0001\u0006\u0013\u0005CA\u000e\u0001\u0011\u0015AC\b1\u0001+\u0011\u0015\tD\b1\u0001+\u0011\u0015)D\b1\u00018\u0011\u0015!\u0005\u0001\"\u0011F\u0003\r\u0011XO\u001c\u000b\u0003\rZ\u00032aR(S\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002L\u001d\u00051AH]8pizJ\u0011!I\u0005\u0003\u001d\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002Q#\n\u00191+Z9\u000b\u00059\u0003\u0003CA*U\u001b\u00051\u0011BA+\u0007\u0005\r\u0011vn\u001e\u0005\u0006/\u000e\u0003\r\u0001W\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003'fK!A\u0017\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000fq\u0003\u0011\u0011!C\u0001;\u0006!1m\u001c9z)\u0011ydl\u00181\t\u000f!Z\u0006\u0013!a\u0001U!9\u0011g\u0017I\u0001\u0002\u0004Q\u0003bB\u001b\\!\u0003\u0005\ra\u000e\u0005\bE\u0002\t\n\u0011\"\u0001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001a\u0016\u0003U\u0015\\\u0013A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-\u0004\u0013AC1o]>$\u0018\r^5p]&\u0011Q\u000e\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB8\u0001#\u0003%\taY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d\t\b!%A\u0005\u0002I\fabY8qs\u0012\"WMZ1vYR$3'F\u0001tU\t9T\rC\u0004v\u0001\u0005\u0005I\u0011\t<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003\u0011a\u0017M\\4\u000b\u0003q\fAA[1wC&\u0011a0\u001f\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005\u0005\u0001!!A\u0005\u0002\u0005\r\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0003!\ry\u0012qA\u0005\u0004\u0003\u0013\u0001#aA%oi\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0011qB\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t\"a\u0006\u0011\u0007}\t\u0019\"C\u0002\u0002\u0016\u0001\u00121!\u00118z\u0011)\tI\"a\u0003\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0004\"CA\u000f\u0001\u0005\u0005I\u0011IA\u0010\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0011!\u0019\t\u0019#!\u000b\u0002\u00125\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0001\u0013AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005!IE/\u001a:bi>\u0014\b\"CA\u0018\u0001\u0005\u0005I\u0011AA\u0019\u0003!\u0019\u0017M\\#rk\u0006dGcA\u001c\u00024!Q\u0011\u0011DA\u0017\u0003\u0003\u0005\r!!\u0005\t\u0013\u0005]\u0002!!A\u0005B\u0005e\u0012AB3rk\u0006d7\u000fF\u00028\u0003wA!\"!\u0007\u00026\u0005\u0005\t\u0019AA\t\u000f%\tyDAA\u0001\u0012\u0003\t\t%A\fBYR,'\u000fV1cY\u0016\u0014VM\\1nK\u000e{W.\\1oIB\u00191$a\u0011\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u000b\u001aR!a\u0011\u0002H\u0011\u0002\u0002\"!\u0013\u0002P)RsgP\u0007\u0003\u0003\u0017R1!!\u0014!\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0015\u0002L\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fu\n\u0019\u0005\"\u0001\u0002VQ\u0011\u0011\u0011\t\u0005\u000b\u00033\n\u0019%!A\u0005F\u0005m\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003]D!\"a\u0018\u0002D\u0005\u0005I\u0011QA1\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy\u00141MA3\u0003OBa\u0001KA/\u0001\u0004Q\u0003BB\u0019\u0002^\u0001\u0007!\u0006\u0003\u00046\u0003;\u0002\ra\u000e\u0005\u000b\u0003W\n\u0019%!A\u0005\u0002\u00065\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\nY\bE\u0003 \u0003c\n)(C\u0002\u0002t\u0001\u0012aa\u00149uS>t\u0007CB\u0010\u0002x)Rs'C\u0002\u0002z\u0001\u0012a\u0001V;qY\u0016\u001c\u0004\"CA?\u0003S\n\t\u00111\u0001@\u0003\rAH\u0005\r\u0005\u000b\u0003\u0003\u000b\u0019%!A\u0005\n\u0005\r\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\"\u0011\u0007a\f9)C\u0002\u0002\nf\u0014aa\u00142kK\u000e$\b")
public class AlterTableRenameCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier oldName;
    private final TableIdentifier newName;
    private final boolean isView;

    public static Function1<Tuple3<TableIdentifier, TableIdentifier, Object>, AlterTableRenameCommand> tupled() {
        return AlterTableRenameCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<Object, AlterTableRenameCommand>>> curried() {
        return AlterTableRenameCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier oldName() {
        return this.oldName;
    }

    public TableIdentifier newName() {
        return this.newName;
    }

    public boolean isView() {
        return this.isView;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (catalog.isTemporaryTable(this.oldName())) {
            catalog.renameTable(this.oldName(), this.newName());
        } else {
            CatalogTable table = catalog.getTableMetadata(this.oldName());
            DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, this.isView());
            boolean wasCached = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AlterTableRenameCommand $outer;
                private final SparkSession sparkSession$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.sparkSession$1.catalog().isCached(this.$outer.oldName().unquotedString());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.sparkSession$1 = sparkSession$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            if (wasCached) {
                try {
                    sparkSession.catalog().uncacheTable(this.oldName().unquotedString());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.log().warn(e.toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catalog.refreshTable(this.oldName());
            catalog.renameTable(this.oldName(), this.newName());
            if (wasCached) {
                sparkSession.catalog().cacheTable(this.newName().unquotedString());
            }
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableRenameCommand copy(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        return new AlterTableRenameCommand(oldName, newName, isView);
    }

    public TableIdentifier copy$default$1() {
        return this.oldName();
    }

    public TableIdentifier copy$default$2() {
        return this.newName();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public String productPrefix() {
        return "AlterTableRenameCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 1: {
                object = this.newName();
                break;
            }
            case 0: {
                object = this.oldName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenameCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenameCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)x$1;
        TableIdentifier tableIdentifier = this.oldName();
        TableIdentifier tableIdentifier2 = alterTableRenameCommand.oldName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.newName();
        TableIdentifier tableIdentifier4 = alterTableRenameCommand.newName();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        if (this.isView() != alterTableRenameCommand.isView()) return false;
        if (!alterTableRenameCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRenameCommand(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        this.oldName = oldName;
        this.newName = newName;
        this.isView = isView;
        Command.class.$init$((Command)this);
    }
}

