/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.spark-project.guava.primitives.Ints;

public class TransportConf {
    private final String SPARK_NETWORK_IO_MODE_KEY;
    private final String SPARK_NETWORK_IO_PREFERDIRECTBUFS_KEY;
    private final String SPARK_NETWORK_IO_CONNECTIONTIMEOUT_KEY;
    private final String SPARK_NETWORK_IO_BACKLOG_KEY;
    private final String SPARK_NETWORK_IO_NUMCONNECTIONSPERPEER_KEY;
    private final String SPARK_NETWORK_IO_SERVERTHREADS_KEY;
    private final String SPARK_NETWORK_IO_CLIENTTHREADS_KEY;
    private final String SPARK_NETWORK_IO_RECEIVEBUFFER_KEY;
    private final String SPARK_NETWORK_IO_SENDBUFFER_KEY;
    private final String SPARK_NETWORK_SASL_TIMEOUT_KEY;
    private final String SPARK_NETWORK_IO_MAXRETRIES_KEY;
    private final String SPARK_NETWORK_IO_RETRYWAIT_KEY;
    private final String SPARK_NETWORK_IO_LAZYFD_KEY;
    private final ConfigProvider conf;
    private final String module;

    public TransportConf(String module, ConfigProvider conf) {
        this.module = module;
        this.conf = conf;
        this.SPARK_NETWORK_IO_MODE_KEY = this.getConfKey("io.mode");
        this.SPARK_NETWORK_IO_PREFERDIRECTBUFS_KEY = this.getConfKey("io.preferDirectBufs");
        this.SPARK_NETWORK_IO_CONNECTIONTIMEOUT_KEY = this.getConfKey("io.connectionTimeout");
        this.SPARK_NETWORK_IO_BACKLOG_KEY = this.getConfKey("io.backLog");
        this.SPARK_NETWORK_IO_NUMCONNECTIONSPERPEER_KEY = this.getConfKey("io.numConnectionsPerPeer");
        this.SPARK_NETWORK_IO_SERVERTHREADS_KEY = this.getConfKey("io.serverThreads");
        this.SPARK_NETWORK_IO_CLIENTTHREADS_KEY = this.getConfKey("io.clientThreads");
        this.SPARK_NETWORK_IO_RECEIVEBUFFER_KEY = this.getConfKey("io.receiveBuffer");
        this.SPARK_NETWORK_IO_SENDBUFFER_KEY = this.getConfKey("io.sendBuffer");
        this.SPARK_NETWORK_SASL_TIMEOUT_KEY = this.getConfKey("sasl.timeout");
        this.SPARK_NETWORK_IO_MAXRETRIES_KEY = this.getConfKey("io.maxRetries");
        this.SPARK_NETWORK_IO_RETRYWAIT_KEY = this.getConfKey("io.retryWait");
        this.SPARK_NETWORK_IO_LAZYFD_KEY = this.getConfKey("io.lazyFD");
    }

    private String getConfKey(String suffix) {
        return "spark." + this.module + "." + suffix;
    }

    public String ioMode() {
        return this.conf.get(this.SPARK_NETWORK_IO_MODE_KEY, "NIO").toUpperCase();
    }

    public boolean preferDirectBufs() {
        return this.conf.getBoolean(this.SPARK_NETWORK_IO_PREFERDIRECTBUFS_KEY, true);
    }

    public int connectionTimeoutMs() {
        long defaultNetworkTimeoutS = JavaUtils.timeStringAsSec(this.conf.get("spark.network.timeout", "120s"));
        long defaultTimeoutMs = JavaUtils.timeStringAsSec(this.conf.get(this.SPARK_NETWORK_IO_CONNECTIONTIMEOUT_KEY, defaultNetworkTimeoutS + "s")) * 1000L;
        return (int)defaultTimeoutMs;
    }

    public int numConnectionsPerPeer() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_NUMCONNECTIONSPERPEER_KEY, 1);
    }

    public int backLog() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_BACKLOG_KEY, -1);
    }

    public int serverThreads() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_SERVERTHREADS_KEY, 0);
    }

    public int clientThreads() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_CLIENTTHREADS_KEY, 0);
    }

    public int receiveBuf() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_RECEIVEBUFFER_KEY, -1);
    }

    public int sendBuf() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_SENDBUFFER_KEY, -1);
    }

    public int saslRTTimeoutMs() {
        return (int)JavaUtils.timeStringAsSec(this.conf.get(this.SPARK_NETWORK_SASL_TIMEOUT_KEY, "30s")) * 1000;
    }

    public int maxIORetries() {
        return this.conf.getInt(this.SPARK_NETWORK_IO_MAXRETRIES_KEY, 3);
    }

    public int ioRetryWaitTimeMs() {
        return (int)JavaUtils.timeStringAsSec(this.conf.get(this.SPARK_NETWORK_IO_RETRYWAIT_KEY, "5s")) * 1000;
    }

    public int memoryMapBytes() {
        return Ints.checkedCast(JavaUtils.byteStringAsBytes(this.conf.get("spark.storage.memoryMapThreshold", "2m")));
    }

    public boolean lazyFileDescriptor() {
        return this.conf.getBoolean(this.SPARK_NETWORK_IO_LAZYFD_KEY, true);
    }

    public int portMaxRetries() {
        return this.conf.getInt("spark.port.maxRetries", 16);
    }

    public int maxSaslEncryptedBlockSize() {
        return Ints.checkedCast(JavaUtils.byteStringAsBytes(this.conf.get("spark.network.sasl.maxEncryptedBlockSize", "64k")));
    }

    public boolean saslServerAlwaysEncrypt() {
        return this.conf.getBoolean("spark.network.sasl.serverAlwaysEncrypt", false);
    }
}

