/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.SqlParser$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.OverrideCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.Queryable;
import org.apache.spark.sql.execution.RunnableCommand;
import org.apache.spark.sql.hive.HiveContext;
import org.apache.spark.sql.hive.execution.DropTable$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0001\u0012q!!\u0003#s_B$\u0016M\u00197f\u0015\t\u0019A!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QAB\u0001\u0005Q&4XM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001cR\u0001A\b\u001a=\u0011\u0002\"\u0001E\f\u000e\u0003EQ!AE\n\u0002\u000f1|w-[2bY*\u0011A#F\u0001\u0006a2\fgn\u001d\u0006\u0003-\u0019\t\u0001bY1uC2L8\u000f^\u0005\u00031E\u00111\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011!\u0004H\u0007\u00027)\u00111AB\u0005\u0003;m\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b!J|G-^2u!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\"A\u0001\u0006\u0001BK\u0002\u0013\u0005!&A\u0005uC\ndWMT1nK\u000e\u0001Q#A\u0016\u0011\u00051zcBA\u0010.\u0013\tq\u0003%\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018!\u0011!\u0019\u0004A!E!\u0002\u0013Y\u0013A\u0003;bE2,g*Y7fA!AQ\u0007\u0001BK\u0002\u0013\u0005a'\u0001\u0005jM\u0016C\u0018n\u001d;t+\u00059\u0004CA\u00109\u0013\tI\u0004EA\u0004C_>dW-\u00198\t\u0011m\u0002!\u0011#Q\u0001\n]\n\u0011\"\u001b4Fq&\u001cHo\u001d\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\ry\u0014I\u0011\t\u0003\u0001\u0002i\u0011A\u0001\u0005\u0006Qq\u0002\ra\u000b\u0005\u0006kq\u0002\ra\u000e\u0005\u0006\t\u0002!\t%R\u0001\u0004eVtGC\u0001$W!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!aS\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u0001(!\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002OAA\u00111\u000bV\u0007\u0002\r%\u0011QK\u0002\u0002\u0004%><\b\"B,D\u0001\u0004A\u0016AC:rY\u000e{g\u000e^3yiB\u00111+W\u0005\u00035\u001a\u0011!bU)M\u0007>tG/\u001a=u\u0011\u001da\u0006!!A\u0005\u0002u\u000bAaY8qsR\u0019qHX0\t\u000f!Z\u0006\u0013!a\u0001W!9Qg\u0017I\u0001\u0002\u00049\u0004bB1\u0001#\u0003%\tAY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0019'FA\u0016eW\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003%)hn\u00195fG.,GM\u0003\u0002kA\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051<'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9a\u000eAI\u0001\n\u0003y\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0002a*\u0012q\u0007\u001a\u0005\be\u0002\t\t\u0011\"\u0011t\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006!A.\u00198h\u0015\u0005I\u0018\u0001\u00026bm\u0006L!\u0001\r<\t\u000fq\u0004\u0011\u0011!C\u0001{\u0006a\u0001O]8ek\u000e$\u0018I]5usV\ta\u0010\u0005\u0002 \u007f&\u0019\u0011\u0011\u0001\u0011\u0003\u0007%sG\u000fC\u0005\u0002\u0006\u0001\t\t\u0011\"\u0001\u0002\b\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0005\u0003\u001f\u00012aHA\u0006\u0013\r\ti\u0001\t\u0002\u0004\u0003:L\b\"CA\t\u0003\u0007\t\t\u00111\u0001\u007f\u0003\rAH%\r\u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0001b!a\u0007\u0002\"\u0005%QBAA\u000f\u0015\r\ty\u0002I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0012\u0003;\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003O\u0001\u0011\u0011!C\u0001\u0003S\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004o\u0005-\u0002BCA\t\u0003K\t\t\u00111\u0001\u0002\n!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0013\u0011G\u0001\tQ\u0006\u001c\bnQ8eKR\ta\u0010C\u0005\u00026\u0001\t\t\u0011\"\u0011\u00028\u00051Q-];bYN$2aNA\u001d\u0011)\t\t\"a\r\u0002\u0002\u0003\u0007\u0011\u0011B\u0004\u000b\u0003{\u0011\u0011\u0011!E\u0001\t\u0005}\u0012!\u0003#s_B$\u0016M\u00197f!\r\u0001\u0015\u0011\t\u0004\n\u0003\t\t\t\u0011#\u0001\u0005\u0003\u0007\u001aR!!\u0011\u0002F\u0011\u0002r!a\u0012\u0002N-:t(\u0004\u0002\u0002J)\u0019\u00111\n\u0011\u0002\u000fI,h\u000e^5nK&!\u0011qJA%\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b{\u0005\u0005C\u0011AA*)\t\ty\u0004\u0003\u0006\u0002X\u0005\u0005\u0013\u0011!C#\u00033\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002i\"Q\u0011QLA!\u0003\u0003%\t)a\u0018\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b}\n\t'a\u0019\t\r!\nY\u00061\u0001,\u0011\u0019)\u00141\fa\u0001o!Q\u0011qMA!\u0003\u0003%\t)!\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u00111NA<!\u0015y\u0012QNA9\u0013\r\ty\u0007\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b}\t\u0019hK\u001c\n\u0007\u0005U\u0004E\u0001\u0004UkBdWM\r\u0005\n\u0003s\n)'!AA\u0002}\n1\u0001\u001f\u00131\u0011)\ti(!\u0011\u0002\u0002\u0013%\u0011qP\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0002B\u0019Q/a!\n\u0007\u0005\u0015eO\u0001\u0004PE*,7\r\u001e")
public class DropTable
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final String tableName;
    private final boolean ifExists;

    public static Function1<Tuple2<String, Object>, DropTable> tupled() {
        return DropTable$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Object, DropTable>> curried() {
        return DropTable$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return RunnableCommand.class.output((RunnableCommand)this);
    }

    public Seq<LogicalPlan> children() {
        return RunnableCommand.class.children((RunnableCommand)this);
    }

    public String tableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public Seq<Row> run(SQLContext sqlContext) {
        Object object;
        HiveContext hiveContext = (HiveContext)sqlContext;
        String ifExistsClause = this.ifExists() ? "IF EXISTS " : "";
        try {
            object = BoxesRunTime.boxToBoolean((boolean)hiveContext.cacheManager().tryUncacheQuery((Queryable)hiveContext.table(this.tableName()), hiveContext.cacheManager().tryUncacheQuery$default$2()));
        }
        catch (Throwable throwable) {
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.getMessage()})), throwable);
            object = BoxedUnit.UNIT;
        }
        catch (NoSuchTableException noSuchTableException) {
            object = BoxedUnit.UNIT;
        }
        catch (InvalidTableException invalidTableException) {
            object = BoxedUnit.UNIT;
        }
        hiveContext.invalidateTable(this.tableName());
        TableIdentifier identifier = SqlParser$.MODULE$.parseTableIdentifier(this.tableName());
        String tableNameForHive = identifier.table().startsWith("_") ? identifier.quotedString() : identifier.unquotedString();
        hiveContext.runSqlHive(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ifExistsClause, tableNameForHive})));
        ((OverrideCatalog)hiveContext.catalog()).unregisterTable(TableIdentifier$.MODULE$.apply(this.tableName()));
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropTable copy(String tableName, boolean ifExists) {
        return new DropTable(tableName, ifExists);
    }

    public String copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public String productPrefix() {
        return "DropTable";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 0: {
                object = this.tableName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropTable;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tableName()));
        n = Statics.mix((int)n, (int)(this.ifExists() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropTable dropTable = (DropTable)((Object)x$1);
        String string = this.tableName();
        String string2 = dropTable.tableName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.ifExists() != dropTable.ifExists()) return false;
        if (!dropTable.canEqual((Object)this)) return false;
        return true;
    }

    public DropTable(String tableName, boolean ifExists) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        RunnableCommand.class.$init$((RunnableCommand)this);
    }
}

