/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.FIFOSchedulingAlgorithm;
import org.apache.spark.scheduler.FairSchedulingAlgorithm;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulingAlgorithm;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.scheduler.TaskSetManager;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!B\u0001\u0003\u0001\u0011Q!\u0001\u0002)p_2T!a\u0001\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\t\u0001Y\u0011#\u0006\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u0019R\"\u0001\u0002\n\u0005Q\u0011!aC*dQ\u0016$W\u000f\\1cY\u0016\u0004\"AF\f\u000e\u0003\u0011I!\u0001\u0007\u0003\u0003\u000f1{wmZ5oO\"A!\u0004\u0001BC\u0002\u0013\u0005A$\u0001\u0005q_>dg*Y7f\u0007\u0001)\u0012!\b\t\u0003=\u0005r!\u0001D\u0010\n\u0005\u0001j\u0011A\u0002)sK\u0012,g-\u0003\u0002#G\t11\u000b\u001e:j]\u001eT!\u0001I\u0007\t\u0011\u0015\u0002!\u0011!Q\u0001\nu\t\u0011\u0002]8pY:\u000bW.\u001a\u0011\t\u0011\u001d\u0002!Q1A\u0005\u0002!\nab]2iK\u0012,H.\u001b8h\u001b>$W-F\u0001*!\tQ\u0003H\u0004\u0002,m9\u0011A&\u000e\b\u0003[Qr!AL\u001a\u000f\u0005=\u0012T\"\u0001\u0019\u000b\u0005EZ\u0012A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003o\t\tabU2iK\u0012,H.\u001b8h\u001b>$W-\u0003\u0002:u\tq1k\u00195fIVd\u0017N\\4N_\u0012,'BA\u001c\u0003\u0011!a\u0004A!A!\u0002\u0013I\u0013aD:dQ\u0016$W\u000f\\5oO6{G-\u001a\u0011\t\u0011y\u0002!\u0011!Q\u0001\n}\nA\"\u001b8ji6Kgn\u00155be\u0016\u0004\"\u0001\u0004!\n\u0005\u0005k!aA%oi\"A1\t\u0001B\u0001B\u0003%q(\u0001\u0006j]&$x+Z5hQRDQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtD#B$I\u0013*[\u0005C\u0001\n\u0001\u0011\u0015QB\t1\u0001\u001e\u0011\u00159C\t1\u0001*\u0011\u0015qD\t1\u0001@\u0011\u0015\u0019E\t1\u0001@\u0011\u001di\u0005A1A\u0005\u00029\u000b\u0001c]2iK\u0012,H.\u00192mKF+X-^3\u0016\u0003=\u00032\u0001U,\u0012\u001b\u0005\t&B\u0001*T\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003)V\u000bA!\u001e;jY*\ta+\u0001\u0003kCZ\f\u0017B\u0001-R\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016DaA\u0017\u0001!\u0002\u0013y\u0015!E:dQ\u0016$W\u000f\\1cY\u0016\fV/Z;fA!9A\f\u0001b\u0001\n\u0003i\u0016\u0001H:dQ\u0016$W\u000f\\1cY\u0016t\u0015-\\3U_N\u001b\u0007.\u001a3vY\u0006\u0014G.Z\u000b\u0002=B!\u0001kX\u000f\u0012\u0013\t\u0001\u0017KA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCBDaA\u0019\u0001!\u0002\u0013q\u0016!H:dQ\u0016$W\u000f\\1cY\u0016t\u0015-\\3U_N\u001b\u0007.\u001a3vY\u0006\u0014G.\u001a\u0011\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u00061q/Z5hQR,\u0012a\u0010\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0003)9X-[4ii~#S-\u001d\u000b\u0003S2\u0004\"\u0001\u00046\n\u0005-l!\u0001B+oSRDq!\u001c4\u0002\u0002\u0003\u0007q(A\u0002yIEBaa\u001c\u0001!B\u0013y\u0014aB<fS\u001eDG\u000f\t\u0005\bc\u0002\u0001\r\u0011\"\u0001f\u0003!i\u0017N\\*iCJ,\u0007bB:\u0001\u0001\u0004%\t\u0001^\u0001\r[&t7\u000b[1sK~#S-\u001d\u000b\u0003SVDq!\u001c:\u0002\u0002\u0003\u0007q\b\u0003\u0004x\u0001\u0001\u0006KaP\u0001\n[&t7\u000b[1sK\u0002Bq!\u001f\u0001A\u0002\u0013\u0005Q-\u0001\u0007sk:t\u0017N\\4UCN\\7\u000fC\u0004|\u0001\u0001\u0007I\u0011\u0001?\u0002!I,hN\\5oOR\u000b7o[:`I\u0015\fHCA5~\u0011\u001di'0!AA\u0002}Baa \u0001!B\u0013y\u0014!\u0004:v]:Lgn\u001a+bg.\u001c\b\u0005\u0003\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0001f\u0003!\u0001(/[8sSRL\b\"CA\u0004\u0001\u0001\u0007I\u0011AA\u0005\u00031\u0001(/[8sSRLx\fJ3r)\rI\u00171\u0002\u0005\t[\u0006\u0015\u0011\u0011!a\u0001\u007f!9\u0011q\u0002\u0001!B\u0013y\u0014!\u00039sS>\u0014\u0018\u000e^=!\u0011!\t\u0019\u0002\u0001a\u0001\n\u0003)\u0017aB:uC\u001e,\u0017\n\u001a\u0005\n\u0003/\u0001\u0001\u0019!C\u0001\u00033\t1b\u001d;bO\u0016LEm\u0018\u0013fcR\u0019\u0011.a\u0007\t\u00115\f)\"!AA\u0002}Bq!a\b\u0001A\u0003&q(\u0001\u0005ti\u0006<W-\u00133!\u0011!\t\u0019\u0003\u0001a\u0001\n\u0003a\u0012\u0001\u00028b[\u0016D\u0011\"a\n\u0001\u0001\u0004%\t!!\u000b\u0002\u00119\fW.Z0%KF$2![A\u0016\u0011!i\u0017QEA\u0001\u0002\u0004i\u0002bBA\u0018\u0001\u0001\u0006K!H\u0001\u0006]\u0006lW\r\t\u0005\n\u0003g\u0001\u0001\u0019!C\u0001\u0003k\ta\u0001]1sK:$X#A$\t\u0013\u0005e\u0002\u00011A\u0005\u0002\u0005m\u0012A\u00039be\u0016tGo\u0018\u0013fcR\u0019\u0011.!\u0010\t\u00115\f9$!AA\u0002\u001dCq!!\u0011\u0001A\u0003&q)A\u0004qCJ,g\u000e\u001e\u0011\t\u0013\u0005\u0015\u0003\u00011A\u0005\u0002\u0005\u001d\u0013A\u0007;bg.\u001cV\r^*dQ\u0016$W\u000f\\5oO\u0006cwm\u001c:ji\"lWCAA%!\r\u0011\u00121J\u0005\u0004\u0003\u001b\u0012!aE*dQ\u0016$W\u000f\\5oO\u0006cwm\u001c:ji\"l\u0007\"CA)\u0001\u0001\u0007I\u0011AA*\u0003y!\u0018m]6TKR\u001c6\r[3ek2LgnZ!mO>\u0014\u0018\u000e\u001e5n?\u0012*\u0017\u000fF\u0002j\u0003+B\u0011\"\\A(\u0003\u0003\u0005\r!!\u0013\t\u0011\u0005e\u0003\u0001)Q\u0005\u0003\u0013\n1\u0004^1tWN+GoU2iK\u0012,H.\u001b8h\u00032<wN]5uQ6\u0004\u0003bBA/\u0001\u0011\u0005\u0013qL\u0001\u000fC\u0012$7k\u00195fIVd\u0017M\u00197f)\rI\u0017\u0011\r\u0005\b\u0003G\nY\u00061\u0001\u0012\u0003-\u00198\r[3ek2\f'\r\\3\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\u0005\t\"/Z7pm\u0016\u001c6\r[3ek2\f'\r\\3\u0015\u0007%\fY\u0007C\u0004\u0002d\u0005\u0015\u0004\u0019A\t\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r\u0005!r-\u001a;TG\",G-\u001e7bE2,')\u001f(b[\u0016$2!EA:\u0011\u001d\t)(!\u001cA\u0002u\tqb]2iK\u0012,H.\u00192mK:\u000bW.\u001a\u0005\b\u0003s\u0002A\u0011IA>\u00031)\u00070Z2vi>\u0014Hj\\:u)\u001dI\u0017QPAA\u0003\u000bCq!a \u0002x\u0001\u0007Q$\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Dq!a!\u0002x\u0001\u0007Q$\u0001\u0003i_N$\b\u0002CAD\u0003o\u0002\r!!#\u0002\rI,\u0017m]8o!\r\u0011\u00121R\u0005\u0004\u0003\u001b\u0013!AE#yK\u000e,Ho\u001c:M_N\u001c(+Z1t_:Dq!!%\u0001\t\u0003\n\u0019*\u0001\fdQ\u0016\u001c7n\u00159fGVd\u0017\r^1cY\u0016$\u0016m]6t)\t\t)\nE\u0002\r\u0003/K1!!'\u000e\u0005\u001d\u0011un\u001c7fC:Dq!!(\u0001\t\u0003\ny*A\u000bhKR\u001cvN\u001d;fIR\u000b7o[*fiF+X-^3\u0016\u0005\u0005\u0005\u0006CBAR\u0003[\u000b\t,\u0004\u0002\u0002&*!\u0011qUAU\u0003\u001diW\u000f^1cY\u0016T1!a+\u000e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000b)KA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u0001\n\u00024&\u0019\u0011Q\u0017\u0002\u0003\u001dQ\u000b7o[*fi6\u000bg.Y4fe\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0016\u0001F5oGJ,\u0017m]3Sk:t\u0017N\\4UCN\\7\u000fF\u0002j\u0003{Cq!a0\u00028\u0002\u0007q(A\u0004uCN\\g*^7\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\u0006!B-Z2sK\u0006\u001cXMU;o]&tw\rV1tWN$2![Ad\u0011\u001d\ty,!1A\u0002}\u0002")
public class Pool
implements Schedulable,
Logging {
    private final String poolName;
    private final Enumeration.Value schedulingMode;
    private final ConcurrentLinkedQueue<Schedulable> schedulableQueue;
    private final ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable;
    private int weight;
    private int minShare;
    private int runningTasks;
    private int priority;
    private int stageId;
    private String name;
    private Pool parent;
    private SchedulingAlgorithm taskSetSchedulingAlgorithm;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String poolName() {
        return this.poolName;
    }

    @Override
    public Enumeration.Value schedulingMode() {
        return this.schedulingMode;
    }

    @Override
    public ConcurrentLinkedQueue<Schedulable> schedulableQueue() {
        return this.schedulableQueue;
    }

    public ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable() {
        return this.schedulableNameToSchedulable;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public void weight_$eq(int x$1) {
        this.weight = x$1;
    }

    @Override
    public int minShare() {
        return this.minShare;
    }

    public void minShare_$eq(int x$1) {
        this.minShare = x$1;
    }

    @Override
    public int runningTasks() {
        return this.runningTasks;
    }

    public void runningTasks_$eq(int x$1) {
        this.runningTasks = x$1;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public void priority_$eq(int x$1) {
        this.priority = x$1;
    }

    @Override
    public int stageId() {
        return this.stageId;
    }

    public void stageId_$eq(int x$1) {
        this.stageId = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    @Override
    public Pool parent() {
        return this.parent;
    }

    @Override
    public void parent_$eq(Pool x$1) {
        this.parent = x$1;
    }

    public SchedulingAlgorithm taskSetSchedulingAlgorithm() {
        return this.taskSetSchedulingAlgorithm;
    }

    public void taskSetSchedulingAlgorithm_$eq(SchedulingAlgorithm x$1) {
        this.taskSetSchedulingAlgorithm = x$1;
    }

    @Override
    public void addSchedulable(Schedulable schedulable) {
        Predef$.MODULE$.require(schedulable != null);
        this.schedulableQueue().add(schedulable);
        this.schedulableNameToSchedulable().put(schedulable.name(), schedulable);
        schedulable.parent_$eq(this);
    }

    @Override
    public void removeSchedulable(Schedulable schedulable) {
        this.schedulableQueue().remove(schedulable);
        this.schedulableNameToSchedulable().remove(schedulable.name());
    }

    @Override
    public Schedulable getSchedulableByName(String schedulableName) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Schedulable schedulable;
            Object object = new Object();
            try {
                if (this.schedulableNameToSchedulable().containsKey(schedulableName)) {
                    return this.schedulableNameToSchedulable().get(schedulableName);
                }
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1)new Serializable(this, schedulableName, object){
                    public static final long serialVersionUID = 0L;
                    private final String schedulableName$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Schedulable schedulable) {
                        Schedulable sched = schedulable.getSchedulableByName(this.schedulableName$1);
                        if (sched == null) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)sched);
                    }
                    {
                        this.schedulableName$1 = schedulableName$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                schedulable = null;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                schedulable = (Schedulable)nonLocalReturnControl2.value();
            }
            return schedulable;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void executorLost(String executorId, String host, ExecutorLossReason reason) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1)new Serializable(this, executorId, host, reason){
            public static final long serialVersionUID = 0L;
            private final String executorId$1;
            private final String host$1;
            private final ExecutorLossReason reason$1;

            public final void apply(Schedulable x$1) {
                x$1.executorLost(this.executorId$1, this.host$1, this.reason$1);
            }
            {
                this.executorId$1 = executorId$1;
                this.host$1 = host$1;
                this.reason$1 = reason$1;
            }
        });
    }

    @Override
    public boolean checkSpeculatableTasks() {
        BooleanRef shouldRevive = BooleanRef.create((boolean)false);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1)new Serializable(this, shouldRevive){
            public static final long serialVersionUID = 0L;
            private final BooleanRef shouldRevive$1;

            public final void apply(Schedulable schedulable) {
                this.shouldRevive$1.elem |= schedulable.checkSpeculatableTasks();
            }
            {
                this.shouldRevive$1 = shouldRevive$1;
            }
        });
        return shouldRevive.elem;
    }

    @Override
    public ArrayBuffer<TaskSetManager> getSortedTaskSetQueue() {
        ObjectRef sortedTaskSetQueue = ObjectRef.create((Object)new ArrayBuffer());
        SchedulingAlgorithm schedulingAlgorithm = this.taskSetSchedulingAlgorithm();
        Seq sortedSchedulableQueue = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).toSeq().sortWith((Function2)new Serializable(this, schedulingAlgorithm){
            public static final long serialVersionUID = 0L;
            private final SchedulingAlgorithm eta$0$1$1;

            public final boolean apply(Schedulable s1, Schedulable s2) {
                return this.eta$0$1$1.comparator(s1, s2);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        sortedSchedulableQueue.foreach((Function1)new Serializable(this, sortedTaskSetQueue){
            public static final long serialVersionUID = 0L;
            private final ObjectRef sortedTaskSetQueue$1;

            public final ArrayBuffer<TaskSetManager> apply(Schedulable schedulable) {
                return ((ArrayBuffer)this.sortedTaskSetQueue$1.elem).$plus$plus$eq(schedulable.getSortedTaskSetQueue());
            }
            {
                this.sortedTaskSetQueue$1 = sortedTaskSetQueue$1;
            }
        });
        return (ArrayBuffer)sortedTaskSetQueue.elem;
    }

    public void increaseRunningTasks(int taskNum) {
        this.runningTasks_$eq(this.runningTasks() + taskNum);
        if (this.parent() != null) {
            this.parent().increaseRunningTasks(taskNum);
        }
    }

    public void decreaseRunningTasks(int taskNum) {
        this.runningTasks_$eq(this.runningTasks() - taskNum);
        if (this.parent() != null) {
            this.parent().decreaseRunningTasks(taskNum);
        }
    }

    public Pool(String poolName, Enumeration.Value schedulingMode, int initMinShare, int initWeight) {
        Enumeration.Value value;
        block4: {
            SchedulingAlgorithm schedulingAlgorithm;
            block3: {
                block2: {
                    this.poolName = poolName;
                    this.schedulingMode = schedulingMode;
                    Logging$class.$init$(this);
                    this.schedulableQueue = new ConcurrentLinkedQueue();
                    this.schedulableNameToSchedulable = new ConcurrentHashMap();
                    this.weight = initWeight;
                    this.minShare = initMinShare;
                    this.runningTasks = 0;
                    this.priority = 0;
                    this.stageId = -1;
                    this.name = poolName;
                    this.parent = null;
                    value = schedulingMode;
                    Enumeration.Value value2 = SchedulingMode$.MODULE$.FAIR();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    schedulingAlgorithm = new FairSchedulingAlgorithm();
                    break block3;
                }
                Enumeration.Value value4 = SchedulingMode$.MODULE$.FIFO();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                schedulingAlgorithm = new FIFOSchedulingAlgorithm();
            }
            this.taskSetSchedulingAlgorithm = schedulingAlgorithm;
            return;
        }
        throw new MatchError((Object)value);
    }
}

