/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RequestMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0001\ta!a\u0004(fiRL(\u000b]2IC:$G.\u001a:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003\r\u0011\bo\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\u000b\u0011\u00059\u0019R\"A\b\u000b\u0005A\t\u0012AB:feZ,'O\u0003\u0002\u0013\r\u00059a.\u001a;x_J\\\u0017B\u0001\u000b\u0010\u0005)\u0011\u0006o\u0019%b]\u0012dWM\u001d\t\u0003-]i\u0011AB\u0005\u00031\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u0003)!\u0017n\u001d9bi\u000eDWM]\u0002\u0001!\tib$D\u0001\u0003\u0013\ty\"A\u0001\u0006ESN\u0004\u0018\r^2iKJD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\t]\u0016$H/_#omB\u0011QdI\u0005\u0003I\t\u00111BT3uif\u0014\u0006oY#om\"Aa\u0005\u0001B\u0001B\u0003%q%A\u0007tiJ,\u0017-\\'b]\u0006<WM\u001d\t\u0003\u001d!J!!K\b\u0003\u001bM#(/Z1n\u001b\u0006t\u0017mZ3s\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q!QFL\u00181!\ti\u0002\u0001C\u0003\u001bU\u0001\u0007A\u0004C\u0003\"U\u0001\u0007!\u0005C\u0003'U\u0001\u0007q\u0005C\u00043\u0001\t\u0007I\u0011B\u001a\u0002\u000f\rd\u0017.\u001a8ugV\tA\u0007\u0005\u00036yy\"U\"\u0001\u001c\u000b\u0005]B\u0014AC2p]\u000e,(O]3oi*\u0011\u0011HO\u0001\u0005kRLGNC\u0001<\u0003\u0011Q\u0017M^1\n\u0005u2$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)E\u0001\u0007G2LWM\u001c;\n\u0005\r\u0003%a\u0004+sC:\u001c\bo\u001c:u\u00072LWM\u001c;\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0014\u0001\u00027b]\u001eL!!\u0013$\u0003\u000f\t{w\u000e\\3b]\"11\n\u0001Q\u0001\nQ\n\u0001b\u00197jK:$8\u000f\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0003=\u0011X-\\8uK\u0006#GM]3tg\u0016\u001cX#A(\u0011\tUb\u0004\u000b\u0015\t\u0003#Jk\u0011\u0001B\u0005\u0003'\u0012\u0011!B\u00159d\u0003\u0012$'/Z:t\u0011\u0019)\u0006\u0001)A\u0005\u001f\u0006\u0001\"/Z7pi\u0016\fE\r\u001a:fgN,7\u000f\t\u0005\u0006/\u0002!\t\u0005W\u0001\be\u0016\u001cW-\u001b<f)\u0011Iv\f\u00195\u0011\u0005ikV\"A.\u000b\u0003q\u000bQa]2bY\u0006L!AX.\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0003Z\u0003\rA\u0010\u0005\u0006CZ\u0003\rAY\u0001\b[\u0016\u001c8/Y4f!\t\u0019g-D\u0001e\u0015\t)'(A\u0002oS>L!a\u001a3\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003j-\u0002\u0007!.\u0001\u0005dC2d'-Y2l!\ty4.\u0003\u0002m\u0001\n\u0019\"\u000b]2SKN\u0004xN\\:f\u0007\u0006dGNY1dW\")q\u000b\u0001C!]R\u0019\u0011l\u001c9\t\u000b\u0005k\u0007\u0019\u0001 \t\u000b\u0005l\u0007\u0019\u00012\t\u000bI\u0004A\u0011B:\u0002\u001f%tG/\u001a:oC2\u0014VmY3jm\u0016$2\u0001^<y!\tiR/\u0003\u0002w\u0005\tq!+Z9vKN$X*Z:tC\u001e,\u0007\"B!r\u0001\u0004q\u0004\"B1r\u0001\u0004\u0011\u0007\"\u0002>\u0001\t\u0003Z\u0018\u0001E4fiN#(/Z1n\u001b\u0006t\u0017mZ3s)\u00059\u0003\"B?\u0001\t\u0003r\u0018aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\te{\u00181\u0004\u0005\b\u0003\u0003a\b\u0019AA\u0002\u0003\u0015\u0019\u0017-^:f!\u0011\t)!!\u0006\u000f\t\u0005\u001d\u0011\u0011\u0003\b\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0016bAA\n7\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005M1\fC\u0003By\u0002\u0007a\bC\u0004\u0002 \u0001!\t%!\t\u0002)\r|gN\\3di&|g\u000eV3s[&t\u0017\r^3e)\rI\u00161\u0005\u0005\u0007\u0003\u0006u\u0001\u0019\u0001 ")
public class NettyRpcHandler
extends RpcHandler
implements Logging {
    private final Dispatcher dispatcher;
    private final NettyRpcEnv nettyEnv;
    private final StreamManager streamManager;
    private final ConcurrentHashMap<TransportClient, Boolean> clients;
    private final ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private ConcurrentHashMap<TransportClient, Boolean> clients() {
        return this.clients;
    }

    private ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses() {
        return this.remoteAddresses;
    }

    public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
        RequestMessage messageToDispatch = this.internalReceive(client, message);
        this.dispatcher.postRemoteMessage(messageToDispatch, callback);
    }

    public void receive(TransportClient client, ByteBuffer message) {
        RequestMessage messageToDispatch = this.internalReceive(client, message);
        this.dispatcher.postOneWayMessage(messageToDispatch);
    }

    private RequestMessage internalReceive(TransportClient client, ByteBuffer message) {
        RequestMessage requestMessage;
        RequestMessage requestMessage2;
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostName(), addr.getPort());
        if (this.clients().putIfAbsent(client, Boolean.TRUE) == null) {
            this.dispatcher.postToAll(new RemoteProcessConnected(clientAddr));
        }
        if ((requestMessage2 = (RequestMessage)this.nettyEnv.deserialize(client, message, ClassTag$.MODULE$.apply(RequestMessage.class))).senderAddress() == null) {
            requestMessage = new RequestMessage(clientAddr, requestMessage2.receiver(), requestMessage2.content());
        } else {
            RpcAddress remoteEnvAddress = requestMessage2.senderAddress();
            if (this.remoteAddresses().putIfAbsent(clientAddr, remoteEnvAddress) == null) {
                this.dispatcher.postToAll(new RemoteProcessConnected(remoteEnvAddress));
            }
            requestMessage = requestMessage2;
        }
        return requestMessage;
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception before connecting to the client";
                }
            }, cause);
        } else {
            RpcAddress clientAddr = new RpcAddress(addr.getHostName(), addr.getPort());
            this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().get(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, remoteEnvAddress));
            }
        }
    }

    public void connectionTerminated(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            this.clients().remove(client);
            RpcAddress clientAddr = new RpcAddress(addr.getHostName(), addr.getPort());
            this.nettyEnv.removeOutbox(clientAddr);
            this.dispatcher.postToAll(new RemoteProcessDisconnected(clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().remove(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessDisconnected(remoteEnvAddress));
            }
        }
    }

    public NettyRpcHandler(Dispatcher dispatcher, NettyRpcEnv nettyEnv, StreamManager streamManager) {
        this.dispatcher = dispatcher;
        this.nettyEnv = nettyEnv;
        this.streamManager = streamManager;
        Logging$class.$init$(this);
        this.clients = new ConcurrentHashMap();
        this.remoteAddresses = new ConcurrentHashMap();
    }
}

