/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.slider.providers.ProviderService;
import org.apache.slider.server.appmaster.AppMasterActionOperations;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.agent.AgentRestOperations;
import org.apache.slider.server.appmaster.web.rest.application.resources.ContentCache;
import org.apache.slider.server.services.security.CertificateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppApiImpl
implements WebAppApi {
    private static final Logger log = LoggerFactory.getLogger(WebAppApiImpl.class);
    protected final StateAccessForProviders appState;
    protected final ProviderService provider;
    protected final CertificateManager certificateManager;
    private final RegistryOperations registryOperations;
    private final MetricsAndMonitoring metricsAndMonitoring;
    private final QueueAccess queues;
    private final AppMasterActionOperations appMasterOperations;
    private final ContentCache contentCache;

    public WebAppApiImpl(StateAccessForProviders appState, ProviderService provider, CertificateManager certificateManager, RegistryOperations registryOperations, MetricsAndMonitoring metricsAndMonitoring, QueueAccess queues, AppMasterActionOperations appMasterOperations, ContentCache contentCache) {
        this.appMasterOperations = appMasterOperations;
        this.contentCache = contentCache;
        Preconditions.checkNotNull((Object)appState);
        Preconditions.checkNotNull((Object)provider);
        this.queues = queues;
        this.registryOperations = registryOperations;
        this.appState = appState;
        this.provider = provider;
        this.certificateManager = certificateManager;
        this.metricsAndMonitoring = metricsAndMonitoring;
    }

    @Override
    public StateAccessForProviders getAppState() {
        return this.appState;
    }

    @Override
    public ProviderService getProviderService() {
        return this.provider;
    }

    @Override
    public CertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    @Override
    public Map<String, RoleStatus> getRoleStatusByName() {
        List<RoleStatus> roleStatuses = this.appState.cloneRoleStatusList();
        TreeMap<String, RoleStatus> map = new TreeMap<String, RoleStatus>();
        for (RoleStatus status : roleStatuses) {
            map.put(status.getName(), status);
        }
        return map;
    }

    @Override
    public AgentRestOperations getAgentRestOperations() {
        return this.provider.getAgentRestOperations();
    }

    @Override
    public RegistryOperations getRegistryOperations() {
        return this.registryOperations;
    }

    @Override
    public MetricsAndMonitoring getMetricsAndMonitoring() {
        return this.metricsAndMonitoring;
    }

    @Override
    public QueueAccess getQueues() {
        return this.queues;
    }

    @Override
    public AppMasterActionOperations getAMOperations() {
        return this.appMasterOperations;
    }

    @Override
    public ContentCache getContentCache() {
        return this.contentCache;
    }
}

