/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.operations;

import com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.operations.RMOperationHandlerActions;
import org.apache.slider.server.appmaster.state.ContainerPriority;

public class ContainerRequestOperation
extends AbstractRMOperation {
    private final AMRMClient.ContainerRequest request;

    public ContainerRequestOperation(AMRMClient.ContainerRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (Object)"Null container request");
        this.request = request;
    }

    public AMRMClient.ContainerRequest getRequest() {
        return this.request;
    }

    public Priority getPriority() {
        return this.request.getPriority();
    }

    public boolean getRelaxLocality() {
        return this.request.getRelaxLocality();
    }

    @Override
    public void execute(RMOperationHandlerActions handler) {
        handler.addContainerRequest(this.request);
    }

    public String toString() {
        return "request container for role " + ContainerPriority.toString(this.getPriority()) + " request " + this.request + " relaxLocality=" + this.getRelaxLocality();
    }
}

