/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.management;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.slider.server.appmaster.management.MeterAndCounter;
import org.apache.slider.server.appmaster.management.MetricsBindingService;
import org.apache.slider.server.appmaster.management.PrefixedMetricsSet;
import org.apache.slider.server.appmaster.management.RecordedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAndMonitoring
extends CompositeService {
    protected static final Logger log = LoggerFactory.getLogger(MetricsAndMonitoring.class);
    final MetricRegistry metrics = new MetricRegistry();
    final HealthCheckRegistry health = new HealthCheckRegistry();
    private final Map<String, MeterAndCounter> meterAndCounterMap = new ConcurrentHashMap<String, MeterAndCounter>();
    private final List<MetricSet> metricSets = new ArrayList<MetricSet>();
    private final List<RecordedEvent> eventHistory = new ArrayList<RecordedEvent>(100);
    public static final int EVENT_LIMIT = 1000;

    public MetricsAndMonitoring(String name) {
        super(name);
    }

    public MetricsAndMonitoring() {
        super("MetricsAndMonitoring");
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public HealthCheckRegistry getHealth() {
        return this.health;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.addService((Service)new MetricsBindingService("MetricsBindingService", this.metrics));
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        for (MetricSet set : this.metricSets) {
            this.unregister(set);
        }
    }

    public MeterAndCounter getMeterAndCounter(String name) {
        return this.meterAndCounterMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeterAndCounter getOrCreateMeterAndCounter(String name) {
        MeterAndCounter instance = this.meterAndCounterMap.get(name);
        if (instance == null) {
            MetricsAndMonitoring metricsAndMonitoring = this;
            synchronized (metricsAndMonitoring) {
                instance = this.meterAndCounterMap.get(name);
                if (instance == null) {
                    instance = new MeterAndCounter(this.metrics, name);
                    this.meterAndCounterMap.put(name, instance);
                }
            }
        }
        return instance;
    }

    public void markMeterAndCounter(String name) {
        MeterAndCounter meter = this.getOrCreateMeterAndCounter(name);
        meter.mark();
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return (T)this.metrics.register(name, metric);
    }

    public <T extends Metric> T register(Class<?> klass, T metric, String ... names) throws IllegalArgumentException {
        return this.register(MetricRegistry.name(klass, (String[])names), metric);
    }

    public synchronized void noteEvent(RecordedEvent event) {
        if (this.eventHistory.size() > 1000) {
            this.eventHistory.remove(0);
        }
        this.eventHistory.add(event);
    }

    public synchronized List<RecordedEvent> cloneEventHistory() {
        return new ArrayList<RecordedEvent>(this.eventHistory);
    }

    public void addMetricSet(MetricSet metricSet) {
        this.metricSets.add(metricSet);
        this.metrics.registerAll(metricSet);
    }

    public void addMetricSet(String prefix, MetricSet metricSet) {
        this.addMetricSet(new PrefixedMetricsSet(prefix, metricSet));
    }

    public void unregister(MetricSet metricSet) {
        for (String s : metricSet.getMetrics().keySet()) {
            try {
                this.metrics.remove(s);
            }
            catch (IllegalArgumentException e) {
                log.info("Exception when trying to unregister {}", (Object)s, (Object)e);
            }
        }
    }
}

