/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.agent.application.metadata.DockerContainerInputFile;
import org.apache.slider.providers.agent.application.metadata.DockerContainerMount;
import org.apache.slider.providers.agent.application.metadata.DockerContainerPort;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.Validate;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainer
implements Validate {
    protected static final Logger log = LoggerFactory.getLogger(DockerContainer.class);
    private String name;
    private String image;
    private String options;
    private List<DockerContainerMount> mounts = new ArrayList<DockerContainerMount>();
    private List<DockerContainerPort> ports = new ArrayList<DockerContainerPort>();
    private String statusCommand;
    private String commandPath;
    private String additionalParam;
    private List<DockerContainerInputFile> inputFiles = new ArrayList<DockerContainerInputFile>();

    @JsonProperty(value="mounts")
    public List<DockerContainerMount> getMounts() {
        return this.mounts;
    }

    @JsonProperty(value="ports")
    public List<DockerContainerPort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="inputFiles")
    public List<DockerContainerInputFile> getInputFiles() {
        return this.inputFiles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    @Override
    public void validate(String version) throws SliderException {
        Metainfo.checkNonNull(this.getName(), "name", "dockerContainer");
        Metainfo.checkNonNull(this.getImage(), "image", "dockerContainer");
        for (DockerContainerMount dcm : this.getMounts()) {
            dcm.validate(version);
        }
        for (DockerContainerPort dcp : this.getPorts()) {
            dcp.validate(version);
        }
    }

    public String getStatusCommand() {
        return this.statusCommand;
    }

    public void setStatusCommand(String statusCommand) {
        this.statusCommand = statusCommand;
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public void setCommandPath(String commandPath) {
        this.commandPath = commandPath;
    }

    public String getAdditionalParam() {
        return this.additionalParam;
    }

    public void setAdditionalParam(String additionalParam) {
        this.additionalParam = additionalParam;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("DockerContainer [name=").append(this.name).append(", image=").append(this.image).append(", options=").append(this.options).append(", mounts=").append(this.mounts).append(", ports=").append(this.ports).append(", statusCommand=").append(this.statusCommand).append(", commandPath=").append(this.commandPath).append(", additionalParam=").append(this.additionalParam).append(", inputFiles=").append(this.inputFiles).append("]");
        return result.toString();
    }
}

