/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import org.apache.slider.providers.agent.Command;
import org.apache.slider.providers.agent.CommandResult;

public enum State {
    INIT,
    INSTALLING,
    INSTALLED,
    STARTING,
    STARTED,
    INSTALL_FAILED,
    UPGRADING,
    UPGRADED,
    STOPPING,
    STOPPED,
    TERMINATING;


    public boolean canIssueCommands() {
        switch (this) {
            case INSTALLING: 
            case STARTING: 
            case UPGRADING: 
            case STOPPING: 
            case TERMINATING: {
                return false;
            }
        }
        return true;
    }

    public Command getSupportedCommand() {
        return this.getSupportedCommand(false);
    }

    public Command getSupportedCommand(boolean isInUpgradeMode) {
        return this.getSupportedCommand(isInUpgradeMode, false);
    }

    public Command getSupportedCommand(boolean isInUpgradeMode, boolean stopInitiated) {
        switch (this) {
            case INIT: 
            case INSTALL_FAILED: {
                return Command.INSTALL;
            }
            case INSTALLED: {
                return Command.START;
            }
            case STARTED: {
                return isInUpgradeMode ? Command.UPGRADE : (stopInitiated ? Command.STOP : Command.NOP);
            }
            case UPGRADED: {
                return Command.STOP;
            }
            case STOPPED: {
                return Command.TERMINATE;
            }
        }
        return Command.NOP;
    }

    public State getNextState(CommandResult result) throws IllegalArgumentException {
        switch (result) {
            case IN_PROGRESS: {
                if (this == INSTALLING || this == STARTING || this == UPGRADING || this == STOPPING || this == TERMINATING) {
                    return this;
                }
                throw new IllegalArgumentException((Object)((Object)result) + " is not valid for " + (Object)((Object)this));
            }
            case COMPLETED: {
                if (this == INSTALLING) {
                    return INSTALLED;
                }
                if (this == STARTING) {
                    return STARTED;
                }
                if (this == UPGRADING) {
                    return UPGRADED;
                }
                if (this == STOPPING) {
                    return STOPPED;
                }
                throw new IllegalArgumentException((Object)((Object)result) + " is not valid for " + (Object)((Object)this));
            }
            case FAILED: {
                if (this == INSTALLING) {
                    return INSTALL_FAILED;
                }
                if (this == STARTING) {
                    return INSTALLED;
                }
                if (this == UPGRADING) {
                    return UPGRADED;
                }
                if (this == STOPPING) {
                    return STOPPED;
                }
                if (this == STOPPED) {
                    return TERMINATING;
                }
                throw new IllegalArgumentException((Object)((Object)result) + " is not valid for " + (Object)((Object)this));
            }
        }
        throw new IllegalArgumentException("Bad command result " + (Object)((Object)result));
    }

    public State getNextState(Command command) throws IllegalArgumentException {
        switch (command) {
            case INSTALL: {
                if (this == INIT || this == INSTALL_FAILED) {
                    return INSTALLING;
                }
                throw new IllegalArgumentException((Object)((Object)command) + " is not valid for " + (Object)((Object)this));
            }
            case INSTALL_ADDON: {
                if (this == INIT || this == INSTALL_FAILED) {
                    return INSTALLING;
                }
                throw new IllegalArgumentException((Object)((Object)command) + " is not valid for " + (Object)((Object)this));
            }
            case START: {
                if (this == INSTALLED) {
                    return STARTING;
                }
                throw new IllegalArgumentException((Object)((Object)command) + " is not valid for " + (Object)((Object)this));
            }
            case UPGRADE: {
                if (this == STARTED) {
                    return UPGRADING;
                }
                throw new IllegalArgumentException((Object)((Object)command) + " is not valid for " + (Object)((Object)this));
            }
            case STOP: {
                if (this == STARTED || this == UPGRADED) {
                    return STOPPING;
                }
                throw new IllegalArgumentException((Object)((Object)command) + " is not valid for " + (Object)((Object)this));
            }
            case TERMINATE: {
                if (this == STOPPED) {
                    return TERMINATING;
                }
                throw new IllegalArgumentException((Object)((Object)command) + " is not valid for " + (Object)((Object)this));
            }
            case NOP: {
                return this;
            }
        }
        throw new IllegalArgumentException("Bad command " + (Object)((Object)command));
    }

    public boolean couldHaveIssued(Command command) {
        return this == INSTALLING && command == Command.INSTALL || this == STARTING && command == Command.START || this == UPGRADING && command == Command.UPGRADE || this == STOPPING && (command == Command.STOP || command == Command.NOP) || this == TERMINATING && command == Command.TERMINATE;
    }
}

