/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.common.params.ArgOps;
import org.apache.slider.common.params.Arguments;
import org.apache.slider.common.params.SliderActions;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.exceptions.UsageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonArgs
extends ArgOps
implements SliderActions,
Arguments {
    protected static final Logger log = LoggerFactory.getLogger(CommonArgs.class);
    private static final int DIFF_BETWEEN_DESCIPTION_AND_COMMAND_NAME = 30;
    @Parameter(names={"--help"}, help=true)
    public boolean help;
    public Map<String, String> definitionMap = new HashMap<String, String>();
    public Map<String, String> syspropsMap = new HashMap<String, String>();
    public final JCommander commander;
    private final String[] args;
    private AbstractActionArgs coreAction;

    public String getClusterName() {
        return this.coreAction.getClusterName();
    }

    protected CommonArgs(String[] args) {
        this.args = args;
        this.commander = new JCommander((Object)this);
    }

    protected CommonArgs(Collection args) {
        List<String> argsAsStrings = SliderUtils.collectionToStringList(args);
        this.args = argsAsStrings.toArray(new String[argsAsStrings.size()]);
        this.commander = new JCommander((Object)this);
    }

    public String usage() {
        return CommonArgs.usage(this, null);
    }

    public static String usage(CommonArgs serviceArgs, String commandOfInterest) {
        String result = null;
        StringBuilder helperMessage = new StringBuilder();
        if (commandOfInterest == null) {
            helperMessage.append("\nUsage: slider COMMAND [options]\n");
            helperMessage.append("where COMMAND is one of\n");
            for (String jcommand : serviceArgs.commander.getCommands().keySet()) {
                helperMessage.append(String.format("\t%-30s%s", jcommand, String.valueOf(serviceArgs.commander.getCommandDescription(jcommand)) + "\n"));
            }
            helperMessage.append("Most commands print help when invoked without parameters or with --help");
            result = helperMessage.toString();
        } else {
            helperMessage.append("\nUsage: slider ").append(commandOfInterest);
            helperMessage.append(serviceArgs.coreAction.getMinParams() > 0 ? " <application>" : "");
            helperMessage.append("\n");
            for (ParameterDescription paramDesc : ((JCommander)serviceArgs.commander.getCommands().get(commandOfInterest)).getParameters()) {
                String optional = paramDesc.getParameter().required() ? "  (required)" : "  (optional)";
                String paramName = paramDesc.getParameterized().getType() == Boolean.TYPE ? paramDesc.getLongestName() : String.valueOf(paramDesc.getLongestName()) + " <" + paramDesc.getParameterized().getName() + ">";
                helperMessage.append(String.format("\t%-30s%s", paramName, String.valueOf(paramDesc.getDescription()) + optional + "\n"));
                result = helperMessage.toString();
            }
        }
        return result;
    }

    public static String usage(CommonArgs serviceArgs) {
        return CommonArgs.usage(serviceArgs, null);
    }

    public void parse() throws SliderException {
        this.addActionArguments();
        try {
            this.commander.parse(this.getArgs());
        }
        catch (ParameterException e) {
            throw new BadCommandArgumentsException(e, "%s in %s", e.toString(), this.getArgs() != null ? SliderUtils.join(this.getArgs(), " ", false) : "[]");
        }
        this.postProcess();
    }

    protected void addAction(String name, Object arg) {
        this.commander.addCommand(name, arg);
    }

    protected void addActions(Object ... actions) {
        Object[] objectArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Object action = objectArray[n2];
            this.commander.addCommand(action);
            ++n2;
        }
    }

    protected void addActionArguments() {
    }

    public void postProcess() throws SliderException {
        this.applyAction();
        this.validate();
        for (Map.Entry<String, String> entry : this.syspropsMap.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public abstract void applyAction() throws SliderException;

    protected void bindCoreAction(AbstractActionArgs action) {
        this.coreAction = action;
        CommonArgs.splitPairs(this.coreAction.definitions, this.definitionMap);
        CommonArgs.splitPairs(this.coreAction.sysprops, this.syspropsMap);
    }

    public AbstractActionArgs getCoreAction() {
        return this.coreAction;
    }

    public void validate() throws BadCommandArgumentsException, UsageException {
        if (this.coreAction == null) {
            throw new UsageException("No action specified" + this.usage(), new Object[0]);
        }
        log.debug("action={}", (Object)this.getAction());
        try {
            this.coreAction.validate();
        }
        catch (BadCommandArgumentsException e) {
            StringBuilder badArgMsgBuilder = new StringBuilder();
            badArgMsgBuilder.append(e.toString()).append("\n");
            badArgMsgBuilder.append(CommonArgs.usage(this, this.coreAction.getActionName()));
            throw new BadCommandArgumentsException(badArgMsgBuilder.toString(), new Object[0]);
        }
        catch (UsageException e) {
            StringBuilder badArgMsgBuilder = new StringBuilder();
            badArgMsgBuilder.append(e.toString()).append("\n");
            badArgMsgBuilder.append(CommonArgs.usage(this, this.coreAction.getActionName()));
            throw new UsageException(badArgMsgBuilder.toString(), new Object[0]);
        }
    }

    public void applyDefinitions(Configuration conf) throws BadCommandArgumentsException {
        CommonArgs.applyDefinitions(this.definitionMap, conf);
    }

    public void applyFileSystemBinding(Configuration conf) {
        ArgOps.applyFileSystemBinding(this.getFilesystemBinding(), conf);
    }

    public boolean isDebug() {
        return this.coreAction.debug;
    }

    public String getFilesystemBinding() {
        return this.coreAction.filesystemBinding;
    }

    public Path getBasePath() {
        return this.coreAction.basePath;
    }

    public String getManager() {
        return this.coreAction.manager;
    }

    public String getAction() {
        return this.commander.getParsedCommand();
    }

    public List<String> getActionArgs() {
        return this.coreAction.parameters;
    }

    public String[] getArgs() {
        return this.args;
    }
}

