/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix4
extends MatrixSIS {
    private static final long serialVersionUID = 5685762518066856310L;
    public static final int SIZE = 4;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4() {
        this.m33 = 1.0;
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    Matrix4(boolean bl) {
    }

    public Matrix4(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public Matrix4(double[] dArray) throws IllegalArgumentException {
        this.setElements(dArray);
    }

    Matrix4(Matrix matrix) throws IllegalArgumentException {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    public static Matrix4 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix4) {
            return (Matrix4)matrix;
        }
        Matrix4.ensureSizeMatch(4, 4, matrix);
        return new Matrix4(matrix);
    }

    public final int getNumRow() {
        return 4;
    }

    public final int getNumCol() {
        return 4;
    }

    @Override
    public final double getElement(int n, int n2) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4) {
            switch (n * 4 + n2) {
                case 0: {
                    return this.m00;
                }
                case 1: {
                    return this.m01;
                }
                case 2: {
                    return this.m02;
                }
                case 3: {
                    return this.m03;
                }
                case 4: {
                    return this.m10;
                }
                case 5: {
                    return this.m11;
                }
                case 6: {
                    return this.m12;
                }
                case 7: {
                    return this.m13;
                }
                case 8: {
                    return this.m20;
                }
                case 9: {
                    return this.m21;
                }
                case 10: {
                    return this.m22;
                }
                case 11: {
                    return this.m23;
                }
                case 12: {
                    return this.m30;
                }
                case 13: {
                    return this.m31;
                }
                case 14: {
                    return this.m32;
                }
                case 15: {
                    return this.m33;
                }
            }
        }
        throw Matrix4.indexOutOfBounds(n, n2);
    }

    public final void setElement(int n, int n2, double d) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4) {
            switch (n * 4 + n2) {
                case 0: {
                    this.m00 = d;
                    return;
                }
                case 1: {
                    this.m01 = d;
                    return;
                }
                case 2: {
                    this.m02 = d;
                    return;
                }
                case 3: {
                    this.m03 = d;
                    return;
                }
                case 4: {
                    this.m10 = d;
                    return;
                }
                case 5: {
                    this.m11 = d;
                    return;
                }
                case 6: {
                    this.m12 = d;
                    return;
                }
                case 7: {
                    this.m13 = d;
                    return;
                }
                case 8: {
                    this.m20 = d;
                    return;
                }
                case 9: {
                    this.m21 = d;
                    return;
                }
                case 10: {
                    this.m22 = d;
                    return;
                }
                case 11: {
                    this.m23 = d;
                    return;
                }
                case 12: {
                    this.m30 = d;
                    return;
                }
                case 13: {
                    this.m31 = d;
                    return;
                }
                case 14: {
                    this.m32 = d;
                    return;
                }
                case 15: {
                    this.m33 = d;
                    return;
                }
            }
        }
        throw Matrix4.indexOutOfBounds(n, n2);
    }

    @Override
    public final double[] getElements() {
        double[] dArray = new double[16];
        this.getElements(dArray);
        return dArray;
    }

    @Override
    final void getElements(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m01;
        dArray[2] = this.m02;
        dArray[3] = this.m03;
        dArray[4] = this.m10;
        dArray[5] = this.m11;
        dArray[6] = this.m12;
        dArray[7] = this.m13;
        dArray[8] = this.m20;
        dArray[9] = this.m21;
        dArray[10] = this.m22;
        dArray[11] = this.m23;
        dArray[12] = this.m30;
        dArray[13] = this.m31;
        dArray[14] = this.m32;
        dArray[15] = this.m33;
    }

    @Override
    public final void setElements(double[] dArray) {
        Matrix4.ensureLengthMatch(16, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m03 = dArray[3];
        this.m10 = dArray[4];
        this.m11 = dArray[5];
        this.m12 = dArray[6];
        this.m13 = dArray[7];
        this.m20 = dArray[8];
        this.m21 = dArray[9];
        this.m22 = dArray[10];
        this.m23 = dArray[11];
        this.m30 = dArray[12];
        this.m31 = dArray[13];
        this.m32 = dArray[14];
        this.m33 = dArray[15];
    }

    @Override
    public final boolean isAffine() {
        return this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m03 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m13 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && this.m23 == 0.0 && this.isAffine();
    }

    @Override
    public void transpose() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m03;
        this.m03 = this.m30;
        this.m30 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
        d = this.m13;
        this.m13 = this.m31;
        this.m31 = d;
        d = this.m23;
        this.m23 = this.m32;
        this.m32 = d;
    }
}

