/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOUnion
extends LogicalRelationalOperator {
    private boolean onSchema;
    private List<Pair<Long, Long>> uidMapping = new ArrayList<Pair<Long, Long>>();

    public LOUnion(OperatorPlan plan) {
        super("LOUnion", plan);
    }

    public LOUnion(OperatorPlan plan, boolean onSchema) {
        this(plan);
        this.onSchema = onSchema;
    }

    public boolean isOnSchema() {
        return this.onSchema;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        List<Operator> inputs = this.plan.getPredecessors(this);
        for (Operator input : inputs) {
            LogicalRelationalOperator op = (LogicalRelationalOperator)input;
            if (op.getSchema() != null) continue;
            if (this.isOnSchema()) {
                String msg = "Schema of relation " + op.getAlias() + " is null." + " UNION ONSCHEMA cannot be used with relations that" + " have null schema.";
                throw new FrontendException((Operator)this, msg, 1116, 2);
            }
            return null;
        }
        LogicalSchema mergedSchema = null;
        if (inputs.size() == 1) {
            this.schema = ((LogicalRelationalOperator)inputs.get(0)).getSchema();
            return this.schema;
        }
        ArrayList<String> inputAliases = new ArrayList<String>(inputs.size());
        ArrayList<LogicalSchema> inputSchemas = new ArrayList<LogicalSchema>(inputs.size());
        for (Operator input : inputs) {
            LogicalRelationalOperator lop = (LogicalRelationalOperator)input;
            inputAliases.add(lop.getAlias());
            inputSchemas.add(lop.getSchema());
        }
        if (this.isOnSchema()) {
            mergedSchema = this.createMergedSchemaOnAlias(inputSchemas, inputAliases);
        } else {
            LogicalSchema s1;
            LogicalSchema s0 = (LogicalSchema)inputSchemas.get(0);
            mergedSchema = LogicalSchema.merge(s0, s1 = (LogicalSchema)inputSchemas.get(1), LogicalSchema.MergeMode.Union);
            if (mergedSchema == null) {
                return null;
            }
            for (int i = 2; i < inputSchemas.size(); ++i) {
                LogicalSchema otherSchema = (LogicalSchema)inputSchemas.get(i);
                if (mergedSchema == null || otherSchema == null) {
                    return null;
                }
                if ((mergedSchema = LogicalSchema.merge(mergedSchema, otherSchema, LogicalSchema.MergeMode.Union)) != null) continue;
                return null;
            }
        }
        for (int i = 0; i < mergedSchema.size(); ++i) {
            LogicalSchema.LogicalFieldSchema outputFieldSchema = mergedSchema.getField(i);
            long uid = -1L;
            for (LogicalSchema inputSchema : inputSchemas) {
                LogicalSchema.LogicalFieldSchema inputFieldSchema = this.onSchema ? inputSchema.getFieldSubNameMatch(outputFieldSchema.alias) : inputSchema.getField(i);
                if (inputFieldSchema == null || (uid = this.getCachedOuputUid(inputFieldSchema.uid)) < 0L) continue;
                break;
            }
            if (uid == -1L) {
                uid = LogicalExpression.getNextUid();
                for (LogicalSchema inputSchema : inputSchemas) {
                    LogicalSchema.LogicalFieldSchema matchedInputFieldSchema;
                    if (this.onSchema) {
                        matchedInputFieldSchema = inputSchema.getFieldSubNameMatch(mergedSchema.getField((int)i).alias);
                        if (matchedInputFieldSchema == null) continue;
                        long inputUid = matchedInputFieldSchema.uid;
                        this.uidMapping.add(new Pair<Long, Long>(uid, inputUid));
                        continue;
                    }
                    matchedInputFieldSchema = mergedSchema.getField(i);
                    long inputUid = inputSchema.getField((int)i).uid;
                    this.uidMapping.add(new Pair<Long, Long>(uid, inputUid));
                }
            }
            outputFieldSchema.uid = uid;
        }
        this.schema = mergedSchema;
        return this.schema;
    }

    private LogicalSchema createMergedSchemaOnAlias(List<LogicalSchema> inputSchemas, List<String> inputAliases) throws FrontendException {
        ArrayList<LogicalSchema> schemas = new ArrayList<LogicalSchema>();
        for (int i = 0; i < inputSchemas.size(); ++i) {
            LogicalSchema sch = inputSchemas.get(i);
            for (LogicalSchema.LogicalFieldSchema fs : sch.getFields()) {
                if (fs.alias != null) continue;
                String msg = "Schema of relation " + inputAliases.get(i) + " has a null fieldschema for column(s). Schema :" + sch.toString(false);
                throw new FrontendException((Operator)this, msg, 1116, 2);
            }
            schemas.add(sch);
        }
        LogicalSchema mergedSchema = null;
        try {
            mergedSchema = LogicalSchema.mergeSchemasByAlias(schemas);
        }
        catch (FrontendException e) {
            String msg = "Error merging schemas for union operator : " + e.getMessage();
            throw new FrontendException(this, msg, 1116, 2, e);
        }
        return mergedSchema;
    }

    private long getCachedOuputUid(long inputUid) {
        long uid = -1L;
        for (Pair<Long, Long> pair : this.uidMapping) {
            if ((Long)pair.second != inputUid) continue;
            uid = (Long)pair.first;
            break;
        }
        return uid;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOUnion) {
            return this.checkEquality((LOUnion)other);
        }
        return false;
    }

    public Set<Long> getInputUids(long uid) {
        HashSet<Long> result = new HashSet<Long>();
        for (Pair<Long, Long> pair : this.uidMapping) {
            if ((Long)pair.first != uid) continue;
            result.add((Long)pair.second);
        }
        return result;
    }

    @Override
    public void resetUid() {
        this.uidMapping = new ArrayList<Pair<Long, Long>>();
    }

    public List<Operator> getInputs() {
        return this.plan.getPredecessors(this);
    }

    public List<Operator> getInputs(LogicalPlan plan) {
        return plan.getPredecessors(this);
    }

    public void setUnionOnSchema(boolean flag) {
        this.onSchema = flag;
    }
}

