/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.ArrayList;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class PORelationToExprProject
extends POProject {
    private static final long serialVersionUID = 1L;
    boolean sendEmptyBagOnEOP = false;

    public PORelationToExprProject(OperatorKey k) {
        this(k, -1, 0);
    }

    public PORelationToExprProject(OperatorKey k, int rp) {
        this(k, rp, 0);
    }

    public PORelationToExprProject(OperatorKey k, int rp, int col) {
        super(k, rp, col);
    }

    public PORelationToExprProject(OperatorKey k, int rp, ArrayList<Integer> cols) {
        super(k, rp, cols);
    }

    @Override
    public String name() {
        return "RelationToExpressionProject[" + DataType.findTypeName(this.resultType) + "]" + (this.isStar() ? "[*]" : this.columns) + " - " + this.mKey.toString();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitProject(this);
    }

    @Override
    public void reset() {
        this.sendEmptyBagOnEOP = true;
    }

    @Override
    public Result getNextDataBag() throws ExecException {
        Result input = this.processInputBag();
        if (this.isAccumulative()) {
            this.reset();
        }
        if (input.returnStatus != 0) {
            if (input.returnStatus == 1) {
                return input;
            }
            if (input.returnStatus == 3 && this.sendEmptyBagOnEOP) {
                input.result = new NonSpillableDataBag();
                input.returnStatus = 0;
            } else {
                this.sendEmptyBagOnEOP = false;
                return input;
            }
        }
        Result r = this.consumeInputBag(input);
        this.sendEmptyBagOnEOP = false;
        return r;
    }

    @Override
    public PORelationToExprProject clone() throws CloneNotSupportedException {
        return (PORelationToExprProject)super.clone();
    }
}

