/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.impl.io.NullableText;
import org.apache.pig.impl.util.ObjectSerializer;

public class PigTextRawComparator
extends WritableComparator
implements Configurable {
    private final Log mLog = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean[] mAsc;
    private Text.Comparator mWrappedComp = new Text.Comparator();

    public PigTextRawComparator() {
        super(NullableText.class);
    }

    public void setConf(Configuration conf) {
        try {
            this.mAsc = (boolean[])ObjectSerializer.deserialize(conf.get("pig.sortOrder"));
        }
        catch (IOException ioe) {
            String msg = "Unable to deserialize pig.sortOrder";
            throw new RuntimeException(msg, ioe);
        }
        if (this.mAsc == null) {
            this.mAsc = new boolean[1];
            this.mAsc[0] = true;
        }
    }

    public Configuration getConf() {
        return null;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int rc = 0;
        rc = b1[s1] == 0 && b2[s2] == 0 ? this.mWrappedComp.compare(b1, s1 + 1, l1 - 2, b2, s2 + 1, l2 - 2) : (b1[s1] != 0 && b2[s2] != 0 ? 0 : (b1[s1] != 0 ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }

    public int compare(Object o1, Object o2) {
        NullableText nt1 = (NullableText)o1;
        NullableText nt2 = (NullableText)o2;
        int rc = 0;
        rc = !nt1.isNull() && !nt2.isNull() ? ((String)nt1.getValueAsPigType()).compareTo((String)nt2.getValueAsPigType()) : (nt1.isNull() && nt2.isNull() ? 0 : (nt1.isNull() ? -1 : 1));
        if (!this.mAsc[0]) {
            rc *= -1;
        }
        return rc;
    }
}

