/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.groovy;

import groovy.lang.Tuple;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;

public class GroovyUtils {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final BagFactory bagFactory = BagFactory.getInstance();

    public static Object groovyToPig(Object groovyObject) throws ExecException {
        Serializable pigObject = null;
        if (groovyObject instanceof Object[] || groovyObject instanceof Tuple) {
            ArrayList<Object> pigObjects = new ArrayList<Object>();
            if (groovyObject instanceof Object[]) {
                for (Object o : (Object[])groovyObject) {
                    pigObjects.add(GroovyUtils.groovyToPig(o));
                }
            } else {
                for (Object o : (Iterable)((Object)groovyObject)) {
                    pigObjects.add(GroovyUtils.groovyToPig(o));
                }
            }
            pigObject = tupleFactory.newTuple(pigObjects);
        } else if (groovyObject instanceof org.apache.pig.data.Tuple || groovyObject instanceof DataBag) {
            pigObject = groovyObject;
        } else if (groovyObject instanceof Map) {
            HashMap<String, Object> pigMap = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)groovyObject).entrySet()) {
                pigMap.put(GroovyUtils.groovyToPig(entry.getKey()).toString(), GroovyUtils.groovyToPig(entry.getValue()));
            }
            pigObject = pigMap;
        } else if (groovyObject instanceof List) {
            DataBag bag = bagFactory.newDefaultBag();
            for (Object o : (List)((Object)groovyObject)) {
                Object p = GroovyUtils.groovyToPig(o);
                if (p instanceof org.apache.pig.data.Tuple || null == p) {
                    bag.add((org.apache.pig.data.Tuple)p);
                    continue;
                }
                bag.add(tupleFactory.newTuple(p));
            }
            pigObject = bag;
        } else if (groovyObject instanceof Integer || groovyObject instanceof Long || groovyObject instanceof Float || groovyObject instanceof Double) {
            pigObject = groovyObject;
        } else if (groovyObject instanceof Byte || groovyObject instanceof Short) {
            pigObject = ((Number)((Object)groovyObject)).intValue();
        } else if (groovyObject instanceof BigInteger) {
            pigObject = ((Number)((Object)groovyObject)).longValue();
        } else if (groovyObject instanceof BigDecimal) {
            pigObject = ((Number)((Object)groovyObject)).doubleValue();
        } else if (groovyObject instanceof byte[]) {
            byte[] b = new byte[((byte[])groovyObject).length];
            System.arraycopy((byte[])groovyObject, 0, b, 0, b.length);
            pigObject = new DataByteArray(b);
        } else if (groovyObject instanceof String) {
            pigObject = groovyObject;
        } else if (groovyObject instanceof Boolean) {
            pigObject = groovyObject;
        } else if (null == groovyObject) {
            pigObject = null;
        } else {
            throw new ExecException("Unable to cast " + groovyObject.getClass().getName() + " to a Pig datatype.");
        }
        return pigObject;
    }

    public static Object pigToGroovy(Object pigObject) throws ExecException {
        Object groovyObject = null;
        if (pigObject instanceof org.apache.pig.data.Tuple) {
            Object[] a = new Object[((org.apache.pig.data.Tuple)pigObject).size()];
            int i = 0;
            for (Object oo : ((org.apache.pig.data.Tuple)pigObject).getAll()) {
                a[i++] = GroovyUtils.pigToGroovy(oo);
            }
            groovyObject = new Tuple(a);
        } else if (pigObject instanceof DataBag) {
            Object[] size_iterator = new Object[]{((DataBag)pigObject).size(), new DataBagGroovyIterator(((DataBag)pigObject).iterator())};
            groovyObject = new Tuple(size_iterator);
        } else if (pigObject instanceof Map) {
            Tuple m = new HashMap();
            for (Map.Entry entry : ((Map)pigObject).entrySet()) {
                m.put((String)GroovyUtils.pigToGroovy(entry.getKey()), GroovyUtils.pigToGroovy(entry.getValue()));
            }
            groovyObject = m;
        } else if (pigObject instanceof Number || pigObject instanceof String || pigObject instanceof Boolean) {
            groovyObject = pigObject;
        } else if (pigObject instanceof DataByteArray) {
            byte[] b = new byte[((DataByteArray)pigObject).size()];
            System.arraycopy(((DataByteArray)pigObject).get(), 0, b, 0, b.length);
            groovyObject = b;
        } else if (null == pigObject) {
            groovyObject = null;
        } else {
            throw new ExecException("Unable to cast pig datatype " + pigObject.getClass().getName() + " to a suitable Groovy Object.");
        }
        return groovyObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataBagGroovyIterator
    implements Iterator<Tuple> {
        private final Iterator<org.apache.pig.data.Tuple> iter;

        public DataBagGroovyIterator(Iterator<org.apache.pig.data.Tuple> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Tuple next() {
            try {
                return (Tuple)GroovyUtils.pigToGroovy(this.iter.next());
            }
            catch (ExecException ee) {
                throw new RuntimeException(ee);
            }
        }

        @Override
        public void remove() {
        }
    }
}

