/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.relational.SchemaNotDefinedException;
import org.apache.pig.newplan.logical.rules.OptimizerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnPruneHelper {
    protected static final String INPUTUIDS = "ColumnPrune:InputUids";
    public static final String OUTPUTUIDS = "ColumnPrune:OutputUids";
    protected static final String REQUIREDCOLS = "ColumnPrune:RequiredColumns";
    private OperatorPlan currentPlan;
    private OperatorSubPlan subPlan;

    public ColumnPruneHelper(OperatorPlan currentPlan) {
        this.currentPlan = currentPlan;
    }

    private OperatorSubPlan getSubPlan() throws FrontendException {
        OperatorSubPlan p = null;
        p = this.currentPlan instanceof OperatorSubPlan ? new OperatorSubPlan(((OperatorSubPlan)this.currentPlan).getBasePlan()) : new OperatorSubPlan(this.currentPlan);
        Iterator<Operator> iter = this.currentPlan.getOperators();
        while (iter.hasNext()) {
            Operator op = iter.next();
            if (!(op instanceof LOForEach)) continue;
            this.addOperator(op, p);
        }
        return p;
    }

    private void addOperator(Operator op, OperatorSubPlan subplan) throws FrontendException {
        if (op == null) {
            return;
        }
        subplan.add(op);
        List<Operator> ll = this.currentPlan.getPredecessors(op);
        if (ll == null) {
            return;
        }
        for (Operator pred : ll) {
            this.addOperator(pred, subplan);
        }
    }

    public boolean check() throws FrontendException {
        List<Operator> sources = this.currentPlan.getSources();
        if (sources.size() > 1 && sources.get(0).getAnnotation(INPUTUIDS) != null) {
            this.clearAnnotation();
            return false;
        }
        this.subPlan = this.getSubPlan();
        if (this.subPlan.size() == 0) {
            this.clearAnnotation();
            return false;
        }
        ColumnDependencyVisitor v = new ColumnDependencyVisitor(this.currentPlan);
        try {
            v.visit();
        }
        catch (SchemaNotDefinedException e) {
            this.clearAnnotation();
            return false;
        }
        List<Operator> ll = this.subPlan.getSources();
        boolean found = false;
        for (Operator op : ll) {
            if (!(op instanceof LOLoad)) continue;
            Set uids = (Set)op.getAnnotation(INPUTUIDS);
            LogicalSchema s = ((LOLoad)op).getSchema();
            Set<Integer> required = this.getColumns(s, uids);
            if (required.size() >= s.size()) continue;
            op.annotate(REQUIREDCOLS, required);
            found = true;
        }
        if (!found) {
            this.clearAnnotation();
        }
        return found;
    }

    private void clearAnnotation() {
        Iterator<Operator> iter = this.currentPlan.getOperators();
        while (iter.hasNext()) {
            Operator op = iter.next();
            op.removeAnnotation(INPUTUIDS);
            op.removeAnnotation(OUTPUTUIDS);
            op.removeAnnotation(REQUIREDCOLS);
        }
    }

    protected Set<Integer> getColumns(LogicalSchema schema, Set<Long> uids) throws FrontendException {
        if (schema == null) {
            throw new SchemaNotDefinedException("Schema is not defined.");
        }
        HashSet<Integer> cols = new HashSet<Integer>();
        for (long uid : uids) {
            int index = schema.findField(uid);
            if (index == -1) {
                throw new FrontendException("UID " + uid + " is not found in the schema " + schema, 2241);
            }
            cols.add(index);
        }
        return cols;
    }

    public OperatorPlan reportChanges() {
        return this.subPlan;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDependencyVisitor
    extends LogicalRelationalNodesVisitor {
        public ColumnDependencyVisitor(OperatorPlan plan) throws FrontendException {
            super(plan, new ReverseDependencyOrderWalker(plan));
        }

        @Override
        public void visit(LOLoad load) throws FrontendException {
            Set<Long> output = this.setOutputUids(load);
            load.annotate(ColumnPruneHelper.INPUTUIDS, output);
        }

        @Override
        public void visit(LOFilter filter) throws FrontendException {
            Set<Long> output = this.setOutputUids(filter);
            HashSet<Long> input = new HashSet<Long>(output);
            LogicalExpressionPlan exp = filter.getFilterPlan();
            this.collectUids(filter, exp, input);
            filter.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOStore store) throws FrontendException {
            Set<Long> output = this.setOutputUids(store);
            if (output.isEmpty()) {
                LogicalSchema s = store.getSchema();
                if (s == null) {
                    throw new SchemaNotDefinedException("Schema for " + store.getName() + " is not defined.");
                }
                for (int i = 0; i < s.size(); ++i) {
                    output.add(s.getField((int)i).uid);
                }
            }
            store.annotate(ColumnPruneHelper.INPUTUIDS, output);
        }

        @Override
        public void visit(LOJoin join) throws FrontendException {
            Set<Long> output = this.setOutputUids(join);
            HashSet<Long> input = new HashSet<Long>(output);
            Collection<LogicalExpressionPlan> exps = join.getExpressionPlanValues();
            for (LogicalExpressionPlan exp : exps) {
                this.collectUids(join, exp, input);
            }
            join.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOCogroup cg) throws FrontendException {
            Set<Long> output = this.setOutputUids(cg);
            HashSet<Long> input = new HashSet<Long>();
            for (LogicalExpressionPlan plan : cg.getExpressionPlans().values()) {
                this.collectUids(cg, plan, input);
            }
            long firstUid = -1L;
            Map<Integer, Long> generatedInputUids = cg.getGeneratedInputUids();
            for (Map.Entry<Integer, Long> entry : generatedInputUids.entrySet()) {
                Long uid = entry.getValue();
                LogicalRelationalOperator pred = (LogicalRelationalOperator)cg.getPlan().getPredecessors(cg).get(entry.getKey());
                if (output.contains(uid)) {
                    input.addAll(this.getAllUids(pred.getSchema()));
                }
                if (pred.getSchema() == null) continue;
                firstUid = pred.getSchema().getField((int)0).uid;
            }
            if (input.isEmpty() && firstUid != -1L) {
                input.add(firstUid);
            }
            cg.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOLimit limit) throws FrontendException {
            Set<Long> output = this.setOutputUids(limit);
            HashSet<Long> input = new HashSet<Long>(output);
            LogicalExpressionPlan exp = limit.getLimitPlan();
            if (exp != null) {
                this.collectUids(limit, exp, input);
            }
            limit.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOStream stream) throws FrontendException {
            Set<Long> output = this.setOutputUids(stream);
            LogicalRelationalOperator pred = (LogicalRelationalOperator)this.plan.getPredecessors(stream).get(0);
            Set<Long> input = this.getAllUids(pred.getSchema());
            stream.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LODistinct distinct) throws FrontendException {
            HashSet<Long> input = new HashSet<Long>();
            LogicalSchema s = distinct.getSchema();
            if (s == null) {
                throw new SchemaNotDefinedException("Schema for " + distinct.getName() + " is not defined.");
            }
            for (int i = 0; i < s.size(); ++i) {
                input.add(s.getField((int)i).uid);
            }
            distinct.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOCross cross) throws FrontendException {
            Set<Long> output = this.setOutputUids(cross);
            List<Operator> preds = this.plan.getPredecessors(cross);
            for (Operator pred : preds) {
                LogicalSchema schema = ((LogicalRelationalOperator)pred).getSchema();
                Set<Long> uids = this.getAllUids(schema);
                boolean allPruned = true;
                for (Long uid : uids) {
                    if (!output.contains(uid)) continue;
                    allPruned = false;
                }
                if (!allPruned) continue;
                output.add(schema.getField((int)0).uid);
            }
            cross.annotate(ColumnPruneHelper.INPUTUIDS, output);
        }

        @Override
        public void visit(LOUnion union) throws FrontendException {
            Set<Long> output = this.setOutputUids(union);
            HashSet<Long> input = new HashSet<Long>();
            for (long uid : output) {
                input.addAll(union.getInputUids(uid));
            }
            union.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOSplit split) throws FrontendException {
            Set<Long> output = this.setOutputUids(split);
            split.annotate(ColumnPruneHelper.INPUTUIDS, output);
        }

        @Override
        public void visit(LOSplitOutput splitOutput) throws FrontendException {
            Set<Long> output = this.setOutputUids(splitOutput);
            HashSet<Long> input = new HashSet<Long>();
            for (long uid : output) {
                input.add(splitOutput.getInputUids(uid));
            }
            LogicalExpressionPlan exp = splitOutput.getFilterPlan();
            this.collectUids(splitOutput, exp, input);
            splitOutput.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOSort sort) throws FrontendException {
            Set<Long> output = this.setOutputUids(sort);
            HashSet<Long> input = new HashSet<Long>(output);
            for (LogicalExpressionPlan exp : sort.getSortColPlans()) {
                this.collectUids(sort, exp, input);
            }
            sort.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LORank rank) throws FrontendException {
            Set<Long> output = this.setOutputUids(rank);
            HashSet<Long> input = new HashSet<Long>(output);
            for (LogicalExpressionPlan exp : rank.getRankColPlans()) {
                this.collectUids(rank, exp, input);
            }
            rank.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        private Set<Long> getAllUids(LogicalSchema schema) {
            HashSet<Long> uids = new HashSet<Long>();
            if (schema == null) {
                return uids;
            }
            for (LogicalSchema.LogicalFieldSchema field : schema.getFields()) {
                if ((field.type == 110 || field.type == 120) && field.schema != null) {
                    uids.addAll(this.getAllUids(field.schema));
                }
                uids.add(field.uid);
            }
            return uids;
        }

        @Override
        public void visit(LOForEach foreach) throws FrontendException {
            LogicalRelationalOperator pred;
            Set<Long> output = this.setOutputUids(foreach);
            LOGenerate gen = OptimizerUtils.findGenerate(foreach);
            gen.annotate(ColumnPruneHelper.OUTPUTUIDS, output);
            this.visit(gen);
            Set input = (Set)gen.getAnnotation(ColumnPruneHelper.INPUTUIDS);
            if (input.isEmpty() && (pred = (LogicalRelationalOperator)this.plan.getPredecessors(foreach).get(0)).getSchema() != null) {
                input.add(pred.getSchema().getField((int)0).uid);
            }
            foreach.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOGenerate gen) throws FrontendException {
            Set output = (Set)gen.getAnnotation(ColumnPruneHelper.OUTPUTUIDS);
            HashSet<Long> input = new HashSet<Long>();
            List<LogicalExpressionPlan> ll = gen.getOutputPlans();
            Iterator iter = output.iterator();
            while (iter.hasNext()) {
                long uid = (Long)iter.next();
                for (int i = 0; i < ll.size(); ++i) {
                    LogicalExpressionPlan exp = ll.get(i);
                    boolean found = false;
                    LogicalSchema planSchema = gen.getOutputPlanSchemas().get(i);
                    for (LogicalSchema.LogicalFieldSchema fs : planSchema.getFields()) {
                        if (fs.uid != uid) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    List<Operator> srcs = exp.getSinks();
                    for (Operator src : srcs) {
                        if (!(src instanceof ProjectExpression)) continue;
                        List innerLoads = (List)LOForEach.findReacheableInnerLoadFromBoundaryProject((ProjectExpression)((ProjectExpression)src)).first;
                        for (LOInnerLoad innerLoad : innerLoads) {
                            ProjectExpression prj = innerLoad.getProjection();
                            if (prj.isProjectStar()) {
                                if (prj.findReferent().getSchema() == null) continue;
                                for (LogicalSchema.LogicalFieldSchema fs : prj.findReferent().getSchema().getFields()) {
                                    input.add(fs.uid);
                                }
                                continue;
                            }
                            if (prj.findReferent().getSchema() == null) continue;
                            LogicalSchema.LogicalFieldSchema fs = prj.findReferent().getSchema().getField(prj.getColNum());
                            input.add(fs.uid);
                        }
                    }
                }
            }
            for (int i = 0; i < ll.size(); ++i) {
                if (!gen.getFlattenFlags()[i]) continue;
                LogicalExpressionPlan exp = ll.get(i);
                LogicalExpression sink = (LogicalExpression)exp.getSources().get(0);
                if (sink.getFieldSchema().type != 110 && sink.getFieldSchema().type != 120) continue;
                List<Operator> srcs = exp.getSinks();
                for (Operator src : srcs) {
                    if (!(src instanceof ProjectExpression)) continue;
                    List innerLoads = (List)LOForEach.findReacheableInnerLoadFromBoundaryProject((ProjectExpression)((ProjectExpression)src)).first;
                    for (LOInnerLoad innerLoad : innerLoads) {
                        ProjectExpression prj = innerLoad.getProjection();
                        if (prj.isProjectStar()) {
                            if (prj.findReferent().getSchema() == null) continue;
                            for (LogicalSchema.LogicalFieldSchema fs : prj.findReferent().getSchema().getFields()) {
                                input.add(fs.uid);
                            }
                            continue;
                        }
                        if (prj.findReferent().getSchema() == null) continue;
                        LogicalSchema.LogicalFieldSchema fs = prj.findReferent().getSchema().getField(prj.getColNum());
                        input.add(fs.uid);
                    }
                }
            }
            gen.annotate(ColumnPruneHelper.INPUTUIDS, input);
        }

        @Override
        public void visit(LOInnerLoad load) throws FrontendException {
            Set<Long> output = this.setOutputUids(load);
            load.annotate(ColumnPruneHelper.INPUTUIDS, output);
        }

        private void collectUids(LogicalRelationalOperator currentOp, LogicalExpressionPlan exp, Set<Long> uids) throws FrontendException {
            List<Operator> ll = exp.getSinks();
            for (Operator op : ll) {
                if (!(op instanceof ProjectExpression)) continue;
                if (!((ProjectExpression)op).isRangeOrStarProject()) {
                    long uid = ((ProjectExpression)op).getFieldSchema().uid;
                    uids.add(uid);
                    continue;
                }
                LogicalRelationalOperator ref = ((ProjectExpression)op).findReferent();
                LogicalSchema s = ref.getSchema();
                if (s == null) {
                    throw new SchemaNotDefinedException("Schema not defined for " + ref.getAlias());
                }
                for (LogicalSchema.LogicalFieldSchema f : s.getFields()) {
                    uids.add(f.uid);
                }
            }
        }

        private Set<Long> setOutputUids(LogicalRelationalOperator op) throws FrontendException {
            List<Operator> ll = this.plan.getSuccessors(op);
            HashSet<Long> uids = new HashSet<Long>();
            LogicalSchema s = op.getSchema();
            if (s == null) {
                throw new SchemaNotDefinedException("Schema for " + op.getName() + " is not defined.");
            }
            if (ll != null) {
                for (Operator succ : ll) {
                    Set inputUids = (Set)succ.getAnnotation(ColumnPruneHelper.INPUTUIDS);
                    if (inputUids == null) continue;
                    Iterator iter = inputUids.iterator();
                    while (iter.hasNext()) {
                        long uid = (Long)iter.next();
                        if (s.findField(uid) == -1) continue;
                        uids.add(uid);
                    }
                }
            } else {
                for (int i = 0; i < s.size(); ++i) {
                    uids.add(s.getField((int)i).uid);
                }
            }
            op.annotate(ColumnPruneHelper.OUTPUTUIDS, uids);
            return uids;
        }
    }
}

