/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.streaming.ExecutableManager;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOStream
extends LogicalRelationalOperator {
    private LogicalSchema scriptSchema;
    private static final long serialVersionUID = 2L;
    private StreamingCommand command;
    private transient ExecutableManager executableManager;
    private LogicalSchema uidOnlySchema;
    private boolean castInserted = false;

    public LOStream(LogicalPlan plan, ExecutableManager exeManager, StreamingCommand cmd, LogicalSchema schema) {
        super("LOStream", plan);
        this.command = cmd;
        this.executableManager = exeManager;
        this.scriptSchema = schema;
    }

    public StreamingCommand getStreamingCommand() {
        return this.command;
    }

    public ExecutableManager getExecutableManager() {
        return this.executableManager;
    }

    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.isCastInserted()) {
            this.schema = new LogicalSchema();
            for (int i = 0; i < this.scriptSchema.size(); ++i) {
                LogicalSchema.LogicalFieldSchema fs = this.scriptSchema.getField(i).deepCopy();
                fs.type = (byte)50;
                this.schema.addField(fs);
            }
        } else if (this.scriptSchema != null) {
            this.schema = this.scriptSchema.deepCopy();
        }
        if (this.schema != null) {
            this.uidOnlySchema = this.schema.mergeUid(this.uidOnlySchema);
        }
        return this.schema;
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOStream) {
            return this.checkEquality((LogicalRelationalOperator)other);
        }
        return false;
    }

    public void setCastInserted(boolean flag) {
        this.castInserted = flag;
    }

    public boolean isCastInserted() {
        return this.castInserted;
    }

    public void resetUid() {
        this.uidOnlySchema = null;
    }

    public LogicalSchema getScriptSchema() {
        return this.scriptSchema;
    }
}

