/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.optimizer.ProjectionPatcher;
import org.apache.pig.newplan.logical.optimizer.SchemaPatcher;
import org.apache.pig.newplan.logical.rules.AddForEach;
import org.apache.pig.newplan.logical.rules.ColumnMapKeyPrune;
import org.apache.pig.newplan.logical.rules.DuplicateForEachColumnRewrite;
import org.apache.pig.newplan.logical.rules.FilterAboveForeach;
import org.apache.pig.newplan.logical.rules.GroupByConstParallelSetter;
import org.apache.pig.newplan.logical.rules.ImplicitSplitInserter;
import org.apache.pig.newplan.logical.rules.LimitOptimizer;
import org.apache.pig.newplan.logical.rules.LoadTypeCastInserter;
import org.apache.pig.newplan.logical.rules.LogicalExpressionSimplifier;
import org.apache.pig.newplan.logical.rules.MergeFilter;
import org.apache.pig.newplan.logical.rules.MergeForEach;
import org.apache.pig.newplan.logical.rules.PartitionFilterOptimizer;
import org.apache.pig.newplan.logical.rules.PushDownForEachFlatten;
import org.apache.pig.newplan.logical.rules.PushUpFilter;
import org.apache.pig.newplan.logical.rules.SplitFilter;
import org.apache.pig.newplan.logical.rules.StreamTypeCastInserter;
import org.apache.pig.newplan.optimizer.PlanOptimizer;
import org.apache.pig.newplan.optimizer.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlanOptimizer
extends PlanOptimizer {
    private Set<String> mRulesOff = null;

    public LogicalPlanOptimizer(OperatorPlan p, int iterations, Set<String> turnOffRules) {
        super(p, null, iterations);
        this.mRulesOff = turnOffRules;
        this.ruleSets = this.buildRuleSets();
        this.addListeners();
    }

    protected List<Set<Rule>> buildRuleSets() {
        ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
        HashSet<Rule> s = new HashSet<Rule>();
        Rule r = new ImplicitSplitInserter("ImplicitSplitInserter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new DuplicateForEachColumnRewrite("DuplicateForEachColumnRewrite");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new LogicalExpressionSimplifier("FilterLogicExpressionSimplifier");
        this.checkAndAddRule(s, r);
        ls.add(s);
        s = new HashSet();
        r = new LoadTypeCastInserter("LoadTypeCastInserter");
        this.checkAndAddRule(s, r);
        r = new StreamTypeCastInserter("StreamTypeCastInserter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new LimitOptimizer("LimitOptimizer");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new SplitFilter("SplitFilter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PushUpFilter("PushUpFilter");
        this.checkAndAddRule(s, r);
        r = new FilterAboveForeach("PushUpFilter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        this.checkAndAddRule(s, r);
        r = new MergeFilter("MergeFilter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PartitionFilterOptimizer("PartitionFilterOptimizer");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new PushDownForEachFlatten("PushDownForEachFlatten");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new ColumnMapKeyPrune("ColumnMapKeyPrune");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new AddForEach("AddForEach");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new MergeForEach("MergeForEach");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        s = new HashSet();
        r = new GroupByConstParallelSetter("GroupByConstParallelSetter");
        this.checkAndAddRule(s, r);
        if (!s.isEmpty()) {
            ls.add(s);
        }
        return ls;
    }

    private void checkAndAddRule(Set<Rule> ruleSet, Rule rule) {
        if (rule.isMandatory()) {
            ruleSet.add(rule);
            return;
        }
        boolean turnAllRulesOff = false;
        if (this.mRulesOff != null) {
            for (String ruleName : this.mRulesOff) {
                if (!"all".equalsIgnoreCase(ruleName)) continue;
                turnAllRulesOff = true;
                break;
            }
        }
        if (turnAllRulesOff) {
            return;
        }
        if (this.mRulesOff != null) {
            for (String ruleOff : this.mRulesOff) {
                String ruleName = rule.getName();
                if (ruleName == null || !ruleName.equalsIgnoreCase(ruleOff)) continue;
                return;
            }
        }
        ruleSet.add(rule);
    }

    private void addListeners() {
        this.addPlanTransformListener(new SchemaPatcher());
        this.addPlanTransformListener(new ProjectionPatcher());
    }
}

