/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.SortInfo;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReducePOStoreImpl;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStoreImpl;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.LineageTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POStore
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private static Result empty = new Result(1, null);
    private transient StoreFuncInterface storer;
    private transient POStoreImpl impl;
    private FileSpec sFile;
    private Schema schema;
    private transient Counter outputRecordCounter = null;
    private boolean isTmpStore;
    private boolean isMultiStore;
    private boolean disableCounter = false;
    private int index;
    private FileSpec lFile;
    private SortInfo sortInfo;
    private String signature;

    public POStore(OperatorKey k) {
        this(k, -1, null);
    }

    public POStore(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POStore(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public void setUp() throws IOException {
        if (this.impl != null) {
            try {
                this.storer = this.impl.createStoreFunc(this);
                if (!this.isTmpStore && !this.disableCounter && this.impl instanceof MapReducePOStoreImpl) {
                    this.outputRecordCounter = ((MapReducePOStoreImpl)this.impl).createRecordCounter(this);
                }
            }
            catch (IOException ioe) {
                int errCode = 2081;
                String msg = "Unable to setup the store function.";
                throw new ExecException(msg, errCode, 4, ioe);
            }
        }
    }

    public void tearDown() throws IOException {
        if (this.impl != null) {
            this.impl.tearDown();
        }
    }

    public void cleanUp() throws IOException {
        if (this.impl != null) {
            this.impl.cleanUp();
        }
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result res = this.processInput();
        try {
            switch (res.returnStatus) {
                case 0: {
                    if (this.illustrator == null) {
                        this.storer.putNext((Tuple)res.result);
                    } else {
                        this.illustratorMarkup(res.result, res.result, 0);
                    }
                    res = empty;
                    if (this.outputRecordCounter == null) break;
                    this.outputRecordCounter.increment(1L);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        catch (IOException ioe) {
            int errCode = 2135;
            String msg = "Received error from store function." + ioe.getMessage();
            throw new ExecException(msg, errCode, ioe);
        }
        return res;
    }

    @Override
    public String name() {
        return this.sFile != null ? this.getAliasString() + "Store" + "(" + this.sFile.toString() + ")" + " - " + this.mKey.toString() : this.getAliasString() + "Store" + "(" + "DummyFil:DummyLdr" + ")" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitStore(this);
    }

    public FileSpec getSFile() {
        return this.sFile;
    }

    public void setSFile(FileSpec sFile) {
        this.sFile = sFile;
    }

    public void setInputSpec(FileSpec lFile) {
        this.lFile = lFile;
    }

    public FileSpec getInputSpec() {
        return this.lFile;
    }

    public void setIsTmpStore(boolean tmp) {
        this.isTmpStore = tmp;
    }

    public boolean isTmpStore() {
        return this.isTmpStore;
    }

    public void setStoreImpl(POStoreImpl impl) {
        this.impl = impl;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public StoreFuncInterface getStoreFunc() {
        if (this.storer == null) {
            this.storer = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(this.sFile.getFuncSpec());
            this.storer.setStoreFuncUDFContextSignature(this.signature);
        }
        return this.storer;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setMultiStore(boolean isMultiStore) {
        this.isMultiStore = isMultiStore;
    }

    public boolean isMultiStore() {
        return this.isMultiStore;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            ExampleTuple tIn = (ExampleTuple)in;
            LineageTracer lineage = this.illustrator.getLineage();
            lineage.insert(tIn);
            if (!this.isTmpStore) {
                this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tIn);
            }
            this.illustrator.addData((Tuple)out);
        }
        return (Tuple)out;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setDisableCounter(boolean disableCounter) {
        this.disableCounter = disableCounter;
    }

    public boolean disableCounter() {
        return this.disableCounter;
    }

    public void setStoreFunc(StoreFuncInterface storeFunc) {
        this.storer = storeFunc;
    }
}

