/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPartitionRearrange
extends POLocalRearrange {
    private static final long serialVersionUID = 1L;
    private Integer totalReducers = -1;
    private static Map<Object, Pair<Integer, Integer>> reducerMap = new HashMap<Object, Pair<Integer, Integer>>();
    private boolean loaded;
    protected static final BagFactory mBagFactory = BagFactory.getInstance();
    private PigContext pigContext;

    public POPartitionRearrange(OperatorKey k) {
        this(k, -1, null);
    }

    public POPartitionRearrange(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POPartitionRearrange(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POPartitionRearrange(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
        this.index = (byte)-1;
        this.leafOps = new ArrayList();
    }

    private void loadPartitionFile() throws RuntimeException {
        String keyDistFile = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.keyDistFile", "");
        if (keyDistFile.isEmpty()) {
            throw new RuntimeException("Internal error: missing key distribution file property.");
        }
        boolean tmpFileCompression = Utils.tmpFileCompression(this.pigContext);
        if (tmpFileCompression) {
            ((Configuration)PigMapReduce.sJobConfInternal.get()).setBoolean("pig.tmpfilecompression", true);
            try {
                ((Configuration)PigMapReduce.sJobConfInternal.get()).set("pig.tmpfilecompression.codec", Utils.tmpFileCompressionCodec(this.pigContext));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Integer[] redCnt = new Integer[1];
            reducerMap = MapRedUtil.loadPartitionFileFromLocalCache(keyDistFile, redCnt, (byte)1, (Configuration)PigMapReduce.sJobConfInternal.get());
            this.totalReducers = redCnt[0] == null ? -1 : redCnt[0];
            this.loaded = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String name() {
        return this.getAliasString() + "Partition rearrange " + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + "(" + this.mIsDistinct + ") - " + this.mKey.toString();
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result inp;
        block7: {
            inp = null;
            Result res = null;
            if (!this.loaded) {
                try {
                    this.loadPartitionFile();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            do {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block7;
            } while (inp.returnStatus == 1);
            for (PhysicalPlan ep : this.plans) {
                ep.attachInput((Tuple)inp.result);
            }
            ArrayList<Result> resLst = new ArrayList<Result>();
            for (ExpressionOperator op : this.leafOps) {
                res = op.getNext(POPartitionRearrange.getDummy(op.getResultType()), op.getResultType());
                if (res.returnStatus != 0) {
                    return new Result();
                }
                resLst.add(res);
            }
            res.result = this.constructPROutput(resLst, (Tuple)inp.result);
            return res;
        }
        return inp;
    }

    protected DataBag constructPROutput(List<Result> resLst, Tuple value) throws ExecException {
        Tuple t = super.constructLROutput(resLst, null, value);
        Object key = t.get(1);
        DataBag opBag = mBagFactory.newDefaultBag();
        Pair<Integer, Integer> indexes = reducerMap.get(key);
        if (indexes == null) {
            indexes = new Pair<Integer, Integer>(-1, 0);
        }
        Integer reducerIdx = (Integer)indexes.first;
        Integer cnt = 0;
        while (cnt <= (Integer)indexes.second) {
            if (reducerIdx >= this.totalReducers) {
                reducerIdx = 0;
            }
            Tuple opTuple = mTupleFactory.newTuple(4);
            opTuple.set(0, t.get(0));
            opTuple.set(1, (int)reducerIdx);
            opTuple.set(2, key);
            opTuple.set(3, t.get(2));
            opBag.add(opTuple);
            Integer n = reducerIdx;
            Integer n2 = reducerIdx = Integer.valueOf(reducerIdx + 1);
            n = cnt;
            n2 = cnt = Integer.valueOf(cnt + 1);
        }
        return opBag;
    }

    public void setPigContext(PigContext pigContext) {
        this.pigContext = pigContext;
    }

    public PigContext getPigContext() {
        return this.pigContext;
    }

    @Override
    public POPartitionRearrange clone() throws CloneNotSupportedException {
        POPartitionRearrange clone = (POPartitionRearrange)super.clone();
        return clone;
    }
}

