/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReducePOStoreImpl;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapBase;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ProgressableReporter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.UDFFinishVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POJoinPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.SpillableMemoryManager;
import org.apache.pig.tools.pigstats.PigStatusReporter;
import org.joda.time.DateTimeZone;

public class PigGenericMapReduce {
    public static JobContext sJobContext = null;
    @Deprecated
    public static Configuration sJobConf = null;
    public static final ThreadLocal<Configuration> sJobConfInternal = new ThreadLocal();
    private static final Tuple DUMMYTUPLE = null;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReduceWithComparator
    extends PigMapReduce.Reduce {
        private byte keyType;

        @Override
        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.keyType = this.pack.getKeyType();
        }

        @Override
        protected void reduce(PigNullableWritable key, Iterable<NullableTuple> tupIter, Reducer.Context context) throws IOException, InterruptedException {
            if (!this.initialized) {
                this.initialized = true;
                this.outputCollector = context;
                this.pigReporter.setRep((TaskAttemptContext)context);
                PhysicalOperator.setReporter(this.pigReporter);
                boolean aggregateWarning = "true".equalsIgnoreCase(this.pigContext.getProperties().getProperty("aggregate.warning"));
                PigHadoopLogger pigHadoopLogger = PigHadoopLogger.getInstance();
                pigHadoopLogger.setAggregate(aggregateWarning);
                PigStatusReporter.setContext((TaskInputOutputContext)context);
                pigHadoopLogger.setReporter(PigStatusReporter.getInstance());
                PhysicalOperator.setPigLogger(pigHadoopLogger);
                for (POStore store : this.stores) {
                    MapReducePOStoreImpl impl = new MapReducePOStoreImpl((TaskInputOutputContext)context);
                    store.setStoreImpl(impl);
                    store.setUp();
                }
            }
            if (this.keyType != 110) {
                Tuple t = (Tuple)key.getValueAsPigType();
                key = HDataType.getWritableComparableTypes(t.get(0), this.keyType);
            }
            this.pack.attachInput(key, tupIter.iterator());
            Result res = this.pack.getNext(DUMMYTUPLE);
            if (res.returnStatus == 0) {
                Tuple packRes = (Tuple)res.result;
                if (this.rp.isEmpty()) {
                    context.write(null, (Object)packRes);
                    return;
                }
                this.rp.attachInput(packRes);
                List leaves = this.rp.getLeaves();
                PhysicalOperator leaf = (PhysicalOperator)leaves.get(0);
                this.runPipeline(leaf);
            }
            if (res.returnStatus == 1) {
                return;
            }
            if (res.returnStatus == 2) {
                int errCode = 2093;
                String msg = "Encountered error in package operator while processing group.";
                throw new ExecException(msg, errCode, 4);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Reduce
    extends Reducer<PigNullableWritable, NullableTuple, PigNullableWritable, Writable> {
        protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        protected PhysicalPlan rp = null;
        protected List<POStore> stores;
        protected POPackage pack;
        ProgressableReporter pigReporter;
        protected Reducer.Context outputCollector;
        protected boolean errorInReduce = false;
        PhysicalOperator[] roots;
        private PhysicalOperator leaf;
        PigContext pigContext = null;
        protected volatile boolean initialized = false;
        private boolean inIllustrator = false;

        public void setReducePlan(PhysicalPlan plan) {
            this.rp = plan;
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.inIllustrator = this.inIllustrator(context);
            if (this.inIllustrator) {
                this.pack = this.getPack(context);
            }
            Configuration jConf = context.getConfiguration();
            SpillableMemoryManager.configure(ConfigurationUtil.toProperties(jConf));
            sJobContext = context;
            sJobConfInternal.set(context.getConfiguration());
            sJobConf = context.getConfiguration();
            try {
                PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(jConf.get("udf.import.list")));
                this.pigContext = (PigContext)ObjectSerializer.deserialize(jConf.get("pig.pigContext"));
                SchemaTupleBackend.initialize(jConf, this.pigContext);
                if (this.rp == null) {
                    this.rp = (PhysicalPlan)ObjectSerializer.deserialize(jConf.get("pig.reducePlan"));
                }
                this.stores = PlanHelper.getPhysicalOperators(this.rp, POStore.class);
                if (!this.inIllustrator) {
                    this.pack = (POPackage)ObjectSerializer.deserialize(jConf.get("pig.reduce.package"));
                }
                if (this.rp.isEmpty()) {
                    this.log.debug((Object)"Reduce Plan empty!");
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.rp.explain(baos);
                    this.log.debug((Object)baos.toString());
                }
                this.pigReporter = new ProgressableReporter();
                if (!this.rp.isEmpty()) {
                    this.roots = this.rp.getRoots().toArray(new PhysicalOperator[1]);
                    this.leaf = (PhysicalOperator)this.rp.getLeaves().get(0);
                }
                MapRedUtil.setupUDFContext(jConf);
            }
            catch (IOException ioe) {
                String msg = "Problem while configuring reduce plan.";
                throw new RuntimeException(msg, ioe);
            }
            this.log.info((Object)("Aliases being processed per job phase (AliasName[line,offset]): " + jConf.get("pig.alias.location")));
            String dtzStr = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.datetime.default.tz");
            if (dtzStr != null && dtzStr.length() > 0) {
                DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forOffsetMillis((int)DateTimeZone.forID((String)dtzStr).getOffset(null)));
            }
        }

        protected void reduce(PigNullableWritable key, Iterable<NullableTuple> tupIter, Reducer.Context context) throws IOException, InterruptedException {
            if (!this.initialized) {
                this.initialized = true;
                this.outputCollector = context;
                this.pigReporter.setRep((TaskAttemptContext)context);
                PhysicalOperator.setReporter(this.pigReporter);
                boolean aggregateWarning = "true".equalsIgnoreCase(this.pigContext.getProperties().getProperty("aggregate.warning"));
                PigHadoopLogger pigHadoopLogger = PigHadoopLogger.getInstance();
                pigHadoopLogger.setAggregate(aggregateWarning);
                PigStatusReporter.setContext((TaskInputOutputContext)context);
                pigHadoopLogger.setReporter(PigStatusReporter.getInstance());
                PhysicalOperator.setPigLogger(pigHadoopLogger);
                if (!this.inIllustrator) {
                    for (POStore store : this.stores) {
                        MapReducePOStoreImpl impl = new MapReducePOStoreImpl((TaskInputOutputContext)context);
                        store.setStoreImpl(impl);
                        store.setUp();
                    }
                }
            }
            if (this.pack instanceof POJoinPackage) {
                this.pack.attachInput(key, tupIter.iterator());
                while (!this.processOnePackageOutput(context)) {
                }
            } else {
                this.pack.attachInput(key, tupIter.iterator());
                this.processOnePackageOutput(context);
            }
        }

        public boolean processOnePackageOutput(Reducer.Context oc) throws IOException, InterruptedException {
            Result res = this.pack.getNext(DUMMYTUPLE);
            if (res.returnStatus == 0) {
                Tuple packRes = (Tuple)res.result;
                if (this.rp.isEmpty()) {
                    oc.write(null, (Object)packRes);
                    return false;
                }
                for (int i = 0; i < this.roots.length; ++i) {
                    this.roots[i].attachInput(packRes);
                }
                this.runPipeline(this.leaf);
            }
            if (res.returnStatus == 1) {
                return false;
            }
            if (res.returnStatus == 2) {
                int errCode = 2093;
                String msg = "Encountered error in package operator while processing group.";
                throw new ExecException(msg, errCode, 4);
            }
            return res.returnStatus == 3;
        }

        protected void runPipeline(PhysicalOperator leaf) throws InterruptedException, IOException {
            Result redRes;
            while (true) {
                redRes = leaf.getNext(DUMMYTUPLE);
                if (redRes.returnStatus == 0) {
                    try {
                        this.outputCollector.write(null, (Object)((Tuple)redRes.result));
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (redRes.returnStatus == 3) {
                    return;
                }
                if (redRes.returnStatus != 1 && redRes.returnStatus == 2) break;
            }
            this.errorInReduce = true;
            String msg = redRes.result != null ? "Received Error while processing the reduce plan: " + redRes.result : "Received Error while processing the reduce plan.";
            int errCode = 2090;
            throw new ExecException(msg, errCode, 4);
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            super.cleanup(context);
            if (this.errorInReduce) {
                return;
            }
            if (((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.stream.in.reduce", "false").equals("true")) {
                this.rp.endOfAllInput = true;
                this.runPipeline(this.leaf);
            }
            if (!this.inIllustrator) {
                for (POStore store : this.stores) {
                    if (!this.initialized) {
                        MapReducePOStoreImpl impl = new MapReducePOStoreImpl((TaskInputOutputContext)context);
                        store.setStoreImpl(impl);
                        store.setUp();
                    }
                    store.tearDown();
                }
            }
            UDFFinishVisitor finisher = new UDFFinishVisitor(this.rp, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(this.rp));
            try {
                finisher.visit();
            }
            catch (VisitorException e) {
                throw new IOException("Error trying to finish UDFs", e);
            }
            PhysicalOperator.setReporter(null);
            this.initialized = false;
        }

        public abstract Reducer.Context getIllustratorContext(Job var1, List<Pair<PigNullableWritable, Writable>> var2, POPackage var3) throws IOException, InterruptedException;

        public abstract boolean inIllustrator(Reducer.Context var1);

        public abstract POPackage getPack(Reducer.Context var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapWithPartitionIndex
    extends Map {
        @Override
        public void collect(Mapper.Context oc, Tuple tuple) throws InterruptedException, IOException {
            Byte tupleKeyIdx = 2;
            Byte tupleValIdx = 3;
            Byte index = (Byte)tuple.get(0);
            Integer partitionIndex = -1;
            if (tuple.size() == 3) {
                Byte by = tupleKeyIdx;
                Byte by2 = tupleKeyIdx = Byte.valueOf((byte)(tupleKeyIdx - 1));
                by = tupleValIdx;
                by2 = tupleValIdx = Byte.valueOf((byte)(tupleValIdx - 1));
            } else {
                partitionIndex = (Integer)tuple.get(1);
            }
            PigNullableWritable key = HDataType.getWritableComparableTypes(tuple.get(tupleKeyIdx.byteValue()), this.keyType);
            NullablePartitionWritable wrappedKey = new NullablePartitionWritable(key);
            NullableTuple val = new NullableTuple((Tuple)tuple.get(tupleValIdx.byteValue()));
            wrappedKey.setIndex(index);
            wrappedKey.setPartition(partitionIndex);
            val.setIndex(index);
            oc.write((Object)wrappedKey, (Object)val);
        }

        @Override
        protected void runPipeline(PhysicalOperator leaf) throws IOException, InterruptedException {
            Result res;
            block0: while (true) {
                res = leaf.getNext(DUMMYTUPLE);
                if (res.returnStatus == 0) {
                    if (res.result instanceof DataBag) {
                        Iterator<Tuple> its = ((DataBag)res.result).iterator();
                        while (true) {
                            if (!its.hasNext()) continue block0;
                            this.collect(this.outputCollector, its.next());
                        }
                    }
                    this.collect(this.outputCollector, (Tuple)res.result);
                    continue;
                }
                if (res.returnStatus == 3) {
                    return;
                }
                if (res.returnStatus != 1 && res.returnStatus == 2) break;
            }
            this.errorInMap = true;
            String errMsg = res.result != null ? "Received Error while processing the map plan: " + res.result : "Received Error while processing the map plan.";
            int errCode = 2055;
            throw new ExecException(errMsg, errCode, 4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapWithComparator
    extends PigMapBase {
        @Override
        public void collect(Mapper.Context oc, Tuple tuple) throws InterruptedException, IOException {
            Object keyTuple = null;
            if (this.keyType != 110) {
                Object k = tuple.get(1);
                keyTuple = this.tf.newTuple(k);
            } else {
                keyTuple = tuple.get(1);
            }
            Byte index = (Byte)tuple.get(0);
            PigNullableWritable key = HDataType.getWritableComparableTypes(keyTuple, (byte)110);
            NullableTuple val = new NullableTuple((Tuple)tuple.get(2));
            key.setIndex(index);
            val.setIndex(index);
            oc.write((Object)key, (Object)val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map
    extends PigMapBase {
        @Override
        public void collect(Mapper.Context oc, Tuple tuple) throws InterruptedException, IOException {
            Byte index = (Byte)tuple.get(0);
            PigNullableWritable key = HDataType.getWritableComparableTypes(tuple.get(1), this.keyType);
            NullableTuple val = new NullableTuple((Tuple)tuple.get(2));
            key.setIndex(index);
            val.setIndex(index);
            oc.write((Object)key, (Object)val);
        }
    }
}

